/*
 * Decompiled with CFR 0.152.
 */
package gregtech.client;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import gregtech.common.config.Client;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.EntityLivingBase;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.common.MinecraftForge;
import org.lwjgl.opengl.GL11;

public class TetherLineRenderer {
    private static final float MAX_LINE_WIDTH = 13.0f;
    private static final int MAX_LINE_TICKS = 14;
    private int ticks;
    private final int tetherX;
    private final int tetherY;
    private final int tetherZ;

    private TetherLineRenderer(int x, int y, int z) {
        this.tetherX = x;
        this.tetherY = y;
        this.tetherZ = z;
    }

    public static void addTetherLineRenderer(int x, int y, int z) {
        if (!Client.render.renderMagLevTethers) {
            return;
        }
        TetherLineRenderer handler = new TetherLineRenderer(x, y, z);
        FMLCommonHandler.instance().bus().register((Object)handler);
        MinecraftForge.EVENT_BUS.register((Object)handler);
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent e) {
        if (e.phase == TickEvent.Phase.END) {
            ++this.ticks;
            if (this.ticks > 14) {
                FMLCommonHandler.instance().bus().unregister((Object)this);
                MinecraftForge.EVENT_BUS.unregister((Object)this);
            }
        }
    }

    @SubscribeEvent
    public void onRenderWorldLast(RenderWorldLastEvent e) {
        EntityLivingBase entity = Minecraft.func_71410_x().field_71451_h;
        double pX = entity.field_70169_q + (entity.field_70165_t - entity.field_70169_q) * (double)e.partialTicks;
        double pY = entity.field_70167_r + (entity.field_70163_u - entity.field_70167_r) * (double)e.partialTicks;
        double pZ = entity.field_70166_s + (entity.field_70161_v - entity.field_70166_s) * (double)e.partialTicks;
        GL11.glPushMatrix();
        GL11.glTranslated((double)(-pX), (double)(-pY), (double)(-pZ));
        this.renderLineToPlayer(pX, pY, pZ, this.ticks);
        GL11.glPopMatrix();
    }

    private void renderLineToPlayer(double pX, double pY, double pZ, int renderTick) {
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        GL11.glPushAttrib((int)8192);
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glDisable((int)2896);
        double progress = (double)renderTick / 14.0;
        double timeFactor = (Math.sin(Math.PI * progress) + 1.0) / 2.0;
        GL11.glLineWidth((float)((float)(13.0 * timeFactor)));
        Tessellator tess = Tessellator.field_78398_a;
        tess.func_78371_b(1);
        tess.func_78370_a(195, 92, 193, (int)(255.0 * timeFactor));
        tess.func_78377_a(pX, pY - (double)(player.field_70131_O / 2.0f), pZ);
        tess.func_78377_a((double)this.tetherX + 0.5, (double)this.tetherY + 0.5, (double)this.tetherZ + 0.5);
        tess.func_78381_a();
        GL11.glPopAttrib();
    }
}

