/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import cpw.mods.fml.common.Loader;
import gnu.trove.list.TIntList;
import gnu.trove.list.array.TIntArrayList;
import gregtech.api.enums.Mods;
import gregtech.api.interfaces.IRecipeMap;
import gregtech.api.recipe.RecipeMetadataKey;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTRecipeBuilder;
import gregtech.api.util.GTUtility;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class GTRecipeMapUtil {
    public static final Function<GTRecipe, GTRecipe> ALL_FAKE_RECIPE = r -> {
        r.mFakeRecipe = true;
        return r;
    };
    private static final Map<String, IRecipeMap> addonRecipeMaps = new HashMap<String, IRecipeMap>();
    private static final Multimap<String, Consumer<IRecipeMap>> delayedActions = ArrayListMultimap.create();
    public static final Set<RecipeMetadataKey<Integer>> SPECIAL_VALUE_ALIASES = new HashSet<RecipeMetadataKey<Integer>>();

    public static <T> T[] appendArray(T[] arr, T val) {
        T[] newArr = Arrays.copyOf(arr, arr.length + 1);
        newArr[arr.length] = val;
        return newArr;
    }

    public static GTRecipeTemplate asTemplate(GTRecipe r) {
        return GTRecipeMapUtil.asTemplate(r, false);
    }

    public static GTRecipeTemplate asTemplate(GTRecipe r, boolean includeTemplate) {
        return new GTRecipeTemplate(r, includeTemplate);
    }

    public static List<GTRecipe> buildRecipeForMultiblock(GTRecipeBuilder b) {
        return GTRecipeMapUtil.buildOrEmpty(GTRecipeMapUtil.convertCellToFluid(b, true));
    }

    public static List<GTRecipe> buildRecipeForMultiblockNoCircuit(GTRecipeBuilder b) {
        return GTRecipeMapUtil.buildOrEmpty(GTRecipeMapUtil.convertCellToFluid(b, false));
    }

    public static GTRecipeBuilder convertCellToFluid(GTRecipeBuilder b, boolean removeIntegratedCircuit) {
        ArrayList<ItemStack> itemInputs = new ArrayList<ItemStack>(Arrays.asList(b.getItemInputsBasic()));
        ArrayList<ItemStack> itemOutputs = new ArrayList<ItemStack>(Arrays.asList(b.getItemOutputs()));
        ArrayList<FluidStack> fluidInputs = new ArrayList<FluidStack>(Arrays.asList(b.getFluidInputs()));
        ArrayList<FluidStack> fluidOutputs = new ArrayList<FluidStack>(Arrays.asList(b.getFluidOutputs()));
        TIntArrayList chances = b.getChances() != null ? new TIntArrayList(b.getChances()) : null;
        GTRecipeMapUtil.cellToFluid(itemInputs, fluidInputs, removeIntegratedCircuit, null);
        GTRecipeMapUtil.cellToFluid(itemOutputs, fluidOutputs, removeIntegratedCircuit, (TIntList)chances);
        itemInputs.removeIf(Objects::isNull);
        if (chances == null) {
            itemOutputs.removeIf(Objects::isNull);
        }
        fluidInputs.removeIf(Objects::isNull);
        fluidOutputs.removeIf(Objects::isNull);
        b.itemInputs(itemInputs.toArray(new ItemStack[0]));
        b.itemOutputs(itemOutputs.toArray(new ItemStack[0]), chances != null ? chances.toArray() : null);
        b.fluidInputs(fluidInputs.toArray(new FluidStack[0]));
        b.fluidOutputs(fluidOutputs.toArray(new FluidStack[0]));
        return b;
    }

    private static void cellToFluid(List<ItemStack> items, List<FluidStack> fluids, boolean removeIntegratedCircuit, TIntList chances) {
        for (int i = items.size() - 1; i >= 0; --i) {
            ItemStack item = items.get(i);
            if (GTUtility.getFluidForFilledItem(item, true) == null && !GTUtility.isCellEmpty(item) && (!removeIntegratedCircuit || !GTUtility.isAnyIntegratedCircuit(item))) continue;
            fluids.add(GTUtility.convertCellToFluid(item));
            items.remove(i);
            if (chances == null) continue;
            chances.removeAt(i);
        }
    }

    public static List<GTRecipe> buildOrEmpty(GTRecipeBuilder builder) {
        return builder.build().map(Collections::singletonList).orElse(Collections.emptyList());
    }

    public static void registerRecipeMap(String identifier, IRecipeMap recipeMap, RecipeMapDependency ... dependencies) {
        String modId = Loader.instance().activeModContainer().getModId();
        if (Mods.GregTech.ID.equals(modId)) {
            throw new IllegalStateException("do not register recipe map under the name of gregtech! do it in your own preinit!");
        }
        String id = modId + "@" + identifier;
        addonRecipeMaps.put(id, recipeMap);
        for (Consumer action : delayedActions.get((Object)id)) {
            action.accept(recipeMap);
        }
    }

    public static void registerRecipesFor(String modid, String identifier, Consumer<IRecipeMap> registerAction) {
        String id = modid + "@" + identifier;
        IRecipeMap map = addonRecipeMaps.get(id);
        if (map == null) {
            delayedActions.put((Object)id, registerAction);
        } else {
            registerAction.accept(map);
        }
    }

    public static final class GTRecipeTemplate {
        private final GTRecipe template;
        private final List<GTRecipe> derivatives = new ArrayList<GTRecipe>();

        private GTRecipeTemplate(GTRecipe template, boolean includeTemplate) {
            this.template = template;
            if (includeTemplate) {
                this.derivatives.add(template);
            }
        }

        public GTRecipe derive() {
            GTRecipe derived = this.template.copyShallow();
            this.derivatives.add(derived);
            return derived;
        }

        public List<GTRecipe> getAll() {
            Set references = Collections.newSetFromMap(new IdentityHashMap());
            for (GTRecipe r : this.derivatives) {
                if (r.mInputs.length != 0 && !references.add(r.mInputs)) {
                    r.mInputs = (ItemStack[])r.mInputs.clone();
                }
                if (r.mOutputs.length != 0 && !references.add(r.mOutputs)) {
                    r.mOutputs = (ItemStack[])r.mOutputs.clone();
                }
                if (r.mFluidInputs.length != 0 && !references.add(r.mFluidInputs)) {
                    r.mFluidInputs = (FluidStack[])r.mFluidInputs.clone();
                }
                if (r.mFluidOutputs.length == 0 || references.add(r.mFluidOutputs)) continue;
                r.mFluidOutputs = (FluidStack[])r.mFluidOutputs.clone();
            }
            return this.derivatives;
        }
    }

    public static final class RecipeMapDependency {
        private final IRecipeMap obj;
        private final String id;

        public RecipeMapDependency(IRecipeMap obj, String id) {
            this.obj = obj;
            this.id = id;
        }

        public static RecipeMapDependency create(String id) {
            return new RecipeMapDependency(null, id);
        }

        public static RecipeMapDependency create(IRecipeMap obj) {
            return new RecipeMapDependency(obj, null);
        }
    }
}

