/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.graphs.consumers;

import cofh.api.energy.IEnergyReceiver;
import gregtech.GTMod;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.SoundResource;
import gregtech.api.graphs.consumers.ConsumerNode;
import gregtech.api.util.GTUtility;
import gregtech.api.util.WorldSpawnedEventBuilder;
import gregtech.common.pollution.Pollution;
import java.util.ArrayList;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class NodeEnergyReceiver
extends ConsumerNode {
    int mRestRF = 0;

    public NodeEnergyReceiver(int aNodeValue, IEnergyReceiver aTileEntity, ForgeDirection side, ArrayList<ConsumerNode> aConsumers) {
        super(aNodeValue, (TileEntity)aTileEntity, side, aConsumers);
    }

    @Override
    public int injectEnergy(long aVoltage, long aMaxAmps) {
        ForgeDirection tDirection = this.mSide;
        int rfOut = GTUtility.safeInt(aVoltage * (long)GregTechAPI.mEUtoRF / 100L);
        int ampsUsed = 0;
        if (this.mRestRF < rfOut) {
            this.mRestRF += rfOut;
            ampsUsed = 1;
        }
        if (((IEnergyReceiver)this.mTileEntity).receiveEnergy(tDirection, this.mRestRF, true) > 0) {
            int consumed = ((IEnergyReceiver)this.mTileEntity).receiveEnergy(tDirection, this.mRestRF, false);
            this.mRestRF -= consumed;
            return ampsUsed;
        }
        if (GregTechAPI.mRFExplosions && GregTechAPI.sMachineExplosions && (long)((IEnergyReceiver)this.mTileEntity).getMaxEnergyStored(tDirection) < (long)rfOut * 600L) {
            this.explode(rfOut);
        }
        return 0;
    }

    private void explode(int aRfOut) {
        if ((long)aRfOut > 32L * (long)GregTechAPI.mEUtoRF / 100L) {
            float tStrength = GTValues.getExplosionPowerForVoltage(aRfOut);
            int tX = this.mTileEntity.field_145851_c;
            int tY = this.mTileEntity.field_145848_d;
            int tZ = this.mTileEntity.field_145849_e;
            World tWorld = this.mTileEntity.func_145831_w();
            GTUtility.sendSoundToPlayers(tWorld, SoundResource.IC2_MACHINES_MACHINE_OVERLOAD, 1.0f, -1.0f, tX, tY, tZ);
            tWorld.func_147449_b(tX, tY, tZ, Blocks.field_150350_a);
            if (GregTechAPI.sMachineExplosions && GTMod.proxy.mPollution) {
                Pollution.addPollution(tWorld.func_72938_d(tX, tZ), GTMod.proxy.mPollutionOnExplosion);
            }
            new WorldSpawnedEventBuilder.ExplosionEffectEventBuilder().setStrength(tStrength).setSmoking(true).setPosition((double)tX + 0.5, (double)tY + 0.5, (double)tZ + 0.5).setWorld(tWorld).run();
        }
    }
}

