/*
 * Decompiled with CFR 0.152.
 */
package serverutils.lib.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.DoubleConsumer;
import java.util.function.DoubleSupplier;
import java.util.function.Function;
import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import java.util.function.LongConsumer;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import serverutils.lib.config.ConfigBoolean;
import serverutils.lib.config.ConfigDouble;
import serverutils.lib.config.ConfigEnum;
import serverutils.lib.config.ConfigInt;
import serverutils.lib.config.ConfigList;
import serverutils.lib.config.ConfigLong;
import serverutils.lib.config.ConfigNull;
import serverutils.lib.config.ConfigString;
import serverutils.lib.config.ConfigValue;
import serverutils.lib.config.ConfigValueInstance;
import serverutils.lib.io.DataIn;
import serverutils.lib.io.DataOut;
import serverutils.lib.util.FinalIDObject;
import serverutils.lib.util.misc.BooleanConsumer;
import serverutils.lib.util.misc.NameMap;

public class ConfigGroup
extends FinalIDObject {
    public static final ConfigGroup DEFAULT = ConfigGroup.newGroup("default");
    public static final DataOut.Serializer<ConfigGroup> SERIALIZER = (data, object) -> {
        data.writeString(object.getId());
        data.writeTextComponent(object.displayName);
        data.writeVarInt(object.values.size());
        for (ConfigValueInstance instance : object.getValues()) {
            data.writeString(instance.getId());
            data.writeVarInt(instance.getIdFlag());
            instance.writeData(data);
        }
        data.writeVarInt(object.groups.size());
        for (ConfigGroup group : object.getGroups()) {
            SERIALIZER.write(data, group);
        }
    };
    public static final DataIn.Deserializer<ConfigGroup> DESERIALIZER = data -> {
        int i;
        ConfigGroup group = ConfigGroup.newGroup(data.readString());
        group.displayName = data.readTextComponent();
        int s = data.readVarInt();
        group.values.clear();
        for (i = 0; i < s; ++i) {
            ConfigValueInstance inst = new ConfigValueInstance(group, data);
            group.values.put(inst.getId(), inst);
        }
        s = data.readVarInt();
        group.groups.clear();
        for (i = 0; i < s; ++i) {
            ConfigGroup group1 = DESERIALIZER.read(data);
            group1.parent = group;
            group.groups.put(group1.getId(), group1);
        }
        return group;
    };
    public ConfigGroup parent;
    private IChatComponent displayName;
    private final Map<String, ConfigValueInstance> values = new LinkedHashMap<String, ConfigValueInstance>();
    private final Map<String, ConfigGroup> groups = new LinkedHashMap<String, ConfigGroup>();

    public static ConfigGroup newGroup(String name) {
        return new ConfigGroup(name);
    }

    private ConfigGroup(String id) {
        super(id);
    }

    public ConfigGroup setDisplayName(IChatComponent t) {
        this.displayName = t;
        return this;
    }

    public IChatComponent getDisplayName() {
        return this.displayName == null ? new ChatComponentTranslation(this.getPath(), new Object[0]) : this.displayName;
    }

    @Nullable
    public ConfigGroup getNullableGroup(String id) {
        return this.groups.get(id);
    }

    public ConfigGroup getGroup(String id) {
        int index = id.indexOf(46);
        if (index == -1) {
            ConfigGroup g = this.groups.get(id);
            if (g == null) {
                g = new ConfigGroup(id);
                g.parent = this;
                this.groups.put(g.getId(), g);
            }
            return g;
        }
        return this.getGroup(id.substring(0, index)).getGroup(id.substring(index + 1));
    }

    public ConfigValueInstance add(ConfigValueInstance inst) {
        if (inst.getGroup() != this) {
            throw new IllegalArgumentException("Can't add to this group, parent doesn't match!");
        }
        this.values.put(inst.getId(), inst);
        return inst;
    }

    public <T extends ConfigValue> ConfigValueInstance add(String id, T value, @Nullable T def, int idFlag) {
        ConfigValueInstance instance = this.add(new ConfigValueInstance(id, this, value, idFlag));
        instance.setOrder(this.values.size());
        if (def != null) {
            instance.setDefaultValue(def);
        }
        return instance;
    }

    public <T extends ConfigValue> ConfigValueInstance add(String id, T value, @Nullable T def) {
        return this.add(id, value, def, 14);
    }

    public ConfigValueInstance addBool(String id, BooleanSupplier getter, BooleanConsumer setter, boolean def) {
        return this.add(id, new ConfigBoolean.SimpleBoolean(getter, setter), new ConfigBoolean(def));
    }

    public ConfigValueInstance addInt(String id, IntSupplier getter, IntConsumer setter, int def, int min, int max) {
        return this.add(id, new ConfigInt.SimpleInt(min, max, getter, setter), new ConfigInt(def));
    }

    public ConfigValueInstance addLong(String id, LongSupplier getter, LongConsumer setter, long def, long min, long max) {
        return this.add(id, new ConfigLong.SimpleLong(min, max, getter, setter), new ConfigLong(def));
    }

    public ConfigValueInstance addDouble(String id, DoubleSupplier getter, DoubleConsumer setter, double def, double min, double max) {
        return this.add(id, new ConfigDouble.SimpleDouble(min, max, getter, setter), new ConfigDouble(def));
    }

    public ConfigValueInstance addString(String id, Supplier<String> getter, Consumer<String> setter, String def, @Nullable Pattern pattern) {
        return this.add(id, new ConfigString.SimpleString(getter, setter, pattern), new ConfigString(def));
    }

    public ConfigValueInstance addString(String id, Supplier<String> getter, Consumer<String> setter, String def) {
        return this.addString(id, getter, setter, def, null);
    }

    public <T> ConfigValueInstance addEnum(String id, Supplier<T> getter, Consumer<T> setter, NameMap<T> nameMap) {
        return this.add(id, new ConfigEnum.SimpleEnum<T>(nameMap, getter, setter), new ConfigEnum<T>(nameMap));
    }

    public <C extends ConfigValue, V> ConfigValueInstance addList(String id, Collection<V> c, C type, Function<V, C> toConfig, Function<C, V> fromConfig) {
        return this.add(id, new ConfigList.SimpleList<C, V>(c, type, toConfig, fromConfig), new ConfigList<C>(type));
    }

    public boolean hasValue(String key) {
        return this.values.containsKey(key);
    }

    public void removeValue(String key) {
        this.values.remove(key);
    }

    @Nullable
    public ConfigValueInstance getValueInstance(String key) {
        int index = key.indexOf(46);
        if (index == -1 || this.groups.isEmpty()) {
            return this.values.get(key);
        }
        return this.getGroup((String)key.substring((int)0, (int)index)).values.get(key.substring(index + 1));
    }

    public ConfigValue getValue(String key) {
        ConfigValueInstance v = this.getValueInstance(key);
        return v == null ? ConfigNull.INSTANCE : v.getValue();
    }

    public final Collection<ConfigValueInstance> getValues() {
        return this.values.values();
    }

    public final List<ConfigValueInstance> getValueTree() {
        ArrayList<ConfigValueInstance> list = new ArrayList<ConfigValueInstance>(this.getValues());
        for (ConfigGroup group : this.getGroups()) {
            list.addAll(group.getValueTree());
        }
        return list;
    }

    public final Collection<ConfigGroup> getGroups() {
        return this.groups.values();
    }

    public ConfigGroup copy() {
        ConfigGroup g = new ConfigGroup(this.getId());
        g.displayName = this.displayName == null ? null : this.displayName.func_150259_f();
        for (ConfigGroup group : this.getGroups()) {
            ConfigGroup gr = group.copy();
            gr.parent = g;
            g.groups.put(gr.getId(), gr);
        }
        for (ConfigValueInstance instance : this.getValues()) {
            g.add(instance.copy(g));
        }
        return g;
    }

    public String getPath() {
        if (this.parent == null) {
            return this.getId();
        }
        return this.parent.getPath() + "." + this.getId();
    }

    public IChatComponent getDisplayNameOf(ConfigValueInstance inst) {
        return new ChatComponentTranslation(inst.getPath(), new Object[0]);
    }

    public IChatComponent getInfoOf(ConfigValueInstance inst) {
        IChatComponent name = inst.getDisplayName();
        if (name instanceof ChatComponentTranslation) {
            ChatComponentTranslation component = (ChatComponentTranslation)name;
            return new ChatComponentTranslation(component.func_150268_i() + ".tooltip", new Object[0]);
        }
        return new ChatComponentTranslation(inst.getPath() + ".tooltip", new Object[0]);
    }

    public List<String> getValueKeyTree() {
        ArrayList<String> list = new ArrayList<String>();
        this.getValueKeyTree0(list, "");
        return list;
    }

    private void getValueKeyTree0(List<String> list, String path) {
        for (ConfigValueInstance instance : this.getValues()) {
            if (path.isEmpty()) {
                list.add(instance.getId());
                continue;
            }
            list.add(path + "." + instance.getId());
        }
    }

    @Override
    public String toString() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (ConfigGroup group : this.getGroups()) {
            map.put(group.getId(), group.toString());
        }
        for (ConfigValueInstance instance : this.getValues()) {
            map.put(instance.getId(), instance.getValue().getString());
        }
        return this.parent == null ? this.getId() + "#" + map : ((Object)map).toString();
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        for (ConfigValueInstance instance : this.getValues()) {
            if (instance.getExcluded()) continue;
            instance.getValue().writeToNBT(nbt, instance.getId());
        }
        for (ConfigGroup group : this.getGroups()) {
            nbt.func_74782_a(group.getId(), (NBTBase)group.serializeNBT());
        }
        return nbt;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        for (ConfigValueInstance instance : this.getValues()) {
            if (instance.getExcluded() || !instance.getCanEdit()) continue;
            instance.getValue().readFromNBT(nbt, instance.getId());
        }
        for (ConfigGroup group : this.getGroups()) {
            group.deserializeNBT(nbt.func_74775_l(group.getId()));
        }
    }
}

