/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.overlay;

import mcp.mobius.waila.api.impl.ConfigHandler;
import mcp.mobius.waila.overlay.DisplayUtil;
import mcp.mobius.waila.overlay.OverlayConfig;
import mcp.mobius.waila.overlay.RayTracing;
import mcp.mobius.waila.overlay.Tooltip;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.util.MovingObjectPosition;
import org.lwjgl.opengl.GL11;

public class OverlayRenderer {
    private static boolean hasBlending;
    private static boolean hasDepthTest;
    private static int boundTexIndex;

    public static void renderOverlay(Tooltip tooltip) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71462_r != null || mc.field_71441_e == null || !Minecraft.func_71382_s() || mc.field_71474_y.field_74321_H.func_151470_d() || !ConfigHandler.instance().showTooltip() || RayTracing.instance().getTarget() == null) {
            return;
        }
        if (RayTracing.instance().getTarget().field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK && RayTracing.instance().getTargetStack() != null) {
            OverlayRenderer.doRenderOverlay(tooltip);
        }
        if (RayTracing.instance().getTarget().field_72313_a == MovingObjectPosition.MovingObjectType.ENTITY && ConfigHandler.instance().getConfig("general.showents")) {
            OverlayRenderer.doRenderOverlay(tooltip);
        }
    }

    private static void doRenderOverlay(Tooltip tooltip) {
        GL11.glPushMatrix();
        OverlayRenderer.saveGLState();
        GL11.glScalef((float)OverlayConfig.scale, (float)OverlayConfig.scale, (float)1.0f);
        GL11.glDisable((int)32826);
        RenderHelper.func_74518_a();
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
        OverlayRenderer.drawTooltipBox(tooltip.x, tooltip.y, tooltip.w, tooltip.h, OverlayConfig.bgcolor, OverlayConfig.gradient1, OverlayConfig.gradient2);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        tooltip.draw();
        GL11.glDisable((int)3042);
        tooltip.draw2nd();
        if (tooltip.hasIcon) {
            RenderHelper.func_74520_c();
        }
        GL11.glEnable((int)32826);
        if (tooltip.hasIcon && tooltip.stack != null && tooltip.stack.func_77973_b() != null) {
            DisplayUtil.renderStack(tooltip.x + 5, tooltip.y + tooltip.h / 2 - 8, tooltip.stack);
        }
        OverlayRenderer.loadGLState();
        GL11.glPopMatrix();
    }

    private static void saveGLState() {
        hasBlending = GL11.glGetBoolean((int)3042);
        hasDepthTest = GL11.glGetBoolean((int)2929);
        boundTexIndex = GL11.glGetInteger((int)32873);
        GL11.glPushAttrib((int)1);
    }

    private static void loadGLState() {
        if (hasBlending) {
            GL11.glEnable((int)3042);
        } else {
            GL11.glDisable((int)3042);
        }
        if (hasDepthTest) {
            GL11.glEnable((int)2929);
        } else {
            GL11.glDisable((int)2929);
        }
        GL11.glBindTexture((int)3553, (int)boundTexIndex);
        GL11.glPopAttrib();
    }

    private static void drawTooltipBox(int x, int y, int w, int h, int bg, int grad1, int grad2) {
        DisplayUtil.drawGradientRect(x + 1, y, w - 1, 1, bg, bg);
        DisplayUtil.drawGradientRect(x + 1, y + h, w - 1, 1, bg, bg);
        DisplayUtil.drawGradientRect(x + 1, y + 1, w - 1, h - 1, bg, bg);
        DisplayUtil.drawGradientRect(x, y + 1, 1, h - 1, bg, bg);
        DisplayUtil.drawGradientRect(x + w, y + 1, 1, h - 1, bg, bg);
        DisplayUtil.drawGradientRect(x + 1, y + 2, 1, h - 3, grad1, grad2);
        DisplayUtil.drawGradientRect(x + w - 1, y + 2, 1, h - 3, grad1, grad2);
        DisplayUtil.drawGradientRect(x + 1, y + 1, w - 1, 1, grad1, grad1);
        DisplayUtil.drawGradientRect(x + 1, y + h - 1, w - 1, 1, grad2, grad2);
    }
}

