/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.packs.erebus.core;

import com.jaquadro.minecraft.storagedrawers.api.pack.BlockConfiguration;
import com.jaquadro.minecraft.storagedrawers.api.pack.BlockType;
import com.jaquadro.minecraft.storagedrawers.api.pack.ExtendedDataResolver;
import com.jaquadro.minecraft.storagedrawers.packs.erebus.core.ModBlocks;
import com.jaquadro.minecraft.storagedrawers.packs.erebus.core.ModCreativeTabs;
import com.jaquadro.minecraft.storagedrawers.packs.erebus.core.RefinedRelocation;
import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;

public class DataResolver
extends ExtendedDataResolver {
    public static String[] blockNames = new String[]{"Baobab", "Eucalyptus", "Mahogany", "Mossbark", "Asper", "Cypress", null, "White", "Bamboo", "Rotten", "Marshwood", null, null, null, "Scorched", "Varnished"};
    public static String[] textureNames = new String[]{"baobab", "eucalyptus", "mahogany", "mossbark", "asper", "cypress", null, "white", "bamboo", "rotten", "marshwood", null, null, null, "scorched", "varnished"};

    public DataResolver(String modID) {
        super(modID, blockNames);
    }

    @Override
    public CreativeTabs getCreativeTabs(BlockType type) {
        return ModCreativeTabs.getTabStorageDrawers();
    }

    @Override
    public String getUnlocalizedName(int meta) {
        if (!this.isValidMetaValue(meta)) {
            return null;
        }
        return textureNames[meta];
    }

    @Override
    public Block getBlock(BlockConfiguration blockConfig) {
        switch (blockConfig.getBlockType()) {
            case Drawers: {
                if (blockConfig.getDrawerCount() == 1) {
                    return ModBlocks.fullDrawers1;
                }
                if (blockConfig.getDrawerCount() == 2 && !blockConfig.isHalfDepth()) {
                    return ModBlocks.fullDrawers2;
                }
                if (blockConfig.getDrawerCount() == 4 && !blockConfig.isHalfDepth()) {
                    return ModBlocks.fullDrawers4;
                }
                if (blockConfig.getDrawerCount() == 2 && blockConfig.isHalfDepth()) {
                    return ModBlocks.halfDrawers2;
                }
                if (blockConfig.getDrawerCount() != 4 || !blockConfig.isHalfDepth()) break;
                return ModBlocks.halfDrawers4;
            }
            case DrawersSorting: {
                if (blockConfig.getDrawerCount() == 1) {
                    return RefinedRelocation.fullDrawers1;
                }
                if (blockConfig.getDrawerCount() == 2 && !blockConfig.isHalfDepth()) {
                    return RefinedRelocation.fullDrawers2;
                }
                if (blockConfig.getDrawerCount() == 4 && !blockConfig.isHalfDepth()) {
                    return RefinedRelocation.fullDrawers4;
                }
                if (blockConfig.getDrawerCount() == 2 && blockConfig.isHalfDepth()) {
                    return RefinedRelocation.halfDrawers2;
                }
                if (blockConfig.getDrawerCount() != 4 || !blockConfig.isHalfDepth()) break;
                return RefinedRelocation.halfDrawers4;
            }
            case Trim: {
                return ModBlocks.trim;
            }
            case TrimSorting: {
                return RefinedRelocation.trim;
            }
        }
        return null;
    }

    @Override
    public void init() {
        Block planks = GameRegistry.findBlock((String)"erebus", (String)"planks");
        int i = 0;
        int p = 0;
        while (i < 6) {
            this.setPlankSlab(i, planks, p, GameRegistry.findBlock((String)"erebus", (String)this.getPlankName(this.getUnlocalizedName(i))), 0);
            ++i;
            ++p;
        }
        i = 7;
        p = 7;
        while (i < 11) {
            this.setPlankSlab(i, planks, p, GameRegistry.findBlock((String)"erebus", (String)this.getPlankName(this.getUnlocalizedName(i))), 0);
            ++i;
            ++p;
        }
        i = 14;
        p = 14;
        while (i < 15) {
            this.setPlankSlab(i, GameRegistry.findBlock((String)"erebus", (String)"planks_scorched"), p, GameRegistry.findBlock((String)"erebus", (String)this.getPlankName(this.getUnlocalizedName(i))), 0);
            ++i;
            ++p;
        }
        i = 15;
        p = 15;
        while (i < 16) {
            this.setPlankSlab(i, GameRegistry.findBlock((String)"erebus", (String)"planks_varnished"), p, GameRegistry.findBlock((String)"erebus", (String)this.getPlankName(this.getUnlocalizedName(i))), 0);
            ++i;
            ++p;
        }
    }

    private String getPlankName(String name) {
        return "slabPlanks" + Character.toUpperCase(name.charAt(0)) + name.substring(1);
    }
}

