/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.weaponry.ammo;

import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import tconstruct.TConstruct;
import tconstruct.library.TConstructRegistry;
import tconstruct.library.crafting.ToolBuilder;
import tconstruct.library.tools.CustomMaterial;
import tconstruct.library.tools.FletchingMaterial;
import tconstruct.library.tools.FletchlingLeafMaterial;
import tconstruct.library.weaponry.AmmoItem;
import tconstruct.weaponry.TinkerWeaponry;

public class ArrowAmmo
extends AmmoItem {
    public static ItemStack vanillaArrow;

    public ArrowAmmo() {
        super(0, "Arrows");
    }

    @Override
    public String getIconSuffix(int partType) {
        String string;
        switch (partType) {
            case 0: {
                string = "_arrow_head";
                break;
            }
            case 1: {
                string = "";
                break;
            }
            case 2: {
                string = "_arrow_shaft";
                break;
            }
            case 3: {
                string = "_arrow_fletching";
                break;
            }
            default: {
                string = "";
            }
        }
        return string;
    }

    @Override
    public String getEffectSuffix() {
        return "_arrow_effect";
    }

    @Override
    public String getDefaultFolder() {
        return "arrow";
    }

    @Override
    public void registerPartPaths(int index, String[] location) {
        this.headStrings.put(index, location[0]);
    }

    @Override
    public void registerAlternatePartPaths(int index, String[] location) {
        this.handleStrings.put(index, location[2]);
        this.accessoryStrings.put(index, location[3]);
    }

    @Override
    public Item getHeadItem() {
        return TinkerWeaponry.arrowhead;
    }

    @Override
    public Item getHandleItem() {
        return TinkerWeaponry.partArrowShaft;
    }

    @Override
    public Item getAccessoryItem() {
        return TinkerWeaponry.fletching;
    }

    @Override
    public int durabilityTypeHandle() {
        return 0;
    }

    @Override
    public String[] getTraits() {
        return new String[]{"ammo", "projectile", "weapon"};
    }

    @Override
    public void buildTool(int id, String name, List<ItemStack> list) {
        if (TConstructRegistry.getArrowMaterial(id) == null) {
            return;
        }
        ItemStack handleStack = new ItemStack(this.getHandleItem(), 1, 0);
        ItemStack accessoryStack = new ItemStack(this.getAccessoryItem(), 1, 0);
        ItemStack tool = ToolBuilder.instance.buildTool(new ItemStack(this.getHeadItem(), 1, id), handleStack, accessoryStack, null, "");
        if (tool != null) {
            tool.func_77978_p().func_74775_l("InfiTool").func_74757_a("Built", true);
            list.add(tool);
        }
    }

    @Override
    public void func_150895_a(Item id, CreativeTabs tab, List<ItemStack> list) {
        super.func_150895_a(id, tab, list);
        ItemStack headStack = new ItemStack(this.getHeadItem(), 1, 3);
        ItemStack handleStack = new ItemStack(this.getHandleItem(), 1, 0);
        ItemStack accessoryStack = new ItemStack(this.getAccessoryItem(), 1, 0);
        ItemStack tool = ToolBuilder.instance.buildTool(headStack, handleStack, accessoryStack, null, "");
        if (tool != null) {
            tool.func_77978_p().func_74775_l("InfiTool").func_74757_a("Built", true);
            vanillaArrow = tool;
        } else {
            TConstruct.logger.error("Couldn't build vanilla equivalent of Tinker Arrow");
        }
    }

    @Override
    protected int getDefaultColor(int renderPass, int materialID) {
        if (renderPass != 2) {
            return super.getDefaultColor(renderPass, materialID);
        }
        CustomMaterial mat = TConstructRegistry.getCustomMaterial(materialID, FletchingMaterial.class);
        if (mat == null) {
            TConstructRegistry.getCustomMaterial(materialID, FletchlingLeafMaterial.class);
        }
        if (mat == null) {
            return 0xFFFFFF;
        }
        return mat.color;
    }

    @Override
    public String getAbilityNameForType(int type, int part) {
        if (part == 1 && type == 3) {
            return EnumChatFormatting.GOLD + StatCollector.func_74838_a((String)"modifier.tool.blaze");
        }
        if (part > 1) {
            return "";
        }
        return super.getAbilityNameForType(type, part);
    }
}

