/*
 * Decompiled with CFR 0.152.
 */
package tectech.thing.metaTileEntity.hatch;

import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import tectech.mechanics.dataTransport.QuantumDataPacket;
import tectech.mechanics.pipe.IConnectsToDataPipe;
import tectech.thing.metaTileEntity.hatch.MTEHatchDataConnector;
import tectech.thing.metaTileEntity.hatch.MTEHatchDataInput;
import tectech.thing.metaTileEntity.pipe.MTEPipeData;
import tectech.util.CommonValues;
import tectech.util.TTUtility;

public class MTEHatchDataOutput
extends MTEHatchDataConnector<QuantumDataPacket> {
    public MTEHatchDataOutput(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier, new String[]{CommonValues.TEC_MARK_EM, StatCollector.func_74838_a((String)"gt.blockmachines.hatch.dataout.desc.0"), StatCollector.func_74838_a((String)"gt.blockmachines.hatch.dataout.desc.1"), EnumChatFormatting.AQUA + StatCollector.func_74838_a((String)"gt.blockmachines.hatch.dataout.desc.2")});
        TTUtility.setTier(aTier, this);
    }

    public MTEHatchDataOutput(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, aDescription, aTextures);
    }

    @Override
    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEHatchDataOutput(this.mName, this.mTier, this.mDescriptionArray, this.mTextures);
    }

    @Override
    public boolean isOutputFacing(ForgeDirection side) {
        return side == this.getBaseMetaTileEntity().getFrontFacing();
    }

    @Override
    public boolean isInputFacing(ForgeDirection side) {
        return false;
    }

    @Override
    public boolean isSimpleMachine() {
        return true;
    }

    @Override
    public boolean isDataInputFacing(ForgeDirection side) {
        return this.isInputFacing(side);
    }

    @Override
    protected QuantumDataPacket loadPacketFromNBT(NBTTagCompound nbt) {
        return new QuantumDataPacket(nbt);
    }

    @Override
    public boolean canConnectData(ForgeDirection side) {
        return this.isOutputFacing(side);
    }

    public void providePacket(QuantumDataPacket packet) {
        this.q = packet;
    }

    @Override
    public void moveAround(IGregTechTileEntity aBaseMetaTileEntity) {
        IConnectsToDataPipe next;
        IConnectsToDataPipe current = this;
        MTEHatchDataOutput source = this;
        int range = 0;
        while ((next = current.getNext(source)) != null && range++ < 1000) {
            if (next instanceof MTEHatchDataInput) {
                ((MTEHatchDataInput)next).setContents((QuantumDataPacket)this.q);
                break;
            }
            source = current;
            current = next;
        }
        this.q = null;
    }

    @Override
    public IConnectsToDataPipe getNext(IConnectsToDataPipe source) {
        IGregTechTileEntity base = this.getBaseMetaTileEntity();
        byte color = base.getColorization();
        if (color < 0) {
            return null;
        }
        IGregTechTileEntity next = base.getIGregTechTileEntityAtSide(base.getFrontFacing());
        if (next == null) {
            return null;
        }
        IMetaTileEntity meta = next.getMetaTileEntity();
        if (meta instanceof MTEPipeData) {
            ((MTEPipeData)meta).markUsed();
            return (IConnectsToDataPipe)((Object)meta);
        }
        if (meta instanceof MTEHatchDataInput && ((MTEHatchDataInput)meta).getColorization() == color && ((MTEHatchDataInput)meta).canConnectData(base.getFrontFacing().getOpposite())) {
            return (IConnectsToDataPipe)((Object)meta);
        }
        return null;
    }
}

