/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.loaders;

import gregtech.api.enums.GTValues;
import gregtech.api.recipe.RecipeMaps;
import gtPlusPlus.api.interfaces.RunnableWithInfo;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.api.recipe.GTPPRecipeMaps;
import gtPlusPlus.core.material.Material;
import gtPlusPlus.core.material.MaterialGenerator;
import gtPlusPlus.core.material.nuclear.MaterialsFluorides;
import gtPlusPlus.core.recipe.common.CI;
import gtPlusPlus.core.util.minecraft.FluidUtils;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import gtPlusPlus.core.util.minecraft.MaterialUtils;
import gtPlusPlus.core.util.minecraft.RecipeUtils;
import gtPlusPlus.xmod.gregtech.loaders.RecipeGenBase;
import gtPlusPlus.xmod.gregtech.loaders.RecipeGenDustGeneration;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class RecipeGenFluorite
extends RecipeGenBase {
    public static final Set<RunnableWithInfo<Material>> mRecipeGenMap = new HashSet<RunnableWithInfo<Material>>();

    public RecipeGenFluorite(Material material) {
        this.toGenerate = material;
        mRecipeGenMap.add(this);
        RecipeUtils.addShapedRecipe(CI.craftingToolHammer_Hard, null, null, material.getCrushedPurified(1), null, null, null, null, null, material.getDustPurified(1));
        RecipeUtils.addShapedRecipe(CI.craftingToolHammer_Hard, null, null, material.getCrushed(1), null, null, null, null, null, material.getDustImpure(1));
        RecipeUtils.addShapedRecipe(CI.craftingToolHammer_Hard, null, null, material.getCrushedCentrifuged(1), null, null, null, null, null, material.getDust(1));
        ItemStack normalDust = material.getDust(1);
        ItemStack smallDust = material.getSmallDust(1);
        ItemStack tinyDust = material.getTinyDust(1);
        if (RecipeUtils.addShapedRecipe(tinyDust, tinyDust, tinyDust, tinyDust, tinyDust, tinyDust, tinyDust, tinyDust, tinyDust, normalDust)) {
            Logger.WARNING("9 Tiny dust to 1 Dust Recipe: " + material.getLocalizedName() + " - Success");
        } else {
            Logger.WARNING("9 Tiny dust to 1 Dust Recipe: " + material.getLocalizedName() + " - Failed");
        }
        if (RecipeUtils.addShapedRecipe(normalDust, null, null, null, null, null, null, null, null, material.getTinyDust(9))) {
            Logger.WARNING("9 Tiny dust from 1 Recipe: " + material.getLocalizedName() + " - Success");
        } else {
            Logger.WARNING("9 Tiny dust from 1 Recipe: " + material.getLocalizedName() + " - Failed");
        }
        if (RecipeUtils.addShapedRecipe(smallDust, smallDust, null, smallDust, smallDust, null, null, null, null, normalDust)) {
            Logger.WARNING("4 Small dust to 1 Dust Recipe: " + material.getLocalizedName() + " - Success");
        } else {
            Logger.WARNING("4 Small dust to 1 Dust Recipe: " + material.getLocalizedName() + " - Failed");
        }
        if (RecipeUtils.addShapedRecipe(null, normalDust, null, null, null, null, null, null, null, material.getSmallDust(4))) {
            Logger.WARNING("4 Small dust from 1 Dust Recipe: " + material.getLocalizedName() + " - Success");
        } else {
            Logger.WARNING("4 Small dust from 1 Dust Recipe: " + material.getLocalizedName() + " - Failed");
        }
    }

    @Override
    public void run() {
        RecipeGenFluorite.generateRecipes(this.toGenerate);
    }

    public static void generateRecipes(Material material) {
        int tVoltageMultiplier = MaterialUtils.getVoltageForTier(material.vTier);
        ItemStack dustStone = ItemUtils.getItemStackOfAmountFromOreDict("dustStone", 1);
        ItemStack tinyDustA = MaterialsFluorides.FLUORITE.getTinyDust(1);
        ItemStack tinyDustB = MaterialsFluorides.FLUORITE.getTinyDust(1);
        ItemStack matDust = MaterialsFluorides.FLUORITE.getDust(1);
        ItemStack matDustA = MaterialsFluorides.FLUORITE.getDust(1);
        if (ItemUtils.checkForInvalidItems(material.getSmallDust(1)) && ItemUtils.checkForInvalidItems(material.getTinyDust(1))) {
            RecipeGenDustGeneration.generatePackagerRecipes(material);
        }
        GTValues.RA.stdBuilder().itemInputs(material.getOre(1)).itemOutputs(material.getCrushed(2)).duration(400).eut(tVoltageMultiplier / 2).addTo(RecipeMaps.maceratorRecipes);
        Logger.MATERIALS("[Macerator] Added Recipe: 'Macerate ore to Crushed ore'");
        GTValues.RA.stdBuilder().itemInputs(material.getRawOre(1)).itemOutputs(material.getCrushed(2)).duration(400).eut(tVoltageMultiplier / 2).addTo(RecipeMaps.maceratorRecipes);
        Logger.MATERIALS("[Macerator] Added Recipe: 'Macerate raw ore to Crushed ore'");
        GTValues.RA.stdBuilder().itemInputs(material.getCrushedCentrifuged(1)).itemOutputs(matDust, matDustA).outputChances(10000, 1000).duration(400).eut(tVoltageMultiplier / 2).addTo(RecipeMaps.maceratorRecipes);
        Logger.MATERIALS("[Macerator] Added Recipe: 'Macerate Centrifuged ore to Pure Dust'");
        GTValues.RA.stdBuilder().itemInputs(material.getCrushedPurified(1)).itemOutputs(material.getCrushedCentrifuged(1), tinyDustA, dustStone).duration(500).eut(48).addTo(RecipeMaps.thermalCentrifugeRecipes);
        Logger.MATERIALS("[ThermalCentrifuge] Added Recipe: 'Washed ore to Centrifuged Ore' | Input: " + material.getCrushedPurified(1).func_82833_r() + " | Outputs: " + material.getCrushedCentrifuged(1).func_82833_r() + ", " + tinyDustA.func_82833_r() + ", " + dustStone.func_82833_r() + ".");
        GTValues.RA.stdBuilder().itemInputs(MaterialsFluorides.FLUORITE.getCrushed(2)).itemOutputs(MaterialsFluorides.FLUORITE.getCrushedPurified(8), MaterialsFluorides.FLUORITE.getDustImpure(4), MaterialsFluorides.FLUORITE.getDustPurified(2)).outputChances(10000, 5000, 1000).fluidInputs(FluidUtils.getFluidStack("hydrogen", 2000)).duration(600).eut(240).addTo(RecipeMaps.chemicalBathRecipes);
        GTValues.RA.stdBuilder().itemInputs(material.getCrushedCentrifuged(1)).itemOutputs(matDust).duration(10).eut(tVoltageMultiplier / 4).addTo(RecipeMaps.hammerRecipes);
        Logger.MATERIALS("[ForgeHammer] Added Recipe: 'Crushed Centrifuged to Pure Dust'");
        GTValues.RA.stdBuilder().itemInputs(material.getDustPurified(1)).itemOutputs(matDust, tinyDustA).eut(tVoltageMultiplier / 2).duration((int)Math.max(1L, material.getMass() * 8L)).addTo(RecipeMaps.centrifugeRecipes);
        Logger.MATERIALS("[Centrifuge] Added Recipe: Purified Dust to Clean Dust");
        GTValues.RA.stdBuilder().itemInputs(material.getDustImpure(1)).itemOutputs(matDust, tinyDustB).eut(tVoltageMultiplier / 2).duration((int)Math.max(1L, material.getMass() * 8L)).addTo(RecipeMaps.centrifugeRecipes);
        Logger.MATERIALS("[Centrifuge] Added Recipe: Inpure Dust to Clean Dust");
        FluidStack aGregtechHydro = FluidUtils.getFluidStack("hydrofluoricacid_gt5u", 16000);
        if (aGregtechHydro == null) {
            aGregtechHydro = FluidUtils.getFluidStack("hydrofluoricacid", 16000);
        }
        GTValues.RA.stdBuilder().itemInputs(CI.getNumberedAdvancedCircuit(5), MaterialsFluorides.FLUORITE.getDust(37)).itemOutputs(ItemUtils.getItemStackOfAmountFromOreDict("dustCalciumSulfate", 15), ItemUtils.getItemStackOfAmountFromOreDict("dustSilver", 1), ItemUtils.getItemStackOfAmountFromOreDict("dustGold", 2), ItemUtils.getItemStackOfAmountFromOreDict("dustTin", 1), ItemUtils.getItemStackOfAmountFromOreDict("dustCopper", 2)).outputChances(10000, 1000, 1000, 3000, 2000).fluidInputs(FluidUtils.getFluidStack("sulfuricacid", 8000)).fluidOutputs(aGregtechHydro).eut(240).duration(12000).addTo(GTPPRecipeMaps.chemicalDehydratorRecipes);
    }

    static {
        MaterialGenerator.mRecipeMapsToGenerate.add(mRecipeGenMap);
    }
}

