/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.base;

import gregtech.GTMod;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.logic.ProcessingLogic;
import gregtech.api.metatileentity.implementations.MTEHatch;
import gregtech.api.metatileentity.implementations.MTEHatchInput;
import gregtech.api.metatileentity.implementations.MTEHatchOutput;
import gregtech.api.objects.GTRenderedTexture;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.GTUtility;
import gregtech.api.util.GTWaila;
import gregtech.api.util.HatchElementBuilder;
import gregtech.api.util.IGTHatchAdder;
import gregtech.api.util.shutdown.ShutDownReasonRegistry;
import gtPlusPlus.core.util.minecraft.FluidUtils;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.MTEHatchSteamBusOutput;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.MteHatchSteamBusInput;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.base.GTPPMultiBlockBase;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.base.MTEHatchCustomFluidBase;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.SpecialChars;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;

public abstract class MTESteamMultiBase<T extends MTESteamMultiBase<T>>
extends GTPPMultiBlockBase<T> {
    public ArrayList<MteHatchSteamBusInput> mSteamInputs = new ArrayList();
    public ArrayList<MTEHatchSteamBusOutput> mSteamOutputs = new ArrayList();
    public ArrayList<MTEHatchCustomFluidBase> mSteamInputFluids = new ArrayList();
    protected static final String TT_steaminputbus = StatCollector.func_74838_a((String)"GTPP.MBTT.SteamInputBus");
    protected static final String TT_steamoutputbus = StatCollector.func_74838_a((String)"GTPP.MBTT.SteamOutputBus");
    protected static final String TT_steamhatch = StatCollector.func_74838_a((String)"GTPP.MBTT.SteamHatch");
    protected static final String HIGH_PRESSURE_TOOLTIP_NOTICE = "Processing Speed & Steam Consumption is doubled under High Pressure";

    public MTESteamMultiBase(String aName) {
        super(aName);
    }

    public MTESteamMultiBase(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int aColorIndex, boolean aActive, boolean aRedstone) {
        if (side == facing) {
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(this.getCasingTextureIndex()), aActive ? this.getFrontOverlayActive() : this.getFrontOverlay()};
        }
        return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(this.getCasingTextureIndex())};
    }

    protected abstract GTRenderedTexture getFrontOverlay();

    protected abstract GTRenderedTexture getFrontOverlayActive();

    public abstract int getTierRecipes();

    private int getCasingTextureIndex() {
        return 10;
    }

    @Override
    protected ProcessingLogic createProcessingLogic() {
        return (ProcessingLogic)new ProcessingLogic().setMaxParallelSupplier(this::getMaxParallelRecipes);
    }

    @Override
    protected void setProcessingLogicPower(ProcessingLogic logic) {
        logic.setAvailableVoltage(GTValues.V[this.getTierRecipes()]);
        logic.setAvailableAmperage(this.getMaxParallelRecipes());
        logic.setAmperageOC(false);
    }

    public ArrayList<FluidStack> getAllSteamStacks() {
        ArrayList<FluidStack> aFluids = new ArrayList<FluidStack>();
        FluidStack aSteam = FluidUtils.getSteam(1);
        for (FluidStack aFluid : this.getStoredFluids()) {
            if (!aFluid.isFluidEqual(aSteam)) continue;
            aFluids.add(aFluid);
        }
        return aFluids;
    }

    public int getTotalSteamStored() {
        int aSteam = 0;
        for (FluidStack aFluid : this.getAllSteamStacks()) {
            aSteam += aFluid.amount;
        }
        return aSteam;
    }

    public boolean tryConsumeSteam(int aAmount) {
        if (this.getTotalSteamStored() <= 0) {
            return false;
        }
        return this.depleteInput(FluidUtils.getSteam(aAmount));
    }

    @Override
    public int getMaxEfficiency(ItemStack arg0) {
        return 0;
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (aBaseMetaTileEntity.isServerSide() && (this.mUpdate == 1 || this.mStartUpCheck == 1)) {
            this.mSteamInputs.clear();
            this.mSteamOutputs.clear();
            this.mInputHatches.clear();
            this.mSteamInputFluids.clear();
        }
        super.onPostTick(aBaseMetaTileEntity, aTick);
    }

    @Override
    public boolean onRunningTick(ItemStack aStack) {
        long aSteamVal;
        if (this.lEUt < 0L && !this.tryConsumeSteam((int)(aSteamVal = -this.lEUt * 10000L / (long)Math.max(1000, this.mEfficiency)))) {
            this.stopMachine(ShutDownReasonRegistry.POWER_LOSS);
            return false;
        }
        return true;
    }

    @Override
    public boolean addToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            this.log("Invalid IGregTechTileEntity");
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            this.log("Invalid IMetaTileEntity");
            return false;
        }
        boolean aDidAdd = false;
        if (aMetaTileEntity instanceof MTEHatchCustomFluidBase) {
            this.log("Adding Steam Input Hatch");
            aDidAdd = this.addToMachineListInternal(this.mSteamInputFluids, aMetaTileEntity, aBaseCasingIndex);
        } else if (aMetaTileEntity instanceof MteHatchSteamBusInput) {
            this.log("Trying to set recipe map. Type: " + (this.getRecipeMap() != null ? this.getRecipeMap().unlocalizedName : "Null"));
            this.resetRecipeMapForHatch(aTileEntity, this.getRecipeMap());
            this.log("Adding Steam Input Bus");
            aDidAdd = this.addToMachineListInternal(this.mSteamInputs, aMetaTileEntity, aBaseCasingIndex);
        } else if (aMetaTileEntity instanceof MTEHatchSteamBusOutput) {
            this.log("Adding Steam Output Bus");
            aDidAdd = this.addToMachineListInternal(this.mSteamOutputs, aMetaTileEntity, aBaseCasingIndex);
        } else if (aMetaTileEntity instanceof MTEHatchInput) {
            aDidAdd = this.addToMachineListInternal(this.mInputHatches, aMetaTileEntity, aBaseCasingIndex);
        } else if (aMetaTileEntity instanceof MTEHatchOutput) {
            // empty if block
        }
        return aDidAdd;
    }

    @Override
    public boolean depleteInput(FluidStack aLiquid) {
        if (aLiquid == null) {
            return false;
        }
        for (MTEHatchCustomFluidBase tHatch : GTUtility.validMTEList(this.mSteamInputFluids)) {
            FluidStack tLiquid = tHatch.getFluid();
            if (tLiquid == null || !tLiquid.isFluidEqual(aLiquid) || (tLiquid = tHatch.drain(aLiquid.amount, false)) == null || tLiquid.amount < aLiquid.amount) continue;
            tLiquid = tHatch.drain(aLiquid.amount, true);
            return tLiquid != null && tLiquid.amount >= aLiquid.amount;
        }
        return false;
    }

    @Override
    public boolean depleteInput(ItemStack aStack) {
        if (GTUtility.isStackInvalid(aStack)) {
            return false;
        }
        FluidStack aLiquid = GTUtility.getFluidForFilledItem(aStack, true);
        if (aLiquid != null) {
            return this.depleteInput(aLiquid);
        }
        for (MTEHatch tHatch : GTUtility.validMTEList(this.mSteamInputFluids)) {
            if (!GTUtility.areStacksEqual(aStack, tHatch.getBaseMetaTileEntity().func_70301_a(0)) || tHatch.getBaseMetaTileEntity().func_70301_a((int)0).field_77994_a < aStack.field_77994_a) continue;
            tHatch.getBaseMetaTileEntity().func_70298_a(0, aStack.field_77994_a);
            return true;
        }
        for (MTEHatch tHatch : GTUtility.validMTEList(this.mSteamInputs)) {
            ((MteHatchSteamBusInput)tHatch).mRecipeMap = this.getRecipeMap();
            for (int i = tHatch.getBaseMetaTileEntity().func_70302_i_() - 1; i >= 0; --i) {
                if (!GTUtility.areStacksEqual(aStack, tHatch.getBaseMetaTileEntity().func_70301_a(i)) || tHatch.getBaseMetaTileEntity().func_70301_a((int)0).field_77994_a < aStack.field_77994_a) continue;
                tHatch.getBaseMetaTileEntity().func_70298_a(0, aStack.field_77994_a);
                return true;
            }
        }
        return false;
    }

    @Override
    public ArrayList<FluidStack> getStoredFluids() {
        ArrayList<FluidStack> rList = new ArrayList<FluidStack>();
        for (MTEHatchCustomFluidBase tHatch : GTUtility.validMTEList(this.mSteamInputFluids)) {
            if (tHatch.getFillableStack() == null) continue;
            rList.add(tHatch.getFillableStack());
        }
        for (MTEHatchInput hatch : this.mInputHatches) {
            if (hatch.getFillableStack() == null) continue;
            rList.add(hatch.getFillableStack());
        }
        return rList;
    }

    @Override
    public ArrayList<ItemStack> getStoredInputs() {
        ArrayList<ItemStack> rList = new ArrayList<ItemStack>();
        for (MteHatchSteamBusInput tHatch : GTUtility.validMTEList(this.mSteamInputs)) {
            tHatch.mRecipeMap = this.getRecipeMap();
            for (int i = tHatch.getBaseMetaTileEntity().func_70302_i_() - 1; i >= 0; --i) {
                if (tHatch.getBaseMetaTileEntity().func_70301_a(i) == null) continue;
                rList.add(tHatch.getBaseMetaTileEntity().func_70301_a(i));
            }
        }
        return rList;
    }

    @Override
    public boolean addOutput(ItemStack aStack) {
        if (GTUtility.isStackInvalid(aStack)) {
            return false;
        }
        aStack = GTUtility.copy(aStack);
        boolean outputSuccess = true;
        while (outputSuccess && aStack.field_77994_a > 0) {
            outputSuccess = false;
            ItemStack single = aStack.func_77979_a(1);
            for (MTEHatch tHatch : GTUtility.validMTEList(this.mSteamOutputs)) {
                if (outputSuccess) continue;
                for (int i = tHatch.func_70302_i_() - 1; i >= 0 && !outputSuccess; --i) {
                    if (!tHatch.getBaseMetaTileEntity().addStackToSlot(i, single)) continue;
                    outputSuccess = true;
                }
            }
            for (MTEHatch tHatch : GTUtility.validMTEList(this.mOutputHatches)) {
                if (outputSuccess || !((MTEHatchOutput)tHatch).outputsItems() || !tHatch.getBaseMetaTileEntity().addStackToSlot(1, single)) continue;
                outputSuccess = true;
            }
        }
        return outputSuccess;
    }

    @Override
    public ArrayList<ItemStack> getStoredOutputs() {
        ArrayList<ItemStack> rList = new ArrayList<ItemStack>();
        for (MTEHatchSteamBusOutput tHatch : GTUtility.validMTEList(this.mSteamOutputs)) {
            for (int i = tHatch.getBaseMetaTileEntity().func_70302_i_() - 1; i >= 0; --i) {
                rList.add(tHatch.getBaseMetaTileEntity().func_70301_a(i));
            }
        }
        return rList;
    }

    @Override
    public List<ItemStack> getItemOutputSlots(ItemStack[] toOutput) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        for (MTEHatch tBus : GTUtility.validMTEList(this.mSteamOutputs)) {
            IGregTechTileEntity tBusInv = tBus.getBaseMetaTileEntity();
            for (int i = 0; i < tBusInv.func_70302_i_(); ++i) {
                ret.add(tBus.func_70301_a(i));
            }
        }
        return ret;
    }

    @Override
    public void updateSlots() {
        for (MTEHatch tHatch : GTUtility.validMTEList(this.mSteamInputFluids)) {
            ((MTEHatchCustomFluidBase)tHatch).updateSlots();
        }
        for (MTEHatch tHatch : GTUtility.validMTEList(this.mSteamInputs)) {
            ((MteHatchSteamBusInput)tHatch).updateSlots();
        }
    }

    @Override
    public boolean supportsBatchMode() {
        return false;
    }

    @Override
    public void clearHatches() {
        super.clearHatches();
        this.mInputHatches.clear();
        this.mSteamInputFluids.clear();
        this.mSteamInputs.clear();
        this.mSteamOutputs.clear();
    }

    @Override
    public boolean resetRecipeMapForAllInputHatches(RecipeMap<?> aMap) {
        boolean ret = super.resetRecipeMapForAllInputHatches(aMap);
        for (MteHatchSteamBusInput hatch : this.mSteamInputs) {
            if (!this.resetRecipeMapForHatch(hatch, aMap)) continue;
            ret = true;
        }
        for (MTEHatchInput g : this.mInputHatches) {
            if (!this.resetRecipeMapForHatch(g, aMap)) continue;
            ret = true;
        }
        return ret;
    }

    @Override
    public void getWailaBody(ItemStack itemStack, List<String> currentTip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        long actualEnergyUsage;
        NBTTagCompound tag = accessor.getNBTData();
        if (tag.func_74767_n("incompleteStructure")) {
            currentTip.add(SpecialChars.RED + "** INCOMPLETE STRUCTURE **" + SpecialChars.RESET);
        }
        String efficiency = SpecialChars.RESET + "  Efficiency: " + tag.func_74760_g("efficiency") + "%";
        if (tag.func_74767_n("hasProblems")) {
            currentTip.add(SpecialChars.RED + "** HAS PROBLEMS **" + efficiency);
        } else if (!tag.func_74767_n("incompleteStructure")) {
            currentTip.add(SpecialChars.GREEN + "Running Fine" + efficiency);
        }
        boolean isActive = tag.func_74767_n("isActive");
        if (isActive && (actualEnergyUsage = tag.func_74763_f("energyUsage")) > 0L) {
            currentTip.add(StatCollector.func_74837_a((String)"GTPP.waila.steam.use", (Object[])new Object[]{GTUtility.formatNumbers(actualEnergyUsage * 20L)}));
        }
        currentTip.add(GTWaila.getMachineProgressString(isActive, tag.func_74762_e("maxProgress"), tag.func_74762_e("progress")));
        if (GTMod.gregtechproxy.wailaAverageNS && tag.func_74764_b("averageNS")) {
            int tAverageTime = tag.func_74762_e("averageNS");
            currentTip.add("Average CPU load of ~" + GTUtility.formatNumbers(tAverageTime) + " ns");
        }
        super.getMTEWailaBody(itemStack, currentTip, accessor, config);
    }

    protected static String getSteamTierTextForWaila(NBTTagCompound tag) {
        int tierMachine = tag.func_74762_e("tierMachine");
        String tierMachineText = tierMachine == 1 ? "Basic" : (tierMachine == 2 ? "High Pressure" : String.valueOf(tierMachine));
        return tierMachineText;
    }

    protected static <T extends MTESteamMultiBase<T>> HatchElementBuilder<T> buildSteamInput(Class<T> typeToken) {
        return GTStructureUtility.buildHatchAdder(typeToken).adder(MTESteamMultiBase::addToMachineList).hatchIds(31040).shouldReject(t -> !t.mSteamInputFluids.isEmpty());
    }

    @Override
    public boolean getDefaultHasMaintenanceChecks() {
        return false;
    }

    protected static enum SteamHatchElement implements IHatchElement<MTESteamMultiBase<?>>
    {
        InputBus_Steam{

            @Override
            public List<? extends Class<? extends IMetaTileEntity>> mteClasses() {
                return Collections.singletonList(MteHatchSteamBusInput.class);
            }

            @Override
            public long count(MTESteamMultiBase<?> t) {
                return t.mSteamInputs.size();
            }
        }
        ,
        OutputBus_Steam{

            @Override
            public List<? extends Class<? extends IMetaTileEntity>> mteClasses() {
                return Collections.singletonList(MTEHatchSteamBusOutput.class);
            }

            @Override
            public long count(MTESteamMultiBase<?> t) {
                return t.mSteamOutputs.size();
            }
        };


        @Override
        public IGTHatchAdder<? super MTESteamMultiBase<?>> adder() {
            return MTESteamMultiBase::addToMachineList;
        }
    }
}

