/*
 * Decompiled with CFR 0.152.
 */
package gregtech.loaders.misc.bees;

import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeeModifier;
import forestry.api.genetics.IEffectData;
import gregtech.GTMod;
import gregtech.api.enums.Mods;
import gregtech.api.util.GTModHandler;
import gregtech.loaders.misc.bees.GTAlleleEffect;
import java.util.Arrays;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;

public class GTEffectTreeTwister
extends GTAlleleEffect {
    private static final Integer[] ALLOWED_DIMS = new Integer[]{2, 112, 60, 69};
    private static final ItemStack TF_TRANS_SAPLING = GTModHandler.getModItem(Mods.TwilightForest.ID, "tile.TFSapling", 1L, 6);
    private static final ItemStack BARN_SAPLING = GTModHandler.getModItem(Mods.GalaxySpace.ID, "barnardaCsapling", 1L, 1);

    public GTEffectTreeTwister() {
        super("effectTreetwister", false, 0);
    }

    @Override
    public IEffectData validateStorage(IEffectData storedData) {
        return storedData;
    }

    @Override
    protected IEffectData doEffectTickThrottled(IBeeGenome genome, IEffectData storedData, IBeeHousing housing) {
        if (TF_TRANS_SAPLING == null || BARN_SAPLING == null) {
            return storedData;
        }
        World world = housing.getWorld();
        if (!Arrays.asList(ALLOWED_DIMS).contains(world.field_73011_w.field_76574_g)) {
            return storedData;
        }
        ChunkCoordinates coords = housing.getCoordinates();
        IBeeModifier beeModifier = BeeManager.beeRoot.createBeeHousingModifier(housing);
        int xRange = (int)(beeModifier.getTerritoryModifier(genome, 1.0f) * (float)genome.getTerritory()[0]);
        int yRange = (int)(beeModifier.getTerritoryModifier(genome, 1.0f) * (float)genome.getTerritory()[1]);
        int zRange = (int)(beeModifier.getTerritoryModifier(genome, 1.0f) * (float)genome.getTerritory()[2]);
        int xCoord = coords.field_71574_a + world.field_73012_v.nextInt(xRange) - xRange / 2;
        int yCoord = coords.field_71572_b + world.field_73012_v.nextInt(yRange) - yRange / 2;
        int zCoord = coords.field_71573_c + world.field_73012_v.nextInt(zRange) - zRange / 2;
        ItemStack sourceBlock = new ItemStack(world.func_147439_a(xCoord, yCoord, zCoord), 1, world.func_72805_g(xCoord, yCoord, zCoord));
        if (TF_TRANS_SAPLING != null && BARN_SAPLING != null && TF_TRANS_SAPLING.func_77969_a(sourceBlock)) {
            world.func_147465_d(xCoord, yCoord, zCoord, Block.func_149634_a((Item)BARN_SAPLING.func_77973_b()), BARN_SAPLING.func_77960_j(), 2);
        }
        return storedData;
    }

    static {
        if (TF_TRANS_SAPLING == null) {
            GTMod.GT_FML_LOGGER.info("GTEffectTreeTwister(): Could not get ItemStack for BarnardaC sapling");
        }
        if (BARN_SAPLING == null) {
            GTMod.GT_FML_LOGGER.info("GTEffectTreeTwister(): Could not get ItemStack for BarnardaC sapling");
        }
    }
}

