/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.boilers;

import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.drawable.UITexture;
import com.gtnewhorizons.modularui.api.forge.IItemHandlerModifiable;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.widget.DrawableWidget;
import com.gtnewhorizons.modularui.common.widget.ProgressBar;
import com.gtnewhorizons.modularui.common.widget.SlotWidget;
import gregtech.GTMod;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.Materials;
import gregtech.api.enums.ParticleFX;
import gregtech.api.enums.SoundResource;
import gregtech.api.enums.SteamVariant;
import gregtech.api.gui.modularui.GTUIInfos;
import gregtech.api.gui.modularui.GTUITextures;
import gregtech.api.gui.modularui.GUITextureSet;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.modularui.IAddUIWidgets;
import gregtech.api.interfaces.modularui.IGetTitleColor;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.MTEBasicTank;
import gregtech.api.objects.GTItemStack;
import gregtech.api.objects.XSTR;
import gregtech.api.util.GTLog;
import gregtech.api.util.GTModHandler;
import gregtech.api.util.GTUtility;
import gregtech.api.util.WorldSpawnedEventBuilder;
import gregtech.common.pollution.Pollution;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;
import org.jetbrains.annotations.NotNull;

public abstract class MTEBoiler
extends MTEBasicTank
implements IGetTitleColor,
IAddUIWidgets {
    public static final byte SOUND_EVENT_LET_OFF_EXCESS_STEAM = 1;
    public int mTemperature = 20;
    public int mProcessingEnergy = 0;
    public int mLossTimer = 0;
    public FluidStack mSteam = null;
    public boolean mHadNoWater = false;
    private int mExcessWater = 0;

    public MTEBoiler(int aID, String aName, String aNameRegional, String aDescription, ITexture ... aTextures) {
        super(aID, aName, aNameRegional, 0, 4, aDescription, aTextures);
    }

    public MTEBoiler(int aID, String aName, String aNameRegional, String[] aDescription, ITexture ... aTextures) {
        super(aID, aName, aNameRegional, 0, 4, aDescription, aTextures);
    }

    public MTEBoiler(String aName, int aTier, String aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, 4, aDescription, aTextures);
    }

    public MTEBoiler(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, 4, aDescription, aTextures);
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity baseMetaTileEntity, ForgeDirection sideDirection, ForgeDirection facingDirection, int colorIndex, boolean active, boolean redstoneLevel) {
        ITexture[] tmp = (sideDirection.flag & (ForgeDirection.UP.flag | ForgeDirection.DOWN.flag)) == 0 ? (sideDirection != facingDirection ? this.mTextures[2][colorIndex + 1] : this.mTextures[(byte)(active ? 4 : 3)][colorIndex + 1]) : this.mTextures[sideDirection.ordinal()][colorIndex + 1];
        if (sideDirection != facingDirection && tmp.length == 2) {
            tmp = new ITexture[]{tmp[0]};
        }
        return tmp;
    }

    @Override
    public boolean isElectric() {
        return false;
    }

    @Override
    public boolean isFacingValid(ForgeDirection facingDirection) {
        return (facingDirection.flag & (ForgeDirection.UP.flag | ForgeDirection.DOWN.flag)) == 0;
    }

    @Override
    public boolean isAccessAllowed(EntityPlayer aPlayer) {
        return true;
    }

    @Override
    public boolean isValidSlot(int aIndex) {
        return true;
    }

    @Override
    public int getProgresstime() {
        return this.mTemperature;
    }

    @Override
    public int maxProgresstime() {
        return 500;
    }

    @Override
    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        if (aBaseMetaTileEntity.isClientSide()) {
            return true;
        }
        if (aPlayer != null) {
            if (GTUtility.areStacksEqual(aPlayer.func_71045_bC(), new ItemStack(Items.field_151131_as, 1))) {
                this.fill(Materials.Water.getFluid(1000L * (long)aPlayer.func_71045_bC().field_77994_a), true);
                if (!aPlayer.field_71075_bZ.field_75098_d) {
                    aPlayer.func_71045_bC().func_150996_a(Items.field_151133_ar);
                }
            } else {
                GTUIInfos.openGTTileEntityUI(aBaseMetaTileEntity, aPlayer);
            }
        }
        return true;
    }

    @Override
    public boolean doesFillContainers() {
        return true;
    }

    @Override
    public boolean doesEmptyContainers() {
        return true;
    }

    @Override
    public boolean canTankBeFilled() {
        return true;
    }

    @Override
    public boolean canTankBeEmptied() {
        return true;
    }

    @Override
    public boolean displaysItemStack() {
        return false;
    }

    @Override
    public boolean displaysStackSize() {
        return false;
    }

    @Override
    public boolean isFluidInputAllowed(FluidStack aFluid) {
        return GTModHandler.isWater(aFluid);
    }

    @Override
    public FluidStack getDrainableStack() {
        return this.mSteam;
    }

    @Override
    public FluidStack setDrainableStack(FluidStack aFluid) {
        this.mSteam = aFluid;
        return this.mSteam;
    }

    @Override
    public boolean isDrainableStackSeparate() {
        return true;
    }

    @Override
    public boolean allowCoverOnSide(ForgeDirection side, GTItemStack aCover) {
        return GregTechAPI.getCoverBehaviorNew(aCover.toStack()).isSimpleCover();
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74768_a("mLossTimer", this.mLossTimer);
        aNBT.func_74768_a("mTemperature", this.mTemperature);
        aNBT.func_74768_a("mProcessingEnergy", this.mProcessingEnergy);
        aNBT.func_74768_a("mExcessWater", this.mExcessWater);
        if (this.mSteam == null) {
            return;
        }
        try {
            aNBT.func_74782_a("mSteam", (NBTBase)this.mSteam.writeToNBT(new NBTTagCompound()));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.mLossTimer = aNBT.func_74762_e("mLossTimer");
        this.mTemperature = aNBT.func_74762_e("mTemperature");
        this.mProcessingEnergy = aNBT.func_74762_e("mProcessingEnergy");
        this.mExcessWater = aNBT.func_74762_e("mExcessWater");
        this.mSteam = FluidStack.loadFluidStackFromNBT((NBTTagCompound)aNBT.func_74775_l("mSteam"));
    }

    protected void produceSteam(int aAmount) {
        this.mExcessWater -= aAmount;
        if (this.mExcessWater < 0) {
            int tWaterToConsume = -this.mExcessWater / 160;
            this.mFluid.amount -= tWaterToConsume;
            this.mExcessWater += 160 * tWaterToConsume;
        }
        if (GTModHandler.isSteam(this.mSteam)) {
            this.mSteam.amount += aAmount;
        } else {
            this.mSteam = GTModHandler.getSteam(aAmount);
        }
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        this.pollute(aTick);
        if (this.isNotAllowedToWork(aBaseMetaTileEntity, aTick)) {
            return;
        }
        this.calculateCooldown();
        this.pushSteamToInventories(aBaseMetaTileEntity);
        if (this.canNotCreateSteam(aBaseMetaTileEntity, aTick)) {
            this.pollute(aTick);
            return;
        }
        this.ventSteamIfTankIsFull();
        this.updateFuelTimed(aBaseMetaTileEntity, aTick);
        this.calculateHeatUp(aBaseMetaTileEntity, aTick);
    }

    private boolean isNotAllowedToWork(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        return !aBaseMetaTileEntity.isServerSide() || aTick <= 20L;
    }

    private void pollute(long aTick) {
        if (this.mProcessingEnergy > 0 && aTick % 20L == 0L) {
            Pollution.addPollution(this.getBaseMetaTileEntity(), this.getPollution());
        }
    }

    private void calculateHeatUp(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (this.mTemperature < this.getMaxTemperature() && this.mProcessingEnergy > 0 && aTick % (long)this.getHeatUpRate() == 0L) {
            this.mProcessingEnergy -= this.getEnergyConsumption();
            this.mTemperature += this.getHeatUpAmount();
        }
        aBaseMetaTileEntity.setActive(this.mProcessingEnergy > 0);
    }

    private void updateFuelTimed(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (this.mProcessingEnergy <= 0 && aBaseMetaTileEntity.isAllowedToWork()) {
            this.updateFuel(aBaseMetaTileEntity, aTick);
        }
    }

    protected void ventSteamIfTankIsFull() {
        if (this.mSteam != null && this.mSteam.amount > this.getSteamCapacity()) {
            this.sendSound((byte)1);
            this.mSteam.amount = this.getSteamCapacity() * 3 / 4;
        }
    }

    private boolean canNotCreateSteam(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (aTick % 10L != 0L) {
            return false;
        }
        if (this.mTemperature > 100) {
            if (!GTModHandler.isWater(this.mFluid) || this.mFluid.amount <= 0) {
                this.mHadNoWater = true;
            } else {
                if (this.mHadNoWater) {
                    GTLog.exp.println("Boiler " + this.mName + " had no Water!");
                    this.onDangerousWaterLack(aBaseMetaTileEntity, aTick);
                    return true;
                }
                this.produceSteam(this.getProductionPerSecond() / 2);
            }
        } else {
            this.mHadNoWater = false;
        }
        return false;
    }

    protected void onDangerousWaterLack(IGregTechTileEntity tile, long ignoredTicks) {
        tile.doExplosion(2048L);
    }

    protected final void pushSteamToSide(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side) {
        if (this.mSteam == null || this.mSteam.amount == 0) {
            return;
        }
        IFluidHandler tTileEntity = aBaseMetaTileEntity.getITankContainerAtSide(side);
        if (tTileEntity == null) {
            return;
        }
        GTUtility.moveFluid(aBaseMetaTileEntity, tTileEntity, side, Math.max(1, this.mSteam.amount / 2), null);
    }

    protected void pushSteamToInventories(IGregTechTileEntity aBaseMetaTileEntity) {
        if (this.mSteam == null || this.mSteam.amount == 0) {
            return;
        }
        for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
            if (direction == aBaseMetaTileEntity.getFrontFacing() || direction == ForgeDirection.DOWN) continue;
            if (this.mSteam == null) break;
            this.pushSteamToSide(aBaseMetaTileEntity, direction);
        }
    }

    private void calculateCooldown() {
        if (this.mTemperature <= 20) {
            this.mTemperature = 20;
            this.mLossTimer = 0;
        } else if (++this.mLossTimer > this.getCooldownInterval()) {
            --this.mTemperature;
            this.mLossTimer = 0;
        }
    }

    protected boolean isAutomatable() {
        return GTMod.gregtechproxy.mAllowSmallBoilerAutomation;
    }

    @Override
    public boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return this.isAutomatable() && aIndex == 1 || aIndex == 3;
    }

    @Override
    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return this.isAutomatable() && aIndex == 0 && this.isItemValidFluidFilledItem(aStack) || aIndex == 2 && this.isItemValidFuel(aStack);
    }

    @Override
    public void doSound(byte aIndex, double aX, double aY, double aZ) {
        if (aIndex == 1) {
            GTUtility.doSoundAtClient(SoundResource.RANDOM_FIZZ, 2, 1.0f, aX, aY, aZ);
            ((WorldSpawnedEventBuilder.ParticleEventBuilder)new WorldSpawnedEventBuilder.ParticleEventBuilder().setIdentifier((Enum)ParticleFX.CLOUD)).setWorld(this.getBaseMetaTileEntity().getWorld()).setMotion(0.0, 0.0, 0.0).times(8, x -> x.setPosition(aX - 0.5 + (double)XSTR.XSTR_INSTANCE.nextFloat(), aY, aZ - 0.5 + (double)XSTR.XSTR_INSTANCE.nextFloat()).run());
        }
    }

    @Override
    public int getTankPressure() {
        return 100;
    }

    protected abstract int getPollution();

    @Override
    public int getCapacity() {
        return 16000;
    }

    protected int getSteamCapacity() {
        return this.getCapacity();
    }

    protected abstract int getProductionPerSecond();

    protected abstract int getMaxTemperature();

    protected abstract int getEnergyConsumption();

    protected abstract int getCooldownInterval();

    protected int getHeatUpRate() {
        return 12;
    }

    protected int getHeatUpAmount() {
        return 1;
    }

    protected abstract void updateFuel(IGregTechTileEntity var1, long var2);

    @Override
    public SteamVariant getSteamVariant() {
        return SteamVariant.BRONZE;
    }

    protected IDrawable[] getFuelSlotBackground() {
        return new IDrawable[]{this.getGUITextureSet().getItemSlot(), GTUITextures.OVERLAY_SLOT_COAL_STEAM.get(this.getSteamVariant())};
    }

    protected IDrawable[] getAshSlotBackground() {
        return new IDrawable[]{this.getGUITextureSet().getItemSlot(), GTUITextures.OVERLAY_SLOT_DUST_STEAM.get(this.getSteamVariant())};
    }

    @Override
    public void addUIWidgets(ModularWindow.Builder builder, UIBuildContext buildContext) {
        ((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)builder.widget(new SlotWidget((IItemHandlerModifiable)this.inventoryHandler, 0).setFilter(this::isItemValidFluidFilledItem).setPos(43, 25).setBackground(new IDrawable[]{this.getGUITextureSet().getItemSlot(), this.getOverlaySlotIn()}))).widget(new SlotWidget((IItemHandlerModifiable)this.inventoryHandler, 1).setAccess(true, false).setPos(43, 61).setBackground(new IDrawable[]{this.getGUITextureSet().getItemSlot(), this.getOverlaySlotOut()}))).widget(this.createFuelSlot())).widget((Widget)this.createAshSlot())).widget(new ProgressBar().setProgress(() -> Float.valueOf(this.mSteam == null ? 0.0f : (float)this.mSteam.amount / (float)this.getSteamCapacity())).setTexture(this.getProgressbarEmpty(), GTUITextures.PROGRESSBAR_BOILER_STEAM, 10).setDirection(ProgressBar.Direction.UP).setPos(70, 25).setSize(10, 54))).widget(new ProgressBar().setProgress(() -> Float.valueOf(this.mFluid == null ? 0.0f : (float)this.mFluid.amount / (float)this.getCapacity())).setTexture(this.getProgressbarEmpty(), GTUITextures.PROGRESSBAR_BOILER_WATER, 10).setDirection(ProgressBar.Direction.UP).setPos(83, 25).setSize(10, 54))).widget(new ProgressBar().setProgress(() -> Float.valueOf((float)this.mTemperature / (float)this.maxProgresstime())).setTexture(this.getProgressbarEmpty(), GTUITextures.PROGRESSBAR_BOILER_HEAT, 10).setDirection(ProgressBar.Direction.UP).setPos(96, 25).setSize(10, 54))).widget(new ProgressBar().setProgress(() -> Float.valueOf(this.mProcessingEnergy > 0 ? Math.max((float)this.mProcessingEnergy / 1000.0f, 0.2f) : 0.0f)).setTexture(this.getProgressbarFuel(), 14).setDirection(ProgressBar.Direction.UP).setPos(116, 45).setSize(14, 14))).widget(new DrawableWidget().setDrawable(this.getOverlaySlotCanister()).setPos(43, 43).setSize(18, 18));
    }

    private boolean isItemValidFluidFilledItem(@NotNull ItemStack stack) {
        return this.isFluidInputAllowed(GTUtility.getFluidForFilledItem(stack, true));
    }

    protected Widget createFuelSlot() {
        return new SlotWidget((IItemHandlerModifiable)this.inventoryHandler, 2).setFilter(this::isItemValidFuel).setPos(115, 61).setBackground(this.getFuelSlotBackground());
    }

    protected boolean isItemValidFuel(@NotNull ItemStack stack) {
        return true;
    }

    protected SlotWidget createAshSlot() {
        return (SlotWidget)new SlotWidget((IItemHandlerModifiable)this.inventoryHandler, 3).setAccess(true, false).setPos(115, 25).setBackground(this.getAshSlotBackground());
    }

    @Override
    public GUITextureSet getGUITextureSet() {
        return GUITextureSet.STEAM.apply(this.getSteamVariant());
    }

    @Override
    public int getTitleColor() {
        return this.getSteamVariant() == SteamVariant.BRONZE ? (Integer)this.COLOR_TITLE.get() : (Integer)this.COLOR_TITLE_WHITE.get();
    }

    protected IDrawable getOverlaySlotIn() {
        return GTUITextures.OVERLAY_SLOT_IN_STEAM.get(this.getSteamVariant());
    }

    protected IDrawable getOverlaySlotOut() {
        return GTUITextures.OVERLAY_SLOT_OUT_STEAM.get(this.getSteamVariant());
    }

    protected IDrawable getOverlaySlotCanister() {
        return GTUITextures.OVERLAY_SLOT_CANISTER_STEAM.get(this.getSteamVariant());
    }

    protected UITexture getProgressbarEmpty() {
        return GTUITextures.PROGRESSBAR_BOILER_EMPTY_STEAM.get(this.getSteamVariant());
    }

    protected UITexture getProgressbarFuel() {
        return GTUITextures.PROGRESSBAR_FUEL_STEAM.get(this.getSteamVariant());
    }
}

