/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import com.gtnewhorizon.structurelib.StructureLibAPI;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import gregtech.GTMod;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.TextureSet;
import gregtech.api.multitileentity.MultiTileEntityBlock;
import gregtech.api.multitileentity.MultiTileEntityRegistry;
import gregtech.api.multitileentity.enums.GT_MultiTileComponentCasing;
import gregtech.api.multitileentity.enums.GT_MultiTileUpgradeCasing;
import gregtech.api.multitileentity.interfaces.IMultiBlockController;
import gregtech.api.multitileentity.multiblock.base.Controller;
import gregtech.api.multitileentity.multiblock.base.MultiBlockPart;
import java.util.Arrays;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class GT_StructureUtilityMuTE {
    public static final MuTEStructureCasing MOTOR_CASINGS = FunctionalCasings.Motor.getCasing();
    public static final MuTEStructureCasing PUMP_CASINGS = FunctionalCasings.Pump.getCasing();
    public static final MuTEStructureCasing CONVEYOR_CASINGS = FunctionalCasings.Conveyor.getCasing();
    public static final MuTEStructureCasing PISTON_CASINGS = FunctionalCasings.Piston.getCasing();
    public static final MuTEStructureCasing ROBOT_ARM_CASINGS = FunctionalCasings.RobotArm.getCasing();
    public static final MuTEStructureCasing EMITTER_CASINGS = FunctionalCasings.Emitter.getCasing();
    public static final MuTEStructureCasing SENSOR_CASINGS = FunctionalCasings.Sensor.getCasing();
    public static final MuTEStructureCasing FIELD_GENERATOR_CASINGS = FunctionalCasings.FieldGenerator.getCasing();
    public static final MuTEStructureCasing INVENTORY_CASINGS = UpgradeCasings.Inventory.getCasing();
    public static final MuTEStructureCasing TANK_CASINGS = UpgradeCasings.Tank.getCasing();
    public static final MuTEStructureCasing AMPERAGE_CASINGS = UpgradeCasings.Amperage.getCasing();
    public static final MuTEStructureCasing LASER_CASINGS = UpgradeCasings.Laser.getCasing();
    public static final MuTEStructureCasing WIRELESS_CASINGS = UpgradeCasings.Wireless.getCasing();
    public static final MuTEStructureCasing CLEANROOM_CASINGS = UpgradeCasings.Cleanroom.getCasing();
    public static final MuTEStructureCasing HEATER_CASINGS = UpgradeCasings.Heater.getCasing();
    public static final MuTEStructureCasing INSULATOR_CASINGS = UpgradeCasings.Insulator.getCasing();

    public static <T> IStructureElement<T> ofMuTECasings(final int modes, final MuTEStructureCasing ... validCasings) {
        if (validCasings == null || validCasings.length == 0) {
            throw new IllegalArgumentException();
        }
        return new IStructureElement<T>(){
            final MuTEStructureCasing[] allowedCasings;
            private static final short[] DEFAULT = new short[]{255, 255, 255, 0};
            private static IIcon[] mIcons = null;
            {
                this.allowedCasings = validCasings;
            }

            public boolean check(T t, World world, int x, int y, int z) {
                TileEntity tileEntity = world.func_147438_o(x, y, z);
                if (!(tileEntity instanceof MultiBlockPart)) {
                    return false;
                }
                MultiBlockPart part = (MultiBlockPart)tileEntity;
                for (MuTEStructureCasing casing : this.allowedCasings) {
                    if (!casing.isCasingValid(part.getMultiTileEntityRegistryID(), part.getMultiTileEntityID())) continue;
                    IMultiBlockController tTarget = part.getTarget(false);
                    if (tTarget != null && tTarget != t) {
                        return false;
                    }
                    part.setTarget((IMultiBlockController)t, modes);
                    ((Controller)t).registerSpecialCasings(part);
                    return true;
                }
                return false;
            }

            public boolean spawnHint(T t, World world, int x, int y, int z, ItemStack trigger) {
                if (mIcons == null) {
                    mIcons = new IIcon[6];
                    Arrays.fill(mIcons, TextureSet.SET_NONE.mTextures[OrePrefixes.block.mTextureIndex].getIcon());
                }
                StructureLibAPI.hintParticleTinted((World)world, (int)x, (int)y, (int)z, (IIcon[])mIcons, (short[])DEFAULT);
                return true;
            }

            public boolean placeBlock(T t, World world, int x, int y, int z, ItemStack trigger) {
                int registryID = validCasings[0].getRegistryId();
                MultiTileEntityRegistry registry = MultiTileEntityRegistry.getRegistry(registryID);
                if (registry == null) {
                    GTMod.GT_FML_LOGGER.error("NULL REGISTRY");
                    return false;
                }
                MultiTileEntityBlock block = registry.getBlock();
                if (world.func_147465_d(x, y, z, (Block)block, this.allowedCasings[0].getDefaultMeta(), 2)) {
                    TileEntity te = world.func_147438_o(x, y, z);
                    if (!(te instanceof MultiBlockPart)) {
                        throw new IllegalStateException("TE is not an MultiBlockPart");
                    }
                    ((MultiBlockPart)te).setTarget((IMultiBlockController)t, modes);
                    ((Controller)t).registerSpecialCasings((MultiBlockPart)te);
                }
                return false;
            }
        };
    }

    public static MuTEStructureCasing createMuTEStructureCasing(String registryName, Integer ... validIds) {
        return new MuTEStructureCasing(registryName, validIds);
    }

    public static class MuTEStructureCasing {
        private final String registryName;
        private int registryId = Short.MAX_VALUE;
        private final int defaultMeta;
        private final Integer[] validIds;

        public MuTEStructureCasing(String registryName, Integer ... validIds) {
            MultiTileEntityRegistry registry = MultiTileEntityRegistry.getRegistry(registryName);
            if (validIds == null || validIds.length == 0 || registry == null) {
                throw new IllegalArgumentException();
            }
            this.registryName = registryName;
            this.validIds = validIds;
            this.defaultMeta = validIds[0];
        }

        public boolean isCasingValid(int registryId, int id) {
            if (this.getRegistryId() != registryId) {
                return false;
            }
            for (Integer validId : this.validIds) {
                if (validId != id) continue;
                return true;
            }
            return false;
        }

        public int getDefaultMeta() {
            return this.defaultMeta;
        }

        public int getRegistryId() {
            if (this.registryId == Short.MAX_VALUE) {
                MultiTileEntityRegistry registry = MultiTileEntityRegistry.getRegistry(this.registryName);
                this.registryId = Block.func_149682_b((Block)registry.getBlock());
            }
            return this.registryId;
        }
    }

    public static enum FunctionalCasings {
        Motor("gt.multitileentity.component.casings", GT_MultiTileComponentCasing.LV_Motor.getId(), GT_MultiTileComponentCasing.MV_Motor.getId(), GT_MultiTileComponentCasing.HV_Motor.getId(), GT_MultiTileComponentCasing.EV_Motor.getId(), GT_MultiTileComponentCasing.IV_Motor.getId(), GT_MultiTileComponentCasing.LuV_Motor.getId(), GT_MultiTileComponentCasing.ZPM_Motor.getId(), GT_MultiTileComponentCasing.UV_Motor.getId(), GT_MultiTileComponentCasing.UHV_Motor.getId(), GT_MultiTileComponentCasing.UEV_Motor.getId(), GT_MultiTileComponentCasing.UIV_Motor.getId(), GT_MultiTileComponentCasing.UMV_Motor.getId(), GT_MultiTileComponentCasing.UXV_Motor.getId(), GT_MultiTileComponentCasing.MAX_Motor.getId()),
        Pump("gt.multitileentity.component.casings", GT_MultiTileComponentCasing.LV_Pump.getId(), GT_MultiTileComponentCasing.MV_Pump.getId(), GT_MultiTileComponentCasing.HV_Pump.getId(), GT_MultiTileComponentCasing.EV_Pump.getId(), GT_MultiTileComponentCasing.IV_Pump.getId(), GT_MultiTileComponentCasing.LuV_Pump.getId(), GT_MultiTileComponentCasing.ZPM_Pump.getId(), GT_MultiTileComponentCasing.UV_Pump.getId(), GT_MultiTileComponentCasing.UHV_Pump.getId(), GT_MultiTileComponentCasing.UEV_Pump.getId(), GT_MultiTileComponentCasing.UIV_Pump.getId(), GT_MultiTileComponentCasing.UMV_Pump.getId(), GT_MultiTileComponentCasing.UXV_Pump.getId(), GT_MultiTileComponentCasing.MAX_Pump.getId()),
        Conveyor("gt.multitileentity.component.casings", GT_MultiTileComponentCasing.LV_Conveyor.getId(), GT_MultiTileComponentCasing.MV_Conveyor.getId(), GT_MultiTileComponentCasing.HV_Conveyor.getId(), GT_MultiTileComponentCasing.EV_Conveyor.getId(), GT_MultiTileComponentCasing.IV_Conveyor.getId(), GT_MultiTileComponentCasing.LuV_Conveyor.getId(), GT_MultiTileComponentCasing.ZPM_Conveyor.getId(), GT_MultiTileComponentCasing.UV_Conveyor.getId(), GT_MultiTileComponentCasing.UHV_Conveyor.getId(), GT_MultiTileComponentCasing.UEV_Conveyor.getId(), GT_MultiTileComponentCasing.UIV_Conveyor.getId(), GT_MultiTileComponentCasing.UMV_Conveyor.getId(), GT_MultiTileComponentCasing.UXV_Conveyor.getId(), GT_MultiTileComponentCasing.MAX_Conveyor.getId()),
        Piston("gt.multitileentity.component.casings", GT_MultiTileComponentCasing.LV_Piston.getId(), GT_MultiTileComponentCasing.MV_Piston.getId(), GT_MultiTileComponentCasing.HV_Piston.getId(), GT_MultiTileComponentCasing.EV_Piston.getId(), GT_MultiTileComponentCasing.IV_Piston.getId(), GT_MultiTileComponentCasing.LuV_Piston.getId(), GT_MultiTileComponentCasing.ZPM_Piston.getId(), GT_MultiTileComponentCasing.UV_Piston.getId(), GT_MultiTileComponentCasing.UHV_Piston.getId(), GT_MultiTileComponentCasing.UEV_Piston.getId(), GT_MultiTileComponentCasing.UIV_Piston.getId(), GT_MultiTileComponentCasing.UMV_Piston.getId(), GT_MultiTileComponentCasing.UXV_Piston.getId(), GT_MultiTileComponentCasing.MAX_Piston.getId()),
        RobotArm("gt.multitileentity.component.casings", GT_MultiTileComponentCasing.LV_RobotArm.getId(), GT_MultiTileComponentCasing.MV_RobotArm.getId(), GT_MultiTileComponentCasing.HV_RobotArm.getId(), GT_MultiTileComponentCasing.EV_RobotArm.getId(), GT_MultiTileComponentCasing.IV_RobotArm.getId(), GT_MultiTileComponentCasing.LuV_RobotArm.getId(), GT_MultiTileComponentCasing.ZPM_RobotArm.getId(), GT_MultiTileComponentCasing.UV_RobotArm.getId(), GT_MultiTileComponentCasing.UHV_RobotArm.getId(), GT_MultiTileComponentCasing.UEV_RobotArm.getId(), GT_MultiTileComponentCasing.UIV_RobotArm.getId(), GT_MultiTileComponentCasing.UMV_RobotArm.getId(), GT_MultiTileComponentCasing.UXV_RobotArm.getId(), GT_MultiTileComponentCasing.MAX_RobotArm.getId()),
        Emitter("gt.multitileentity.component.casings", GT_MultiTileComponentCasing.LV_Emitter.getId(), GT_MultiTileComponentCasing.MV_Emitter.getId(), GT_MultiTileComponentCasing.HV_Emitter.getId(), GT_MultiTileComponentCasing.EV_Emitter.getId(), GT_MultiTileComponentCasing.IV_Emitter.getId(), GT_MultiTileComponentCasing.LuV_Emitter.getId(), GT_MultiTileComponentCasing.ZPM_Emitter.getId(), GT_MultiTileComponentCasing.UV_Emitter.getId(), GT_MultiTileComponentCasing.UHV_Emitter.getId(), GT_MultiTileComponentCasing.UEV_Emitter.getId(), GT_MultiTileComponentCasing.UIV_Emitter.getId(), GT_MultiTileComponentCasing.UMV_Emitter.getId(), GT_MultiTileComponentCasing.UXV_Emitter.getId(), GT_MultiTileComponentCasing.MAX_Emitter.getId()),
        Sensor("gt.multitileentity.component.casings", GT_MultiTileComponentCasing.LV_Sensor.getId(), GT_MultiTileComponentCasing.MV_Sensor.getId(), GT_MultiTileComponentCasing.HV_Sensor.getId(), GT_MultiTileComponentCasing.EV_Sensor.getId(), GT_MultiTileComponentCasing.IV_Sensor.getId(), GT_MultiTileComponentCasing.LuV_Sensor.getId(), GT_MultiTileComponentCasing.ZPM_Sensor.getId(), GT_MultiTileComponentCasing.UV_Sensor.getId(), GT_MultiTileComponentCasing.UHV_Sensor.getId(), GT_MultiTileComponentCasing.UEV_Sensor.getId(), GT_MultiTileComponentCasing.UIV_Sensor.getId(), GT_MultiTileComponentCasing.UMV_Sensor.getId(), GT_MultiTileComponentCasing.UXV_Sensor.getId(), GT_MultiTileComponentCasing.MAX_Sensor.getId()),
        FieldGenerator("gt.multitileentity.component.casings", GT_MultiTileComponentCasing.LV_FieldGenerator.getId(), GT_MultiTileComponentCasing.MV_FieldGenerator.getId(), GT_MultiTileComponentCasing.HV_FieldGenerator.getId(), GT_MultiTileComponentCasing.EV_FieldGenerator.getId(), GT_MultiTileComponentCasing.IV_FieldGenerator.getId(), GT_MultiTileComponentCasing.LuV_FieldGenerator.getId(), GT_MultiTileComponentCasing.ZPM_FieldGenerator.getId(), GT_MultiTileComponentCasing.UV_FieldGenerator.getId(), GT_MultiTileComponentCasing.UHV_FieldGenerator.getId(), GT_MultiTileComponentCasing.UEV_FieldGenerator.getId(), GT_MultiTileComponentCasing.UIV_FieldGenerator.getId(), GT_MultiTileComponentCasing.UMV_FieldGenerator.getId(), GT_MultiTileComponentCasing.UXV_FieldGenerator.getId(), GT_MultiTileComponentCasing.MAX_FieldGenerator.getId());

        private final MuTEStructureCasing casing;

        private FunctionalCasings(String registryName, Integer ... validIds) {
            this.casing = GT_StructureUtilityMuTE.createMuTEStructureCasing(registryName, validIds);
        }

        public MuTEStructureCasing getCasing() {
            return this.casing;
        }
    }

    public static enum UpgradeCasings {
        Inventory("gt.multitileentity.upgrade.casings", GT_MultiTileUpgradeCasing.ULV_Inventory.getId(), GT_MultiTileUpgradeCasing.LV_Inventory.getId(), GT_MultiTileUpgradeCasing.MV_Inventory.getId(), GT_MultiTileUpgradeCasing.HV_Inventory.getId(), GT_MultiTileUpgradeCasing.EV_Inventory.getId(), GT_MultiTileUpgradeCasing.IV_Inventory.getId(), GT_MultiTileUpgradeCasing.LuV_Inventory.getId(), GT_MultiTileUpgradeCasing.ZPM_Inventory.getId(), GT_MultiTileUpgradeCasing.UV_Inventory.getId(), GT_MultiTileUpgradeCasing.UHV_Inventory.getId(), GT_MultiTileUpgradeCasing.UEV_Inventory.getId(), GT_MultiTileUpgradeCasing.UIV_Inventory.getId(), GT_MultiTileUpgradeCasing.UMV_Inventory.getId(), GT_MultiTileUpgradeCasing.UXV_Inventory.getId(), GT_MultiTileUpgradeCasing.MAX_Inventory.getId()),
        Tank("gt.multitileentity.upgrade.casings", GT_MultiTileUpgradeCasing.ULV_Tank.getId(), GT_MultiTileUpgradeCasing.LV_Tank.getId(), GT_MultiTileUpgradeCasing.MV_Tank.getId(), GT_MultiTileUpgradeCasing.HV_Tank.getId(), GT_MultiTileUpgradeCasing.EV_Tank.getId(), GT_MultiTileUpgradeCasing.IV_Tank.getId(), GT_MultiTileUpgradeCasing.LuV_Tank.getId(), GT_MultiTileUpgradeCasing.ZPM_Tank.getId(), GT_MultiTileUpgradeCasing.UV_Tank.getId(), GT_MultiTileUpgradeCasing.UHV_Tank.getId(), GT_MultiTileUpgradeCasing.UEV_Tank.getId(), GT_MultiTileUpgradeCasing.UIV_Tank.getId(), GT_MultiTileUpgradeCasing.UMV_Tank.getId(), GT_MultiTileUpgradeCasing.UXV_Tank.getId(), GT_MultiTileUpgradeCasing.MAX_Tank.getId()),
        Amperage("gt.multitileentity.upgrade.casings", GT_MultiTileUpgradeCasing.Amp_4.getId(), GT_MultiTileUpgradeCasing.Amp_16.getId(), GT_MultiTileUpgradeCasing.Amp_64.getId(), GT_MultiTileUpgradeCasing.Amp_256.getId(), GT_MultiTileUpgradeCasing.Amp_1_024.getId(), GT_MultiTileUpgradeCasing.Amp_4_096.getId(), GT_MultiTileUpgradeCasing.Amp_16_384.getId(), GT_MultiTileUpgradeCasing.Amp_65_536.getId(), GT_MultiTileUpgradeCasing.Amp_262_144.getId(), GT_MultiTileUpgradeCasing.Amp_1_048_576.getId()),
        Laser("gt.multitileentity.upgrade.casings", GT_MultiTileUpgradeCasing.Laser.getId()),
        Wireless("gt.multitileentity.upgrade.casings", GT_MultiTileUpgradeCasing.Wireless.getId()),
        Cleanroom("gt.multitileentity.upgrade.casings", GT_MultiTileUpgradeCasing.Cleanroom.getId()),
        Heater("gt.multitileentity.upgrade.casings", GT_MultiTileUpgradeCasing.Heater_Prototype.getId(), GT_MultiTileUpgradeCasing.Heater_IndustrialGrade.getId(), GT_MultiTileUpgradeCasing.Heater_NextGen.getId(), GT_MultiTileUpgradeCasing.Heater_Omnipotent.getId(), GT_MultiTileUpgradeCasing.Heater_OmegaType.getId()),
        Insulator("gt.multitileentity.upgrade.casings", GT_MultiTileUpgradeCasing.Insulator_Prototype.getId(), GT_MultiTileUpgradeCasing.Insulator_IndustrialGrade.getId(), GT_MultiTileUpgradeCasing.Insulator_NextGen.getId(), GT_MultiTileUpgradeCasing.Insulator_Omnipotent.getId(), GT_MultiTileUpgradeCasing.Insulator_OmegaType.getId());

        private final MuTEStructureCasing casing;

        private UpgradeCasings(String registryName, Integer ... validIds) {
            this.casing = GT_StructureUtilityMuTE.createMuTEStructureCasing(registryName, validIds);
        }

        public MuTEStructureCasing getCasing() {
            return this.casing;
        }
    }
}

