/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.recipe.maps;

import gregtech.api.enums.GTValues;
import gregtech.api.recipe.RecipeMapBackend;
import gregtech.api.recipe.RecipeMapBackendPropertiesBuilder;
import gregtech.api.util.GTModHandler;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.MethodsReturnNonnullByDefault;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class LargeBoilerFuelBackend
extends RecipeMapBackend {
    private static boolean addedGeneralDesc = false;
    private static final List<String> ALLOWED_SOLID_FUELS = Arrays.asList("gregtech:gt.blockreinforced:6", "gregtech:gt.blockreinforced:7");

    public LargeBoilerFuelBackend(RecipeMapBackendPropertiesBuilder propertiesBuilder) {
        super(propertiesBuilder);
    }

    public static boolean isAllowedSolidFuel(ItemStack stack) {
        return LargeBoilerFuelBackend.isAllowedSolidFuel(Item.field_150901_e.func_148750_c((Object)stack.func_77973_b()), stack.func_77960_j());
    }

    public static boolean isAllowedSolidFuel(String itemRegistryName, int meta) {
        return ALLOWED_SOLID_FUELS.contains(itemRegistryName + ":" + meta);
    }

    public static boolean addAllowedSolidFuel(ItemStack stack) {
        return LargeBoilerFuelBackend.addAllowedSolidFuel(Item.field_150901_e.func_148750_c((Object)stack.func_77973_b()), stack.func_77960_j());
    }

    public static boolean addAllowedSolidFuel(String itemregistryName, int meta) {
        return ALLOWED_SOLID_FUELS.add(itemregistryName + ":" + meta);
    }

    public GTRecipe addDenseLiquidRecipe(GTRecipe recipe) {
        return this.addRecipe(recipe, (double)recipe.mSpecialValue / 10.0, false);
    }

    public GTRecipe addDieselRecipe(GTRecipe recipe) {
        return this.addRecipe(recipe, (double)recipe.mSpecialValue / 40.0, false);
    }

    public void addSolidRecipes(ItemStack ... itemStacks) {
        for (ItemStack itemStack : itemStacks) {
            this.addSolidRecipe(itemStack);
        }
    }

    @Nullable
    public GTRecipe addSolidRecipe(@Nullable ItemStack fuelItemStack) {
        if (fuelItemStack == null) {
            return null;
        }
        if (!addedGeneralDesc) {
            GTValues.RA.stdBuilder().duration(1).eut(1).specialValue(1).setNEIDesc("Not all solid fuels are listed.", "Any item that burns in a", "vanilla furnace will burn in", "a Large Bronze or Steel Boiler.").build().map(this::compileRecipe);
            addedGeneralDesc = true;
        }
        String registryName = Item.field_150901_e.func_148750_c((Object)fuelItemStack.func_77973_b());
        boolean isHighTierAllowed = ALLOWED_SOLID_FUELS.contains(registryName + ":" + fuelItemStack.func_77960_j());
        return GTValues.RA.stdBuilder().itemInputs(fuelItemStack).duration(1).eut(0).specialValue(GTModHandler.getFuelValue(fuelItemStack) / 1600).build().map(r -> this.addRecipe((GTRecipe)r, (double)GTModHandler.getFuelValue(fuelItemStack) / 1600.0, isHighTierAllowed)).orElse(null);
    }

    private GTRecipe addRecipe(GTRecipe recipe, double baseBurnTime, boolean isHighTierAllowed) {
        double floatErrorCorrection = 1.0E-4;
        double bronzeBurnTime = baseBurnTime * 2.0 + floatErrorCorrection;
        bronzeBurnTime -= bronzeBurnTime % 0.05;
        double steelBurnTime = baseBurnTime + floatErrorCorrection;
        steelBurnTime -= steelBurnTime % 0.05;
        double titaniumBurnTime = baseBurnTime * 0.3 + floatErrorCorrection;
        titaniumBurnTime -= titaniumBurnTime % 0.05;
        double tungstensteelBurnTime = baseBurnTime * 0.15 + floatErrorCorrection;
        tungstensteelBurnTime -= tungstensteelBurnTime % 0.05;
        if (isHighTierAllowed) {
            recipe.setNeiDesc("Burn time in seconds:", String.format("Bronze Boiler: %.4f", bronzeBurnTime), String.format("Steel Boiler: %.4f", steelBurnTime), String.format("Titanium Boiler: %.4f", titaniumBurnTime), String.format("Tungstensteel Boiler: %.4f", tungstensteelBurnTime));
        } else {
            recipe.setNeiDesc("Burn time in seconds:", String.format("Bronze Boiler: %.4f", bronzeBurnTime), String.format("Steel Boiler: %.4f", steelBurnTime), "Titanium Boiler: Not allowed", "Tungstenst. Boiler: Not allowed");
        }
        return this.compileRecipe(recipe);
    }
}

