/*
 * Decompiled with CFR 0.152.
 */
package galacticgreg.generators;

import galacticgreg.api.Enums;
import galacticgreg.api.ISpaceObjectGenerator;
import galacticgreg.api.StructureInformation;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;

public class GenEllipsoid
implements ISpaceObjectGenerator {
    private Vec3 _mEllipsoidCenter;
    private Random _mRandom;
    private List<StructureInformation> _mStructure;
    private final double _mCoreDensity = 0.7;
    private final double _mSineFactor = 0.05;
    private float _mRandomInfluence;
    private float _mRandomAngleX;
    private float _mRandomAngleY;
    private float _mRandomAngleZ;
    private int _mSizeA;
    private int _mSizeB;
    private int _mSizeC;

    public GenEllipsoid() {
        this.reset();
    }

    @Override
    public Enums.SpaceObjectType getType() {
        return Enums.SpaceObjectType.OreAsteroid;
    }

    @Override
    public void randomize(int pSizeMin, int pSizeMax) {
        this._mRandom = new Random(System.currentTimeMillis());
        this._mRandomAngleX = (float)((double)this._mRandom.nextFloat() * Math.PI);
        this._mRandomAngleY = (float)((double)this._mRandom.nextFloat() * Math.PI);
        this._mRandomAngleZ = (float)((double)this._mRandom.nextFloat() * Math.PI);
        this._mRandomInfluence = this._mRandom.nextFloat();
        this._mSizeA = pSizeMin + this._mRandom.nextInt(pSizeMax - pSizeMin) + 10;
        this._mSizeB = pSizeMin + this._mRandom.nextInt(pSizeMax - pSizeMin) + 10;
        this._mSizeC = pSizeMin + this._mRandom.nextInt(pSizeMax - pSizeMin) + 10;
    }

    @Override
    public void setCenterPoint(int pX, int pY, int pZ) {
        this._mEllipsoidCenter = Vec3.func_72443_a((double)pX, (double)pY, (double)pZ);
    }

    @Override
    public void setCenterPoint(Vec3 pCenter) {
        this._mEllipsoidCenter = pCenter;
    }

    @Override
    public Vec3 getCenterPoint() {
        return this._mEllipsoidCenter;
    }

    @Override
    public List<StructureInformation> getStructure() {
        return this._mStructure;
    }

    @Override
    public void calculate() {
        int Xmin = (int)(this._mEllipsoidCenter.field_72450_a - (double)this._mSizeA);
        int Xmax = (int)(this._mEllipsoidCenter.field_72450_a + (double)this._mSizeA);
        int Ymin = (int)(this._mEllipsoidCenter.field_72448_b - (double)this._mSizeB);
        int Ymax = (int)(this._mEllipsoidCenter.field_72448_b + (double)this._mSizeB);
        int Zmin = (int)(this._mEllipsoidCenter.field_72449_c - (double)this._mSizeC);
        int Zmax = (int)(this._mEllipsoidCenter.field_72449_c + (double)this._mSizeC);
        for (int iX = Xmin; iX <= Xmax; ++iX) {
            for (int iY = Ymin; iY <= Ymax; ++iY) {
                for (int iZ = Zmin; iZ <= Zmax; ++iZ) {
                    double tmpX = Math.pow(this._mEllipsoidCenter.field_72450_a - (double)iX, 2.0) / Math.pow(this._mSizeA, 2.0);
                    double tmpY = Math.pow(this._mEllipsoidCenter.field_72448_b - (double)iY, 2.0) / Math.pow(this._mSizeB, 2.0);
                    double tmpZ = Math.pow(this._mEllipsoidCenter.field_72449_c - (double)iZ, 2.0) / Math.pow(this._mSizeC, 2.0);
                    double val = tmpX + tmpY + tmpZ;
                    Vec3 tPoint = Vec3.func_72443_a((double)iX, (double)iY, (double)iZ);
                    tPoint.func_72440_a(this._mRandomAngleX);
                    tPoint.func_72442_b(this._mRandomAngleY);
                    tPoint.func_72446_c(this._mRandomAngleZ);
                    Enums.TargetBlockPosition tbp = Enums.TargetBlockPosition.Invalid;
                    if (val <= 0.01) {
                        tbp = Enums.TargetBlockPosition.AsteroidInnerCore;
                    } else if (val > 0.01 && val < 0.7) {
                        tbp = Enums.TargetBlockPosition.AsteroidCore;
                    } else if (val >= 0.7 && val <= 1.0 - 0.05 * (double)MathHelper.func_76126_a((float)((float)(iZ + iX + iY) - this._mRandom.nextFloat() * this._mRandomInfluence))) {
                        tbp = Enums.TargetBlockPosition.AsteroidShell;
                    }
                    if (tbp == Enums.TargetBlockPosition.Invalid) continue;
                    this._mStructure.add(new StructureInformation(Vec3.func_72443_a((double)iX, (double)iY, (double)iZ), tbp));
                }
            }
        }
    }

    @Override
    public void reset() {
        this._mStructure = new ArrayList<StructureInformation>();
        this._mEllipsoidCenter = Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
    }
}

