/*
 * Decompiled with CFR 0.152.
 */
package bartworks.neiHandler;

import bartworks.neiHandler.NEIBWConfig;
import bartworks.system.material.BWMetaGeneratedOres;
import bartworks.system.material.BWMetaGeneratedSmallOres;
import bartworks.system.material.Werkstoff;
import bartworks.system.oregen.BWOreLayer;
import bartworks.system.oregen.BWWorldGenRoss128b;
import bartworks.system.oregen.BWWorldGenRoss128ba;
import codechicken.lib.gui.GuiDraw;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.GuiCraftingRecipe;
import codechicken.nei.recipe.TemplateRecipeHandler;
import cpw.mods.fml.common.event.FMLInterModComms;
import gregtech.api.enums.OrePrefixes;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;

public class OreNEIHandler
extends TemplateRecipeHandler {
    public OreNEIHandler() {
        if (!NEIBWConfig.sIsAdded) {
            FMLInterModComms.sendRuntimeMessage((Object)"bartworks", (String)"NEIPlugins", (String)"register-crafting-handler", (String)("bartworks@" + this.getRecipeName() + "@" + this.getOverlayIdentifier()));
            GuiCraftingRecipe.craftinghandlers.add(this);
        }
    }

    public void drawBackground(int recipe) {
        GuiDraw.drawRect((int)0, (int)0, (int)166, (int)65, (int)0x888888);
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(0, 40, 40, 120), "quickanddirtyneihandler", new Object[0]));
    }

    public int recipiesPerPage() {
        return 1;
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if ("quickanddirtyneihandler".equalsIgnoreCase(outputId)) {
            HashSet result = new HashSet();
            Werkstoff.werkstoffHashSet.stream().filter(w -> w.hasGenerationFeature(OrePrefixes.ore)).forEach(w -> result.add(w.get(OrePrefixes.ore)));
            result.forEach(this::loadCraftingRecipes);
            result.clear();
            Werkstoff.werkstoffHashSet.stream().filter(w -> w.hasGenerationFeature(OrePrefixes.ore)).forEach(w -> result.add(w.get(OrePrefixes.oreSmall)));
            result.forEach(this::loadCraftingRecipes);
            result.clear();
            HashSet hashSet = new HashSet(this.arecipes);
            this.arecipes.clear();
            this.arecipes.addAll(hashSet);
        }
        if ("item".equals(outputId)) {
            this.loadCraftingRecipes((ItemStack)results[0]);
            HashSet hashSet = new HashSet(this.arecipes);
            this.arecipes.clear();
            this.arecipes.addAll(hashSet);
        }
    }

    public void drawExtras(int recipe) {
        Object e;
        if (recipe < this.arecipes.size() && (e = this.arecipes.get(recipe)) instanceof CachedOreRecipe) {
            CachedOreRecipe cachedOreRecipe = (CachedOreRecipe)((Object)e);
            if (cachedOreRecipe.getOtherStacks() == null || cachedOreRecipe.getOtherStacks().isEmpty()) {
                return;
            }
            if (!cachedOreRecipe.small ? cachedOreRecipe.getOtherStacks().get(0) == null || cachedOreRecipe.getOtherStacks().get((int)0).item == null || cachedOreRecipe.getOtherStacks().get(1) == null || cachedOreRecipe.getOtherStacks().get(2) == null || cachedOreRecipe.getOtherStacks().get(3) == null || cachedOreRecipe.getOtherStacks().get((int)1).item == null || cachedOreRecipe.getOtherStacks().get((int)2).item == null || cachedOreRecipe.getOtherStacks().get((int)3).item == null : cachedOreRecipe.getOtherStacks().get(0) == null || cachedOreRecipe.getOtherStacks().get((int)0).item == null) {
                return;
            }
            if (cachedOreRecipe.worldGen != null) {
                GuiDraw.drawString((String)(EnumChatFormatting.BOLD + "DIM: " + EnumChatFormatting.RESET + cachedOreRecipe.worldGen.getDimName()), (int)0, (int)40, (int)0, (boolean)false);
            }
            GuiDraw.drawString((String)(EnumChatFormatting.BOLD + "Primary:"), (int)0, (int)50, (int)0, (boolean)false);
            GuiDraw.drawString((String)cachedOreRecipe.getOtherStacks().get((int)0).item.func_82833_r(), (int)0, (int)60, (int)0, (boolean)false);
            if (!cachedOreRecipe.small) {
                GuiDraw.drawString((String)(EnumChatFormatting.BOLD + "Secondary:"), (int)0, (int)70, (int)0, (boolean)false);
                GuiDraw.drawString((String)cachedOreRecipe.getOtherStacks().get((int)1).item.func_82833_r(), (int)0, (int)80, (int)0, (boolean)false);
                GuiDraw.drawString((String)(EnumChatFormatting.BOLD + "InBetween:"), (int)0, (int)90, (int)0, (boolean)false);
                GuiDraw.drawString((String)cachedOreRecipe.getOtherStacks().get((int)2).item.func_82833_r(), (int)0, (int)100, (int)0, (boolean)false);
                GuiDraw.drawString((String)(EnumChatFormatting.BOLD + "Sporadic:"), (int)0, (int)110, (int)0, (boolean)false);
                GuiDraw.drawString((String)cachedOreRecipe.getOtherStacks().get((int)3).item.func_82833_r(), (int)0, (int)120, (int)0, (boolean)false);
            } else if (cachedOreRecipe.worldGen != null) {
                GuiDraw.drawString((String)(EnumChatFormatting.BOLD + "Amount per Chunk:"), (int)0, (int)70, (int)0, (boolean)false);
                GuiDraw.drawString((String)(cachedOreRecipe.worldGen.mDensity + ""), (int)0, (int)80, (int)0, (boolean)false);
            }
        }
        super.drawExtras(recipe);
    }

    public void loadCraftingRecipes(ItemStack result) {
        Block ore = Block.func_149634_a((Item)result.func_77973_b());
        if (ore instanceof BWMetaGeneratedOres) {
            BWOreLayer.NEIMAP.get((Object)((short)result.func_77960_j())).stream().filter(l -> !(ore instanceof BWMetaGeneratedSmallOres) || !l.getClass().equals(BWWorldGenRoss128b.class) && !l.getClass().equals(BWWorldGenRoss128ba.class)).forEach(l -> this.arecipes.add(new CachedOreRecipe((BWOreLayer)l, result, ore instanceof BWMetaGeneratedSmallOres)));
        }
    }

    public String getGuiTexture() {
        return "textures/gui/container/brewing_stand.png";
    }

    public String getRecipeName() {
        return "BartWorks Ores";
    }

    class CachedOreRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        boolean small;
        BWOreLayer worldGen;
        PositionedStack stack;

        public CachedOreRecipe(BWOreLayer worldGen, ItemStack result, boolean smallOres) {
            super((TemplateRecipeHandler)OreNEIHandler.this);
            this.worldGen = worldGen;
            this.stack = new PositionedStack((Object)result, 0, 0);
            this.small = smallOres;
        }

        public PositionedStack getResult() {
            return this.stack;
        }

        public List<PositionedStack> getOtherStacks() {
            ArrayList<PositionedStack> ret = new ArrayList<PositionedStack>();
            int x = 0;
            for (int i = 0; i < (this.small ? 1 : 4); ++i) {
                ret.add(new PositionedStack((Object)this.worldGen.getStacks().get(i), x += 20, 12));
            }
            return ret;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof CachedOreRecipe)) {
                return false;
            }
            CachedOreRecipe that = (CachedOreRecipe)((Object)o);
            return Objects.equals(this.worldGen, that.worldGen);
        }

        public int hashCode() {
            return this.worldGen.hashCode();
        }
    }
}

