/*
 * Decompiled with CFR 0.152.
 */
package bartworks.common.tileentities.tiered;

import bartworks.API.recipe.BartWorksRecipeMaps;
import bartworks.common.items.ItemLabModule;
import bartworks.common.items.ItemLabParts;
import bartworks.common.loaders.BioCultureLoader;
import bartworks.common.loaders.BioItemList;
import bartworks.common.loaders.FluidLoader;
import bartworks.util.BWTooltipReference;
import bartworks.util.BWUtil;
import bartworks.util.BioCulture;
import bartworks.util.BioDNA;
import bartworks.util.BioData;
import bartworks.util.BioPlasmid;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Mods;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.MTEBasicMachine;
import gregtech.api.objects.XSTR;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTOreDictUnificator;
import gregtech.api.util.GTUtility;
import gregtech.common.items.behaviors.BehaviourDataOrb;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class MTEBioLab
extends MTEBasicMachine {
    private static final int DNA_EXTRACTION_MODULE = 0;
    private static final int PCR_THERMOCYCLE_MODULE = 1;
    private static final int PLASMID_SYNTHESIS_MODULE = 2;
    private static final int TRANSFORMATION_MODULE = 3;
    private static final int CLONAL_CELLULAR_SYNTHESIS_MODULE = 4;
    private static final int INCUBATION_MODULE = 5;

    public MTEBioLab(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier, 1, (String)null, 6, 2, TextureFactory.of(TextureFactory.of(new Textures.BlockIcons.CustomIcon("basicmachines/fluid_extractor/OVERLAY_SIDE_ACTIVE")), TextureFactory.builder().addIcon(new Textures.BlockIcons.CustomIcon("basicmachines/fluid_extractor/OVERLAY_SIDE_ACTIVE_GLOW")).glow().build()), TextureFactory.of(TextureFactory.of(new Textures.BlockIcons.CustomIcon("basicmachines/fluid_extractor/OVERLAY_SIDE")), TextureFactory.builder().addIcon(new Textures.BlockIcons.CustomIcon("basicmachines/fluid_extractor/OVERLAY_SIDE_GLOW")).glow().build()), TextureFactory.of(TextureFactory.of(new Textures.BlockIcons.CustomIcon("basicmachines/microwave/OVERLAY_FRONT_ACTIVE")), TextureFactory.builder().addIcon(new Textures.BlockIcons.CustomIcon("basicmachines/microwave/OVERLAY_FRONT_ACTIVE_GLOW")).glow().build()), TextureFactory.of(TextureFactory.of(new Textures.BlockIcons.CustomIcon("basicmachines/microwave/OVERLAY_FRONT")), TextureFactory.builder().addIcon(new Textures.BlockIcons.CustomIcon("basicmachines/microwave/OVERLAY_FRONT_GLOW")).glow().build()), TextureFactory.of(TextureFactory.of(new Textures.BlockIcons.CustomIcon("basicmachines/chemical_reactor/OVERLAY_FRONT_ACTIVE")), TextureFactory.builder().addIcon(new Textures.BlockIcons.CustomIcon("basicmachines/chemical_reactor/OVERLAY_FRONT_ACTIVE_GLOW")).glow().build()), TextureFactory.of(TextureFactory.of(new Textures.BlockIcons.CustomIcon("basicmachines/chemical_reactor/OVERLAY_FRONT")), TextureFactory.builder().addIcon(new Textures.BlockIcons.CustomIcon("basicmachines/chemical_reactor/OVERLAY_FRONT_GLOW")).glow().build()), TextureFactory.of(TextureFactory.of(new Textures.BlockIcons.CustomIcon("basicmachines/polarizer/OVERLAY_BOTTOM_ACTIVE")), TextureFactory.builder().addIcon(new Textures.BlockIcons.CustomIcon("basicmachines/polarizer/OVERLAY_BOTTOM_ACTIVE_GLOW")).glow().build()), TextureFactory.of(TextureFactory.of(new Textures.BlockIcons.CustomIcon("basicmachines/polarizer/OVERLAY_BOTTOM")), TextureFactory.builder().addIcon(new Textures.BlockIcons.CustomIcon("basicmachines/polarizer/OVERLAY_BOTTOM_GLOW")).glow().build()));
    }

    public MTEBioLab(String aName, int aTier, int aAmperage, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, aAmperage, aDescription, aTextures, 6, 2);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity iGregTechTileEntity) {
        return new MTEBioLab(this.mName, (int)this.mTier, this.mAmperage, this.mDescriptionArray, this.mTextures);
    }

    @Override
    public RecipeMap<?> getRecipeMap() {
        return BartWorksRecipeMaps.bioLabRecipes;
    }

    @Override
    public int getCapacity() {
        return this.mTier * 1000;
    }

    @Override
    public int checkRecipe(boolean skipOC) {
        FluidStack dnaFluid;
        int rTier = 3;
        FluidStack fluidStack = dnaFluid = Mods.Gendustry.isModLoaded() ? FluidRegistry.getFluidStack((String)"liquiddna", (int)1000) : Materials.Biomass.getFluid(1000L);
        if (this.getSpecialSlot() != null && this.getSpecialSlot().func_77973_b() instanceof ItemLabModule) {
            int damage = this.getSpecialSlot().func_77960_j();
            switch (damage) {
                case 0: {
                    if (!GTUtility.isStackValid(this.mInventory[this.getInputSlot()]) || !(this.mInventory[this.getInputSlot()].func_77973_b() instanceof ItemLabParts) || this.mInventory[this.getInputSlot()].func_77960_j() != 0 || this.mInventory[this.getInputSlot()].func_77978_p() == null || !GTUtility.isStackValid(this.mInventory[this.getInputSlot() + 1]) || !(this.mInventory[this.getInputSlot() + 1].func_77973_b() instanceof ItemLabParts) || this.mInventory[this.getInputSlot() + 1].func_77960_j() != 1 || this.mInventory[this.getInputSlot() + 1].func_77978_p() != null || !GTUtility.isStackValid(this.mInventory[this.getInputSlot() + 2]) || !(this.mInventory[this.getInputSlot() + 2].func_77973_b() instanceof ItemLabParts) || this.mInventory[this.getInputSlot() + 2].func_77960_j() != 3 || !GTUtility.areStacksEqual(this.mInventory[this.getInputSlot() + 3], Materials.Ethanol.getCells(1)) || this.mFluid == null || !this.mFluid.isFluidEqual(FluidRegistry.getFluidStack((String)"ic2distilledwater", (int)1000)) || this.mFluid.amount < 1000) break;
                    NBTTagCompound DNABioDataTag = this.mInventory[this.getInputSlot()].func_77978_p().func_74775_l("DNA");
                    if (DNABioDataTag == null) {
                        return super.checkRecipe(skipOC);
                    }
                    BioData cultureDNABioData = BioData.getBioDataFromName(this.mInventory[this.getInputSlot()].func_77978_p().func_74775_l("DNA").func_74779_i("Name"));
                    if (cultureDNABioData == null) {
                        return super.checkRecipe(skipOC);
                    }
                    if (this.mTier < rTier + cultureDNABioData.getTier()) {
                        return 1;
                    }
                    for (int i = 0; i < 4; ++i) {
                        if (this.mInventory[this.getInputSlot() + i] == null) continue;
                        --this.mInventory[this.getInputSlot() + i].field_77994_a;
                    }
                    this.mFluid.amount -= 1000;
                    if (cultureDNABioData.getChance() > new XSTR().nextInt(10000)) {
                        this.mOutputItems[0] = BioItemList.getDNASampleFlask(BioDNA.convertDataToDNA(cultureDNABioData));
                    }
                    this.mOutputItems[1] = GTOreDictUnificator.get(OrePrefixes.cell, Materials.Empty, 1L);
                    this.calculateOverclockedNess(BWUtil.getMachineVoltageFromTier(rTier + cultureDNABioData.getTier()), 500);
                    return 2;
                }
                case 1: {
                    if (!GTUtility.isStackValid(this.mInventory[this.getInputSlot()]) || !(this.mInventory[this.getInputSlot()].func_77973_b() instanceof ItemLabParts) || this.mInventory[this.getInputSlot()].func_77960_j() != 1 || this.mInventory[this.getInputSlot()].func_77978_p() == null || !GTUtility.isStackValid(this.mInventory[this.getInputSlot() + 3]) || !GTUtility.areStacksEqual(this.mInventory[this.getInputSlot() + 3], ItemList.Tool_DataOrb.get(1L, new Object[0])) || !GTUtility.isStackValid(this.mInventory[this.getInputSlot() + 1]) || !GTUtility.areStacksEqual(this.mInventory[this.getInputSlot() + 1], FluidLoader.BioLabFluidCells[0]) || !GTUtility.isStackValid(this.mInventory[this.getInputSlot() + 2]) || !GTUtility.areStacksEqual(this.mInventory[this.getInputSlot() + 2], FluidLoader.BioLabFluidCells[3]) || this.mFluid == null || !this.mFluid.isFluidEqual(dnaFluid) || this.mFluid.amount < 1000) break;
                    NBTTagCompound DNABioDataTag = this.mInventory[this.getInputSlot()].func_77978_p();
                    if (DNABioDataTag == null) {
                        return super.checkRecipe(skipOC);
                    }
                    BioData cultureDNABioData = BioData.getBioDataFromName(DNABioDataTag.func_74779_i("Name"));
                    if (cultureDNABioData == null) {
                        return super.checkRecipe(skipOC);
                    }
                    if (this.mTier < 1 + rTier + cultureDNABioData.getTier()) {
                        return 1;
                    }
                    for (int i = 0; i < 4; ++i) {
                        if (this.mInventory[this.getInputSlot() + i] == null) continue;
                        --this.mInventory[this.getInputSlot() + i].field_77994_a;
                    }
                    this.mFluid.amount -= 1000;
                    ItemStack Outp = ItemList.Tool_DataOrb.get(1L, new Object[0]);
                    BehaviourDataOrb.setDataTitle(Outp, "DNA Sample");
                    BehaviourDataOrb.setDataName(Outp, cultureDNABioData.getName());
                    this.mOutputItems[0] = cultureDNABioData.getChance() > new XSTR().nextInt(10000) ? Outp : ItemList.Tool_DataOrb.get(1L, new Object[0]);
                    this.mOutputItems[1] = ItemList.Cell_Empty.get(2L, new Object[0]);
                    this.calculateOverclockedNess(BWUtil.getMachineVoltageFromTier(1 + rTier + cultureDNABioData.getTier()), 500);
                    return 2;
                }
                case 2: {
                    ItemStack inp2 = ItemList.Tool_DataOrb.get(1L, new Object[0]);
                    BehaviourDataOrb.setDataTitle(inp2, "DNA Sample");
                    BehaviourDataOrb.setDataName(inp2, BioCultureLoader.BIO_DATA_BETA_LACMATASE.getName());
                    if (!GTUtility.isStackValid(this.mInventory[this.getInputSlot()]) || !GTUtility.areStacksEqual(FluidLoader.BioLabFluidCells[1], this.mInventory[this.getInputSlot()]) || !GTUtility.isStackValid(this.mInventory[this.getInputSlot() + 1]) || !GTUtility.areStacksEqual(this.mInventory[this.getInputSlot() + 1], BioItemList.getPlasmidCell(null)) || !GTUtility.isStackValid(this.mInventory[this.getInputSlot() + 2]) || !GTUtility.areStacksEqual(this.mInventory[this.getInputSlot() + 2], ItemList.Tool_DataOrb.get(1L, new Object[0]), true) || !"DNA Sample".equals(BehaviourDataOrb.getDataTitle(this.mInventory[this.getInputSlot() + 2])) || BehaviourDataOrb.getDataName(this.mInventory[this.getInputSlot() + 2]).isEmpty() || !GTUtility.isStackValid(this.mInventory[this.getInputSlot() + 3]) || !GTUtility.areStacksEqual(this.mInventory[this.getInputSlot() + 3], inp2) || this.mFluid == null || !this.mFluid.isFluidEqual(dnaFluid) || this.mFluid.amount < 1000) break;
                    BioData cultureDNABioData = BioData.getBioDataFromName(BehaviourDataOrb.getDataName(this.mInventory[this.getInputSlot() + 2]));
                    if (cultureDNABioData == null) {
                        return super.checkRecipe(skipOC);
                    }
                    if (this.mTier < 1 + rTier + cultureDNABioData.getTier()) {
                        return 1;
                    }
                    for (int i = 0; i < 2; ++i) {
                        if (this.mInventory[this.getInputSlot() + i] == null) continue;
                        --this.mInventory[this.getInputSlot() + i].field_77994_a;
                    }
                    this.mFluid.amount -= 1000;
                    if (cultureDNABioData.getChance() > new XSTR().nextInt(10000)) {
                        this.mOutputItems[0] = BioItemList.getPlasmidCell(BioPlasmid.convertDataToPlasmid(cultureDNABioData));
                    }
                    this.mOutputItems[1] = ItemList.Cell_Empty.get(1L, new Object[0]);
                    this.calculateOverclockedNess(BWUtil.getMachineVoltageFromTier(1 + rTier + cultureDNABioData.getTier()), 500);
                    return 2;
                }
                case 3: {
                    if (!GTUtility.isStackValid(this.mInventory[this.getInputSlot()]) || !GTUtility.areStacksEqual(this.mInventory[this.getInputSlot()], BioItemList.getPetriDish(null), true) || this.mInventory[this.getInputSlot()].func_77978_p() == null || !GTUtility.isStackValid(this.mInventory[this.getInputSlot() + 1]) || !GTUtility.areStacksEqual(this.mInventory[this.getInputSlot() + 1], BioItemList.getPlasmidCell(null), true) || this.mInventory[this.getInputSlot() + 1].func_77978_p() == null || !GTUtility.isStackValid(this.mInventory[this.getInputSlot() + 2]) || !GTUtility.areStacksEqual(this.mInventory[this.getInputSlot() + 2], FluidLoader.BioLabFluidCells[2]) || this.mFluid == null || !this.mFluid.isFluidEqual(FluidRegistry.getFluidStack((String)"ic2distilledwater", (int)1000)) || this.mFluid.amount < 1000) break;
                    BioData cultureDNABioData = BioData.getBioDataFromNBTTag(this.mInventory[this.getInputSlot() + 1].func_77978_p());
                    BioCulture bioCulture = BioCulture.getBioCultureFromNBTTag(this.mInventory[this.getInputSlot()].func_77978_p());
                    if (cultureDNABioData == null || bioCulture == null) {
                        return super.checkRecipe(skipOC);
                    }
                    if (this.mTier < 3 + rTier + cultureDNABioData.getTier()) {
                        return 1;
                    }
                    for (int i = 0; i < 3; ++i) {
                        if (this.mInventory[this.getInputSlot() + i] == null) continue;
                        --this.mInventory[this.getInputSlot() + i].field_77994_a;
                    }
                    this.mFluid.amount -= 1000;
                    bioCulture = bioCulture.setPlasmid(BioPlasmid.convertDataToPlasmid(cultureDNABioData));
                    if (cultureDNABioData.getChance() > new XSTR().nextInt(10000)) {
                        this.mOutputItems[0] = BioItemList.getPetriDish(bioCulture);
                    }
                    this.mOutputItems[1] = ItemList.Cell_Empty.get(1L, new Object[0]);
                    this.calculateOverclockedNess(BWUtil.getMachineVoltageFromTier(3 + rTier + cultureDNABioData.getTier()), 500);
                    return 2;
                }
                case 4: {
                    ItemStack Outp = ItemList.Tool_DataOrb.get(1L, new Object[0]);
                    BehaviourDataOrb.setDataTitle(Outp, "DNA Sample");
                    if (!GTUtility.isStackValid(this.mInventory[this.getInputSlot()]) || !GTUtility.areStacksEqual(this.mInventory[this.getInputSlot()], BioItemList.getPetriDish(null)) || !GTUtility.isStackValid(this.mInventory[this.getInputSlot() + 1]) || !GTUtility.areStacksEqual(this.mInventory[this.getInputSlot() + 1], BioItemList.getOther(4)) || !GTUtility.isStackValid(this.mInventory[this.getInputSlot() + 2]) || !GTUtility.areStacksEqual(this.mInventory[this.getInputSlot() + 2], ItemList.Circuit_Chip_Stemcell.get(2L, new Object[0])) || !GTUtility.isStackValid(this.mInventory[this.getInputSlot() + 3]) || !GTUtility.areStacksEqual(this.mInventory[this.getInputSlot() + 3], ItemList.Tool_DataOrb.get(1L, new Object[0]), true) || !"DNA Sample".equals(BehaviourDataOrb.getDataTitle(this.mInventory[this.getInputSlot() + 3])) || !this.mFluid.isFluidEqual(dnaFluid) || this.mFluid.amount < 8000) break;
                    BioData cultureDNABioData = BioData.getBioDataFromName(BehaviourDataOrb.getDataName(this.mInventory[this.getInputSlot() + 3]));
                    if (cultureDNABioData == null) {
                        return super.checkRecipe(skipOC);
                    }
                    if (this.mTier < 3 + rTier + cultureDNABioData.getTier()) {
                        return 1;
                    }
                    for (int i = 0; i < 3; ++i) {
                        if (this.mInventory[this.getInputSlot() + i] == null) continue;
                        --this.mInventory[this.getInputSlot() + i].field_77994_a;
                    }
                    this.mFluid.amount -= 8000;
                    if (cultureDNABioData.getChance() > new XSTR().nextInt(10000)) {
                        BioCulture out = BioCulture.getBioCulture(BioDNA.convertDataToDNA(cultureDNABioData));
                        if (out == null) {
                            return 0;
                        }
                        out = out.setPlasmid(BioPlasmid.convertDataToPlasmid(cultureDNABioData));
                        this.mOutputItems[0] = BioItemList.getPetriDish(out);
                    }
                    this.calculateOverclockedNess(BWUtil.getMachineVoltageFromTier(3 + rTier + cultureDNABioData.getTier()), 500);
                    return 2;
                }
            }
        }
        return super.checkRecipe(skipOC);
    }

    @Override
    public String[] getDescription() {
        return new String[]{StatCollector.func_74838_a((String)"tooltip.tile.biolab.0.name"), BWTooltipReference.ADDED_BY_BARTIMAEUSNEK_VIA_BARTWORKS.get()};
    }
}

