/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.me;

import appeng.api.AEApi;
import appeng.api.config.SearchBoxMode;
import appeng.api.config.Settings;
import appeng.api.config.SortDir;
import appeng.api.config.SortOrder;
import appeng.api.config.TypeFilter;
import appeng.api.config.ViewItems;
import appeng.api.storage.IItemDisplayRegistry;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IDisplayRepo;
import appeng.api.storage.data.IItemList;
import appeng.client.gui.widgets.IScrollSource;
import appeng.client.gui.widgets.ISortSource;
import appeng.core.AEConfig;
import appeng.integration.modules.NEI;
import appeng.items.storage.ItemViewCell;
import appeng.util.ItemSorters;
import appeng.util.Platform;
import appeng.util.item.OreHelper;
import appeng.util.item.OreReference;
import appeng.util.prioitylist.IPartitionList;
import java.util.ArrayList;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;

public class ItemRepo
implements IDisplayRepo {
    private final IItemList<IAEItemStack> list = AEApi.instance().storage().createItemList();
    private final ArrayList<IAEItemStack> view = new ArrayList();
    private final ArrayList<ItemStack> dsp = new ArrayList();
    private final IScrollSource src;
    private final ISortSource sortSrc;
    private int rowSize = 9;
    private String searchString = "";
    private IPartitionList<IAEItemStack> myPartitionList;
    private boolean hasPower;

    public ItemRepo(IScrollSource src, ISortSource sortSrc) {
        this.src = src;
        this.sortSrc = sortSrc;
    }

    @Override
    public IAEItemStack getReferenceItem(int idx) {
        if ((idx += this.src.getCurrentScroll() * this.rowSize) >= this.view.size()) {
            return null;
        }
        return this.view.get(idx);
    }

    @Override
    public ItemStack getItem(int idx) {
        if ((idx += this.src.getCurrentScroll() * this.rowSize) >= this.dsp.size()) {
            return null;
        }
        return this.dsp.get(idx);
    }

    @Override
    public void postUpdate(IAEItemStack is) {
        IAEItemStack st = this.list.findPrecise(is);
        if (st != null) {
            st.reset();
            st.add(is);
        } else {
            this.list.add(is);
        }
    }

    @Override
    public void setViewCell(ItemStack[] list) {
        this.myPartitionList = ItemViewCell.createFilter(list);
        this.updateView();
    }

    @Override
    public void updateView() {
        this.view.clear();
        this.dsp.clear();
        this.view.ensureCapacity(this.list.size());
        this.dsp.ensureCapacity(this.list.size());
        Enum viewMode = this.sortSrc.getSortDisplay();
        Enum<?> searchMode = AEConfig.instance.settings.getSetting(Settings.SEARCH_MODE);
        Enum typeFilter = this.sortSrc.getTypeFilter();
        Predicate<IAEItemStack> itemFilter = this.getFilter(this.searchString);
        if (NEI.searchField.existsSearchField()) {
            if (searchMode == SearchBoxMode.NEI_AUTOSEARCH || searchMode == SearchBoxMode.NEI_MANUAL_SEARCH) {
                NEI.searchField.setText(this.searchString);
            }
            Predicate<ItemStack> neiFilter = NEI.searchField.getFilter(this.searchString);
            itemFilter = is -> neiFilter.test(is.getItemStack());
        }
        if (itemFilter == null) {
            return;
        }
        IItemDisplayRegistry registry = AEApi.instance().registries().itemDisplay();
        block0: for (IAEItemStack is2 : this.list) {
            if (registry.isBlacklisted(is2.getItem()) || registry.isBlacklisted(is2.getItem().getClass())) continue;
            for (BiPredicate<TypeFilter, IAEItemStack> filter : registry.getItemFilters()) {
                if (filter.test((TypeFilter)typeFilter, is2)) continue;
                continue block0;
            }
            if (this.myPartitionList != null && !this.myPartitionList.isListed(is2) || viewMode == ViewItems.CRAFTABLE && !is2.isCraftable()) continue;
            if (viewMode == ViewItems.CRAFTABLE) {
                is2 = is2.copy();
                is2.setStackSize(0L);
            }
            if (viewMode == ViewItems.STORED && is2.getStackSize() == 0L || !itemFilter.test(is2)) continue;
            this.view.add(is2);
        }
        Enum SortBy = this.sortSrc.getSortBy();
        Enum SortDir2 = this.sortSrc.getSortDir();
        ItemSorters.setDirection((SortDir)SortDir2);
        ItemSorters.init();
        if (SortBy == SortOrder.MOD) {
            this.view.sort(ItemSorters.CONFIG_BASED_SORT_BY_MOD);
        } else if (SortBy == SortOrder.AMOUNT) {
            this.view.sort(ItemSorters.CONFIG_BASED_SORT_BY_SIZE);
        } else if (SortBy == SortOrder.INVTWEAKS) {
            this.view.sort(ItemSorters.CONFIG_BASED_SORT_BY_INV_TWEAKS);
        } else {
            this.view.sort(ItemSorters.CONFIG_BASED_SORT_BY_NAME);
        }
        for (IAEItemStack is3 : this.view) {
            this.dsp.add(is3.getItemStack());
        }
    }

    private Predicate<IAEItemStack> getFilter(String innerSearch) {
        if (innerSearch.length() == 0) {
            return stack -> true;
        }
        String prefix = innerSearch.substring(0, 1);
        if ("#".equals(prefix)) {
            Pattern pattern = ItemRepo.getPattern(innerSearch.substring(1));
            return stack -> {
                String tooltip = String.join((CharSequence)"\n", Platform.getTooltip(stack));
                return pattern.matcher(tooltip).find();
            };
        }
        if ("@".equals(prefix)) {
            Pattern pattern = ItemRepo.getPattern(innerSearch.substring(1));
            return stack -> {
                String mod = Platform.getModId(stack);
                return pattern.matcher(mod).find();
            };
        }
        if ("$".equals(prefix)) {
            Pattern pattern = ItemRepo.getPattern(innerSearch.substring(1));
            return stack -> {
                OreReference ores = OreHelper.INSTANCE.isOre(stack.getItemStack());
                return ores != null && pattern.matcher(String.join((CharSequence)"\n", ores.getEquivalents())).find();
            };
        }
        Pattern pattern = ItemRepo.getPattern(innerSearch);
        return stack -> {
            String name = Platform.getItemDisplayName(stack);
            if (pattern.matcher(name).find()) {
                return true;
            }
            String tooltip = String.join((CharSequence)"\n", Platform.getTooltip(stack));
            return pattern.matcher(tooltip).find();
        };
    }

    private static Pattern getPattern(String search) {
        int flags = 74;
        try {
            return Pattern.compile(search, 74);
        }
        catch (PatternSyntaxException __) {
            return Pattern.compile(Pattern.quote(search), 74);
        }
    }

    @Override
    public int size() {
        return this.view.size();
    }

    @Override
    public void clear() {
        this.list.resetStatus();
    }

    @Override
    public boolean hasPower() {
        return this.hasPower;
    }

    @Override
    public void setPowered(boolean hasPower) {
        this.hasPower = hasPower;
    }

    @Override
    public int getRowSize() {
        return this.rowSize;
    }

    @Override
    public void setRowSize(int rowSize) {
        this.rowSize = rowSize;
    }

    @Override
    public String getSearchString() {
        return this.searchString;
    }

    @Override
    public void setSearchString(@Nonnull String searchString) {
        this.searchString = searchString;
    }
}

