/*
 * Decompiled with CFR 0.152.
 */
package com.dreammaster.scripts;

import bartworks.common.loaders.ItemRegistry;
import com.dreammaster.gthandler.CustomItemList;
import com.dreammaster.scripts.IScriptLoader;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Mods;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.SubTag;
import gregtech.api.enums.TierEU;
import gregtech.api.interfaces.IRecipeMap;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.util.GTModHandler;
import gregtech.api.util.GTOreDictUnificator;
import gregtech.api.util.GTUtility;
import java.util.Arrays;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class ScriptLogisticPipes
implements IScriptLoader {
    private static final Materials[] solderingMaterials = new Materials[]{Materials.SolderingAlloy, Materials.Tin, Materials.Lead};

    @Override
    public String getScriptName() {
        return "Logistic Pipes";
    }

    @Override
    public List<String> getDependencies() {
        return Arrays.asList(Mods.LogisticsPipes.ID, Mods.ProjectRedExpansion.ID, Mods.ProjectRedCore.ID, Mods.AppliedEnergistics2.ID, Mods.BartWorks.ID, Mods.BuildCraftSilicon.ID, Mods.ExtraUtilities.ID, Mods.Forestry.ID, Mods.GalacticraftCore.ID, Mods.IndustrialCraft2.ID, Mods.IronChests.ID, Mods.OpenComputers.ID, Mods.Railcraft.ID, Mods.Thaumcraft.ID);
    }

    private static FluidStack getSolderingFluid(Materials material, long baseAmount) {
        if (material.contains(SubTag.SOLDERING_MATERIAL_GOOD)) {
            return material.getMolten(baseAmount);
        }
        if (material.contains(SubTag.SOLDERING_MATERIAL_BAD)) {
            return material.getMolten(baseAmount * 4L);
        }
        if (material.contains(SubTag.SOLDERING_MATERIAL)) {
            return material.getMolten(baseAmount * 2L);
        }
        return null;
    }

    @Override
    public void loadRecipes() {
        this.loadModuleRecipes();
        this.loadUpgradeRecipes();
        this.loadPipeRecipes();
        this.loadMiscRecipes();
    }

    private void loadModuleRecipes() {
        for (Materials solderingMaterial : solderingMaterials) {
            GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{GTOreDictUnificator.get((OrePrefixes)OrePrefixes.plate, (Object)Materials.Iron, (long)4L), GTOreDictUnificator.get((OrePrefixes)OrePrefixes.circuit, (Object)Materials.ULV, (long)1L), GTOreDictUnificator.get((OrePrefixes)OrePrefixes.wireGt01, (Object)Materials.Gold, (long)4L), GTUtility.getIntegratedCircuit((int)18)}).fluidInputs(new FluidStack[]{ScriptLogisticPipes.getSolderingFluid(solderingMaterial, 36L)}).itemOutputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.itemModule", (long)4L, (int)0, (ItemStack)missing)}).duration(300).eut(TierEU.RECIPE_LV).addTo((IRecipeMap)RecipeMaps.assemblerRecipes);
            GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.itemModule", (long)4L, (int)0, (ItemStack)missing), GTOreDictUnificator.get((OrePrefixes)OrePrefixes.plate, (Object)Materials.Steel, (long)2L), GTOreDictUnificator.get((OrePrefixes)OrePrefixes.circuit, (Object)Materials.ULV, (long)1L), GTOreDictUnificator.get((OrePrefixes)OrePrefixes.plate, (Object)Materials.RedAlloy, (long)1L), GTModHandler.getModItem((String)Mods.ProjectRedCore.ID, (String)"projectred.core.part", (long)2L, (int)32, (ItemStack)missing), GTUtility.getIntegratedCircuit((int)18)}).fluidInputs(new FluidStack[]{ScriptLogisticPipes.getSolderingFluid(solderingMaterial, 36L)}).itemOutputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.itemModule", (long)4L, (int)1, (ItemStack)missing)}).duration(500).eut(TierEU.RECIPE_LV).addTo((IRecipeMap)RecipeMaps.assemblerRecipes);
            GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.itemModule", (long)4L, (int)0, (ItemStack)missing), GTOreDictUnificator.get((OrePrefixes)OrePrefixes.plate, (Object)Materials.Steel, (long)2L), GTOreDictUnificator.get((OrePrefixes)OrePrefixes.circuit, (Object)Materials.ULV, (long)1L), GTOreDictUnificator.get((OrePrefixes)OrePrefixes.bolt, (Object)Materials.Steel, (long)8L), GTModHandler.getModItem((String)Mods.ProjectRedCore.ID, (String)"projectred.core.part", (long)2L, (int)20, (ItemStack)missing), GTUtility.getIntegratedCircuit((int)18)}).fluidInputs(new FluidStack[]{ScriptLogisticPipes.getSolderingFluid(solderingMaterial, 36L)}).itemOutputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.itemModule", (long)4L, (int)2, (ItemStack)missing)}).duration(300).eut(TierEU.RECIPE_LV).addTo((IRecipeMap)RecipeMaps.assemblerRecipes);
            GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.itemModule", (long)2L, (int)0, (ItemStack)missing), GTOreDictUnificator.get((OrePrefixes)OrePrefixes.plate, (Object)Materials.Lapis, (long)1L), GTOreDictUnificator.get((OrePrefixes)OrePrefixes.circuit, (Object)Materials.ULV, (long)1L), GTOreDictUnificator.get((OrePrefixes)OrePrefixes.bolt, (Object)Materials.Steel, (long)8L), GTModHandler.getModItem((String)Mods.ProjectRedCore.ID, (String)"projectred.core.part", (long)2L, (int)30, (ItemStack)missing), GTUtility.getIntegratedCircuit((int)18)}).fluidInputs(new FluidStack[]{ScriptLogisticPipes.getSolderingFluid(solderingMaterial, 36L)}).itemOutputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.itemModule", (long)2L, (int)3, (ItemStack)missing)}).duration(500).eut(TierEU.RECIPE_LV).addTo((IRecipeMap)RecipeMaps.assemblerRecipes);
            GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.itemModule", (long)2L, (int)1, (ItemStack)missing), GTOreDictUnificator.get((OrePrefixes)OrePrefixes.plate, (Object)Materials.RedAlloy, (long)4L), GTOreDictUnificator.get((OrePrefixes)OrePrefixes.circuit, (Object)Materials.ULV, (long)2L), GTOreDictUnificator.get((OrePrefixes)OrePrefixes.plate, (Object)Materials.Bronze, (long)2L), GTModHandler.getModItem((String)Mods.ProjectRedCore.ID, (String)"projectred.core.part", (long)2L, (int)20, (ItemStack)missing), GTUtility.getIntegratedCircuit((int)18)}).fluidInputs(new FluidStack[]{ScriptLogisticPipes.getSolderingFluid(solderingMaterial, 36L)}).itemOutputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.itemModule", (long)2L, (int)4, (ItemStack)missing)}).duration(400).eut(TierEU.RECIPE_LV).addTo((IRecipeMap)RecipeMaps.assemblerRecipes);
            GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.itemModule", (long)4L, (int)1, (ItemStack)missing), GTOreDictUnificator.get((OrePrefixes)OrePrefixes.plate, (Object)Materials.RedstoneAlloy, (long)1L), GTOreDictUnificator.get((OrePrefixes)OrePrefixes.circuit, (Object)Materials.ULV, (long)2L), GTOreDictUnificator.get((OrePrefixes)OrePrefixes.plate, (Object)Materials.Bronze, (long)1L), GTModHandler.getModItem((String)Mods.ProjectRedCore.ID, (String)"projectred.core.part", (long)2L, (int)20, (ItemStack)missing), GTUtility.getIntegratedCircuit((int)18)}).fluidInputs(new FluidStack[]{ScriptLogisticPipes.getSolderingFluid(solderingMaterial, 36L)}).itemOutputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.itemModule", (long)4L, (int)4, (ItemStack)missing)}).duration(600).eut(TierEU.RECIPE_LV).addTo((IRecipeMap)RecipeMaps.assemblerRecipes);
            GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.itemModule", (long)1L, (int)501, (ItemStack)missing), ItemList.Robot_Arm_LV.get(1L, new Object[0]), GTOreDictUnificator.get((OrePrefixes)OrePrefixes.circuit, (Object)Materials.MV, (long)2L), GTOreDictUnificator.get((OrePrefixes)OrePrefixes.plate, (Object)Materials.Lapis, (long)1L), GTOreDictUnificator.get((OrePrefixes)OrePrefixes.bolt, (Object)Materials.BlueAlloy, (long)8L), GTUtility.getIntegratedCircuit((int)18)}).fluidInputs(new FluidStack[]{ScriptLogisticPipes.getSolderingFluid(solderingMaterial, 36L)}).itemOutputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.itemModule", (long)1L, (int)5, (ItemStack)missing)}).duration(2400).eut(TierEU.RECIPE_MV).addTo((IRecipeMap)RecipeMaps.assemblerRecipes);
            GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.itemModule", (long)1L, (int)3, (ItemStack)missing), GTModHandler.getModItem((String)Mods.BuildCraftSilicon.ID, (String)"redstoneChipset", (long)1L, (int)5, (ItemStack)missing), GTUtility.getIntegratedCircuit((int)18)}).fluidInputs(new FluidStack[]{ScriptLogisticPipes.getSolderingFluid(solderingMaterial, 36L)}).itemOutputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.itemModule", (long)1L, (int)7, (ItemStack)missing)}).duration(900).eut(TierEU.RECIPE_LV).addTo((IRecipeMap)RecipeMaps.assemblerRecipes);
            GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.itemModule", (long)4L, (int)0, (ItemStack)missing), ItemList.Electric_Motor_LV.get(1L, new Object[0]), GTOreDictUnificator.get((OrePrefixes)OrePrefixes.circuit, (Object)Materials.ULV, (long)1L), GTOreDictUnificator.get((OrePrefixes)OrePrefixes.plate, (Object)Materials.Lapis, (long)1L), GTOreDictUnificator.get((OrePrefixes)OrePrefixes.bolt, (Object)Materials.Gold, (long)8L), GTModHandler.getModItem((String)Mods.ProjectRedCore.ID, (String)"projectred.core.part", (long)2L, (int)30, (ItemStack)missing), GTUtility.getIntegratedCircuit((int)18)}).fluidInputs(new FluidStack[]{ScriptLogisticPipes.getSolderingFluid(solderingMaterial, 36L)}).itemOutputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.itemModule", (long)4L, (int)500, (ItemStack)missing)}).duration(400).eut(TierEU.RECIPE_LV).addTo((IRecipeMap)RecipeMaps.assemblerRecipes);
            GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.itemModule", (long)1L, (int)9, (ItemStack)missing), GTOreDictUnificator.get((OrePrefixes)OrePrefixes.lens, (Object)Materials.Glass, (long)1L), ItemList.Conveyor_Module_MV.get(1L, new Object[0]), ItemList.Sensor_MV.get(1L, new Object[0]), GTOreDictUnificator.get((OrePrefixes)OrePrefixes.circuit, (Object)Materials.MV, (long)1L), GTUtility.getIntegratedCircuit((int)18)}).fluidInputs(new FluidStack[]{ScriptLogisticPipes.getSolderingFluid(solderingMaterial, 36L)}).itemOutputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.itemModule", (long)1L, (int)8, (ItemStack)missing)}).duration(1600).eut(TierEU.RECIPE_MV).addTo((IRecipeMap)RecipeMaps.assemblerRecipes);
            GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.itemModule", (long)1L, (int)9, (ItemStack)missing), ItemList.Robot_Arm_MV.get(1L, new Object[0]), GTOreDictUnificator.get((OrePrefixes)OrePrefixes.gearGtSmall, (Object)Materials.StainlessSteel, (long)4L), ItemList.Sensor_MV.get(1L, new Object[0]), ItemList.Emitter_MV.get(1L, new Object[0]), GTOreDictUnificator.get((OrePrefixes)OrePrefixes.circuit, (Object)Materials.MV, (long)1L), GTUtility.getIntegratedCircuit((int)18)}).fluidInputs(new FluidStack[]{ScriptLogisticPipes.getSolderingFluid(solderingMaterial, 36L)}).itemOutputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.itemModule", (long)1L, (int)10, (ItemStack)missing)}).duration(800).eut(TierEU.RECIPE_HV).addTo((IRecipeMap)RecipeMaps.assemblerRecipes);
            GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.itemModule", (long)5L, (int)0, (ItemStack)missing), ItemList.Emitter_MV.get(1L, new Object[0]), GTOreDictUnificator.get((OrePrefixes)OrePrefixes.circuit, (Object)Materials.MV, (long)1L), ItemList.Cover_Crafting.get(5L, new Object[0]), GTModHandler.getModItem((String)Mods.ProjectRedCore.ID, (String)"projectred.core.part", (long)2L, (int)30, (ItemStack)missing), GTUtility.getIntegratedCircuit((int)18)}).fluidInputs(new FluidStack[]{ScriptLogisticPipes.getSolderingFluid(solderingMaterial, 36L)}).itemOutputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.itemModule", (long)5L, (int)600, (ItemStack)missing)}).duration(800).eut(TierEU.RECIPE_LV).addTo((IRecipeMap)RecipeMaps.assemblerRecipes);
            GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.itemModule", (long)2L, (int)1, (ItemStack)missing), ItemList.Conveyor_Module_LV.get(1L, new Object[0]), ItemList.Circuit_Parts_Diode.get(2L, new Object[0]), GTOreDictUnificator.get((OrePrefixes)OrePrefixes.plate, (Object)Materials.Steel, (long)1L), GTModHandler.getModItem((String)Mods.ProjectRedCore.ID, (String)"projectred.core.part", (long)1L, (int)30, (ItemStack)missing), GTUtility.getIntegratedCircuit((int)18)}).fluidInputs(new FluidStack[]{ScriptLogisticPipes.getSolderingFluid(solderingMaterial, 36L)}).itemOutputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.itemModule", (long)2L, (int)17, (ItemStack)missing)}).duration(600).eut(TierEU.RECIPE_LV).addTo((IRecipeMap)RecipeMaps.assemblerRecipes);
        }
        GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.itemModule", (long)1L, (int)0, (ItemStack)missing), GTModHandler.getModItem((String)Mods.ExtraUtilities.ID, (String)"trashcan", (long)1L, (int)0, (ItemStack)missing)}).itemOutputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.itemModule", (long)1L, (int)6, (ItemStack)missing)}).duration(600).eut(TierEU.RECIPE_LV).addTo((IRecipeMap)RecipeMaps.formingPressRecipes);
        GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.itemModule", (long)1L, (int)3, (ItemStack)missing), GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.logisticsParts", (long)1L, (int)5, (ItemStack)missing)}).itemOutputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.itemModule", (long)1L, (int)103, (ItemStack)missing)}).duration(600).eut(TierEU.RECIPE_LV).addTo((IRecipeMap)RecipeMaps.formingPressRecipes);
        GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.itemModule", (long)1L, (int)7, (ItemStack)missing), GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.logisticsParts", (long)1L, (int)5, (ItemStack)missing)}).itemOutputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.itemModule", (long)1L, (int)107, (ItemStack)missing)}).duration(600).eut(TierEU.RECIPE_LV).addTo((IRecipeMap)RecipeMaps.formingPressRecipes);
        GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.itemModule", (long)1L, (int)103, (ItemStack)missing), GTModHandler.getModItem((String)Mods.BuildCraftSilicon.ID, (String)"redstoneChipset", (long)1L, (int)5, (ItemStack)missing)}).itemOutputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.itemModule", (long)1L, (int)107, (ItemStack)missing)}).duration(600).eut(TierEU.RECIPE_LV).addTo((IRecipeMap)RecipeMaps.formingPressRecipes);
        GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.itemModule", (long)1L, (int)3, (ItemStack)missing), GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.logisticsParts", (long)1L, (int)6, (ItemStack)missing)}).itemOutputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.itemModule", (long)1L, (int)203, (ItemStack)missing)}).duration(600).eut(TierEU.RECIPE_LV).addTo((IRecipeMap)RecipeMaps.formingPressRecipes);
        GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.itemModule", (long)1L, (int)7, (ItemStack)missing), GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.logisticsParts", (long)1L, (int)6, (ItemStack)missing)}).itemOutputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.itemModule", (long)1L, (int)207, (ItemStack)missing)}).duration(600).eut(TierEU.RECIPE_LV).addTo((IRecipeMap)RecipeMaps.formingPressRecipes);
        GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.itemModule", (long)1L, (int)203, (ItemStack)missing), GTModHandler.getModItem((String)Mods.BuildCraftSilicon.ID, (String)"redstoneChipset", (long)1L, (int)5, (ItemStack)missing)}).itemOutputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.itemModule", (long)1L, (int)207, (ItemStack)missing)}).duration(600).eut(TierEU.RECIPE_LV).addTo((IRecipeMap)RecipeMaps.formingPressRecipes);
        GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.itemModule", (long)1L, (int)500, (ItemStack)missing), GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.logisticsParts", (long)1L, (int)6, (ItemStack)missing)}).itemOutputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.itemModule", (long)1L, (int)501, (ItemStack)missing)}).duration(600).eut(TierEU.RECIPE_LV).addTo((IRecipeMap)RecipeMaps.formingPressRecipes);
        GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.itemModule", (long)1L, (int)1, (ItemStack)missing), GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"itemBatREDischarged", (long)1L, (int)0, (ItemStack)missing)}).itemOutputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.itemModule", (long)1L, (int)300, (ItemStack)missing)}).duration(600).eut(TierEU.RECIPE_LV).addTo((IRecipeMap)RecipeMaps.formingPressRecipes);
        GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.itemModule", (long)1L, (int)1, (ItemStack)missing), GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"itemBatRE", (long)1L, (int)Short.MAX_VALUE, (ItemStack)missing)}).itemOutputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.itemModule", (long)1L, (int)300, (ItemStack)missing)}).duration(600).eut(TierEU.RECIPE_LV).addTo((IRecipeMap)RecipeMaps.formingPressRecipes);
        GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.itemModule", (long)1L, (int)1, (ItemStack)missing), GTModHandler.getModItem((String)Mods.Forestry.ID, (String)"beeswax", (long)4L, (ItemStack)missing), ItemList.Circuit_Parts_Diode.get(2L, new Object[0]), GTUtility.getIntegratedCircuit((int)18)}).fluidInputs(new FluidStack[]{FluidRegistry.getFluidStack((String)"for.honey", (int)1000)}).itemOutputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.itemModule", (long)1L, (int)9, (ItemStack)missing)}).duration(800).eut(TierEU.RECIPE_LV).addTo((IRecipeMap)RecipeMaps.assemblerRecipes);
        GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.itemModule", (long)1L, (int)9, (ItemStack)missing), GTModHandler.getModItem((String)Mods.ExtraUtilities.ID, (String)"trashcan", (long)1L, (int)0, (ItemStack)missing)}).itemOutputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.itemModule", (long)1L, (int)11, (ItemStack)missing)}).duration(1600).eut(TierEU.RECIPE_MV).addTo((IRecipeMap)RecipeMaps.formingPressRecipes);
        GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.itemModule", (long)1L, (int)1, (ItemStack)missing), GTOreDictUnificator.get((OrePrefixes)OrePrefixes.gearGtSmall, (Object)Materials.Gold, (long)2L)}).itemOutputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.itemModule", (long)1L, (int)12, (ItemStack)missing)}).duration(600).eut(TierEU.RECIPE_LV).addTo((IRecipeMap)RecipeMaps.formingPressRecipes);
        GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.itemModule", (long)1L, (int)1, (ItemStack)missing), GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"writable_book", (long)1L, (int)Short.MAX_VALUE, (ItemStack)missing)}).itemOutputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.itemModule", (long)1L, (int)13, (ItemStack)missing)}).duration(600).eut(TierEU.RECIPE_LV).addTo((IRecipeMap)RecipeMaps.formingPressRecipes);
        GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.itemModule", (long)1L, (int)1, (ItemStack)missing), GTModHandler.getModItem((String)Mods.BuildCraftSilicon.ID, (String)"redstoneChipset", (long)1L, (int)5, (ItemStack)missing), GTModHandler.getModItem((String)Mods.Thaumcraft.ID, (String)"ItemShard", (long)2L, (int)6, (ItemStack)missing)}).itemOutputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.itemModule", (long)1L, (int)30, (ItemStack)missing)}).duration(600).eut(TierEU.RECIPE_LV).addTo((IRecipeMap)RecipeMaps.formingPressRecipes);
        GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.itemModule", (long)1L, (int)1, (ItemStack)missing), GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"enchanted_book", (long)1L, (int)Short.MAX_VALUE, (ItemStack)missing)}).itemOutputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.itemModule", (long)1L, (int)31, (ItemStack)missing)}).duration(600).eut(TierEU.RECIPE_LV).addTo((IRecipeMap)RecipeMaps.formingPressRecipes);
        GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.itemModule", (long)1L, (int)31, (ItemStack)missing), GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.logisticsParts", (long)1L, (int)5, (ItemStack)missing)}).itemOutputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.itemModule", (long)1L, (int)131, (ItemStack)missing)}).duration(600).eut(TierEU.RECIPE_LV).addTo((IRecipeMap)RecipeMaps.formingPressRecipes);
        GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.itemModule", (long)1L, (int)5, (ItemStack)missing), GTModHandler.getModItem((String)Mods.OpenComputers.ID, (String)"item", (long)2L, (int)24, (ItemStack)missing)}).itemOutputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.itemModule", (long)1L, (int)14, (ItemStack)missing)}).duration(2400).eut(TierEU.RECIPE_MV).addTo((IRecipeMap)RecipeMaps.formingPressRecipes);
        GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.itemModule", (long)1L, (int)1, (ItemStack)missing), GTModHandler.getModItem((String)Mods.OpenComputers.ID, (String)"item", (long)2L, (int)24, (ItemStack)missing)}).itemOutputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.itemModule", (long)1L, (int)15, (ItemStack)missing)}).duration(600).eut(TierEU.RECIPE_MV).addTo((IRecipeMap)RecipeMaps.formingPressRecipes);
        GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.itemModule", (long)4L, (int)600, (ItemStack)missing), GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.logisticsParts", (long)1L, (int)5, (ItemStack)missing)}).itemOutputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.itemModule", (long)4L, (int)601, (ItemStack)missing)}).duration(800).eut(TierEU.RECIPE_MV).addTo((IRecipeMap)RecipeMaps.formingPressRecipes);
        GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.itemModule", (long)4L, (int)601, (ItemStack)missing), GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.logisticsParts", (long)1L, (int)6, (ItemStack)missing)}).itemOutputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.itemModule", (long)4L, (int)602, (ItemStack)missing)}).duration(1800).eut(TierEU.RECIPE_MV).addTo((IRecipeMap)RecipeMaps.formingPressRecipes);
        GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.itemModule", (long)4L, (int)2, (ItemStack)missing), GTModHandler.getModItem((String)Mods.BuildCraftSilicon.ID, (String)"redstoneChipset", (long)1L, (int)2, (ItemStack)missing), GTModHandler.getModItem((String)Mods.ProjectRedCore.ID, (String)"projectred.core.part", (long)2L, (int)28, (ItemStack)missing)}).itemOutputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.itemModule", (long)4L, (int)502, (ItemStack)missing)}).duration(600).eut(TierEU.RECIPE_LV).addTo((IRecipeMap)RecipeMaps.assemblerRecipes);
        GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.itemModule", (long)1L, (int)1, (ItemStack)missing), GTModHandler.getModItem((String)Mods.BuildCraftSilicon.ID, (String)"redstoneChipset", (long)1L, (int)2, (ItemStack)missing)}).itemOutputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.itemModule", (long)1L, (int)16, (ItemStack)missing)}).duration(600).eut(TierEU.RECIPE_LV).addTo((IRecipeMap)RecipeMaps.formingPressRecipes);
    }

    private void loadUpgradeRecipes() {
        int circuit;
        int meta;
        int side;
        for (Materials solderingMaterial : solderingMaterials) {
            GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.ProjectRedCore.ID, (String)"projectred.core.part", (long)4L, (int)0, (ItemStack)missing), GTOreDictUnificator.get((OrePrefixes)OrePrefixes.circuit, (Object)Materials.ULV, (long)1L), GTOreDictUnificator.get((OrePrefixes)OrePrefixes.foil, (Object)Materials.Tin, (long)4L), GTOreDictUnificator.get((OrePrefixes)OrePrefixes.wireFine, (Object)Materials.Copper, (long)4L), GTUtility.getIntegratedCircuit((int)18)}).fluidInputs(new FluidStack[]{ScriptLogisticPipes.getSolderingFluid(solderingMaterial, 36L)}).itemOutputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.logisticsParts", (long)4L, (int)4, (ItemStack)missing)}).duration(600).eut(TierEU.RECIPE_LV).addTo((IRecipeMap)RecipeMaps.assemblerRecipes);
            GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.ProjectRedCore.ID, (String)"projectred.core.part", (long)4L, (int)0, (ItemStack)missing), GTOreDictUnificator.get((OrePrefixes)OrePrefixes.circuit, (Object)Materials.ULV, (long)1L), GTOreDictUnificator.get((OrePrefixes)OrePrefixes.foil, (Object)Materials.Tin, (long)4L), GTOreDictUnificator.get((OrePrefixes)OrePrefixes.wireFine, (Object)Materials.AnnealedCopper, (long)4L), GTUtility.getIntegratedCircuit((int)18)}).fluidInputs(new FluidStack[]{ScriptLogisticPipes.getSolderingFluid(solderingMaterial, 36L)}).itemOutputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.logisticsParts", (long)4L, (int)4, (ItemStack)missing)}).duration(600).eut(TierEU.RECIPE_LV).addTo((IRecipeMap)RecipeMaps.assemblerRecipes);
        }
        for (side = 0; side < 6; ++side) {
            meta = side;
            circuit = side < 2 ? side + 5 : side - 1;
            GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.logisticsParts", (long)4L, (int)4, (ItemStack)missing), ItemList.Electric_Piston_LV.get(1L, new Object[0]), GTOreDictUnificator.get((OrePrefixes)OrePrefixes.foil, (Object)Materials.Bronze, (long)2L), GTModHandler.getModItem((String)Mods.ProjectRedCore.ID, (String)"projectred.core.part", (long)4L, (int)33, (ItemStack)missing), GTUtility.getIntegratedCircuit((int)circuit)}).itemOutputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.itemUpgrade", (long)4L, (int)meta, (ItemStack)missing)}).duration(200).eut(TierEU.RECIPE_LV).addTo((IRecipeMap)RecipeMaps.assemblerRecipes);
            this.addShapedRecipe(GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.itemUpgrade", (long)1L, (int)0, (ItemStack)missing), null, null, "craftingToolScrewdriver", null, GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.itemUpgrade", (long)1L, (int)meta, (ItemStack)missing), null, null, null, null);
            this.addShapedRecipe(GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.itemUpgrade", (long)1L, (int)1, (ItemStack)missing), null, null, null, null, GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.itemUpgrade", (long)1L, (int)meta, (ItemStack)missing), null, null, null, "craftingToolScrewdriver");
            this.addShapedRecipe(GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.itemUpgrade", (long)1L, (int)2, (ItemStack)missing), null, "craftingToolScrewdriver", null, null, GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.itemUpgrade", (long)1L, (int)meta, (ItemStack)missing), null, null, null, null);
            this.addShapedRecipe(GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.itemUpgrade", (long)1L, (int)3, (ItemStack)missing), null, null, null, null, GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.itemUpgrade", (long)1L, (int)meta, (ItemStack)missing), null, null, "craftingToolScrewdriver", null);
            this.addShapedRecipe(GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.itemUpgrade", (long)1L, (int)4, (ItemStack)missing), null, null, null, null, GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.itemUpgrade", (long)1L, (int)meta, (ItemStack)missing), "craftingToolScrewdriver", null, null, null);
            this.addShapedRecipe(GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.itemUpgrade", (long)1L, (int)5, (ItemStack)missing), null, null, null, "craftingToolScrewdriver", GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.itemUpgrade", (long)1L, (int)meta, (ItemStack)missing), null, null, null, null);
        }
        for (side = 0; side < 6; ++side) {
            meta = side + 10;
            circuit = side < 2 ? side + 5 : side - 1;
            GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.logisticsParts", (long)1L, (int)4, (ItemStack)missing), GTOreDictUnificator.get((OrePrefixes)OrePrefixes.plate, (Object)Materials.Steel, (long)1L), GTUtility.getIntegratedCircuit((int)circuit)}).itemOutputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.itemUpgrade", (long)4L, (int)meta, (ItemStack)missing)}).duration(160).eut(TierEU.RECIPE_LV).addTo((IRecipeMap)RecipeMaps.assemblerRecipes);
            this.addShapedRecipe(GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.itemUpgrade", (long)1L, (int)10, (ItemStack)missing), null, null, "craftingToolScrewdriver", null, GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.itemUpgrade", (long)1L, (int)meta, (ItemStack)missing), null, null, null, null);
            this.addShapedRecipe(GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.itemUpgrade", (long)1L, (int)11, (ItemStack)missing), null, null, null, null, GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.itemUpgrade", (long)1L, (int)meta, (ItemStack)missing), null, null, null, "craftingToolScrewdriver");
            this.addShapedRecipe(GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.itemUpgrade", (long)1L, (int)12, (ItemStack)missing), null, "craftingToolScrewdriver", null, null, GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.itemUpgrade", (long)1L, (int)meta, (ItemStack)missing), null, null, null, null);
            this.addShapedRecipe(GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.itemUpgrade", (long)1L, (int)13, (ItemStack)missing), null, null, null, null, GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.itemUpgrade", (long)1L, (int)meta, (ItemStack)missing), null, null, "craftingToolScrewdriver", null);
            this.addShapedRecipe(GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.itemUpgrade", (long)1L, (int)14, (ItemStack)missing), null, null, null, null, GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.itemUpgrade", (long)1L, (int)meta, (ItemStack)missing), "craftingToolScrewdriver", null, null, null);
            this.addShapedRecipe(GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.itemUpgrade", (long)1L, (int)15, (ItemStack)missing), null, null, null, "craftingToolScrewdriver", GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.itemUpgrade", (long)1L, (int)meta, (ItemStack)missing), null, null, null, null);
        }
        GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.logisticsParts", (long)8L, (int)4, (ItemStack)missing), ItemList.Electric_Motor_LV.get(1L, new Object[0]), GTModHandler.getModItem((String)Mods.ProjectRedCore.ID, (String)"projectred.core.part", (long)2L, (int)32, (ItemStack)missing), GTUtility.getIntegratedCircuit((int)18)}).itemOutputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.itemUpgrade", (long)8L, (int)20, (ItemStack)missing)}).fluidInputs(new FluidStack[]{Materials.Lubricant.getFluid(500L)}).duration(600).eut(TierEU.RECIPE_LV).addTo((IRecipeMap)RecipeMaps.assemblerRecipes);
        GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.logisticsParts", (long)2L, (int)4, (ItemStack)missing), ItemList.Sensor_LV.get(1L, new Object[0]), GTModHandler.getModItem((String)Mods.BuildCraftSilicon.ID, (String)"redstoneChipset", (long)1L, (int)2, (ItemStack)missing), GTModHandler.getModItem((String)Mods.ProjectRedCore.ID, (String)"projectred.core.part", (long)1L, (int)23, (ItemStack)missing), GTUtility.getIntegratedCircuit((int)18)}).itemOutputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.itemUpgrade", (long)2L, (int)21, (ItemStack)missing)}).duration(800).eut(TierEU.RECIPE_MV).addTo((IRecipeMap)RecipeMaps.assemblerRecipes);
        GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.logisticsParts", (long)1L, (int)4, (ItemStack)missing), GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.itemModule", (long)1L, (int)600, (ItemStack)missing), ItemList.Large_Fluid_Cell_Steel.get(1L, new Object[0]), GTUtility.getIntegratedCircuit((int)18)}).itemOutputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.itemUpgrade", (long)4L, (int)22, (ItemStack)missing)}).duration(600).eut(TierEU.RECIPE_MV).addTo((IRecipeMap)RecipeMaps.assemblerRecipes);
        GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.logisticsParts", (long)2L, (int)4, (ItemStack)missing), ItemList.Conveyor_Module_LV.get(1L, new Object[0]), GTOreDictUnificator.get((OrePrefixes)OrePrefixes.foil, (Object)Materials.RedAlloy, (long)1L), GTModHandler.getModItem((String)Mods.ProjectRedCore.ID, (String)"projectred.core.part", (long)2L, (int)33, (ItemStack)missing), GTUtility.getIntegratedCircuit((int)18)}).itemOutputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.itemUpgrade", (long)2L, (int)23, (ItemStack)missing)}).duration(600).eut(TierEU.RECIPE_LV).addTo((IRecipeMap)RecipeMaps.assemblerRecipes);
        GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.logisticsParts", (long)2L, (int)4, (ItemStack)missing), ItemList.Robot_Arm_LV.get(1L, new Object[0]), GTOreDictUnificator.get((OrePrefixes)OrePrefixes.foil, (Object)Materials.RedAlloy, (long)1L), GTModHandler.getModItem((String)Mods.ProjectRedCore.ID, (String)"projectred.core.part", (long)2L, (int)20, (ItemStack)missing), GTUtility.getIntegratedCircuit((int)18)}).itemOutputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.itemUpgrade", (long)2L, (int)24, (ItemStack)missing)}).duration(600).eut(TierEU.RECIPE_LV).addTo((IRecipeMap)RecipeMaps.assemblerRecipes);
        GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.logisticsParts", (long)2L, (int)4, (ItemStack)missing), GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"wool", (long)1L, (int)Short.MAX_VALUE, (ItemStack)missing), GTOreDictUnificator.get((OrePrefixes)OrePrefixes.foil, (Object)Materials.Steel, (long)1L), GTModHandler.getModItem((String)Mods.ProjectRedCore.ID, (String)"projectred.core.part", (long)2L, (int)26, (ItemStack)missing), GTUtility.getIntegratedCircuit((int)18)}).itemOutputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.itemUpgrade", (long)2L, (int)25, (ItemStack)missing)}).duration(600).eut(TierEU.RECIPE_LV).addTo((IRecipeMap)RecipeMaps.assemblerRecipes);
        GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.logisticsParts", (long)1L, (int)4, (ItemStack)missing), ItemList.Emitter_MV.get(1L, new Object[0]), ItemList.Sensor_MV.get(1L, new Object[0]), GTModHandler.getModItem((String)Mods.BuildCraftSilicon.ID, (String)"redstoneChipset", (long)1L, (int)3, (ItemStack)missing), GTModHandler.getModItem((String)Mods.ProjectRedCore.ID, (String)"projectred.core.part", (long)1L, (int)24, (ItemStack)missing), GTUtility.getIntegratedCircuit((int)18)}).itemOutputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.itemUpgrade", (long)1L, (int)41, (ItemStack)missing)}).duration(1200).eut(TierEU.RECIPE_MV).addTo((IRecipeMap)RecipeMaps.assemblerRecipes);
        GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.logisticsParts", (long)1L, (int)4, (ItemStack)missing), GTOreDictUnificator.get((OrePrefixes)OrePrefixes.plate, (Object)Materials.Tin, (long)1L)}).itemOutputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.itemUpgrade", (long)4L, (int)42, (ItemStack)missing)}).duration(160).eut(TierEU.RECIPE_LV).addTo((IRecipeMap)RecipeMaps.formingPressRecipes);
        GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.logisticsParts", (long)1L, (int)4, (ItemStack)missing), GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.itemModule", (long)1L, (int)107, (ItemStack)missing), GTModHandler.getModItem((String)Mods.BuildCraftSilicon.ID, (String)"redstoneChipset", (long)1L, (int)2, (ItemStack)missing), GTModHandler.getModItem((String)Mods.ProjectRedCore.ID, (String)"projectred.core.part", (long)1L, (int)33, (ItemStack)missing), GTUtility.getIntegratedCircuit((int)18)}).itemOutputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.itemUpgrade", (long)1L, (int)26, (ItemStack)missing)}).duration(1200).eut(TierEU.RECIPE_MV).addTo((IRecipeMap)RecipeMaps.assemblerRecipes);
        GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.logisticsParts", (long)2L, (int)4, (ItemStack)missing), GTOreDictUnificator.get((OrePrefixes)OrePrefixes.circuit, (Object)Materials.ULV, (long)1L), GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"chest", (long)1L, (int)0, (ItemStack)missing), GTModHandler.getModItem((String)Mods.ProjectRedCore.ID, (String)"projectred.core.part", (long)2L, (int)34, (ItemStack)missing), GTUtility.getIntegratedCircuit((int)18)}).itemOutputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.itemUpgrade", (long)2L, (int)44, (ItemStack)missing)}).duration(400).eut(TierEU.RECIPE_LV).addTo((IRecipeMap)RecipeMaps.assemblerRecipes);
    }

    private void loadPipeRecipes() {
        for (Materials solderingMaterial : solderingMaterials) {
            GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.PipeItemsBasicTransport", (long)8L, (int)0, (ItemStack)missing), GTOreDictUnificator.get((OrePrefixes)OrePrefixes.gearGtSmall, (Object)Materials.Gold, (long)1L), GTOreDictUnificator.get((OrePrefixes)OrePrefixes.gem, (Object)Materials.Diamond, (long)1L), GTOreDictUnificator.get((OrePrefixes)OrePrefixes.plate, (Object)Materials.Steel, (long)2L), GTOreDictUnificator.get((OrePrefixes)OrePrefixes.wireFine, (Object)Materials.RedAlloy, (long)16L), GTUtility.getIntegratedCircuit((int)18)}).fluidInputs(new FluidStack[]{ScriptLogisticPipes.getSolderingFluid(solderingMaterial, 36L)}).itemOutputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.PipeItemsBasicLogistics", (long)8L, (int)0, (ItemStack)missing)}).duration(400).eut(TierEU.RECIPE_LV).addTo((IRecipeMap)RecipeMaps.assemblerRecipes);
            GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.PipeItemsBasicTransport", (long)16L, (int)0, (ItemStack)missing), GTOreDictUnificator.get((OrePrefixes)OrePrefixes.gearGtSmall, (Object)Materials.Gold, (long)1L), GTOreDictUnificator.get((OrePrefixes)OrePrefixes.gem, (Object)Materials.Diamond, (long)1L), GTOreDictUnificator.get((OrePrefixes)OrePrefixes.plate, (Object)Materials.Steel, (long)2L), GTOreDictUnificator.get((OrePrefixes)OrePrefixes.wireFine, (Object)Materials.RedstoneAlloy, (long)8L), GTUtility.getIntegratedCircuit((int)18)}).fluidInputs(new FluidStack[]{ScriptLogisticPipes.getSolderingFluid(solderingMaterial, 36L)}).itemOutputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.PipeItemsBasicLogistics", (long)16L, (int)0, (ItemStack)missing)}).duration(400).eut(TierEU.RECIPE_LV).addTo((IRecipeMap)RecipeMaps.assemblerRecipes);
        }
        GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.PipeItemsBasicLogistics", (long)1L, (int)0, (ItemStack)missing), ItemList.Emitter_LV.get(1L, new Object[0]), ItemList.Conveyor_Module_LV.get(1L, new Object[0]), GTOreDictUnificator.get((OrePrefixes)OrePrefixes.plate, (Object)Materials.EnderPearl, (long)4L), GTUtility.getIntegratedCircuit((int)18)}).itemOutputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.PipeItemsRequestLogistics", (long)1L, (int)0, (ItemStack)missing)}).duration(600).eut(TierEU.RECIPE_LV).addTo((IRecipeMap)RecipeMaps.assemblerRecipes);
        GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.PipeItemsRequestLogistics", (long)1L, (int)0, (ItemStack)missing), GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.logisticsParts", (long)2L, (int)5, (ItemStack)missing), GTModHandler.getModItem((String)Mods.BuildCraftSilicon.ID, (String)"redstoneChipset", (long)4L, (int)1, (ItemStack)missing), GTUtility.getIntegratedCircuit((int)18)}).itemOutputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.PipeItemsRequestLogisticsMk2", (long)1L, (int)0, (ItemStack)missing)}).duration(600).eut(TierEU.RECIPE_MV).addTo((IRecipeMap)RecipeMaps.assemblerRecipes);
        GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.PipeItemsBasicLogistics", (long)3L, (int)0, (ItemStack)missing), GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.itemModule", (long)1L, (int)500, (ItemStack)missing), GTUtility.getIntegratedCircuit((int)18)}).itemOutputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.PipeItemsProviderLogistics", (long)3L, (int)0, (ItemStack)missing)}).duration(600).eut(TierEU.RECIPE_LV).addTo((IRecipeMap)RecipeMaps.assemblerRecipes);
        GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.PipeItemsProviderLogistics", (long)2L, (int)0, (ItemStack)missing), GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.logisticsParts", (long)1L, (int)6, (ItemStack)missing), GTUtility.getIntegratedCircuit((int)18)}).itemOutputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.PipeItemsProviderLogisticsMk2", (long)2L, (int)0, (ItemStack)missing)}).duration(600).eut(TierEU.RECIPE_LV).addTo((IRecipeMap)RecipeMaps.assemblerRecipes);
        GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.PipeItemsBasicLogistics", (long)2L, (int)0, (ItemStack)missing), GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.itemModule", (long)1L, (int)501, (ItemStack)missing), GTUtility.getIntegratedCircuit((int)18)}).itemOutputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.PipeItemsProviderLogisticsMk2", (long)2L, (int)0, (ItemStack)missing)}).duration(600).eut(TierEU.RECIPE_LV).addTo((IRecipeMap)RecipeMaps.assemblerRecipes);
        GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.PipeItemsBasicLogistics", (long)2L, (int)0, (ItemStack)missing), GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.itemModule", (long)1L, (int)600, (ItemStack)missing), GTUtility.getIntegratedCircuit((int)18)}).itemOutputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.PipeItemsCraftingLogistics", (long)2L, (int)0, (ItemStack)missing)}).duration(600).eut(TierEU.RECIPE_LV).addTo((IRecipeMap)RecipeMaps.assemblerRecipes);
        GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.PipeItemsCraftingLogistics", (long)2L, (int)0, (ItemStack)missing), GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.logisticsParts", (long)1L, (int)5, (ItemStack)missing), GTUtility.getIntegratedCircuit((int)18)}).itemOutputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.PipeItemsCraftingLogisticsMk2", (long)2L, (int)0, (ItemStack)missing)}).duration(600).eut(TierEU.RECIPE_LV).addTo((IRecipeMap)RecipeMaps.assemblerRecipes);
        GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.PipeItemsBasicLogistics", (long)2L, (int)0, (ItemStack)missing), GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.itemModule", (long)1L, (int)601, (ItemStack)missing), GTUtility.getIntegratedCircuit((int)18)}).itemOutputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.PipeItemsCraftingLogisticsMk2", (long)2L, (int)0, (ItemStack)missing)}).duration(600).eut(TierEU.RECIPE_LV).addTo((IRecipeMap)RecipeMaps.assemblerRecipes);
        GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.PipeItemsCraftingLogisticsMk2", (long)2L, (int)0, (ItemStack)missing), GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.logisticsParts", (long)1L, (int)6, (ItemStack)missing), GTUtility.getIntegratedCircuit((int)18)}).itemOutputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.PipeItemsCraftingLogisticsMk3", (long)2L, (int)0, (ItemStack)missing)}).duration(600).eut(TierEU.RECIPE_LV).addTo((IRecipeMap)RecipeMaps.assemblerRecipes);
        GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.PipeItemsBasicLogistics", (long)2L, (int)0, (ItemStack)missing), GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.itemModule", (long)1L, (int)602, (ItemStack)missing), GTUtility.getIntegratedCircuit((int)18)}).itemOutputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.PipeItemsCraftingLogisticsMk3", (long)2L, (int)0, (ItemStack)missing)}).duration(600).eut(TierEU.RECIPE_LV).addTo((IRecipeMap)RecipeMaps.assemblerRecipes);
        GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.PipeItemsBasicLogistics", (long)2L, (int)0, (ItemStack)missing), GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.itemModule", (long)1L, (int)0, (ItemStack)missing), ItemList.Robot_Arm_LV.get(1L, new Object[0]), GTModHandler.getModItem((String)Mods.BuildCraftSilicon.ID, (String)"redstoneChipset", (long)2L, (int)5, (ItemStack)missing), GTOreDictUnificator.get((OrePrefixes)OrePrefixes.plate, (Object)Materials.EnderPearl, (long)1L), GTUtility.getIntegratedCircuit((int)18)}).itemOutputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.PipeItemsSatelliteLogistics", (long)2L, (int)0, (ItemStack)missing)}).duration(600).eut(TierEU.RECIPE_LV).addTo((IRecipeMap)RecipeMaps.assemblerRecipes);
        GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.PipeItemsBasicLogistics", (long)3L, (int)0, (ItemStack)missing), GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.itemModule", (long)1L, (int)502, (ItemStack)missing), GTUtility.getIntegratedCircuit((int)18)}).itemOutputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.PipeItemsSupplierLogistics", (long)3L, (int)0, (ItemStack)missing)}).duration(600).eut(TierEU.RECIPE_LV).addTo((IRecipeMap)RecipeMaps.assemblerRecipes);
        GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.PipeItemsBasicLogistics", (long)2L, (int)0, (ItemStack)missing), GTOreDictUnificator.get((OrePrefixes)OrePrefixes.plate, (Object)Materials.RedAlloy, (long)2L), GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"chest", (long)1L, (int)0, (ItemStack)missing), GTUtility.getIntegratedCircuit((int)18)}).itemOutputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.PipeLogisticsChassiMk1", (long)2L, (int)0, (ItemStack)missing)}).duration(600).eut(TierEU.RECIPE_LV).addTo((IRecipeMap)RecipeMaps.assemblerRecipes);
        GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.PipeLogisticsChassiMk1", (long)2L, (int)0, (ItemStack)missing), GTOreDictUnificator.get((OrePrefixes)OrePrefixes.plate, (Object)Materials.Aluminium, (long)2L), GTModHandler.getModItem((String)Mods.IronChests.ID, (String)"BlockIronChest", (long)1L, (int)3, (ItemStack)missing), GTModHandler.getModItem((String)Mods.BuildCraftSilicon.ID, (String)"redstoneChipset", (long)1L, (int)5, (ItemStack)missing), GTUtility.getIntegratedCircuit((int)18)}).itemOutputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.PipeLogisticsChassiMk2", (long)2L, (int)0, (ItemStack)missing)}).duration(600).eut(TierEU.RECIPE_LV).addTo((IRecipeMap)RecipeMaps.assemblerRecipes);
        GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.PipeItemsBasicLogistics", (long)6L, (int)0, (ItemStack)missing), GTOreDictUnificator.get((OrePrefixes)OrePrefixes.plate, (Object)Materials.Aluminium, (long)4L), GTModHandler.getModItem((String)Mods.IronChests.ID, (String)"BlockIronChest", (long)1L, (int)3, (ItemStack)missing), GTOreDictUnificator.get((OrePrefixes)OrePrefixes.circuit, (Object)Materials.LV, (long)1L), GTUtility.getIntegratedCircuit((int)18)}).itemOutputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.PipeLogisticsChassiMk2", (long)6L, (int)0, (ItemStack)missing)}).duration(600).eut(TierEU.RECIPE_LV).addTo((IRecipeMap)RecipeMaps.assemblerRecipes);
        GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.PipeLogisticsChassiMk2", (long)2L, (int)0, (ItemStack)missing), GTOreDictUnificator.get((OrePrefixes)OrePrefixes.plate, (Object)Materials.Electrum, (long)2L), GTModHandler.getModItem((String)Mods.IronChests.ID, (String)"BlockIronChest", (long)1L, (int)0, (ItemStack)missing), GTModHandler.getModItem((String)Mods.BuildCraftSilicon.ID, (String)"redstoneChipset", (long)1L, (int)2, (ItemStack)missing), GTUtility.getIntegratedCircuit((int)18)}).itemOutputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.PipeLogisticsChassiMk3", (long)2L, (int)0, (ItemStack)missing)}).duration(600).eut(TierEU.RECIPE_LV).addTo((IRecipeMap)RecipeMaps.assemblerRecipes);
        GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.PipeItemsBasicLogistics", (long)6L, (int)0, (ItemStack)missing), GTOreDictUnificator.get((OrePrefixes)OrePrefixes.plate, (Object)Materials.Electrum, (long)4L), GTModHandler.getModItem((String)Mods.IronChests.ID, (String)"BlockIronChest", (long)2L, (int)0, (ItemStack)missing), GTOreDictUnificator.get((OrePrefixes)OrePrefixes.circuit, (Object)Materials.MV, (long)1L), GTUtility.getIntegratedCircuit((int)18)}).itemOutputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.PipeLogisticsChassiMk3", (long)6L, (int)0, (ItemStack)missing)}).duration(600).eut(TierEU.RECIPE_LV).addTo((IRecipeMap)RecipeMaps.assemblerRecipes);
        GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.PipeLogisticsChassiMk3", (long)2L, (int)0, (ItemStack)missing), GTOreDictUnificator.get((OrePrefixes)OrePrefixes.plate, (Object)Materials.Kanthal, (long)2L), GTModHandler.getModItem((String)Mods.IronChests.ID, (String)"BlockIronChest", (long)1L, (int)4, (ItemStack)missing), GTModHandler.getModItem((String)Mods.BuildCraftSilicon.ID, (String)"redstoneChipset", (long)1L, (int)3, (ItemStack)missing), GTUtility.getIntegratedCircuit((int)18)}).itemOutputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.PipeLogisticsChassiMk4", (long)2L, (int)0, (ItemStack)missing)}).duration(600).eut(TierEU.RECIPE_LV).addTo((IRecipeMap)RecipeMaps.assemblerRecipes);
        GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.PipeItemsBasicLogistics", (long)6L, (int)0, (ItemStack)missing), GTOreDictUnificator.get((OrePrefixes)OrePrefixes.plate, (Object)Materials.Kanthal, (long)8L), GTModHandler.getModItem((String)Mods.IronChests.ID, (String)"BlockIronChest", (long)2L, (int)4, (ItemStack)missing), GTOreDictUnificator.get((OrePrefixes)OrePrefixes.circuit, (Object)Materials.MV, (long)1L), GTUtility.getIntegratedCircuit((int)18)}).itemOutputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.PipeLogisticsChassiMk4", (long)6L, (int)0, (ItemStack)missing)}).duration(600).eut(TierEU.RECIPE_LV).addTo((IRecipeMap)RecipeMaps.assemblerRecipes);
        GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.PipeLogisticsChassiMk4", (long)2L, (int)0, (ItemStack)missing), GTOreDictUnificator.get((OrePrefixes)OrePrefixes.plate, (Object)Materials.VibrantAlloy, (long)2L), GTModHandler.getModItem((String)Mods.IronChests.ID, (String)"BlockIronChest", (long)1L, (int)1, (ItemStack)missing), GTModHandler.getModItem((String)Mods.BuildCraftSilicon.ID, (String)"redstoneChipset", (long)1L, (int)7, (ItemStack)missing), GTUtility.getIntegratedCircuit((int)18)}).itemOutputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.PipeLogisticsChassiMk5", (long)2L, (int)0, (ItemStack)missing)}).duration(600).eut(TierEU.RECIPE_LV).addTo((IRecipeMap)RecipeMaps.assemblerRecipes);
        GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.PipeItemsBasicLogistics", (long)12L, (int)0, (ItemStack)missing), GTOreDictUnificator.get((OrePrefixes)OrePrefixes.plate, (Object)Materials.VibrantAlloy, (long)6L), GTModHandler.getModItem((String)Mods.IronChests.ID, (String)"BlockIronChest", (long)2L, (int)1, (ItemStack)missing), GTOreDictUnificator.get((OrePrefixes)OrePrefixes.circuit, (Object)Materials.HV, (long)1L), GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.logisticsParts", (long)1L, (int)6, (ItemStack)missing), GTUtility.getIntegratedCircuit((int)18)}).itemOutputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.PipeLogisticsChassiMk5", (long)12L, (int)0, (ItemStack)missing)}).duration(1200).eut(TierEU.RECIPE_LV).addTo((IRecipeMap)RecipeMaps.assemblerRecipes);
        GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.remoteOrdererItem", (long)0L, (int)Short.MAX_VALUE, (ItemStack)missing), GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.PipeItemsRequestLogistics", (long)1L, (int)0, (ItemStack)missing), GTUtility.getIntegratedCircuit((int)18)}).itemOutputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.PipeItemsRemoteOrdererLogistics", (long)1L, (int)0, (ItemStack)missing)}).duration(600).eut(TierEU.RECIPE_LV).addTo((IRecipeMap)RecipeMaps.assemblerRecipes);
        GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.PipeItemsBasicLogistics", (long)2L, (int)0, (ItemStack)missing), GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.itemModule", (long)1L, (int)8, (ItemStack)missing), GTUtility.getIntegratedCircuit((int)18)}).itemOutputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.PipeItemsApiaristAnalyser", (long)2L, (int)0, (ItemStack)missing)}).duration(1600).eut(TierEU.RECIPE_MV).addTo((IRecipeMap)RecipeMaps.assemblerRecipes);
        GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.PipeItemsBasicLogistics", (long)3L, (int)0, (ItemStack)missing), GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.itemModule", (long)1L, (int)9, (ItemStack)missing), GTUtility.getIntegratedCircuit((int)18)}).itemOutputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.PipeItemsApiaristSink", (long)3L, (int)0, (ItemStack)missing)}).duration(800).eut(TierEU.RECIPE_LV).addTo((IRecipeMap)RecipeMaps.assemblerRecipes);
        GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.PipeItemsBasicLogistics", (long)1L, (int)0, (ItemStack)missing), GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"web", (long)1L, (int)0, (ItemStack)missing), GTUtility.getIntegratedCircuit((int)18)}).itemOutputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.PipeItemsFirewall", (long)1L, (int)0, (ItemStack)missing)}).duration(600).eut(TierEU.RECIPE_LV).addTo((IRecipeMap)RecipeMaps.assemblerRecipes);
        GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.PipeFluidBasic", (long)5L, (int)0, (ItemStack)missing), ItemList.Robot_Arm_LV.get(1L, new Object[0]), GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"bucket", (long)1L, (int)0, (ItemStack)missing), ItemList.Large_Fluid_Cell_Steel.get(1L, new Object[0]), GTUtility.getIntegratedCircuit((int)18)}).itemOutputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.PipeItemsFluidSupplier", (long)5L, (int)0, (ItemStack)missing)}).duration(600).eut(TierEU.RECIPE_MV).addTo((IRecipeMap)RecipeMaps.assemblerRecipes);
        for (Materials solderingMaterial : solderingMaterials) {
            GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.PipeItemsBasicLogistics", (long)12L, (int)0, (ItemStack)missing), ItemList.Electric_Pump_LV.get(1L, new Object[0]), ItemList.Large_Fluid_Cell_Steel.get(1L, new Object[0]), GTUtility.getIntegratedCircuit((int)18)}).fluidInputs(new FluidStack[]{ScriptLogisticPipes.getSolderingFluid(solderingMaterial, 144L)}).itemOutputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.PipeFluidBasic", (long)12L, (int)0, (ItemStack)missing)}).duration(800).eut(TierEU.RECIPE_LV).addTo((IRecipeMap)RecipeMaps.assemblerRecipes);
        }
        GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.PipeFluidBasic", (long)6L, (int)0, (ItemStack)missing), ItemList.Electric_Pump_MV.get(1L, new Object[0]), ItemList.Large_Fluid_Cell_Steel.get(1L, new Object[0]), GTUtility.getIntegratedCircuit((int)18)}).itemOutputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.PipeFluidInsertion", (long)6L, (int)0, (ItemStack)missing)}).duration(600).eut(TierEU.RECIPE_LV).addTo((IRecipeMap)RecipeMaps.assemblerRecipes);
        GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.PipeFluidBasic", (long)3L, (int)0, (ItemStack)missing), GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.itemModule", (long)1L, (int)500, (ItemStack)missing), ItemList.Large_Fluid_Cell_Steel.get(1L, new Object[0]), GTUtility.getIntegratedCircuit((int)18)}).itemOutputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.PipeFluidProvider", (long)3L, (int)0, (ItemStack)missing)}).duration(600).eut(TierEU.RECIPE_MV).addTo((IRecipeMap)RecipeMaps.assemblerRecipes);
        GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.PipeFluidBasic", (long)1L, (int)0, (ItemStack)missing), GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.PipeItemsRequestLogistics", (long)1L, (int)0, (ItemStack)missing), ItemList.Large_Fluid_Cell_Steel.get(1L, new Object[0]), GTUtility.getIntegratedCircuit((int)18)}).itemOutputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.PipeFluidRequestLogistics", (long)1L, (int)0, (ItemStack)missing)}).duration(600).eut(TierEU.RECIPE_MV).addTo((IRecipeMap)RecipeMaps.assemblerRecipes);
        GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.PipeFluidBasic", (long)4L, (int)0, (ItemStack)missing), GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.itemModule", (long)1L, (int)3, (ItemStack)missing), ItemList.Large_Fluid_Cell_Steel.get(1L, new Object[0]), GTUtility.getIntegratedCircuit((int)18)}).itemOutputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.PipeFluidExtractor", (long)4L, (int)0, (ItemStack)missing)}).duration(600).eut(TierEU.RECIPE_MV).addTo((IRecipeMap)RecipeMaps.assemblerRecipes);
        GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.PipeFluidBasic", (long)1L, (int)0, (ItemStack)missing), GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.itemModule", (long)1L, (int)0, (ItemStack)missing), ItemList.Robot_Arm_LV.get(1L, new Object[0]), GTModHandler.getModItem((String)Mods.BuildCraftSilicon.ID, (String)"redstoneChipset", (long)2L, (int)5, (ItemStack)missing), GTOreDictUnificator.get((OrePrefixes)OrePrefixes.plate, (Object)Materials.EnderPearl, (long)1L), GTUtility.getIntegratedCircuit((int)18)}).itemOutputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.PipeFluidSatellite", (long)1L, (int)0, (ItemStack)missing)}).duration(600).eut(TierEU.RECIPE_MV).addTo((IRecipeMap)RecipeMaps.assemblerRecipes);
        GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.PipeFluidBasic", (long)4L, (int)0, (ItemStack)missing), GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.itemModule", (long)1L, (int)502, (ItemStack)missing), ItemList.Large_Fluid_Cell_Steel.get(1L, new Object[0]), GTUtility.getIntegratedCircuit((int)18)}).itemOutputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.PipeFluidSupplierMk2", (long)4L, (int)0, (ItemStack)missing)}).duration(600).eut(TierEU.RECIPE_MV).addTo((IRecipeMap)RecipeMaps.assemblerRecipes);
        GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{GTOreDictUnificator.get((OrePrefixes)OrePrefixes.stickLong, (Object)Materials.Steel, (long)2L), new ItemStack(ItemRegistry.PUMPPARTS, 1, 0), GTOreDictUnificator.get((OrePrefixes)OrePrefixes.wireFine, (Object)Materials.Gold, (long)2L), GTUtility.getIntegratedCircuit((int)18)}).itemOutputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.PipeItemsBasicTransport", (long)8L, (int)0, (ItemStack)missing)}).duration(100).eut(TierEU.RECIPE_LV).addTo((IRecipeMap)RecipeMaps.assemblerRecipes);
        GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{GTOreDictUnificator.get((OrePrefixes)OrePrefixes.stickLong, (Object)Materials.Steel, (long)2L), GTModHandler.getModItem((String)Mods.Railcraft.ID, (String)"glass", (long)4L, (int)0, (ItemStack)missing), GTOreDictUnificator.get((OrePrefixes)OrePrefixes.wireFine, (Object)Materials.Gold, (long)8L), GTUtility.getIntegratedCircuit((int)18)}).itemOutputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.PipeItemsBasicTransport", (long)32L, (int)0, (ItemStack)missing)}).duration(100).eut(TierEU.RECIPE_LV).addTo((IRecipeMap)RecipeMaps.assemblerRecipes);
        GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{GTOreDictUnificator.get((OrePrefixes)OrePrefixes.stickLong, (Object)Materials.Steel, (long)2L), GTModHandler.getModItem((String)Mods.ExtraUtilities.ID, (String)"decorativeBlock2", (long)4L, (int)5, (ItemStack)missing), GTOreDictUnificator.get((OrePrefixes)OrePrefixes.wireFine, (Object)Materials.Gold, (long)8L), GTUtility.getIntegratedCircuit((int)18)}).itemOutputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.PipeItemsBasicTransport", (long)32L, (int)0, (ItemStack)missing)}).duration(100).eut(TierEU.RECIPE_LV).addTo((IRecipeMap)RecipeMaps.assemblerRecipes);
        GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{GTOreDictUnificator.get((OrePrefixes)OrePrefixes.stickLong, (Object)Materials.Aluminium, (long)2L), GTOreDictUnificator.get((OrePrefixes)OrePrefixes.plate, (Object)Materials.ReinforceGlass, (long)4L), GTOreDictUnificator.get((OrePrefixes)OrePrefixes.wireFine, (Object)Materials.Gold, (long)16L), GTUtility.getIntegratedCircuit((int)18)}).itemOutputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.PipeItemsBasicTransport", (long)64L, (int)0, (ItemStack)missing)}).duration(100).eut(TierEU.RECIPE_LV).addTo((IRecipeMap)RecipeMaps.assemblerRecipes);
        GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{GTOreDictUnificator.get((OrePrefixes)OrePrefixes.stickLong, (Object)Materials.Aluminium, (long)2L), GTOreDictUnificator.get((OrePrefixes)OrePrefixes.plate, (Object)Materials.BorosilicateGlass, (long)2L), GTOreDictUnificator.get((OrePrefixes)OrePrefixes.wireFine, (Object)Materials.Gold, (long)16L), GTUtility.getIntegratedCircuit((int)18)}).itemOutputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.PipeItemsBasicTransport", (long)64L, (int)0, (ItemStack)missing)}).duration(100).eut(TierEU.RECIPE_LV).addTo((IRecipeMap)RecipeMaps.assemblerRecipes);
    }

    private void loadMiscRecipes() {
        for (Materials solderingMaterial : solderingMaterials) {
            GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{ItemList.Transformer_MV_LV.get(1L, new Object[0]), GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.PipeItemsBasicLogistics", (long)4L, (int)0, (ItemStack)missing), GTOreDictUnificator.get((OrePrefixes)OrePrefixes.circuit, (Object)Materials.LV, (long)2L), GTOreDictUnificator.get((OrePrefixes)OrePrefixes.cableGt04, (Object)Materials.Copper, (long)4L), GTOreDictUnificator.get((OrePrefixes)OrePrefixes.screw, (Object)Materials.Steel, (long)8L), GTUtility.getIntegratedCircuit((int)24)}).fluidInputs(new FluidStack[]{ScriptLogisticPipes.getSolderingFluid(solderingMaterial, 288L)}).itemOutputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"logisticsSolidBlock", (long)1L, (int)1, (ItemStack)missing)}).duration(800).eut(TierEU.RECIPE_LV).addTo((IRecipeMap)RecipeMaps.assemblerRecipes);
            GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{ItemList.Transformer_MV_LV.get(1L, new Object[0]), GTOreDictUnificator.get((OrePrefixes)OrePrefixes.circuit, (Object)Materials.LV, (long)2L), GTOreDictUnificator.get((OrePrefixes)OrePrefixes.cableGt04, (Object)Materials.AnnealedCopper, (long)4L), GTOreDictUnificator.get((OrePrefixes)OrePrefixes.screw, (Object)Materials.Steel, (long)8L), GTUtility.getIntegratedCircuit((int)24)}).fluidInputs(new FluidStack[]{ScriptLogisticPipes.getSolderingFluid(solderingMaterial, 288L)}).itemOutputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"logisticsSolidBlock", (long)1L, (int)1, (ItemStack)missing)}).duration(800).eut(TierEU.RECIPE_LV).addTo((IRecipeMap)RecipeMaps.assemblerRecipes);
        }
        GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{ItemList.Hull_MV.get(1L, new Object[0]), GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.PipeItemsBasicLogistics", (long)4L, (int)0, (ItemStack)missing), GTOreDictUnificator.get((OrePrefixes)OrePrefixes.plate, (Object)Materials.Electrum, (long)8L), GTOreDictUnificator.get((OrePrefixes)OrePrefixes.circuit, (Object)Materials.LV, (long)2L), GTOreDictUnificator.get((OrePrefixes)OrePrefixes.cableGt08, (Object)Materials.Copper, (long)4L), GTOreDictUnificator.get((OrePrefixes)OrePrefixes.bolt, (Object)Materials.Steel, (long)4L), GTUtility.getIntegratedCircuit((int)24)}).fluidInputs(new FluidStack[]{Materials.Plastic.getMolten(576L)}).itemOutputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"logisticsSolidBlock", (long)1L, (int)2, (ItemStack)missing)}).duration(1600).eut(TierEU.RECIPE_MV).addTo((IRecipeMap)RecipeMaps.assemblerRecipes);
        GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{ItemList.Hull_LV.get(1L, new Object[0]), GTModHandler.getModItem((String)Mods.Forestry.ID, (String)"factory2", (long)1L, (int)2, (ItemStack)missing), ItemList.Electric_Piston_LV.get(1L, new Object[0]), GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.PipeItemsBasicLogistics", (long)1L, (int)0, (ItemStack)missing), GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.itemModule", (long)1L, (int)600, (ItemStack)missing), GTOreDictUnificator.get((OrePrefixes)OrePrefixes.circuit, (Object)Materials.MV, (long)2L), GTOreDictUnificator.get((OrePrefixes)OrePrefixes.cableGt08, (Object)Materials.Copper, (long)2L), GTOreDictUnificator.get((OrePrefixes)OrePrefixes.bolt, (Object)Materials.BlueAlloy, (long)4L), GTUtility.getIntegratedCircuit((int)24)}).fluidInputs(new FluidStack[]{Materials.Plastic.getMolten(576L)}).itemOutputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"logisticsSolidBlock", (long)1L, (int)3, (ItemStack)missing)}).duration(900).eut(TierEU.RECIPE_LV).addTo((IRecipeMap)RecipeMaps.assemblerRecipes);
        GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{ItemList.Hull_LV.get(1L, new Object[0]), GTModHandler.getModItem((String)Mods.ProjectRedExpansion.ID, (String)"projectred.expansion.machine2", (long)1L, (int)10, (ItemStack)missing), ItemList.Electric_Piston_LV.get(1L, new Object[0]), GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.PipeItemsBasicLogistics", (long)1L, (int)0, (ItemStack)missing), GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.itemModule", (long)1L, (int)600, (ItemStack)missing), GTOreDictUnificator.get((OrePrefixes)OrePrefixes.circuit, (Object)Materials.MV, (long)2L), GTOreDictUnificator.get((OrePrefixes)OrePrefixes.cableGt08, (Object)Materials.Copper, (long)2L), GTOreDictUnificator.get((OrePrefixes)OrePrefixes.bolt, (Object)Materials.BlueAlloy, (long)4L), GTUtility.getIntegratedCircuit((int)24)}).fluidInputs(new FluidStack[]{Materials.Plastic.getMolten(576L)}).itemOutputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"logisticsSolidBlock", (long)1L, (int)3, (ItemStack)missing)}).duration(900).eut(TierEU.RECIPE_LV).addTo((IRecipeMap)RecipeMaps.assemblerRecipes);
        GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"logisticsSolidBlock", (long)1L, (int)3, (ItemStack)missing), GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.itemUpgrade", (long)1L, (int)25, (ItemStack)missing)}).itemOutputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"logisticsSolidBlock", (long)1L, (int)4, (ItemStack)missing)}).duration(600).eut(TierEU.RECIPE_LV).addTo((IRecipeMap)RecipeMaps.formingPressRecipes);
        GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{ItemList.Hull_MV.get(1L, new Object[0]), GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.PipeItemsBasicLogistics", (long)4L, (int)0, (ItemStack)missing), ItemList.Sensor_MV.get(1L, new Object[0]), GTOreDictUnificator.get((OrePrefixes)OrePrefixes.plate, (Object)Materials.Aluminium, (long)8L), GTOreDictUnificator.get((OrePrefixes)OrePrefixes.circuit, (Object)Materials.MV, (long)1L), GTOreDictUnificator.get((OrePrefixes)OrePrefixes.cableGt02, (Object)Materials.Copper, (long)4L), GTUtility.getIntegratedCircuit((int)24)}).fluidInputs(new FluidStack[]{Materials.Plastic.getMolten(576L)}).itemOutputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"logisticsSolidBlock", (long)1L, (int)5, (ItemStack)missing)}).duration(1600).eut(TierEU.RECIPE_MV).addTo((IRecipeMap)RecipeMaps.assemblerRecipes);
        GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{ItemList.Hull_MV.get(1L, new Object[0]), CustomItemList.Display.get(1L, new Object[0]), ItemList.Cover_Crafting.get(1L, new Object[0]), GTModHandler.getModItem((String)Mods.OpenComputers.ID, (String)"keyboard", (long)1L, (int)0, (ItemStack)missing), GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.PipeItemsRequestLogistics", (long)1L, (int)0, (ItemStack)missing), GTModHandler.getModItem((String)Mods.IronChests.ID, (String)"BlockIronChest", (long)1L, (int)3, (ItemStack)missing), GTOreDictUnificator.get((OrePrefixes)OrePrefixes.circuit, (Object)Materials.MV, (long)2L), GTUtility.getIntegratedCircuit((int)24)}).fluidInputs(new FluidStack[]{Materials.Plastic.getMolten(576L)}).itemOutputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.PipeBlockRequestTable", (long)1L, (int)0, (ItemStack)missing)}).duration(1600).eut(TierEU.RECIPE_MV).addTo((IRecipeMap)RecipeMaps.assemblerRecipes);
        for (Materials solderingMaterial : solderingMaterials) {
            GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.BuildCraftSilicon.ID, (String)"redstoneChipset", (long)2L, (int)2, (ItemStack)missing), GTOreDictUnificator.get((OrePrefixes)OrePrefixes.plate, (Object)Materials.NetherQuartz, (long)2L), ItemList.Circuit_Parts_Diode.get(1L, new Object[0]), GTModHandler.getModItem((String)Mods.AppliedEnergistics2.ID, (String)"item.ItemMultiMaterial", (long)1L, (int)22, (ItemStack)missing), GTOreDictUnificator.get((OrePrefixes)OrePrefixes.bolt, (Object)Materials.Steel, (long)4L), GTUtility.getIntegratedCircuit((int)18)}).fluidInputs(new FluidStack[]{ScriptLogisticPipes.getSolderingFluid(solderingMaterial, 36L)}).itemOutputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.logisticsParts", (long)4L, (int)5, (ItemStack)missing)}).duration(400).eut(TierEU.RECIPE_LV).addTo((IRecipeMap)RecipeMaps.assemblerRecipes);
            GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.logisticsParts", (long)2L, (int)5, (ItemStack)missing), GTOreDictUnificator.get((OrePrefixes)OrePrefixes.plate, (Object)Materials.StainlessSteel, (long)2L), ItemList.Circuit_Parts_Diode.get(2L, new Object[0]), GTModHandler.getModItem((String)Mods.AppliedEnergistics2.ID, (String)"item.ItemMultiMaterial", (long)1L, (int)24, (ItemStack)missing), GTOreDictUnificator.get((OrePrefixes)OrePrefixes.bolt, (Object)Materials.Platinum, (long)4L), GTUtility.getIntegratedCircuit((int)18)}).fluidInputs(new FluidStack[]{ScriptLogisticPipes.getSolderingFluid(solderingMaterial, 36L)}).itemOutputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.logisticsParts", (long)4L, (int)6, (ItemStack)missing)}).duration(800).eut(TierEU.RECIPE_HV).addTo((IRecipeMap)RecipeMaps.assemblerRecipes);
            GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.logisticsParts", (long)1L, (int)5, (ItemStack)missing), com.dreammaster.item.ItemList.GoldCoreChip.getIS(1), ItemList.Robot_Arm_MV.get(2L, new Object[0]), GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"upgradeModule", (long)2L, (int)0, (ItemStack)missing), GTOreDictUnificator.get((OrePrefixes)OrePrefixes.bolt, (Object)Materials.RedSteel, (long)16L), GTUtility.getIntegratedCircuit((int)18)}).fluidInputs(new FluidStack[]{ScriptLogisticPipes.getSolderingFluid(solderingMaterial, 72L)}).itemOutputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.logisticsParts", (long)1L, (int)7, (ItemStack)missing)}).duration(900).eut(TierEU.RECIPE_MV).addTo((IRecipeMap)RecipeMaps.assemblerRecipes);
            GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.logisticsParts", (long)1L, (int)7, (ItemStack)missing), com.dreammaster.item.ItemList.DiamondCoreChip.getIS(1), ItemList.Robot_Arm_HV.get(1L, new Object[0]), GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"upgradeModule", (long)4L, (int)0, (ItemStack)missing), GTOreDictUnificator.get((OrePrefixes)OrePrefixes.bolt, (Object)Materials.RedSteel, (long)32L), GTUtility.getIntegratedCircuit((int)18)}).fluidInputs(new FluidStack[]{ScriptLogisticPipes.getSolderingFluid(solderingMaterial, 144L)}).itemOutputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.logisticsParts", (long)1L, (int)8, (ItemStack)missing)}).duration(900).eut(TierEU.RECIPE_MV).addTo((IRecipeMap)RecipeMaps.assemblerRecipes);
        }
        GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{ItemList.Emitter_MV.get(1L, new Object[0]), ItemList.Sensor_MV.get(1L, new Object[0]), CustomItemList.Display.get(1L, new Object[0]), GTOreDictUnificator.get((OrePrefixes)OrePrefixes.plate, (Object)Materials.Aluminium, (long)4L), GTOreDictUnificator.get((OrePrefixes)OrePrefixes.circuit, (Object)Materials.HV, (long)1L), GTOreDictUnificator.get((OrePrefixes)OrePrefixes.wireGt01, (Object)Materials.Copper, (long)4L), GTOreDictUnificator.get((OrePrefixes)OrePrefixes.screw, (Object)Materials.Diamond, (long)4L), GTUtility.getIntegratedCircuit((int)18)}).fluidInputs(new FluidStack[]{Materials.Plastic.getMolten(144L)}).itemOutputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.remoteOrdererItem", (long)1L, (int)0, (ItemStack)missing)}).duration(1600).eut(TierEU.RECIPE_MV).addTo((IRecipeMap)RecipeMaps.assemblerRecipes);
        GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{ItemList.Cover_Screen.get(1L, new Object[0]), GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"sign", (long)1L, (int)0, (ItemStack)missing), GTUtility.getIntegratedCircuit((int)18)}).itemOutputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.ItemPipeSignCreator", (long)1L, (int)0, (ItemStack)missing)}).duration(200).eut(TierEU.RECIPE_LV).addTo((IRecipeMap)RecipeMaps.assemblerRecipes);
        GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{ItemList.Cover_Screen.get(1L, new Object[0]), GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.itemModule", (long)1L, (int)0, (ItemStack)missing), GTUtility.getIntegratedCircuit((int)18)}).itemOutputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.pipeController", (long)1L, (int)0, (ItemStack)missing)}).duration(1600).eut(TierEU.RECIPE_LV).addTo((IRecipeMap)RecipeMaps.assemblerRecipes);
        this.addShapedRecipe(GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.itemDisk", (long)1L, (int)0, (ItemStack)missing), "plateCarbon", "plateCarbon", "plateCarbon", "plateCarbon", GTModHandler.getModItem((String)Mods.OpenComputers.ID, (String)"item", (long)1L, (int)19, (ItemStack)missing), "plateCarbon", "plateCarbon", "circuitULV", "plateCarbon");
        this.addShapedRecipe(GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.logisticsHUDGlasses", (long)1L, (int)0, (ItemStack)missing), GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.logisticsParts", (long)1L, (int)1, (ItemStack)missing), GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.logisticsParts", (long)1L, (int)2, (ItemStack)missing), GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.logisticsParts", (long)1L, (int)1, (ItemStack)missing), "screwAluminium", "circuitGood", "screwAluminium", GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.logisticsParts", (long)1L, (int)0, (ItemStack)missing), "craftingToolScrewdriver", GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.logisticsParts", (long)1L, (int)0, (ItemStack)missing));
        GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{GTOreDictUnificator.get((OrePrefixes)OrePrefixes.bolt, (Object)Materials.Aluminium, (long)1L), GTOreDictUnificator.get((OrePrefixes)OrePrefixes.stickLong, (Object)Materials.Diamond, (long)1L), GTUtility.getIntegratedCircuit((int)18)}).fluidInputs(new FluidStack[]{Materials.Aluminium.getMolten(144L)}).itemOutputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.logisticsParts", (long)1L, (int)0, (ItemStack)missing)}).duration(1600).eut(TierEU.RECIPE_MV).addTo((IRecipeMap)RecipeMaps.assemblerRecipes);
        GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{GTOreDictUnificator.get((OrePrefixes)OrePrefixes.lens, (Object)Materials.Glass, (long)1L), GTOreDictUnificator.get((OrePrefixes)OrePrefixes.ring, (Object)Materials.Aluminium, (long)1L), GTOreDictUnificator.get((OrePrefixes)OrePrefixes.circuit, (Object)Materials.MV, (long)1L), GTUtility.getIntegratedCircuit((int)18)}).fluidInputs(new FluidStack[]{Materials.Aluminium.getMolten(144L)}).itemOutputs(new ItemStack[]{GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.logisticsParts", (long)1L, (int)1, (ItemStack)missing)}).duration(800).eut(TierEU.RECIPE_MV).addTo((IRecipeMap)RecipeMaps.assemblerRecipes);
        this.addShapedRecipe(GTModHandler.getModItem((String)Mods.LogisticsPipes.ID, (String)"item.logisticsParts", (long)1L, (int)2, (ItemStack)missing), GTModHandler.getModItem((String)Mods.BuildCraftSilicon.ID, (String)"redstoneChipset", (long)1L, (int)3, (ItemStack)missing), "stickDiamond", GTModHandler.getModItem((String)Mods.BuildCraftSilicon.ID, (String)"redstoneChipset", (long)1L, (int)3, (ItemStack)missing), "craftingToolFile", "screwAluminium", "craftingToolSoftHammer", null, "craftingToolScrewdriver", null);
    }
}

