/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.archaicfix.recipe;

import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;

public class LastMatchedInfo {
    public final IRecipe recipe;
    int hash;
    ItemStack[] invItems;

    public LastMatchedInfo(IRecipe recipe, InventoryCrafting inventory) {
        this.invItems = new ItemStack[inventory.func_70302_i_()];
        for (int i = 0; i < this.invItems.length; ++i) {
            ItemStack stack = inventory.func_70301_a(i);
            this.invItems[i] = stack != null ? stack.func_77946_l() : null;
        }
        this.recipe = recipe;
        this.hash = this.getHash(inventory);
    }

    private boolean matchesSavedInventory(InventoryCrafting inventory) {
        if (this.invItems == null) {
            return false;
        }
        if (this.invItems.length != inventory.func_70302_i_()) {
            return false;
        }
        for (int i = 0; i < this.invItems.length; ++i) {
            ItemStack newStack = inventory.func_70301_a(i);
            if (this.invItems[i] == null && newStack == null) continue;
            if (this.invItems[i] == null || newStack == null) {
                return false;
            }
            if (this.invItems[i].func_77969_a(newStack) && ItemStack.func_77970_a((ItemStack)this.invItems[i], (ItemStack)newStack)) continue;
            return false;
        }
        return true;
    }

    public boolean matches(InventoryCrafting crafting) {
        if (this.getHash(crafting) != this.hash) {
            return false;
        }
        return this.matchesSavedInventory(crafting);
    }

    public ItemStack getCraftingResult(InventoryCrafting inventory) {
        if (this.recipe != null) {
            return this.recipe.func_77572_b(inventory);
        }
        return null;
    }

    private int getHash(InventoryCrafting inventory) {
        int result = 1;
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack stack = inventory.func_70301_a(i);
            int hashCode = 1;
            if (stack != null) {
                hashCode = 31 * hashCode + Item.func_150891_b((Item)stack.func_77973_b());
                hashCode = 31 * hashCode + stack.func_77960_j();
                hashCode = 31 * hashCode + (!stack.func_77942_o() ? 0 : stack.func_77978_p().hashCode());
            }
            result = 17 * result + hashCode;
        }
        return result;
    }
}

