/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.api2.client.gui.resources.textures;

import betterquesting.api2.client.gui.misc.GuiRectangle;
import betterquesting.api2.client.gui.misc.IGuiRect;
import betterquesting.api2.client.gui.resources.colors.GuiColorStatic;
import betterquesting.api2.client.gui.resources.colors.IGuiColor;
import betterquesting.api2.client.gui.resources.textures.IGuiTexture;
import betterquesting.api2.client.gui.themes.presets.PresetTexture;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public class FluidTexture
implements IGuiTexture {
    private static final IGuiColor defColor = new GuiColorStatic(255, 255, 255, 255);
    private final FluidStack fluid;
    private final boolean showCount;
    private final boolean keepAspect;
    private final IGuiRect bounds = new GuiRectangle(0, 0, 16, 16);

    public FluidTexture(FluidStack fluid) {
        this(fluid, false, true);
    }

    public FluidTexture(FluidStack fluid, boolean showCount, boolean keepAspect) {
        this.fluid = fluid;
        this.showCount = showCount;
        this.keepAspect = keepAspect;
    }

    @Override
    public void drawTexture(int x, int y, int width, int height, float zDepth, float partialTick) {
        this.drawTexture(x, y, width, height, zDepth, partialTick, defColor);
    }

    @Override
    public void drawTexture(int x, int y, int width, int height, float zDepth, float partialTick, IGuiColor color) {
        if (width <= 0 || height <= 0) {
            return;
        }
        float sx = (float)width / 16.0f;
        float sy = (float)height / 16.0f;
        double dx = 0.0;
        double dy = 0.0;
        if (this.keepAspect) {
            float sa = Math.min(sx, sy);
            dx = Math.floor((sx - sa) * 8.0f);
            dy = Math.floor((sy - sa) * 8.0f);
            sx = sa;
            sy = sa;
        }
        GL11.glPushMatrix();
        GL11.glTranslated((double)((double)x + dx), (double)((double)y + dy), (double)0.0);
        GL11.glScalef((float)sx, (float)sy, (float)1.0f);
        int fCol = this.fluid.getFluid().getColor(this.fluid);
        float a = (float)(fCol >> 24 & 0xFF) / 255.0f;
        float r = (float)(fCol >> 16 & 0xFF) / 255.0f;
        float g = (float)(fCol >> 8 & 0xFF) / 255.0f;
        float b = (float)(fCol & 0xFF) / 255.0f;
        GL11.glColor4f((float)(r += color.getRed() / 2.0f), (float)(g += color.getGreen() / 2.0f), (float)(b += color.getBlue() / 2.0f), (float)(a += color.getAlpha() / 2.0f));
        Minecraft mc = Minecraft.func_71410_x();
        mc.field_71446_o.func_110577_a(TextureMap.field_110575_b);
        IIcon icon = this.fluid.getFluid().getIcon() != null ? this.fluid.getFluid().getIcon() : ((TextureMap)mc.field_71446_o.func_110581_b(TextureMap.field_110575_b)).func_110572_b("missigno");
        this.drawTexturedModalRect(0.0, 0.0, 0.0, icon, 16.0, 16.0);
        GL11.glPopMatrix();
    }

    @Override
    public ResourceLocation getTexture() {
        return PresetTexture.TX_NULL;
    }

    @Override
    public IGuiRect getBounds() {
        return this.bounds;
    }

    private void drawTexturedModalRect(double xCoord, double yCoord, double zDepth, IIcon textureSprite, double widthIn, double heightIn) {
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a(xCoord, yCoord + heightIn, zDepth, (double)textureSprite.func_94209_e(), (double)textureSprite.func_94210_h());
        tessellator.func_78374_a(xCoord + widthIn, yCoord + heightIn, zDepth, (double)textureSprite.func_94212_f(), (double)textureSprite.func_94210_h());
        tessellator.func_78374_a(xCoord + widthIn, yCoord, zDepth, (double)textureSprite.func_94212_f(), (double)textureSprite.func_94206_g());
        tessellator.func_78374_a(xCoord, yCoord, zDepth, (double)textureSprite.func_94209_e(), (double)textureSprite.func_94206_g());
        tessellator.func_78381_a();
    }
}

