/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.SolarSystem.planets.kuiperbelt.dimension;

import galaxyspace.SolarSystem.planets.kuiperbelt.dimension.WorldProviderKuiper;
import galaxyspace.SolarSystem.planets.kuiperbelt.world.BiomeGenBaseKuiper;
import galaxyspace.core.entity.mob.EntityEvolvedColdBlaze;
import galaxyspace.core.entity.mob.EntityEvolvedEnderman;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3;
import micdoodle8.mods.galacticraft.core.blocks.GCBlocks;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedCreeper;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedSkeleton;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedSpider;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedZombie;
import micdoodle8.mods.galacticraft.core.perlin.NoiseModule;
import micdoodle8.mods.galacticraft.core.perlin.generator.Billowed;
import micdoodle8.mods.galacticraft.core.perlin.generator.Gradient;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.planets.asteroids.ConfigManagerAsteroids;
import micdoodle8.mods.galacticraft.planets.asteroids.blocks.AsteroidBlocks;
import micdoodle8.mods.galacticraft.planets.asteroids.world.gen.SpecialAsteroidBlock;
import micdoodle8.mods.galacticraft.planets.asteroids.world.gen.SpecialAsteroidBlockHandler;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.block.BlockFalling;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.util.IProgressUpdate;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import net.minecraft.world.gen.ChunkProviderGenerate;
import net.minecraft.world.gen.feature.WorldGenFlowers;
import net.minecraft.world.gen.feature.WorldGenLakes;
import net.minecraft.world.gen.feature.WorldGenTallGrass;
import net.minecraft.world.gen.feature.WorldGenTrees;

public class ChunkProviderKuiper
extends ChunkProviderGenerate {
    final Block ASTEROID_STONE;
    final byte ASTEROID_STONE_META_0 = 0;
    final byte ASTEROID_STONE_META_1 = 1;
    final byte ASTEROID_STONE_META_2 = (byte)2;
    final Block ASTEROID_ICE;
    final Block DIRT;
    final byte DIRT_META = 0;
    final Block GRASS;
    final byte GRASS_META = 0;
    final Block LIGHT;
    final byte LIGHT_META = 0;
    final Block TALL_GRASS;
    final byte TALL_GRASS_META = 1;
    final Block FLOWER;
    final Block LAVA;
    final byte LAVA_META = 0;
    final Block WATER;
    final byte WATER_META = 0;
    private final Random rand;
    private final World worldObj;
    private final NoiseModule asteroidDensity;
    private final NoiseModule asteroidTurbulance;
    private final NoiseModule asteroidSkewX;
    private final NoiseModule asteroidSkewY;
    private final NoiseModule asteroidSkewZ;
    private final SpecialAsteroidBlockHandler coreHandler;
    private final SpecialAsteroidBlockHandler shellHandler;
    private ArrayList<AsteroidData> largeAsteroids;
    private static HashSet<BlockVec3> chunksDone = new HashSet();
    private int largeAsteroidsLastChunkX;
    private int largeAsteroidsLastChunkZ;

    public ChunkProviderKuiper(World par1World, long par2, boolean par4) {
        super(par1World, par2, par4);
        this.ASTEROID_STONE = AsteroidBlocks.blockBasic;
        this.ASTEROID_ICE = AsteroidBlocks.blockDenseIce;
        this.DIRT = Blocks.field_150346_d;
        this.GRASS = Blocks.field_150349_c;
        this.LIGHT = Blocks.field_150426_aN;
        this.TALL_GRASS = Blocks.field_150329_H;
        this.FLOWER = Blocks.field_150328_O;
        this.LAVA = Blocks.field_150353_l;
        this.WATER = Blocks.field_150355_j;
        this.largeAsteroids = new ArrayList();
        this.worldObj = par1World;
        this.rand = new Random(par2);
        this.asteroidDensity = new Billowed(this.rand.nextLong(), 2, 0.25f);
        this.asteroidDensity.setFrequency(0.009f);
        this.asteroidDensity.amplitude = 0.6f;
        this.asteroidTurbulance = new Gradient(this.rand.nextLong(), 1, 0.2f);
        this.asteroidTurbulance.setFrequency(0.08f);
        this.asteroidTurbulance.amplitude = 0.5f;
        this.asteroidSkewX = new Gradient(this.rand.nextLong(), 1, 1.0f);
        this.asteroidSkewX.amplitude = 8.0f;
        this.asteroidSkewX.frequencyX = 0.005f;
        this.asteroidSkewY = new Gradient(this.rand.nextLong(), 1, 1.0f);
        this.asteroidSkewY.amplitude = 8.0f;
        this.asteroidSkewY.frequencyY = 0.005f;
        this.asteroidSkewZ = new Gradient(this.rand.nextLong(), 1, 1.0f);
        this.asteroidSkewZ.amplitude = 8.0f;
        this.asteroidSkewZ.frequencyZ = 0.005f;
        SpecialAsteroidBlockHandler coreHandler = this.coreHandler = new SpecialAsteroidBlockHandler();
        Block asteroid_STONE = this.ASTEROID_STONE;
        ((Object)((Object)this)).getClass();
        coreHandler.addBlock(new SpecialAsteroidBlock(asteroid_STONE, 2, 5, 0.3));
        SpecialAsteroidBlockHandler coreHandler2 = this.coreHandler;
        Block asteroid_STONE2 = this.ASTEROID_STONE;
        ((Object)((Object)this)).getClass();
        coreHandler2.addBlock(new SpecialAsteroidBlock(asteroid_STONE2, 1, 7, 0.3));
        SpecialAsteroidBlockHandler coreHandler3 = this.coreHandler;
        Block asteroid_STONE3 = this.ASTEROID_STONE;
        ((Object)((Object)this)).getClass();
        coreHandler3.addBlock(new SpecialAsteroidBlock(asteroid_STONE3, 0, 11, 0.25));
        this.coreHandler.addBlock(new SpecialAsteroidBlock(this.ASTEROID_STONE, 3, 5, 0.2));
        this.coreHandler.addBlock(new SpecialAsteroidBlock(this.ASTEROID_STONE, 4, 4, 0.15));
        this.coreHandler.addBlock(new SpecialAsteroidBlock(this.ASTEROID_STONE, 5, 3, 0.2));
        SpecialAsteroidBlockHandler shellHandler = this.shellHandler = new SpecialAsteroidBlockHandler();
        Block asteroid_STONE4 = this.ASTEROID_STONE;
        ((Object)((Object)this)).getClass();
        shellHandler.addBlock(new SpecialAsteroidBlock(asteroid_STONE4, 0, 1, 0.15));
        SpecialAsteroidBlockHandler shellHandler2 = this.shellHandler;
        Block asteroid_STONE5 = this.ASTEROID_STONE;
        ((Object)((Object)this)).getClass();
        shellHandler2.addBlock(new SpecialAsteroidBlock(asteroid_STONE5, 1, 3, 0.15));
        SpecialAsteroidBlockHandler shellHandler3 = this.shellHandler;
        Block asteroid_STONE6 = this.ASTEROID_STONE;
        ((Object)((Object)this)).getClass();
        shellHandler3.addBlock(new SpecialAsteroidBlock(asteroid_STONE6, 2, 1, 0.15));
        this.shellHandler.addBlock(new SpecialAsteroidBlock(AsteroidBlocks.blockDenseIce, 0, 1, 0.15));
    }

    public void generateTerrain(int chunkX, int chunkZ, Block[] idArray, byte[] metaArray, boolean flagDataOnly) {
        this.largeAsteroids.clear();
        Random random = new Random();
        for (int i = chunkX - 3; i < chunkX + 3; ++i) {
            int minX = i * 16;
            int maxX = minX + 16;
            for (int k = chunkZ - 3; k < chunkZ + 3; ++k) {
                int minZ = k * 16;
                int maxZ = minZ + 16;
                for (int x = minX; x < maxX; x += 2) {
                    for (int z = minZ; z < maxZ; z += 2) {
                        if (!((double)this.randFromPointPos(x, z) < ((double)this.asteroidDensity.getNoise((float)x, (float)z) + 0.4) / 2400.0)) continue;
                        random.setSeed(x + z * 3067);
                        int y = random.nextInt(160) + 48;
                        int size = random.nextInt(10) + 5;
                        this.generateAsteroid(random, x, y, z, chunkX << 4, chunkZ << 4, size, idArray, metaArray, flagDataOnly);
                    }
                }
            }
        }
    }

    private void generateAsteroid(Random rand, int asteroidX, int asteroidY, int asteroidZ, int chunkX, int chunkZ, int size, Block[] blockArray, byte[] metaArray, boolean flagDataOnly) {
        int indexBaseX;
        int distanceX;
        int indexXZ;
        int indexXY;
        int x3;
        SpecialAsteroidBlock core = this.coreHandler.getBlock(rand, size);
        SpecialAsteroidBlock shell = null;
        if (rand.nextInt(2) == 0) {
            shell = this.shellHandler.getBlock(rand, size);
        }
        boolean isHollow = false;
        float hollowSize = rand.nextFloat() * 0.19999999f + 0.6f;
        if (rand.nextInt(10) == 0 && size >= 15) {
            isHollow = true;
            shell = new SpecialAsteroidBlock(AsteroidBlocks.blockDenseIce, 0, 1, 0.15);
        }
        ((WorldProviderKuiper)this.worldObj.field_73011_w).addAsteroid(asteroidX, asteroidY, asteroidZ, size, isHollow ? -1 : core.index);
        int xMin = this.clamp(Math.max(chunkX, asteroidX - size - 8 - 2) - chunkX, 0, 16);
        int zMin = this.clamp(Math.max(chunkZ, asteroidZ - size - 8 - 2) - chunkZ, 0, 16);
        int yMin = asteroidY - size - 8 - 2;
        int yMax = asteroidY + size + 8 + 2;
        int xMax = this.clamp(Math.min(chunkX + 16, asteroidX + size + 8 + 2) - chunkX, 0, 16);
        int zMax = this.clamp(Math.min(chunkZ + 16, asteroidZ + size + 8 + 2) - chunkZ, 0, 16);
        int xSize = xMax - xMin;
        int ySize = yMax - yMin;
        int zSize = zMax - zMin;
        if (xSize <= 0 || ySize <= 0 || zSize <= 0) {
            return;
        }
        float noiseOffsetX = this.randFromPoint(asteroidX, asteroidY, asteroidZ) * 256.0f + (float)chunkX;
        float noiseOffsetY = this.randFromPoint(asteroidX * 7, asteroidY * 11, asteroidZ * 13) * 256.0f;
        float noiseOffsetZ = this.randFromPoint(asteroidX * 17, asteroidY * 23, asteroidZ * 29) * 256.0f + (float)chunkZ;
        this.setOtherAxisFrequency(1.0f / ((float)size * 2.0f / 2.0f));
        float[] sizeXArray = new float[ySize * zSize];
        float[] sizeZArray = new float[xSize * ySize];
        float[] sizeYArray = new float[xSize * zSize];
        for (int x = 0; x < xSize; ++x) {
            int xx = x * zSize;
            float xxx = (float)x + noiseOffsetX;
            for (int z = 0; z < zSize; ++z) {
                sizeYArray[xx + z] = this.asteroidSkewY.getNoise(xxx, (float)z + noiseOffsetZ);
            }
        }
        AsteroidData asteroidData = new AsteroidData(isHollow, sizeYArray, xMin, zMin, xMax, zMax, zSize, size, asteroidX, asteroidY, asteroidZ);
        this.largeAsteroids.add(asteroidData);
        this.largeAsteroidsLastChunkX = chunkX;
        this.largeAsteroidsLastChunkZ = chunkZ;
        if (flagDataOnly) {
            return;
        }
        for (int y = 0; y < ySize; ++y) {
            int yy = y * zSize;
            float yyy = (float)y + noiseOffsetY;
            for (int z2 = 0; z2 < zSize; ++z2) {
                sizeXArray[yy + z2] = this.asteroidSkewX.getNoise(yyy, (float)z2 + noiseOffsetZ);
            }
        }
        for (int x2 = 0; x2 < xSize; ++x2) {
            int xx2 = x2 * ySize;
            float xxx2 = (float)x2 + noiseOffsetX;
            for (int y2 = 0; y2 < ySize; ++y2) {
                sizeZArray[xx2 + y2] = this.asteroidSkewZ.getNoise(xxx2, (float)y2 + noiseOffsetY);
            }
        }
        double shellThickness = 0.0;
        int terrainY = 0;
        int terrainYY = 0;
        if (shell != null) {
            shellThickness = 1.0 - shell.thickness;
        }
        for (x3 = xMax - 1; x3 >= xMin; --x3) {
            indexXY = (x3 - xMin) * ySize - yMin;
            indexXZ = (x3 - xMin) * zSize - zMin;
            distanceX = asteroidX - (x3 + chunkX);
            indexBaseX = x3 * 256 << 4;
            float xx3 = x3 + chunkX;
            for (int z3 = zMin; z3 < zMax; ++z3) {
                if (isHollow) {
                    float sizeModY = sizeYArray[indexXZ + z3];
                    terrainY = this.getTerrainHeightFor(sizeModY, asteroidY, size);
                    terrainYY = this.getTerrainHeightFor(sizeModY, asteroidY - 1, size);
                }
                float sizeY = (float)size + sizeYArray[indexXZ + z3];
                sizeY *= sizeY;
                int distanceZ = asteroidZ - (z3 + chunkZ);
                int indexBase = indexBaseX | z3 * 256;
                float zz = z3 + chunkZ;
                for (int y3 = yMin; y3 < yMax; ++y3) {
                    int index;
                    float distanceAbove;
                    float dSizeX = (float)distanceX / ((float)size + sizeXArray[(y3 - yMin) * zSize + z3 - zMin]);
                    float dSizeZ = (float)distanceZ / ((float)size + sizeZArray[indexXY + y3]);
                    dSizeX *= dSizeX;
                    dSizeZ *= dSizeZ;
                    int distanceY = asteroidY - y3;
                    distanceY *= distanceY;
                    float distance = distanceAbove = dSizeX + (float)distanceY / sizeY + dSizeZ;
                    distance += this.asteroidTurbulance.getNoise(xx3, (float)y3, zz);
                    if (isHollow && distance <= hollowSize && (distanceAbove += this.asteroidTurbulance.getNoise(xx3, (float)(y3 + 1), zz)) <= 1.0f && y3 - 1 == terrainYY) {
                        index = indexBase | y3 + 1;
                        blockArray[index] = this.LIGHT;
                        int n = index;
                        ((Object)((Object)this)).getClass();
                        metaArray[n] = 0;
                    }
                    if (!(distance <= 1.0f)) continue;
                    index = indexBase | y3;
                    if (isHollow && distance <= hollowSize) {
                        if (y3 == terrainY) {
                            blockArray[index] = this.GRASS;
                            int n2 = index;
                            ((Object)((Object)this)).getClass();
                            metaArray[n2] = 0;
                            continue;
                        }
                        if (y3 < terrainY) {
                            blockArray[index] = this.DIRT;
                            int n3 = index;
                            ((Object)((Object)this)).getClass();
                            metaArray[n3] = 0;
                            continue;
                        }
                        blockArray[index] = Blocks.field_150350_a;
                        metaArray[index] = 0;
                        continue;
                    }
                    if ((double)distance <= core.thickness) {
                        if (rand.nextBoolean()) {
                            blockArray[index] = core.block;
                            metaArray[index] = core.meta;
                            continue;
                        }
                        blockArray[index] = this.ASTEROID_STONE;
                        int n4 = index;
                        ((Object)((Object)this)).getClass();
                        metaArray[n4] = 0;
                        continue;
                    }
                    if (shell != null && (double)distance >= shellThickness) {
                        blockArray[index] = shell.block;
                        metaArray[index] = shell.meta;
                        continue;
                    }
                    blockArray[index] = this.ASTEROID_ICE;
                    int n5 = index;
                    ((Object)((Object)this)).getClass();
                    metaArray[n5] = 1;
                }
            }
        }
        if (isHollow) {
            shellThickness = 0.0;
            if (shell != null) {
                shellThickness = 1.0 - shell.thickness;
            }
            for (x3 = xMin; x3 < xMax; ++x3) {
                indexXY = (x3 - xMin) * ySize - yMin;
                indexXZ = (x3 - xMin) * zSize - zMin;
                distanceX = asteroidX - (x3 + chunkX);
                distanceX *= distanceX;
                indexBaseX = x3 * 256 << 4;
                for (int z4 = zMin; z4 < zMax; ++z4) {
                    float sizeY = (float)size + sizeYArray[indexXZ + z4];
                    sizeY *= sizeY;
                    int distanceZ = asteroidZ - (z4 + chunkZ);
                    distanceZ *= distanceZ;
                    int indexBase = indexBaseX | z4 * 256;
                    for (int y4 = yMin; y4 < yMax; ++y4) {
                        float sizeX = (float)size + sizeXArray[(y4 - yMin) * zSize + z4 - zMin];
                        float sizeZ = (float)size + sizeZArray[indexXY + y4];
                        sizeX *= sizeX;
                        sizeZ *= sizeZ;
                        int distanceY2 = asteroidY - y4;
                        distanceY2 *= distanceY2;
                        float distance2 = (float)distanceX / sizeX + (float)distanceY2 / sizeY + (float)distanceZ / sizeZ;
                        if (!((distance2 += this.asteroidTurbulance.getNoise((float)(x3 + chunkX), (float)y4, (float)(z4 + chunkZ))) <= 1.0f)) continue;
                        int index2 = indexBase | y4;
                        int indexAbove = indexBase | y4 + 1;
                        if (Blocks.field_150350_a != blockArray[indexAbove] || blockArray[index2] != this.ASTEROID_STONE && blockArray[index2] != this.GRASS || this.rand.nextInt(20) != 0) continue;
                        blockArray[index2] = this.LIGHT;
                        int n6 = index2;
                        ((Object)((Object)this)).getClass();
                        metaArray[n6] = 0;
                    }
                }
            }
        }
    }

    private final void setOtherAxisFrequency(float frequency) {
        this.asteroidSkewX.frequencyY = frequency;
        this.asteroidSkewX.frequencyZ = frequency;
        this.asteroidSkewY.frequencyX = frequency;
        this.asteroidSkewY.frequencyZ = frequency;
        this.asteroidSkewZ.frequencyX = frequency;
        this.asteroidSkewZ.frequencyY = frequency;
    }

    private final int clamp(int x, int min, int max) {
        if (x < min) {
            x = min;
        } else if (x > max) {
            x = max;
        }
        return x;
    }

    private final double clamp(double x, double min, double max) {
        if (x < min) {
            x = min;
        } else if (x > max) {
            x = max;
        }
        return x;
    }

    private final int getTerrainHeightFor(float yMod, int asteroidY, int asteroidSize) {
        return (int)((float)(asteroidY - asteroidSize / 4) + yMod * 1.5f);
    }

    private final int getTerrainHeightAt(int x, float[] yModArray, int xMin, int zMin, int zSize, int asteroidY, int asteroidSize) {
        int index = (x - xMin) * zSize - zMin;
        if (index < yModArray.length && index >= 0) {
            float yMod = yModArray[index];
            return this.getTerrainHeightFor(yMod, asteroidY, asteroidSize);
        }
        return 1;
    }

    public Chunk func_73154_d(int par1, int par2) {
        this.rand.setSeed((long)par1 * 341873128712L + (long)par2 * 132897987541L);
        Block[] ids = new Block[65536];
        byte[] meta = new byte[65536];
        this.generateTerrain(par1, par2, ids, meta, false);
        Chunk var4 = new Chunk(this.worldObj, ids, meta, par1, par2);
        byte[] var5 = var4.func_76605_m();
        for (int var6 = 0; var6 < var5.length; ++var6) {
            var5[var6] = (byte)BiomeGenBaseKuiper.kuiper.field_76756_M;
        }
        this.generateSkylightMap(var4, par1, par2);
        return var4;
    }

    private float randFromPoint(int x, int y, int z) {
        int n = x + z * 57 + y * 571;
        n ^= n << 13;
        n = n * (n * n * 15731 + 789221) + 1376312589 & Integer.MAX_VALUE;
        return 1.0f - (float)n / 1.0737418E9f;
    }

    private float randFromPoint(int x, int z) {
        int n = x + z * 57;
        n ^= n << 13;
        n = n * (n * n * 15731 + 789221) + 1376312589 & Integer.MAX_VALUE;
        return 1.0f - (float)n / 1.0737418E9f;
    }

    private float randFromPointPos(int x, int z) {
        int n = x + z * 57;
        n ^= n << 13;
        n = n * (n * n * 15731 + 789221) + 1376312589 & 0x3FFFFFFF;
        return 1.0f - (float)n / 1.0737418E9f;
    }

    public boolean func_73149_a(int par1, int par2) {
        return true;
    }

    public void func_73153_a(IChunkProvider par1IChunkProvider, int chunkX, int chunkZ) {
        long var8;
        long var7;
        int z;
        int x;
        block24: {
            x = chunkX << 4;
            z = chunkZ << 4;
            if (!chunksDone.add(new BlockVec3(x, 0, z))) {
                return;
            }
            BlockFalling.field_149832_M = true;
            this.worldObj.func_72807_a(x + 16, z + 16);
            BlockFalling.field_149832_M = false;
            this.rand.setSeed(this.worldObj.func_72905_C());
            var7 = this.rand.nextLong() / 2L * 2L + 1L;
            var8 = this.rand.nextLong() / 2L * 2L + 1L;
            this.rand.setSeed((long)chunkX * var7 + (long)chunkZ * var8 ^ this.worldObj.func_72905_C());
            if (!this.rand.nextBoolean()) break block24;
            double density = (double)this.asteroidDensity.getNoise((float)(chunkX * 16), (float)(chunkZ * 16)) * 0.54;
            double numOfBlocks = this.clamp(this.randFromPoint(chunkX, chunkZ), 0.4, 1.0) * 200.0 * density + 50.0;
            int y0 = this.rand.nextInt(2);
            int yRange = 160;
            int i = 0;
            while ((double)i < numOfBlocks) {
                block25: {
                    int meta;
                    Block block;
                    int pz;
                    int px;
                    int y2;
                    block27: {
                        block28: {
                            block26: {
                                y2 = this.rand.nextInt(160) + 48;
                                if (y0 != y2 / 16 % 2) break block25;
                                px = x + this.rand.nextInt(16);
                                pz = z + this.rand.nextInt(16);
                                block = this.ASTEROID_ICE;
                                ((Object)((Object)this)).getClass();
                                meta = 1;
                                if (this.rand.nextInt(400) != 0) break block26;
                                meta = 4;
                                if (!ConfigManagerAsteroids.disableIlmeniteGen) break block27;
                                break block25;
                            }
                            if (this.rand.nextInt(300) != 0) break block28;
                            meta = 5;
                            if (!ConfigManagerAsteroids.disableIronGen) break block27;
                            break block25;
                        }
                        if (this.rand.nextInt(250) != 0) break block27;
                        meta = 3;
                        if (ConfigManagerAsteroids.disableAluminumGen) break block25;
                    }
                    this.worldObj.func_147465_d(px, y2, pz, block, meta, 2);
                    int count = 7;
                    if (!(this.worldObj.func_147439_a(px - 1, y2, pz) instanceof BlockAir)) {
                        count = 1;
                    } else if (!(this.worldObj.func_147439_a(px - 2, y2, pz) instanceof BlockAir)) {
                        count = 3;
                    } else if (!(this.worldObj.func_147439_a(px - 3, y2, pz) instanceof BlockAir)) {
                        count = 5;
                    } else if (!(this.worldObj.func_147439_a(px - 4, y2, pz) instanceof BlockAir)) {
                        count = 6;
                    }
                    this.worldObj.func_72915_b(EnumSkyBlock.Block, px, y2, pz, count);
                }
                ++i;
            }
        }
        if (this.largeAsteroidsLastChunkX != chunkX || this.largeAsteroidsLastChunkZ != chunkZ) {
            this.generateTerrain(chunkX, chunkZ, null, null, true);
        }
        this.rand.setSeed((long)chunkX * var7 + (long)chunkZ * var8 ^ this.worldObj.func_72905_C());
        if (!this.largeAsteroids.isEmpty()) {
            for (AsteroidData asteroidIndex : this.largeAsteroids) {
                int l;
                if (!asteroidIndex.isHollow) continue;
                float[] sizeYArray = asteroidIndex.sizeYArray;
                int xMin = asteroidIndex.xMinArray;
                int zMin = asteroidIndex.zMinArray;
                int zSize = asteroidIndex.zSizeArray;
                int asteroidY = asteroidIndex.asteroidYArray;
                int asteroidSize = asteroidIndex.asteroidSizeArray;
                boolean treesdone = false;
                if (ConfigManagerCore.challengeMode || this.rand.nextInt(2) == 0) {
                    int treeType = this.rand.nextInt(3);
                    if (treeType == 1) {
                        treeType = 0;
                    }
                    WorldGenTrees wg = new WorldGenTrees(false, 2, 0, 0, false);
                    for (int tries = 0; tries < 5; ++tries) {
                        int j = this.rand.nextInt(16) + x + 8;
                        int k = this.rand.nextInt(16) + z + 8;
                        if (wg.func_76484_a(this.worldObj, this.rand, j, this.getTerrainHeightAt(j - x, sizeYArray, xMin, zMin, zSize, asteroidY, asteroidSize), k)) break;
                    }
                    treesdone = true;
                }
                if (!treesdone || this.rand.nextInt(2) == 0) {
                    l = this.rand.nextInt(16) + x + 8;
                    int m = this.rand.nextInt(16) + z + 8;
                    Block tall_GRASS = this.TALL_GRASS;
                    ((Object)((Object)this)).getClass();
                    new WorldGenTallGrass(tall_GRASS, 1).func_76484_a(this.worldObj, this.rand, l, this.getTerrainHeightAt(l - x, sizeYArray, xMin, zMin, zSize, asteroidY, asteroidSize), m);
                }
                if (this.rand.nextInt(2) == 0) {
                    l = this.rand.nextInt(16) + x + 8;
                    int m = this.rand.nextInt(16) + z + 8;
                    new WorldGenFlowers(this.FLOWER).func_76484_a(this.worldObj, this.rand, l, this.getTerrainHeightAt(l - x, sizeYArray, xMin, zMin, zSize, asteroidY, asteroidSize), m);
                }
                if (this.rand.nextInt(2) == 0) {
                    l = this.rand.nextInt(16) + x + 8;
                    int m = this.rand.nextInt(16) + z + 8;
                    new WorldGenLakes(this.LAVA).func_76484_a(this.worldObj, this.rand, l, this.getTerrainHeightAt(l - x, sizeYArray, xMin, zMin, zSize, asteroidY, asteroidSize), m);
                }
                if (this.rand.nextInt(2) != 0) continue;
                l = this.rand.nextInt(16) + x + 8;
                int m = this.rand.nextInt(16) + z + 8;
                new WorldGenLakes(this.WATER).func_76484_a(this.worldObj, this.rand, l, this.getTerrainHeightAt(l - x, sizeYArray, xMin, zMin, zSize, asteroidY, asteroidSize), m);
            }
        }
        for (int xx = 0; xx < 16; ++xx) {
            int xPos = x + xx;
            for (int zz = 0; zz < 16; ++zz) {
                int zPos = z + zz;
                for (int y3 = 16; y3 < 240; ++y3) {
                    this.worldObj.func_147463_c(EnumSkyBlock.Block, xPos, y3, zPos);
                }
            }
        }
    }

    public void generateSkylightMap(Chunk chunk, int cx, int cz) {
        for (int j = 0; j < 16; ++j) {
            if (chunk.func_76587_i()[j] != null) continue;
            chunk.func_76587_i()[j] = new ExtendedBlockStorage(j << 4, false);
        }
        int i = chunk.func_76625_h();
        chunk.field_82912_p = Integer.MAX_VALUE;
        for (int k = 0; k < 16; ++k) {
            block2: for (int l = 0; l < 16; ++l) {
                chunk.field_76638_b[k + (l << 4)] = -999;
                for (int y = i + 15; y > 0; --y) {
                    if (chunk.func_150808_b(k, y - 1, l) == 0) continue;
                    chunk.field_76634_f[l << 4 | k] = y;
                    if (chunk.field_76634_f[l << 4 | k] >= chunk.field_82912_p) continue block2;
                    chunk.field_82912_p = y;
                    continue block2;
                }
            }
        }
        for (AsteroidData a : this.largeAsteroids) {
            int yMin = a.asteroidYArray - a.asteroidSizeArray;
            int yMax = a.asteroidYArray + a.asteroidSizeArray;
            int xMin = a.xMinArray;
            if (yMin < 0) {
                yMin = 0;
            }
            if (yMax > 255) {
                yMax = 255;
            }
            if (xMin == 0) {
                xMin = 1;
            }
            for (int x = a.xMax - 1; x >= xMin; --x) {
                for (int z = a.zMinArray; z < a.zMax; ++z) {
                    for (int y2 = yMin; y2 < yMax; ++y2) {
                        if (!(chunk.func_150810_a(x - 1, y2, z) instanceof BlockAir) || chunk.func_150810_a(x, y2, z) instanceof BlockAir) continue;
                        int count = 2;
                        if (x > 1 && chunk.func_150810_a(x - 2, y2, z) instanceof BlockAir) {
                            count += 2;
                        }
                        if (x > 2) {
                            if (chunk.func_150810_a(x - 3, y2, z) instanceof BlockAir) {
                                count += 2;
                            }
                            if (chunk.func_150810_a(x - 3, y2 + 1, z) instanceof BlockAir) {
                                ++count;
                            }
                            if (chunk.func_150810_a(x - 3, y2 + 1, z) instanceof BlockAir) {
                                ++count;
                            }
                            if (z > 0 && chunk.func_150810_a(x - 3, y2, z - 1) instanceof BlockAir) {
                                ++count;
                            }
                            if (z < 15 && chunk.func_150810_a(x - 3, y2, z + 1) instanceof BlockAir) {
                                ++count;
                            }
                        }
                        if (x > 3) {
                            if (chunk.func_150810_a(x - 4, y2, z) instanceof BlockAir) {
                                count += 2;
                            }
                            if (chunk.func_150810_a(x - 4, y2 + 1, z) instanceof BlockAir) {
                                ++count;
                            }
                            if (chunk.func_150810_a(x - 4, y2 + 1, z) instanceof BlockAir) {
                                ++count;
                            }
                            if (z > 0 && !(chunk.func_150810_a(x - 4, y2, z - 1) instanceof BlockAir)) {
                                ++count;
                            }
                            if (z < 15 && !(chunk.func_150810_a(x - 4, y2, z + 1) instanceof BlockAir)) {
                                ++count;
                            }
                        }
                        if (count > 12) {
                            count = 12;
                        }
                        chunk.func_150807_a(x - 1, y2 & 0xF, z, GCBlocks.brightAir, 15 - count);
                        ExtendedBlockStorage extendedblockstorage = chunk.func_76587_i()[y2 >> 4];
                        if (extendedblockstorage == null) continue;
                        extendedblockstorage.func_76677_d(x - 1, y2 & 0xF, z, count);
                    }
                }
            }
        }
        chunk.field_76643_l = true;
    }

    public boolean func_73151_a(boolean par1, IProgressUpdate par2IProgressUpdate) {
        return true;
    }

    public boolean func_73157_c() {
        return true;
    }

    public String func_73148_d() {
        return "RandomLevelSource";
    }

    public List<BiomeGenBase.SpawnListEntry> func_73155_a(EnumCreatureType par1EnumCreatureType, int i, int j, int k) {
        if (par1EnumCreatureType == EnumCreatureType.monster) {
            ArrayList<BiomeGenBase.SpawnListEntry> monsters = new ArrayList<BiomeGenBase.SpawnListEntry>();
            monsters.add(new BiomeGenBase.SpawnListEntry(EntityEvolvedZombie.class, 3000, 1, 3));
            monsters.add(new BiomeGenBase.SpawnListEntry(EntityEvolvedSpider.class, 2000, 1, 2));
            monsters.add(new BiomeGenBase.SpawnListEntry(EntityEvolvedSkeleton.class, 1500, 1, 1));
            monsters.add(new BiomeGenBase.SpawnListEntry(EntityEvolvedCreeper.class, 2000, 1, 1));
            monsters.add(new BiomeGenBase.SpawnListEntry(EntityEvolvedEnderman.class, 2000, 1, 1));
            monsters.add(new BiomeGenBase.SpawnListEntry(EntityEvolvedColdBlaze.class, 2000, 1, 1));
            return monsters;
        }
        return null;
    }

    public BlockVec3 isLargeAsteroidAt(int x0, int z0) {
        for (int i0 = 0; i0 <= 32; ++i0) {
            for (int i2 = -i0; i2 <= i0; ++i2) {
                int xToCheck = (x0 >> 4) + i0;
                int zToCheck = (z0 >> 4) + i2;
                if (this.isLargeAsteroidAt0(xToCheck * 16, zToCheck * 16)) {
                    return new BlockVec3(xToCheck * 16, 0, zToCheck * 16);
                }
                xToCheck = (x0 >> 4) + i0;
                zToCheck = (z0 >> 4) - i2;
                if (this.isLargeAsteroidAt0(xToCheck * 16, zToCheck * 16)) {
                    return new BlockVec3(xToCheck * 16, 0, zToCheck * 16);
                }
                xToCheck = (x0 >> 4) - i0;
                zToCheck = (z0 >> 4) + i2;
                if (this.isLargeAsteroidAt0(xToCheck * 16, zToCheck * 16)) {
                    return new BlockVec3(xToCheck * 16, 0, zToCheck * 16);
                }
                xToCheck = (x0 >> 4) - i0;
                zToCheck = (z0 >> 4) - i2;
                if (!this.isLargeAsteroidAt0(xToCheck * 16, zToCheck * 16)) continue;
                return new BlockVec3(xToCheck * 16, 0, zToCheck * 16);
            }
        }
        return null;
    }

    private boolean isLargeAsteroidAt0(int x0, int z0) {
        for (int x = x0; x < x0 + 16; x += 2) {
            for (int z = z0; z < z0 + 16; z += 2) {
                if (!((double)Math.abs(this.randFromPoint(x, z)) < ((double)this.asteroidDensity.getNoise((float)x, (float)z) + 0.4) / 2400.0)) continue;
                return true;
            }
        }
        return false;
    }

    private static class AsteroidData {
        public boolean isHollow;
        public float[] sizeYArray;
        public int xMinArray;
        public int zMinArray;
        public int xMax;
        public int zMax;
        public int zSizeArray;
        public int asteroidSizeArray;
        public int asteroidYArray;

        public AsteroidData(boolean hollow, float[] sizeYArray2, int xMin, int zMin, int xmax, int zmax, int zSize, int size, int asteroidX, int asteroidY, int asteroidZ) {
            this.isHollow = hollow;
            this.sizeYArray = (float[])sizeYArray2.clone();
            this.xMinArray = xMin;
            this.zMinArray = zMin;
            this.xMax = xmax;
            this.zMax = zmax;
            this.zSizeArray = zSize;
            this.asteroidSizeArray = size;
            this.asteroidYArray = asteroidY;
        }
    }
}

