/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.modularui.api.drawable.shapes;

import com.gtnewhorizons.modularui.api.GlStateManager;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.math.Color;
import net.minecraft.client.renderer.Tessellator;

public class Rectangle
implements IDrawable {
    public static final double PI_2 = 1.5707963267948966;
    private int cornerRadius = 0;
    private int colorTL = 0;
    private int colorTR = 0;
    private int colorBL = 0;
    private int colorBR = 0;
    private int cornerSegments = 6;

    public Rectangle setCornerRadius(int cornerRadius) {
        this.cornerRadius = Math.max(0, cornerRadius);
        return this;
    }

    public Rectangle setColor(int colorTL, int colorTR, int colorBL, int colorBR) {
        this.colorTL = colorTL;
        this.colorTR = colorTR;
        this.colorBL = colorBL;
        this.colorBR = colorBR;
        return this;
    }

    public Rectangle setVerticalGradient(int colorTop, int colorBottom) {
        return this.setColor(colorTop, colorTop, colorBottom, colorBottom);
    }

    public Rectangle setHorizontalGradient(int colorLeft, int colorRight) {
        return this.setColor(colorLeft, colorRight, colorLeft, colorRight);
    }

    public Rectangle setColor(int color) {
        return this.setColor(color, color, color, color);
    }

    public Rectangle setCornerSegments(int cornerSegments) {
        this.cornerSegments = cornerSegments;
        return this;
    }

    @Override
    public void applyThemeColor(int color) {
        if (this.colorTL == 0 && this.colorBL == 0 && this.colorBR == 0 && this.colorTR == 0) {
            IDrawable.super.applyThemeColor(color == 0 ? -1 : color);
        }
    }

    @Override
    public void draw(float x0, float y0, float width, float height, float partialTicks) {
        GlStateManager.disableTexture2D();
        GlStateManager.enableBlend();
        GlStateManager.enableAlpha();
        GlStateManager.disableLighting();
        GlStateManager.tryBlendFuncSeparate(GlStateManager.SourceFactor.SRC_ALPHA, GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, GlStateManager.SourceFactor.ONE, GlStateManager.DestFactor.ZERO);
        GlStateManager.shadeModel(7425);
        Tessellator tessellator = Tessellator.field_78398_a;
        float x1 = x0 + width;
        float y1 = y0 + height;
        if (this.cornerRadius == 0) {
            tessellator.func_78382_b();
            tessellator.func_78370_a(Color.getRed(this.colorTL), Color.getGreen(this.colorTL), Color.getBlue(this.colorTL), Color.getAlpha(this.colorTL));
            tessellator.func_78377_a((double)x0, (double)y0, 0.0);
            tessellator.func_78370_a(Color.getRed(this.colorBL), Color.getGreen(this.colorBL), Color.getBlue(this.colorBL), Color.getAlpha(this.colorBL));
            tessellator.func_78377_a((double)x0, (double)y1, 0.0);
            tessellator.func_78370_a(Color.getRed(this.colorBR), Color.getGreen(this.colorBR), Color.getBlue(this.colorBR), Color.getAlpha(this.colorBR));
            tessellator.func_78377_a((double)x1, (double)y1, 0.0);
            tessellator.func_78370_a(Color.getRed(this.colorTR), Color.getGreen(this.colorTR), Color.getBlue(this.colorTR), Color.getAlpha(this.colorTR));
            tessellator.func_78377_a((double)x1, (double)y0, 0.0);
        } else {
            float y;
            float x;
            int i;
            tessellator.func_78371_b(6);
            int color = Color.average(this.colorBL, this.colorBR, this.colorTR, this.colorTL);
            tessellator.func_78370_a(Color.getRed(color), Color.getGreen(color), Color.getBlue(color), Color.getAlpha(color));
            tessellator.func_78377_a((double)(x0 + width / 2.0f), (double)(y0 + height / 2.0f), 0.0);
            tessellator.func_78370_a(Color.getRed(this.colorTL), Color.getGreen(this.colorTL), Color.getBlue(this.colorTL), Color.getAlpha(this.colorTL));
            tessellator.func_78377_a((double)x0, (double)(y0 + (float)this.cornerRadius), 0.0);
            tessellator.func_78370_a(Color.getRed(this.colorBL), Color.getGreen(this.colorBL), Color.getBlue(this.colorBL), Color.getAlpha(this.colorBL));
            tessellator.func_78377_a((double)x0, (double)(y1 - (float)this.cornerRadius), 0.0);
            int n = this.cornerSegments;
            for (i = 1; i <= n; ++i) {
                x = (float)((double)(x0 + (float)this.cornerRadius) - Math.cos(1.5707963267948966 / (double)n * (double)i) * (double)this.cornerRadius);
                y = (float)((double)(y1 - (float)this.cornerRadius) + Math.sin(1.5707963267948966 / (double)n * (double)i) * (double)this.cornerRadius);
                tessellator.func_78370_a(Color.getRed(this.colorBL), Color.getGreen(this.colorBL), Color.getBlue(this.colorBL), Color.getAlpha(this.colorBL));
                tessellator.func_78377_a((double)x, (double)y, 0.0);
            }
            tessellator.func_78370_a(Color.getRed(this.colorBR), Color.getGreen(this.colorBR), Color.getBlue(this.colorBR), Color.getAlpha(this.colorBR));
            tessellator.func_78377_a((double)(x1 - (float)this.cornerRadius), (double)y1, 0.0);
            for (i = 1; i <= n; ++i) {
                x = (float)((double)(x1 - (float)this.cornerRadius) + Math.sin(1.5707963267948966 / (double)n * (double)i) * (double)this.cornerRadius);
                y = (float)((double)(y1 - (float)this.cornerRadius) + Math.cos(1.5707963267948966 / (double)n * (double)i) * (double)this.cornerRadius);
                tessellator.func_78370_a(Color.getRed(this.colorBR), Color.getGreen(this.colorBR), Color.getBlue(this.colorBR), Color.getAlpha(this.colorBR));
                tessellator.func_78377_a((double)x, (double)y, 0.0);
            }
            tessellator.func_78370_a(Color.getRed(this.colorTR), Color.getGreen(this.colorTR), Color.getBlue(this.colorTR), Color.getAlpha(this.colorTR));
            tessellator.func_78377_a((double)x1, (double)(y0 + (float)this.cornerRadius), 0.0);
            for (i = 1; i <= n; ++i) {
                x = (float)((double)(x1 - (float)this.cornerRadius) + Math.cos(1.5707963267948966 / (double)n * (double)i) * (double)this.cornerRadius);
                y = (float)((double)(y0 + (float)this.cornerRadius) - Math.sin(1.5707963267948966 / (double)n * (double)i) * (double)this.cornerRadius);
                tessellator.func_78370_a(Color.getRed(this.colorTR), Color.getGreen(this.colorTR), Color.getBlue(this.colorTR), Color.getAlpha(this.colorTR));
                tessellator.func_78377_a((double)x, (double)y, 0.0);
            }
            tessellator.func_78370_a(Color.getRed(this.colorTL), Color.getGreen(this.colorTL), Color.getBlue(this.colorTL), Color.getAlpha(this.colorTL));
            tessellator.func_78377_a((double)(x0 + (float)this.cornerRadius), (double)y0, 0.0);
            for (i = 1; i <= n; ++i) {
                x = (float)((double)(x0 + (float)this.cornerRadius) - Math.sin(1.5707963267948966 / (double)n * (double)i) * (double)this.cornerRadius);
                y = (float)((double)(y0 + (float)this.cornerRadius) - Math.cos(1.5707963267948966 / (double)n * (double)i) * (double)this.cornerRadius);
                tessellator.func_78370_a(Color.getRed(this.colorTL), Color.getGreen(this.colorTL), Color.getBlue(this.colorTL), Color.getAlpha(this.colorTL));
                tessellator.func_78377_a((double)x, (double)y, 0.0);
            }
            tessellator.func_78370_a(Color.getRed(this.colorTL), Color.getGreen(this.colorTL), Color.getBlue(this.colorTL), Color.getAlpha(this.colorTL));
            tessellator.func_78377_a((double)x0, (double)(y0 + (float)this.cornerRadius), 0.0);
        }
        tessellator.func_78381_a();
        GlStateManager.shadeModel(7424);
        GlStateManager.disableBlend();
        GlStateManager.enableAlpha();
        GlStateManager.enableTexture2D();
    }
}

