/*
 * Decompiled with CFR 0.152.
 */
package com.projecturanus.betterp2p.network.data;

import com.projecturanus.betterp2p.client.gui.widget.GuiScale;
import com.projecturanus.betterp2p.item.BetterMemoryCardModes;
import com.projecturanus.betterp2p.network.data.MemoryInfo;
import com.projecturanus.betterp2p.network.data.P2PLocation;
import com.projecturanus.betterp2p.network.data.P2PLocationKt;
import io.netty.buffer.ByteBuf;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u001a\u000e\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0003\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"TUNNEL_ANY", "", "readMemoryInfo", "Lcom/projecturanus/betterp2p/network/data/MemoryInfo;", "buf", "Lio/netty/buffer/ByteBuf;", "writeMemoryInfo", "", "info", "betterp2p"})
public final class MemoryInfoKt {
    public static final int TUNNEL_ANY = -1;

    @NotNull
    public static final MemoryInfo readMemoryInfo(@NotNull ByteBuf buf) {
        GuiScale e2;
        BetterMemoryCardModes betterMemoryCardModes;
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        P2PLocation selectedEntry = null;
        if (buf.readBoolean()) {
            selectedEntry = P2PLocationKt.readP2PLocation(buf);
        }
        long frequency = buf.readLong();
        try {
            betterMemoryCardModes = BetterMemoryCardModes.values()[buf.readInt()];
        }
        catch (Exception e2) {
            betterMemoryCardModes = BetterMemoryCardModes.OUTPUT;
        }
        BetterMemoryCardModes mode = betterMemoryCardModes;
        try {
            e2 = GuiScale.values()[buf.readByte()];
        }
        catch (ArrayIndexOutOfBoundsException e3) {
            e2 = GuiScale.DYNAMIC;
        }
        GuiScale guiScale = e2;
        byte type = buf.readByte();
        return new MemoryInfo(selectedEntry, frequency, mode, guiScale, type);
    }

    public static final void writeMemoryInfo(@NotNull ByteBuf buf, @NotNull MemoryInfo info2) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        Intrinsics.checkNotNullParameter((Object)info2, (String)"info");
        boolean hasSelected = info2.getSelectedEntry() != null;
        buf.writeBoolean(hasSelected);
        if (hasSelected) {
            P2PLocation p2PLocation = info2.getSelectedEntry();
            Intrinsics.checkNotNull((Object)p2PLocation);
            P2PLocationKt.writeP2PLocation(buf, p2PLocation);
        }
        buf.writeLong(info2.getFrequency());
        buf.writeInt(info2.getMode().ordinal());
        buf.writeByte(info2.getGuiScale().ordinal());
        buf.writeByte(info2.getType());
    }
}

