/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.tileEntity;

import WayofTime.alchemicalWizardry.AlchemicalWizardry;
import WayofTime.alchemicalWizardry.api.altarRecipeRegistry.AltarRecipe;
import WayofTime.alchemicalWizardry.api.altarRecipeRegistry.AltarRecipeRegistry;
import WayofTime.alchemicalWizardry.api.items.interfaces.IBloodOrb;
import WayofTime.alchemicalWizardry.api.soulNetwork.SoulNetworkHandler;
import WayofTime.alchemicalWizardry.api.tile.IBloodAltar;
import WayofTime.alchemicalWizardry.common.NewPacketHandler;
import WayofTime.alchemicalWizardry.common.bloodAltarUpgrade.AltarUpgradeComponent;
import WayofTime.alchemicalWizardry.common.bloodAltarUpgrade.UpgradedAltars;
import WayofTime.alchemicalWizardry.common.spell.complex.effect.SpellHelper;
import WayofTime.alchemicalWizardry.common.tileEntity.TEInventory;
import WayofTime.alchemicalWizardry.compat.IBloodMagicWailaProvider;
import java.text.NumberFormat;
import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;

public class TEAltar
extends TEInventory
implements IFluidTank,
IFluidHandler,
IBloodAltar,
IBloodMagicWailaProvider {
    public static final int sizeInv = 1;
    public static final int BASE_RECIPE_DELAY = 100;
    public static final double CRAFTING_DELAY_RUNE_EFFICIENCY = 0.8;
    private int resultID = 0;
    private int resultDamage = 0;
    private int upgradeLevel = 0;
    protected FluidStack fluid = new FluidStack(AlchemicalWizardry.lifeEssenceFluid, 0);
    public int capacity = 10000;
    private boolean isActive = false;
    private int liquidRequired;
    private boolean canBeFilled;
    private int consumptionRate = 0;
    private int drainRate = 0;
    private float consumptionMultiplier = 0.0f;
    private float efficiencyMultiplier = 0.0f;
    private float sacrificeEfficiencyMultiplier;
    private float selfSacrificeEfficiencyMultiplier;
    private float capacityMultiplier = 1.0f;
    private float orbCapacityMultiplier;
    private float dislocationMultiplier;
    private int accelerationUpgrades;
    private boolean isUpgraded = false;
    private boolean isResultBlock = false;
    private int bufferCapacity = 1000;
    protected FluidStack fluidOutput = new FluidStack(AlchemicalWizardry.lifeEssenceFluid, 0);
    protected FluidStack fluidInput = new FluidStack(AlchemicalWizardry.lifeEssenceFluid, 0);
    private int progress = 0;
    private long nextForcedRecipeCheck = -1L;
    private int maxDelayBeforeNextCraft = 100;
    private int lockdownDuration = 0;
    private int demonBloodDuration = 0;
    private int cooldownAfterCrafting = 500;

    public TEAltar() {
        super(1);
    }

    public int fillMainTank(int amount) {
        int filledAmount = Math.min(this.capacity - this.fluid.amount, amount);
        this.fluid.amount += filledAmount;
        return filledAmount;
    }

    public int getRSPowerOutput() {
        return 5;
    }

    @Override
    public void addToDemonBloodDuration(int dur) {
        this.demonBloodDuration += dur;
    }

    @Override
    public boolean hasDemonBlood() {
        return this.demonBloodDuration > 0;
    }

    @Override
    public void decrementDemonBlood() {
        this.demonBloodDuration = Math.max(0, this.demonBloodDuration - 1);
    }

    @Override
    public void func_145839_a(NBTTagCompound par1NBTTagCompound) {
        super.func_145839_a(par1NBTTagCompound);
        this.resultID = par1NBTTagCompound.func_74762_e("resultID");
        this.resultDamage = par1NBTTagCompound.func_74762_e("resultDamage");
        if (!par1NBTTagCompound.func_74764_b("Empty")) {
            FluidStack fluidIn;
            FluidStack fluidOut;
            FluidStack fluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)par1NBTTagCompound);
            if (fluid != null) {
                this.setMainFluid(fluid);
            }
            if ((fluidOut = new FluidStack(AlchemicalWizardry.lifeEssenceFluid, par1NBTTagCompound.func_74762_e("outputAmount"))) != null) {
                this.setOutputFluid(fluidOut);
            }
            if ((fluidIn = new FluidStack(AlchemicalWizardry.lifeEssenceFluid, par1NBTTagCompound.func_74762_e("inputAmount"))) != null) {
                this.setInputFluid(fluidIn);
            }
        }
        this.upgradeLevel = par1NBTTagCompound.func_74762_e("upgradeLevel");
        this.isActive = par1NBTTagCompound.func_74767_n("isActive");
        this.liquidRequired = par1NBTTagCompound.func_74762_e("liquidRequired");
        this.canBeFilled = par1NBTTagCompound.func_74767_n("canBeFilled");
        this.isUpgraded = par1NBTTagCompound.func_74767_n("isUpgraded");
        this.consumptionRate = par1NBTTagCompound.func_74762_e("consumptionRate");
        this.drainRate = par1NBTTagCompound.func_74762_e("drainRate");
        this.consumptionMultiplier = par1NBTTagCompound.func_74760_g("consumptionMultiplier");
        this.efficiencyMultiplier = par1NBTTagCompound.func_74760_g("efficiencyMultiplier");
        this.selfSacrificeEfficiencyMultiplier = par1NBTTagCompound.func_74760_g("selfSacrificeEfficiencyMultiplier");
        this.sacrificeEfficiencyMultiplier = par1NBTTagCompound.func_74760_g("sacrificeEfficiencyMultiplier");
        this.capacityMultiplier = par1NBTTagCompound.func_74760_g("capacityMultiplier");
        this.orbCapacityMultiplier = par1NBTTagCompound.func_74760_g("orbCapacityMultiplier");
        this.dislocationMultiplier = par1NBTTagCompound.func_74760_g("dislocationMultiplier");
        this.capacity = par1NBTTagCompound.func_74762_e("capacity");
        this.bufferCapacity = par1NBTTagCompound.func_74762_e("bufferCapacity");
        this.progress = par1NBTTagCompound.func_74762_e("progress");
        this.isResultBlock = par1NBTTagCompound.func_74767_n("isResultBlock");
        this.lockdownDuration = par1NBTTagCompound.func_74762_e("lockdownDuration");
        this.accelerationUpgrades = par1NBTTagCompound.func_74762_e("accelerationUpgrades");
        this.demonBloodDuration = par1NBTTagCompound.func_74762_e("demonBloodDuration");
        this.cooldownAfterCrafting = par1NBTTagCompound.func_74762_e("cooldownAfterCrafting");
    }

    public void setMainFluid(FluidStack fluid) {
        this.fluid = fluid;
    }

    public void setOutputFluid(FluidStack fluid) {
        this.fluidOutput = fluid;
    }

    public void setInputFluid(FluidStack fluid) {
        this.fluidInput = fluid;
    }

    @Override
    public void func_145841_b(NBTTagCompound par1NBTTagCompound) {
        super.func_145841_b(par1NBTTagCompound);
        par1NBTTagCompound.func_74768_a("resultID", this.resultID);
        par1NBTTagCompound.func_74768_a("resultDamage", this.resultDamage);
        if (this.fluid != null) {
            this.fluid.writeToNBT(par1NBTTagCompound);
        } else {
            par1NBTTagCompound.func_74778_a("Empty", "");
        }
        if (this.fluidOutput != null) {
            par1NBTTagCompound.func_74768_a("outputAmount", this.fluidOutput.amount);
        }
        if (this.fluidInput != null) {
            par1NBTTagCompound.func_74768_a("inputAmount", this.fluidInput.amount);
        }
        par1NBTTagCompound.func_74768_a("upgradeLevel", this.upgradeLevel);
        par1NBTTagCompound.func_74757_a("isActive", this.isActive);
        par1NBTTagCompound.func_74768_a("liquidRequired", this.liquidRequired);
        par1NBTTagCompound.func_74757_a("canBeFilled", this.canBeFilled);
        par1NBTTagCompound.func_74757_a("isUpgraded", this.isUpgraded);
        par1NBTTagCompound.func_74768_a("consumptionRate", this.consumptionRate);
        par1NBTTagCompound.func_74768_a("drainRate", this.drainRate);
        par1NBTTagCompound.func_74776_a("consumptionMultiplier", this.consumptionMultiplier);
        par1NBTTagCompound.func_74776_a("efficiencyMultiplier", this.efficiencyMultiplier);
        par1NBTTagCompound.func_74776_a("sacrificeEfficiencyMultiplier", this.sacrificeEfficiencyMultiplier);
        par1NBTTagCompound.func_74776_a("selfSacrificeEfficiencyMultiplier", this.selfSacrificeEfficiencyMultiplier);
        par1NBTTagCompound.func_74757_a("isResultBlock", this.isResultBlock);
        par1NBTTagCompound.func_74776_a("capacityMultiplier", this.capacityMultiplier);
        par1NBTTagCompound.func_74776_a("orbCapacityMultiplier", this.orbCapacityMultiplier);
        par1NBTTagCompound.func_74776_a("dislocationMultiplier", this.dislocationMultiplier);
        par1NBTTagCompound.func_74768_a("capacity", this.capacity);
        par1NBTTagCompound.func_74768_a("progress", this.progress);
        par1NBTTagCompound.func_74768_a("bufferCapacity", this.bufferCapacity);
        par1NBTTagCompound.func_74768_a("lockdownDuration", this.lockdownDuration);
        par1NBTTagCompound.func_74768_a("accelerationUpgrades", this.accelerationUpgrades);
        par1NBTTagCompound.func_74768_a("demonBloodDuration", this.demonBloodDuration);
        par1NBTTagCompound.func_74768_a("cooldownAfterCrafting", this.cooldownAfterCrafting);
    }

    @Override
    public String func_145825_b() {
        return "TEAltar";
    }

    public FluidStack getFluid() {
        return this.fluid;
    }

    public int getFluidAmount() {
        if (this.fluid == null) {
            return 0;
        }
        return this.fluid.amount;
    }

    @Override
    public int getCapacity() {
        return this.capacity;
    }

    @Override
    public int getCurrentBlood() {
        return this.getFluidAmount();
    }

    @Override
    public int getTier() {
        return this.upgradeLevel;
    }

    @Override
    public int getProgress() {
        return this.progress;
    }

    @Override
    public float getSacrificeMultiplier() {
        return this.sacrificeEfficiencyMultiplier;
    }

    @Override
    public float getSelfSacrificeMultiplier() {
        return this.selfSacrificeEfficiencyMultiplier;
    }

    @Override
    public float getOrbMultiplier() {
        return this.orbCapacityMultiplier;
    }

    @Override
    public float getDislocationMultiplier() {
        return this.dislocationMultiplier;
    }

    @Override
    public int getBufferCapacity() {
        return this.bufferCapacity;
    }

    public FluidTankInfo getInfo() {
        return new FluidTankInfo((IFluidTank)this);
    }

    public int fill(FluidStack resource, boolean doFill) {
        TEAltar tile = this;
        if (resource == null) {
            return 0;
        }
        if (resource.getFluidID() != new FluidStack(AlchemicalWizardry.lifeEssenceFluid, 1).getFluidID()) {
            return 0;
        }
        if (!doFill) {
            if (this.fluidInput == null) {
                return Math.min(this.bufferCapacity, resource.amount);
            }
            if (!this.fluidInput.isFluidEqual(resource)) {
                return 0;
            }
            return Math.min(this.bufferCapacity - this.fluidInput.amount, resource.amount);
        }
        if (this.fluidInput == null) {
            this.fluidInput = new FluidStack(resource, Math.min(this.bufferCapacity, resource.amount));
            if (tile != null) {
                FluidEvent.fireEvent((FluidEvent)new FluidEvent.FluidFillingEvent(this.fluidInput, tile.func_145831_w(), tile.field_145851_c, tile.field_145848_d, tile.field_145849_e, (IFluidTank)this));
            }
            return this.fluidInput.amount;
        }
        if (!this.fluidInput.isFluidEqual(resource)) {
            return 0;
        }
        int filled = this.bufferCapacity - this.fluidInput.amount;
        if (resource.amount < filled) {
            this.fluidInput.amount += resource.amount;
            filled = resource.amount;
        } else {
            this.fluidInput.amount = this.bufferCapacity;
        }
        if (tile != null) {
            FluidEvent.fireEvent((FluidEvent)new FluidEvent.FluidFillingEvent(this.fluidInput, tile.func_145831_w(), tile.field_145851_c, tile.field_145848_d, tile.field_145849_e, (IFluidTank)this));
        }
        return filled;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        if (this.fluidOutput == null) {
            return null;
        }
        int drained = maxDrain;
        if (this.fluidOutput.amount < drained) {
            drained = this.fluidOutput.amount;
        }
        FluidStack stack = new FluidStack(this.fluidOutput, drained);
        if (doDrain) {
            this.fluidOutput.amount -= drained;
            if (this.fluidOutput.amount <= 0) {
                this.fluidOutput = null;
            }
            if (this != null) {
                FluidEvent.fireEvent((FluidEvent)new FluidEvent.FluidDrainingEvent(this.fluidOutput, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, (IFluidTank)this));
            }
        }
        if (this.fluidOutput == null) {
            this.fluidOutput = new FluidStack(AlchemicalWizardry.lifeEssenceFluid, 0);
        }
        if (this.field_145850_b != null) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        return stack;
    }

    public void func_145845_h() {
        this.decrementDemonBlood();
        if (this.hasDemonBlood() && !this.field_145850_b.field_72995_K) {
            SpellHelper.sendIndexedParticleToAllAround(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, 20, this.field_145850_b.field_73011_w.field_76574_g, 1, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        if (this.lockdownDuration > 0) {
            --this.lockdownDuration;
        }
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        long totalWorldTime = this.field_145850_b.func_82737_E();
        if (totalWorldTime % 20L == 0L) {
            Block block = this.field_145850_b.func_147439_a(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e);
            block.func_149695_a(this.field_145850_b, this.field_145851_c + 1, this.field_145848_d, this.field_145849_e, block);
            block = this.field_145850_b.func_147439_a(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e);
            block.func_149695_a(this.field_145850_b, this.field_145851_c - 1, this.field_145848_d, this.field_145849_e, block);
            block = this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e);
            block.func_149695_a(this.field_145850_b, this.field_145851_c, this.field_145848_d + 1, this.field_145849_e, block);
            block = this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e);
            block.func_149695_a(this.field_145850_b, this.field_145851_c, this.field_145848_d - 1, this.field_145849_e, block);
            block = this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e + 1);
            block.func_149695_a(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e + 1, block);
            block = this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e - 1);
            block.func_149695_a(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e - 1, block);
            if (AlchemicalWizardry.lockdownAltar) {
                List<EntityPlayer> list = SpellHelper.getPlayersInRange(this.field_145850_b, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, 15.0, 15.0);
                for (EntityPlayer player : list) {
                    PotionEffect regenEffect = player.func_70660_b(Potion.field_76428_l);
                    if (regenEffect == null || regenEffect.func_76458_c() < 2) continue;
                    this.lockdownDuration += 20;
                }
            }
        }
        if (totalWorldTime % (long)Math.max(20 - this.accelerationUpgrades, 1) == 0L) {
            int syphonMax = (int)(20.0f * this.dislocationMultiplier);
            int fluidInputted = 0;
            int fluidOutputted = 0;
            fluidInputted = Math.min(syphonMax, -this.fluid.amount + this.capacity);
            fluidInputted = Math.min(this.fluidInput.amount, fluidInputted);
            this.fluid.amount += fluidInputted;
            this.fluidInput.amount -= fluidInputted;
            fluidOutputted = Math.min(syphonMax, this.bufferCapacity - this.fluidOutput.amount);
            fluidOutputted = Math.min(this.fluid.amount, fluidOutputted);
            this.fluidOutput.amount += fluidOutputted;
            this.fluid.amount -= fluidOutputted;
        }
        if (this.shouldTryToStartCycle(totalWorldTime) && (this.isActive || this.cooldownAfterCrafting <= 0)) {
            this.startCycle();
        }
        if (!this.isActive) {
            if (this.cooldownAfterCrafting > 0) {
                --this.cooldownAfterCrafting;
            }
            return;
        }
        if (this.func_70301_a(0) == null) {
            return;
        }
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (!this.canBeFilled) {
            if (this.fluid != null && this.fluid.amount >= 1) {
                int stackSize = this.func_70301_a((int)0).field_77994_a;
                int liquidDrained = Math.min((int)(this.upgradeLevel >= 2 ? (float)this.consumptionRate * (1.0f + this.consumptionMultiplier) : (float)this.consumptionRate), this.fluid.amount);
                if (liquidDrained > this.liquidRequired * stackSize - this.progress) {
                    liquidDrained = this.liquidRequired * stackSize - this.progress;
                }
                this.fluid.amount -= liquidDrained;
                this.progress += liquidDrained;
                if (totalWorldTime % 4L == 0L) {
                    SpellHelper.sendIndexedParticleToAllAround(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, 20, this.field_145850_b.field_73011_w.field_76574_g, 1, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                }
                if (this.progress >= this.liquidRequired * stackSize) {
                    ItemStack result = AltarRecipeRegistry.getItemForItemAndTier(this.func_70301_a(0), this.upgradeLevel);
                    if (result != null) {
                        result.field_77994_a *= stackSize;
                    }
                    this.func_70299_a(0, result);
                    this.progress = 0;
                    for (int i = 0; i < 8; ++i) {
                        SpellHelper.sendIndexedParticleToAllAround(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, 20, this.field_145850_b.field_73011_w.field_76574_g, 4, (float)this.field_145851_c + 0.5f, (float)this.field_145848_d + 1.0f, (float)this.field_145849_e + 0.5f);
                    }
                    this.isActive = false;
                    if (this.nextForcedRecipeCheck < 0L) {
                        this.nextForcedRecipeCheck = this.field_145850_b.func_82737_E() + (long)this.maxDelayBeforeNextCraft;
                    }
                }
            } else if (this.progress > 0) {
                this.progress -= (int)(this.efficiencyMultiplier * (float)this.drainRate);
                if (totalWorldTime % 2L == 0L) {
                    SpellHelper.sendIndexedParticleToAllAround(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, 20, this.field_145850_b.field_73011_w.field_76574_g, 2, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                }
            }
        } else {
            ItemStack returnedItem = this.func_70301_a(0);
            if (!(returnedItem.func_77973_b() instanceof IBloodOrb)) {
                return;
            }
            IBloodOrb item = (IBloodOrb)returnedItem.func_77973_b();
            NBTTagCompound itemTag = returnedItem.func_77978_p();
            if (itemTag == null) {
                return;
            }
            String ownerName = itemTag.func_74779_i("ownerName");
            if (ownerName.equals("")) {
                return;
            }
            if (this.fluid != null && this.fluid.amount >= 1) {
                int liquidDrained = Math.min((int)(this.upgradeLevel >= 2 ? (float)this.consumptionRate * (1.0f + this.consumptionMultiplier) : (float)this.consumptionRate), this.fluid.amount);
                int drain = SoulNetworkHandler.addCurrentEssenceToMaximum(ownerName, liquidDrained, (int)((float)item.getMaxEssence() * this.orbCapacityMultiplier));
                this.fluid.amount -= drain;
                if (totalWorldTime % 4L == 0L) {
                    SpellHelper.sendIndexedParticleToAllAround(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, 20, this.field_145850_b.field_73011_w.field_76574_g, 3, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                }
            }
        }
        if (this.field_145850_b != null) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    private boolean shouldTryToStartCycle(long totalWorldTime) {
        if (!this.isActive && this.nextForcedRecipeCheck >= 0L) {
            if (this.nextForcedRecipeCheck <= totalWorldTime) {
                this.nextForcedRecipeCheck = -1L;
                return true;
            }
            return false;
        }
        if (totalWorldTime % 100L == 0L) {
            this.nextForcedRecipeCheck = -1L;
            return true;
        }
        return false;
    }

    public void setActive() {
        this.isActive = false;
    }

    public boolean isActive() {
        return this.isActive;
    }

    @Override
    public void sacrificialDaggerCall(int amount, boolean isSacrifice) {
        if (!isSacrifice && this.lockdownDuration > 0) {
            int amt = (int)Math.min((float)(this.bufferCapacity - this.fluidInput.amount), (isSacrifice ? 1.0f + this.sacrificeEfficiencyMultiplier : 1.0f + this.selfSacrificeEfficiencyMultiplier) * (float)amount);
            this.fluidInput.amount += amt;
        } else {
            this.fluid.amount = (int)((float)this.fluid.amount + Math.min((float)(this.capacity - this.fluid.amount), (isSacrifice ? 1.0f + this.sacrificeEfficiencyMultiplier : 1.0f + this.selfSacrificeEfficiencyMultiplier) * (float)amount));
        }
    }

    public Packet func_145844_m() {
        return NewPacketHandler.getPacket(this);
    }

    public void handlePacketData(int[] intData, int[] fluidData, int capacity) {
        if (intData == null) {
            return;
        }
        if (intData.length == 3) {
            for (int i = 0; i < 1; ++i) {
                ItemStack is;
                this.inv[i] = intData[i * 3 + 2] != 0 ? (is = new ItemStack(Item.func_150899_d((int)intData[i * 3]), intData[i * 3 + 2], intData[i * 3 + 1])) : null;
            }
        }
        FluidStack flMain = new FluidStack(fluidData[0], fluidData[1]);
        FluidStack flIn = new FluidStack(fluidData[2], fluidData[3]);
        FluidStack flOut = new FluidStack(fluidData[4], fluidData[5]);
        this.setMainFluid(flMain);
        this.setInputFluid(flIn);
        this.setOutputFluid(flOut);
        this.capacity = capacity;
    }

    public int[] buildIntDataList() {
        int[] sortList = new int[3];
        int pos = 0;
        for (ItemStack is : this.inv) {
            if (is != null) {
                sortList[pos++] = Item.func_150891_b((Item)is.func_77973_b());
                sortList[pos++] = is.func_77960_j();
                sortList[pos++] = is.field_77994_a;
                continue;
            }
            sortList[pos++] = 0;
            sortList[pos++] = 0;
            sortList[pos++] = 0;
        }
        return sortList;
    }

    @Override
    public void startCycle() {
        if (this.field_145850_b != null) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        this.checkAndSetAltar();
        if (this.fluid == null || this.fluid.amount <= 0) {
            return;
        }
        if (!this.isActive) {
            this.progress = 0;
        }
        if (AltarRecipeRegistry.isRequiredItemValid(this.func_70301_a(0), this.upgradeLevel)) {
            AltarRecipe recipe = AltarRecipeRegistry.getAltarRecipeForItemAndTier(this.func_70301_a(0), this.upgradeLevel);
            this.isActive = true;
            this.liquidRequired = recipe.getLiquidRequired();
            this.canBeFilled = recipe.getCanBeFilled();
            this.consumptionRate = recipe.getConsumptionRate();
            this.drainRate = recipe.drainRate;
            return;
        }
        this.isActive = false;
    }

    public void checkAndSetAltar() {
        boolean checkUpgrade = true;
        int upgradeState = UpgradedAltars.isAltarValid(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        if (upgradeState <= 1) {
            this.upgradeLevel = 1;
            this.isUpgraded = false;
            this.consumptionMultiplier = 0.0f;
            this.efficiencyMultiplier = 1.0f;
            this.sacrificeEfficiencyMultiplier = 0.0f;
            this.selfSacrificeEfficiencyMultiplier = 0.0f;
            this.capacityMultiplier = 1.0f;
            this.orbCapacityMultiplier = 1.0f;
            this.dislocationMultiplier = 1.0f;
            this.accelerationUpgrades = 0;
            this.maxDelayBeforeNextCraft = -1;
            return;
        }
        AltarUpgradeComponent upgrades = UpgradedAltars.getUpgrades(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, upgradeState);
        if (upgrades == null) {
            this.upgradeLevel = 1;
            this.isUpgraded = false;
            this.consumptionMultiplier = 0.0f;
            this.efficiencyMultiplier = 1.0f;
            this.sacrificeEfficiencyMultiplier = 0.0f;
            this.selfSacrificeEfficiencyMultiplier = 0.0f;
            this.capacityMultiplier = 1.0f;
            this.orbCapacityMultiplier = 1.0f;
            this.dislocationMultiplier = 1.0f;
            this.upgradeLevel = upgradeState;
            this.accelerationUpgrades = 0;
            this.maxDelayBeforeNextCraft = -1;
            return;
        }
        this.isUpgraded = checkUpgrade;
        this.upgradeLevel = upgradeState;
        this.consumptionMultiplier = (float)(0.25 * (double)upgrades.getSpeedUpgrades());
        this.efficiencyMultiplier = (float)Math.pow(0.8, upgrades.getSpeedUpgrades());
        this.sacrificeEfficiencyMultiplier = (float)(0.12 * (double)upgrades.getSacrificeUpgrades());
        this.selfSacrificeEfficiencyMultiplier = (float)(0.12 * (double)upgrades.getSelfSacrificeUpgrades());
        this.capacityMultiplier = (float)(1.0 * Math.pow(1.14, upgrades.getBetterCapacitiveUpgrades()) + 0.35 * (double)upgrades.getAltarCapacitiveUpgrades());
        this.dislocationMultiplier = (float)Math.pow(1.5, upgrades.getDisplacementUpgrades());
        this.orbCapacityMultiplier = (float)(1.0 + 0.04 * (double)upgrades.getOrbCapacitiveUpgrades());
        this.capacity = (int)(10000.0f * this.capacityMultiplier);
        this.bufferCapacity = (int)(1000.0f * this.capacityMultiplier);
        this.accelerationUpgrades = upgrades.getAccelerationUpgrades();
        this.maxDelayBeforeNextCraft = Math.max(1, (int)Math.floor(100.0 * Math.pow(0.8, upgrades.getQuicknessUpgrades())));
        if (this.fluid.amount > this.capacity) {
            this.fluid.amount = this.capacity;
        }
        if (this.fluidOutput.amount > this.bufferCapacity) {
            this.fluidOutput.amount = this.bufferCapacity;
        }
        if (this.fluidInput.amount > this.bufferCapacity) {
            this.fluidInput.amount = this.bufferCapacity;
        }
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack itemstack) {
        return slot == 0;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (resource == null) {
            return 0;
        }
        resource = resource.copy();
        int totalUsed = 0;
        int used = this.fill(resource, doFill);
        resource.amount -= used;
        this.startCycle();
        return totalUsed += used;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (resource == null) {
            return null;
        }
        if (!resource.isFluidEqual(this.fluidOutput)) {
            return null;
        }
        return this.drain(from, resource.amount, doDrain);
    }

    public FluidStack drain(ForgeDirection from, int maxEmpty, boolean doDrain) {
        return this.drain(maxEmpty, doDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return this.fluidInput != null && this.fluid.getFluid().equals(this.fluidInput.getFluid());
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        FluidTank compositeTank = new FluidTank(this.capacity);
        compositeTank.setFluid(this.fluid);
        return new FluidTankInfo[]{compositeTank.getInfo()};
    }

    public int[] buildFluidList() {
        int[] sortList = new int[6];
        if (this.fluid == null) {
            sortList[0] = AlchemicalWizardry.lifeEssenceFluid.getID();
            sortList[1] = 0;
        } else {
            sortList[0] = this.fluid.getFluidID();
            sortList[1] = this.fluid.amount;
        }
        if (this.fluidInput == null) {
            sortList[2] = AlchemicalWizardry.lifeEssenceFluid.getID();
            sortList[3] = 0;
        } else {
            sortList[2] = this.fluidInput.getFluidID();
            sortList[3] = this.fluidInput.amount;
        }
        if (this.fluidOutput == null) {
            sortList[4] = AlchemicalWizardry.lifeEssenceFluid.getID();
            sortList[5] = 0;
        } else {
            sortList[4] = this.fluidOutput.getFluidID();
            sortList[5] = this.fluidOutput.amount;
        }
        return sortList;
    }

    public void sendChatInfoToPlayer(EntityPlayer player) {
        player.func_145747_a((IChatComponent)new ChatComponentTranslation(String.format("message.altar.currentessence", new Object[0]), new Object[]{this.fluid.amount}));
        player.func_145747_a((IChatComponent)new ChatComponentTranslation(String.format("message.altar.currenttier", new Object[0]), new Object[]{UpgradedAltars.isAltarValid(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e)}));
        player.func_145747_a((IChatComponent)new ChatComponentTranslation(String.format("message.altar.capacity", new Object[0]), new Object[]{this.getCapacity()}));
    }

    public void sendMoreChatInfoToPlayer(EntityPlayer player) {
        if (this.func_70301_a(0) != null) {
            int stackSize = this.func_70301_a((int)0).field_77994_a;
            player.func_145747_a((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"message.altar.progress") + " " + this.progress + "LP/" + this.liquidRequired * stackSize + "LP"));
            player.func_145747_a((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"message.altar.consumptionrate") + " " + (int)((float)this.consumptionRate * (1.0f + this.consumptionMultiplier)) + "LP/t"));
        }
        player.func_145747_a((IChatComponent)new ChatComponentTranslation(String.format("message.altar.currentessence", new Object[0]), new Object[]{this.fluid.amount}));
        player.func_145747_a((IChatComponent)new ChatComponentTranslation(String.format("message.altar.inputtank", new Object[0]), new Object[]{this.fluidInput.amount}));
        player.func_145747_a((IChatComponent)new ChatComponentTranslation(String.format("message.altar.outputtank", new Object[0]), new Object[]{this.fluidOutput.amount}));
    }

    @Override
    public void requestPauseAfterCrafting(int amount) {
        if (this.isActive) {
            this.cooldownAfterCrafting = amount;
        }
    }

    @Override
    public void getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        if (!accessor.getNBTData().func_74764_b("altar") || !config.getConfig("bm.bloodAltar")) {
            return;
        }
        NBTTagCompound altarData = accessor.getNBTData().func_74775_l("altar");
        NumberFormat numberFormat = NumberFormat.getIntegerInstance();
        if (altarData.func_74764_b("stored")) {
            currenttip.add(StatCollector.func_74838_a((String)"tooltip.waila.currentFluid") + numberFormat.format(altarData.func_74762_e("stored")));
        } else {
            currenttip.add(StatCollector.func_74838_a((String)"tooltip.waila.noFluid"));
        }
        currenttip.add(StatCollector.func_74838_a((String)"tooltip.waila.altarCapacity") + numberFormat.format(altarData.func_74762_e("capacity")));
        currenttip.add(StatCollector.func_74838_a((String)"tooltip.waila.tier") + altarData.func_74762_e("tier"));
        if (altarData.func_74764_b("progress")) {
            currenttip.add(StatCollector.func_74838_a((String)"tooltip.waila.altarProgress") + altarData.func_74762_e("progress") + "%");
            currenttip.add(StatCollector.func_74838_a((String)"tooltip.waila.crafting") + altarData.func_74779_i("crafting"));
        }
    }

    @Override
    public void getWailaNBTData(EntityPlayerMP player, TileEntity tile, NBTTagCompound tag, World world, int x, int y, int z) {
        NBTTagCompound altarData = new NBTTagCompound();
        altarData.func_74768_a("tier", this.getTier());
        altarData.func_74768_a("capacity", this.getCapacity());
        int blood = this.getCurrentBlood();
        if (blood > 0) {
            altarData.func_74768_a("stored", blood);
        }
        if (this.func_70301_a(0) != null && this.progress > 0) {
            altarData.func_74768_a("progress", (int)((double)this.getProgress() / (double)this.liquidRequired * 100.0 / (double)this.func_70301_a((int)0).field_77994_a));
            ItemStack result = AltarRecipeRegistry.getItemForItemAndTier(this.func_70301_a(0), this.upgradeLevel);
            if (result != null) {
                altarData.func_74778_a("crafting", result.func_82833_r());
            }
        }
        tag.func_74782_a("altar", (NBTBase)altarData);
    }
}

