/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.summoning.meteor;

import WayofTime.alchemicalWizardry.AlchemicalWizardry;
import WayofTime.alchemicalWizardry.common.summoning.meteor.MeteorParadigmComponent;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.registry.GameRegistry;
import gregtech.common.blocks.TileEntityOres;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;

public class MeteorParadigm {
    public List<MeteorParadigmComponent> componentList = new ArrayList<MeteorParadigmComponent>();
    public List<MeteorParadigmComponent> fillerList = new ArrayList<MeteorParadigmComponent>();
    public ItemStack focusStack;
    public int radius;
    public int cost;
    public int fillerChance;
    public static Random rand = new Random();
    private static final Pattern itemNamePattern = Pattern.compile("(.*):(.*):(\\d+):(\\d+)");
    private static final Pattern oredictPattern = Pattern.compile("OREDICT:(.*):(\\d+)");

    public MeteorParadigm(ItemStack focusStack, int radius, int cost) {
        new MeteorParadigm(focusStack, radius, cost, 0);
    }

    public MeteorParadigm(ItemStack focusStack, int radius, int cost, int fillerChance) {
        this.focusStack = focusStack;
        this.radius = radius;
        this.cost = cost;
        this.fillerChance = fillerChance;
    }

    public static List<MeteorParadigmComponent> parseStringArray(String[] blockArray) {
        ArrayList<MeteorParadigmComponent> addList = new ArrayList<MeteorParadigmComponent>();
        for (int i = 0; i < blockArray.length; ++i) {
            String blockName = blockArray[i];
            boolean success = false;
            Matcher matcher = itemNamePattern.matcher(blockName);
            if (matcher.matches()) {
                String modID = matcher.group(1);
                String itemName = matcher.group(2);
                int meta = Integer.parseInt(matcher.group(3));
                int weight = Integer.parseInt(matcher.group(4));
                ItemStack stack = GameRegistry.findItemStack((String)modID, (String)itemName, (int)1);
                if (stack != null && stack.func_77973_b() instanceof ItemBlock) {
                    stack.func_77964_b(meta);
                    addList.add(new MeteorParadigmComponent(stack, weight));
                    success = true;
                }
            } else {
                String oreDict;
                matcher = oredictPattern.matcher(blockName);
                if (matcher.matches()) {
                    oreDict = matcher.group(1);
                    int weight = Integer.parseInt(matcher.group(2));
                    ArrayList list = OreDictionary.getOres((String)oreDict);
                    for (ItemStack stack : list) {
                        if (stack == null || !(stack.func_77973_b() instanceof ItemBlock)) continue;
                        addList.add(new MeteorParadigmComponent(stack, weight));
                        success = true;
                        break;
                    }
                } else {
                    oreDict = blockName;
                    int weight = Integer.parseInt(blockArray[++i]);
                    ArrayList list = OreDictionary.getOres((String)oreDict);
                    for (ItemStack stack : list) {
                        if (stack == null || !(stack.func_77973_b() instanceof ItemBlock)) continue;
                        addList.add(new MeteorParadigmComponent(stack, weight));
                        success = true;
                        break;
                    }
                }
            }
            if (success) continue;
            AlchemicalWizardry.logger.warn("Unable to add Meteor Paradigm \"" + blockName + "\"");
        }
        return addList;
    }

    public int getTotalListWeight(List<MeteorParadigmComponent> blockList) {
        int totalWeight = 0;
        for (MeteorParadigmComponent mpc : blockList) {
            totalWeight += mpc.getWeight();
        }
        return totalWeight;
    }

    public void createMeteorImpact(World world, int x, int y, int z, boolean[] flags) {
        ArrayList<MeteorParadigmComponent> fillerList;
        boolean hasTerrae = false;
        boolean hasOrbisTerrae = false;
        boolean hasCrystallos = false;
        boolean hasIncendium = false;
        boolean hasTennebrae = false;
        if (flags != null && flags.length >= 5) {
            hasTerrae = flags[0];
            hasOrbisTerrae = flags[1];
            hasCrystallos = flags[2];
            hasIncendium = flags[3];
            hasTennebrae = flags[4];
        }
        int newRadius = this.radius;
        int fillerChance = this.fillerChance;
        if (hasOrbisTerrae) {
            newRadius += 2;
            fillerChance = (int)((double)fillerChance * 1.12);
        } else if (hasTerrae) {
            ++newRadius;
            fillerChance = (int)((double)fillerChance * 1.06);
        }
        if (fillerChance > 100) {
            fillerChance = 100;
        }
        world.func_72876_a(null, (double)x, (double)y, (double)z, (float)(newRadius * 4), AlchemicalWizardry.doMeteorsDestroyBlocks);
        if (hasCrystallos || hasIncendium || hasTennebrae) {
            fillerList = new ArrayList();
            if (hasCrystallos) {
                fillerList.add(new MeteorParadigmComponent(new ItemStack(Blocks.field_150432_aD), 180));
            }
            if (hasIncendium) {
                fillerList.add(new MeteorParadigmComponent(new ItemStack(Blocks.field_150424_aL), 60));
                fillerList.add(new MeteorParadigmComponent(new ItemStack(Blocks.field_150425_aM), 60));
                fillerList.add(new MeteorParadigmComponent(new ItemStack(Blocks.field_150426_aN), 60));
            }
            if (hasTennebrae) {
                fillerList.add(new MeteorParadigmComponent(new ItemStack(Blocks.field_150343_Z), 180));
            }
        } else {
            fillerList = this.fillerList;
        }
        int totalComponentWeight = this.getTotalListWeight(this.componentList);
        int totalFillerWeight = this.getTotalListWeight(fillerList);
        for (int i = -newRadius; i <= newRadius; ++i) {
            for (int j = -newRadius; j <= newRadius; ++j) {
                for (int k = -newRadius; k <= newRadius; ++k) {
                    if ((float)(i * i + j * j + k * k) >= ((float)newRadius + 0.5f) * ((float)newRadius + 0.5f) || !world.func_147437_c(x + i, y + j, z + k)) continue;
                    if (fillerChance <= 0 || world.field_73012_v.nextInt(100) >= fillerChance) {
                        this.setMeteorBlock(x + i, y + j, z + k, world, this.componentList, totalComponentWeight);
                        continue;
                    }
                    this.setMeteorBlock(x + i, y + j, z + k, world, fillerList, totalFillerWeight);
                }
            }
        }
    }

    private void setMeteorBlock(int x, int y, int z, World world, List<MeteorParadigmComponent> blockList, int totalListWeight) {
        int randNum = world.field_73012_v.nextInt(totalListWeight);
        for (MeteorParadigmComponent mpc : blockList) {
            ItemStack blockStack;
            if ((randNum -= mpc.getWeight()) >= 0 || (blockStack = mpc.getValidBlockParadigm()) == null || !(blockStack.func_77973_b() instanceof ItemBlock)) continue;
            ((ItemBlock)blockStack.func_77973_b()).placeBlockAt(blockStack, null, world, x, y, z, 0, 0.0f, 0.0f, 0.0f, blockStack.func_77960_j());
            if (AlchemicalWizardry.isGregTechLoaded) {
                MeteorParadigm.setGTOresNaturalIfNeeded(world, x, y, z);
            }
            world.func_147471_g(x, y, z);
            break;
        }
    }

    @Optional.Method(modid="gregtech")
    private static void setGTOresNaturalIfNeeded(World world, int x, int y, int z) {
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (tileEntity instanceof TileEntityOres) {
            ((TileEntityOres)tileEntity).mNatural = true;
        }
    }
}

