/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.rituals;

import WayofTime.alchemicalWizardry.AlchemicalWizardry;
import WayofTime.alchemicalWizardry.api.alchemy.energy.ReagentRegistry;
import WayofTime.alchemicalWizardry.api.rituals.IMasterRitualStone;
import WayofTime.alchemicalWizardry.api.rituals.RitualComponent;
import WayofTime.alchemicalWizardry.api.rituals.RitualEffect;
import WayofTime.alchemicalWizardry.api.soulNetwork.SoulNetworkHandler;
import WayofTime.alchemicalWizardry.common.spell.complex.effect.SpellHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.world.World;

public class RitualEffectHealing
extends RitualEffect {
    public static final int reductusDrain = 10;
    public static final int virtusDrain = 10;
    public static final int praesidiumDrain = 2;

    @Override
    public void performEffect(IMasterRitualStone ritualStone) {
        int potency;
        String owner = ritualStone.getOwner();
        int currentEssence = SoulNetworkHandler.getCurrentEssence(owner);
        World world = ritualStone.getWorld();
        int x = ritualStone.getXCoord();
        int y = ritualStone.getYCoord();
        int z = ritualStone.getZCoord();
        int timeDelay = 50;
        if (world.func_72820_D() % (long)timeDelay != 0L) {
            return;
        }
        boolean hasPraesidium = this.canDrainReagent(ritualStone, ReagentRegistry.praesidiumReagent, 2, false);
        int range = 15 * (hasPraesidium ? 3 : 1);
        int vertRange = 15 * (hasPraesidium ? 3 : 1);
        List<EntityLivingBase> list = SpellHelper.getLivingEntitiesInRange(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, range, vertRange);
        int entityCount = 0;
        boolean flag = false;
        for (EntityLivingBase livingEntity : list) {
            if (livingEntity instanceof EntityPlayer) {
                entityCount += 10;
                continue;
            }
            ++entityCount;
        }
        boolean hasVirtus = this.canDrainReagent(ritualStone, ReagentRegistry.virtusReagent, 10, false);
        int cost = this.getCostPerRefresh() * (hasVirtus ? 3 : 1);
        int n = potency = hasVirtus ? 1 : 0;
        if (currentEssence < cost * entityCount) {
            SoulNetworkHandler.causeNauseaToPlayer(owner);
        } else {
            entityCount = 0;
            boolean hasReductus = this.canDrainReagent(ritualStone, ReagentRegistry.reductusReagent, 10, false);
            for (EntityLivingBase livingEntity : list) {
                PotionEffect effect;
                boolean bl = hasReductus = hasReductus && this.canDrainReagent(ritualStone, ReagentRegistry.reductusReagent, 10, false);
                if (hasReductus && !(livingEntity instanceof EntityPlayer) || !(livingEntity.func_110143_aJ() + 0.1f < livingEntity.func_110138_aP()) || (effect = livingEntity.func_70660_b(Potion.field_76428_l)) != null && (effect == null || effect.func_76458_c() > potency || effect.func_76459_b() > timeDelay) || hasVirtus && !this.canDrainReagent(ritualStone, ReagentRegistry.virtusReagent, 10, false)) continue;
                livingEntity.func_70690_d(new PotionEffect(Potion.field_76428_l.field_76415_H, timeDelay + 2, potency));
                if (hasReductus) {
                    this.canDrainReagent(ritualStone, ReagentRegistry.reductusReagent, 10, true);
                }
                if (hasVirtus) {
                    this.canDrainReagent(ritualStone, ReagentRegistry.virtusReagent, 10, true);
                }
                if (livingEntity instanceof EntityPlayer) {
                    entityCount += 10;
                    continue;
                }
                ++entityCount;
            }
            if (entityCount > 0) {
                if (hasPraesidium) {
                    this.canDrainReagent(ritualStone, ReagentRegistry.praesidiumReagent, 2, true);
                }
                SoulNetworkHandler.syphonFromNetwork(owner, cost * entityCount);
            }
        }
    }

    @Override
    public int getCostPerRefresh() {
        return AlchemicalWizardry.ritualCostRegen[1];
    }

    @Override
    public List<RitualComponent> getRitualComponentList() {
        ArrayList<RitualComponent> healingRitual = new ArrayList<RitualComponent>();
        healingRitual.add(new RitualComponent(4, 0, 0, 4));
        healingRitual.add(new RitualComponent(5, 0, -1, 4));
        healingRitual.add(new RitualComponent(5, 0, 1, 4));
        healingRitual.add(new RitualComponent(-4, 0, 0, 4));
        healingRitual.add(new RitualComponent(-5, 0, -1, 4));
        healingRitual.add(new RitualComponent(-5, 0, 1, 4));
        healingRitual.add(new RitualComponent(0, 0, 4, 2));
        healingRitual.add(new RitualComponent(-1, 0, 5, 2));
        healingRitual.add(new RitualComponent(1, 0, 5, 2));
        healingRitual.add(new RitualComponent(0, 0, -4, 2));
        healingRitual.add(new RitualComponent(-1, 0, -5, 2));
        healingRitual.add(new RitualComponent(1, 0, -5, 2));
        healingRitual.add(new RitualComponent(3, 0, 5, 1));
        healingRitual.add(new RitualComponent(5, 0, 3, 1));
        healingRitual.add(new RitualComponent(3, 0, -5, 1));
        healingRitual.add(new RitualComponent(5, 0, -3, 1));
        healingRitual.add(new RitualComponent(-3, 0, 5, 1));
        healingRitual.add(new RitualComponent(-5, 0, 3, 1));
        healingRitual.add(new RitualComponent(-3, 0, -5, 1));
        healingRitual.add(new RitualComponent(-5, 0, -3, 1));
        healingRitual.add(new RitualComponent(-3, 0, -3, 5));
        healingRitual.add(new RitualComponent(-3, 0, 3, 5));
        healingRitual.add(new RitualComponent(3, 0, -3, 5));
        healingRitual.add(new RitualComponent(3, 0, 3, 5));
        healingRitual.add(new RitualComponent(4, 0, 5, 3));
        healingRitual.add(new RitualComponent(4, -1, 5, 3));
        healingRitual.add(new RitualComponent(5, 0, 4, 3));
        healingRitual.add(new RitualComponent(5, -1, 4, 3));
        healingRitual.add(new RitualComponent(5, 0, 5, 3));
        healingRitual.add(new RitualComponent(4, 0, -5, 3));
        healingRitual.add(new RitualComponent(4, -1, -5, 3));
        healingRitual.add(new RitualComponent(5, 0, -4, 3));
        healingRitual.add(new RitualComponent(5, -1, -4, 3));
        healingRitual.add(new RitualComponent(5, 0, -5, 3));
        healingRitual.add(new RitualComponent(-4, 0, 5, 3));
        healingRitual.add(new RitualComponent(-4, -1, 5, 3));
        healingRitual.add(new RitualComponent(-5, 0, 4, 3));
        healingRitual.add(new RitualComponent(-5, -1, 4, 3));
        healingRitual.add(new RitualComponent(-5, 0, 5, 3));
        healingRitual.add(new RitualComponent(-4, 0, -5, 3));
        healingRitual.add(new RitualComponent(-4, -1, -5, 3));
        healingRitual.add(new RitualComponent(-5, 0, -4, 3));
        healingRitual.add(new RitualComponent(-5, -1, -4, 3));
        healingRitual.add(new RitualComponent(-5, 0, -5, 3));
        return healingRitual;
    }
}

