/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.carts;

import mods.railcraft.common.carts.ItemLocomotive;
import mods.railcraft.common.util.crafting.DyeHelper;
import mods.railcraft.common.util.inventory.InvTools;
import mods.railcraft.common.util.misc.EnumColor;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.World;

public class LocomotivePaintingRecipe
implements IRecipe {
    private final ItemStack locomotive;

    public LocomotivePaintingRecipe(ItemStack locomotive) {
        this.locomotive = locomotive;
        InvTools.addNBTTag(locomotive, "gregfix", "get the hell off my lawn!");
    }

    private boolean isDye(ItemStack stack) {
        return this.getDye(stack) != -1;
    }

    private int getDye(ItemStack stack) {
        for (EnumColor color : EnumColor.VALUES) {
            if (!InvTools.isItemEqual(stack, DyeHelper.getDyes().get((Object)color))) continue;
            return color.ordinal();
        }
        return -1;
    }

    private boolean isLocomotive(ItemStack loco) {
        return InvTools.isItemEqualIgnoreNBT(this.locomotive, loco);
    }

    public boolean func_77569_a(InventoryCrafting craftingGrid, World var2) {
        if (craftingGrid.func_70302_i_() < this.func_77570_a()) {
            return false;
        }
        ItemStack dyePrimary = craftingGrid.func_70463_b(1, 0);
        if (!this.isDye(dyePrimary)) {
            return false;
        }
        ItemStack cart = craftingGrid.func_70463_b(1, 1);
        if (!this.isLocomotive(cart)) {
            return false;
        }
        ItemStack dyeSecondary = craftingGrid.func_70463_b(1, 2);
        return this.isDye(dyeSecondary);
    }

    public ItemStack func_77572_b(InventoryCrafting craftingGrid) {
        ItemStack dyePrimary = craftingGrid.func_70463_b(1, 0);
        ItemStack loco = craftingGrid.func_70463_b(1, 1);
        ItemStack dyeSecondary = craftingGrid.func_70463_b(1, 2);
        if (loco == null) {
            return null;
        }
        ItemStack result = loco.func_77946_l();
        ItemLocomotive.setItemColorData(result, this.getDye(dyePrimary), this.getDye(dyeSecondary));
        return result;
    }

    public int func_77570_a() {
        return 9;
    }

    public ItemStack func_77571_b() {
        return this.locomotive;
    }
}

