/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.aesthetics.post;

import java.util.HashSet;
import java.util.Set;
import mods.railcraft.api.core.IPostConnection;
import mods.railcraft.common.blocks.aesthetics.lantern.BlockLantern;
import mods.railcraft.common.blocks.aesthetics.post.BlockPostBase;
import mods.railcraft.common.blocks.signals.ISignalTile;
import mods.railcraft.common.plugins.forge.WorldPlugin;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.misc.MiscTools;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSign;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public class PostConnectionHelper {
    public static final Set<Block> canConnect = new HashSet<Block>();
    public static final Set<Block> noConnect = new HashSet<Block>();

    public static IPostConnection.ConnectStyle connect(IBlockAccess world, int x1, int y1, int z1, ForgeDirection side) {
        int z2;
        int y2;
        Block block = WorldPlugin.getBlock(world, x1, y1, z1);
        if (block instanceof IPostConnection && ((IPostConnection)block).connectsToPost(world, x1, y1, z1, side) == IPostConnection.ConnectStyle.NONE) {
            return IPostConnection.ConnectStyle.NONE;
        }
        int x2 = MiscTools.getXOnSide(x1, side);
        if (world.func_147437_c(x2, y2 = MiscTools.getYOnSide(y1, side), z2 = MiscTools.getZOnSide(z1, side))) {
            return IPostConnection.ConnectStyle.NONE;
        }
        Block otherBlock = WorldPlugin.getBlock(world, x2, y2, z2);
        ForgeDirection oppositeSide = side.getOpposite();
        try {
            if (otherBlock instanceof IPostConnection) {
                return ((IPostConnection)otherBlock).connectsToPost(world, x2, y2, z2, oppositeSide);
            }
        }
        catch (Error error) {
            Game.logErrorAPI("Railcraft", error, IPostConnection.class);
        }
        if (otherBlock instanceof BlockPostBase) {
            return IPostConnection.ConnectStyle.TWO_THIN;
        }
        if (noConnect.contains(otherBlock)) {
            return IPostConnection.ConnectStyle.NONE;
        }
        if (canConnect.contains(otherBlock)) {
            return IPostConnection.ConnectStyle.TWO_THIN;
        }
        if (otherBlock instanceof BlockSign) {
            int meta = world.func_72805_g(x2, y2, z2);
            return meta == side.ordinal() ? IPostConnection.ConnectStyle.SINGLE_THICK : IPostConnection.ConnectStyle.NONE;
        }
        if (otherBlock instanceof BlockLantern) {
            return IPostConnection.ConnectStyle.SINGLE_THICK;
        }
        TileEntity otherTile = world.func_147438_o(x2, y2, z2);
        if (otherTile instanceof ISignalTile) {
            return IPostConnection.ConnectStyle.TWO_THIN;
        }
        if (world.isSideSolid(x2, y2, z2, oppositeSide, false)) {
            return IPostConnection.ConnectStyle.TWO_THIN;
        }
        return IPostConnection.ConnectStyle.NONE;
    }

    static {
        canConnect.add(Blocks.field_150426_aN);
        canConnect.add(Blocks.field_150379_bu);
        canConnect.add(Blocks.field_150374_bv);
        canConnect.add(Blocks.field_150359_w);
        canConnect.add(Blocks.field_150474_ac);
        canConnect.add((Block)Blocks.field_150331_J);
        noConnect.add(Blocks.field_150346_d);
        noConnect.add(Blocks.field_150348_b);
        noConnect.add(Blocks.field_150351_n);
        noConnect.add((Block)Blocks.field_150349_c);
        noConnect.add((Block)Blocks.field_150354_m);
        noConnect.add(Blocks.field_150357_h);
        noConnect.add(Blocks.field_150365_q);
        noConnect.add(Blocks.field_150482_ag);
        noConnect.add(Blocks.field_150412_bA);
        noConnect.add(Blocks.field_150352_o);
        noConnect.add(Blocks.field_150366_p);
        noConnect.add(Blocks.field_150369_x);
        noConnect.add(Blocks.field_150450_ax);
        noConnect.add(Blocks.field_150439_ay);
        noConnect.add(Blocks.field_150435_aG);
        noConnect.add(Blocks.field_150433_aE);
        noConnect.add(Blocks.field_150431_aC);
        noConnect.add(Blocks.field_150440_ba);
        noConnect.add(Blocks.field_150423_aK);
        noConnect.add(Blocks.field_150335_W);
        noConnect.add(Blocks.field_150425_aM);
        noConnect.add(Blocks.field_150424_aL);
        noConnect.add(Blocks.field_150360_v);
    }
}

