/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.client.gui;

import appeng.api.AEApi;
import appeng.api.config.ActionItems;
import appeng.api.config.Settings;
import appeng.api.config.TerminalStyle;
import appeng.api.config.YesNo;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.util.DimensionalCoord;
import appeng.client.gui.IInterfaceTerminalPostUpdate;
import appeng.client.gui.widgets.GuiImgButton;
import appeng.client.gui.widgets.GuiScrollbar;
import appeng.client.gui.widgets.IDropToFillTextField;
import appeng.client.gui.widgets.ITooltip;
import appeng.client.gui.widgets.MEGuiTextField;
import appeng.client.render.BlockPosHighlighter;
import appeng.container.slot.AppEngSlot;
import appeng.core.AEConfig;
import appeng.core.CommonHelper;
import appeng.core.localization.ButtonToolTips;
import appeng.core.localization.GuiColors;
import appeng.core.localization.GuiText;
import appeng.core.localization.PlayerMessages;
import appeng.core.sync.AppEngPacket;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.PacketInterfaceTerminalUpdate;
import appeng.core.sync.packets.PacketInventoryAction;
import appeng.helpers.InventoryAction;
import appeng.helpers.PatternHelper;
import appeng.integration.IntegrationRegistry;
import appeng.integration.IntegrationType;
import appeng.items.misc.ItemEncodedPattern;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.util.Platform;
import appeng.util.item.AEItemStack;
import com.glodblock.github.FluidCraft;
import com.glodblock.github.client.gui.GuiFCImgButton;
import com.glodblock.github.client.gui.base.FCBaseMEGui;
import com.glodblock.github.client.gui.container.ContainerInterfaceWireless;
import com.glodblock.github.inventory.item.IWirelessTerminal;
import com.glodblock.github.network.CPacketRenamer;
import com.google.common.base.Optional;
import cpw.mods.fml.common.Loader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class GuiInterfaceWireless
extends FCBaseMEGui
implements IDropToFillTextField,
IInterfaceTerminalPostUpdate {
    public static final int HEADER_HEIGHT = 52;
    public static final int INV_HEIGHT = 98;
    public static final int VIEW_WIDTH = 174;
    public static final int VIEW_LEFT = 10;
    protected static final ResourceLocation BACKGROUND = new ResourceLocation("appliedenergistics2", "textures/guis/newinterfaceterminal.png");
    private final InterfaceWirelessList masterList = new InterfaceWirelessList();
    private final MEGuiTextField searchFieldOutputs;
    private final MEGuiTextField searchFieldInputs;
    private final MEGuiTextField searchFieldNames;
    private final GuiImgButton guiButtonHideFull;
    private final GuiImgButton guiButtonAssemblersOnly;
    private final GuiImgButton guiButtonBrokenRecipes;
    private final GuiImgButton terminalStyleBox;
    private final GuiImgButton searchStringSave;
    private boolean onlyMolecularAssemblers = false;
    private boolean onlyBrokenRecipes = false;
    private boolean online;
    private int viewHeight;
    private final List<String> extraOptionsText;
    private ItemStack tooltipStack;
    private final boolean neiPresent;
    protected static String searchFieldInputsText = "";
    protected static String searchFieldOutputsText = "";
    protected static String searchFieldNamesText = "";
    private static final float ITEM_STACK_Z = 100.0f;
    private static final float SLOT_Z = 0.5f;
    private static final float ITEM_STACK_OVERLAY_Z = 200.0f;
    private static final float SLOT_HOVER_Z = 310.0f;
    private static final float TOOLTIP_Z = 410.0f;
    private static final float STEP_Z = 10.0f;
    private static final float MAGIC_RENDER_ITEM_Z = 50.0f;
    protected int offsetY;

    public GuiInterfaceWireless(InventoryPlayer inventoryPlayer, IWirelessTerminal te) {
        super(inventoryPlayer, (Container)new ContainerInterfaceWireless(inventoryPlayer, te));
        this.setScrollBar(new GuiScrollbar());
        this.field_146999_f = 208;
        this.field_147000_g = 255;
        this.neiPresent = Loader.isModLoaded((String)"NotEnoughItems");
        this.searchFieldInputs = new MEGuiTextField(86, 12, ButtonToolTips.SearchFieldInputs.getLocal()){

            public void onTextChange(String oldText) {
                GuiInterfaceWireless.this.masterList.markDirty();
            }
        };
        this.searchFieldOutputs = new MEGuiTextField(86, 12, ButtonToolTips.SearchFieldOutputs.getLocal()){

            public void onTextChange(String oldText) {
                GuiInterfaceWireless.this.masterList.markDirty();
            }
        };
        this.searchFieldNames = new MEGuiTextField(71, 12, ButtonToolTips.SearchFieldNames.getLocal()){

            public void onTextChange(String oldText) {
                GuiInterfaceWireless.this.masterList.markDirty();
            }
        };
        this.searchFieldNames.setFocused(true);
        this.searchStringSave = new GuiImgButton(0, 0, (Enum)Settings.SAVE_SEARCH, (Enum)(AEConfig.instance.preserveSearchBar ? YesNo.YES : YesNo.NO));
        this.guiButtonAssemblersOnly = new GuiImgButton(0, 0, (Enum)Settings.ACTIONS, null);
        this.guiButtonHideFull = new GuiImgButton(0, 0, (Enum)Settings.ACTIONS, null);
        this.guiButtonBrokenRecipes = new GuiImgButton(0, 0, (Enum)Settings.ACTIONS, null);
        this.terminalStyleBox = new GuiImgButton(0, 0, (Enum)Settings.TERMINAL_STYLE, null);
        this.extraOptionsText = new ArrayList<String>(2);
        this.extraOptionsText.add(ButtonToolTips.HighlightInterface.getLocal());
    }

    @Override
    public int getOffsetY() {
        return this.offsetY;
    }

    @Override
    public void setOffsetY(int y) {
        this.offsetY = y;
    }

    private void setScrollBar() {
        int maxScroll = this.masterList.getHeight() - this.viewHeight - 1;
        if (maxScroll <= 0) {
            this.getScrollBar().setTop(52).setLeft(189).setHeight(this.viewHeight).setRange(0, 0, 1);
        } else {
            this.getScrollBar().setTop(52).setLeft(189).setHeight(this.viewHeight).setRange(0, maxScroll, 12);
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.clear();
        this.viewHeight = this.calculateViewHeight();
        this.field_147000_g = 150 + this.viewHeight;
        int unusedSpace = this.field_146295_m - this.field_147000_g;
        this.field_147009_r = (int)Math.floor((float)unusedSpace / (unusedSpace < 0 ? 3.8f : 2.0f));
        this.searchFieldInputs.x = this.field_147003_i + Math.max(32, 10);
        this.searchFieldInputs.y = this.field_147009_r + 25;
        this.searchFieldOutputs.x = this.field_147003_i + Math.max(32, 10);
        this.searchFieldOutputs.y = this.field_147009_r + 38;
        this.searchFieldNames.x = this.field_147003_i + Math.max(32, 10) + 99;
        this.searchFieldNames.y = this.field_147009_r + 38;
        this.terminalStyleBox.field_146128_h = this.field_147003_i - 18;
        this.terminalStyleBox.field_146129_i = this.field_147009_r + 8;
        this.searchStringSave.field_146128_h = this.field_147003_i - 18;
        this.searchStringSave.field_146129_i = this.terminalStyleBox.field_146129_i + 18;
        this.guiButtonBrokenRecipes.field_146128_h = this.field_147003_i - 18;
        this.guiButtonBrokenRecipes.field_146129_i = this.searchStringSave.field_146129_i + 18;
        this.guiButtonHideFull.field_146128_h = this.field_147003_i - 18;
        this.guiButtonHideFull.field_146129_i = this.guiButtonBrokenRecipes.field_146129_i + 18;
        this.guiButtonAssemblersOnly.field_146128_h = this.field_147003_i - 18;
        this.guiButtonAssemblersOnly.field_146129_i = this.guiButtonHideFull.field_146129_i + 18;
        this.offsetY = this.guiButtonAssemblersOnly.field_146129_i + 18;
        this.setSearchString();
        this.setScrollBar();
        this.repositionSlots();
        this.field_146292_n.add(this.guiButtonAssemblersOnly);
        this.field_146292_n.add(this.guiButtonHideFull);
        this.field_146292_n.add(this.guiButtonBrokenRecipes);
        this.field_146292_n.add(this.searchStringSave);
        this.field_146292_n.add(this.terminalStyleBox);
        this.initGuiDone();
        this.addSwitchGuiBtns();
    }

    protected void repositionSlots() {
        for (Object obj : this.field_147002_h.field_75151_b) {
            if (!(obj instanceof AppEngSlot)) continue;
            AppEngSlot slot = (AppEngSlot)obj;
            slot.field_75221_f = this.field_147000_g + slot.getY() - 78 - 4;
        }
    }

    protected int calculateViewHeight() {
        int maxViewHeight = this.getMaxViewHeight();
        boolean hasNEI = IntegrationRegistry.INSTANCE.isEnabled(IntegrationType.NEI);
        int NEIPadding = hasNEI ? 40 : 0;
        int availableSpace = this.field_146295_m - 52 - 98 - NEIPadding;
        return Math.min((int)((double)availableSpace * 0.95), maxViewHeight);
    }

    public void drawFG(int offsetX, int offsetY, int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b(this.getGuiDisplayName(GuiText.InterfaceTerminal.getLocal()), 8, 6, GuiColors.InterfaceTerminalTitle.getColor());
        this.field_146289_q.func_78276_b(GuiText.inventory.getLocal(), 12, this.field_147000_g - 96, GuiColors.InterfaceTerminalInventory.getColor());
        if (!this.neiPresent && this.tooltipStack != null) {
            this.func_146285_a(this.tooltipStack, mouseX, mouseY);
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float btn) {
        this.guiButtonAssemblersOnly.set((Enum)(this.onlyMolecularAssemblers ? ActionItems.MOLECULAR_ASSEMBLEERS_ON : ActionItems.MOLECULAR_ASSEMBLEERS_OFF));
        this.guiButtonHideFull.set((Enum)(AEConfig.instance.showOnlyInterfacesWithFreeSlotsInInterfaceTerminal ? ActionItems.TOGGLE_SHOW_FULL_INTERFACES_OFF : ActionItems.TOGGLE_SHOW_FULL_INTERFACES_ON));
        this.guiButtonBrokenRecipes.set((Enum)(this.onlyBrokenRecipes ? ActionItems.TOGGLE_SHOW_ONLY_INVALID_PATTERN_OFF : ActionItems.TOGGLE_SHOW_ONLY_INVALID_PATTERN_ON));
        this.terminalStyleBox.set(AEConfig.instance.settings.getSetting(Settings.TERMINAL_STYLE));
        super.func_73863_a(mouseX, mouseY, btn);
        this.handleTooltip(mouseX, mouseY, (ITooltip)this.searchFieldInputs);
        this.handleTooltip(mouseX, mouseY, (ITooltip)this.searchFieldOutputs);
        this.handleTooltip(mouseX, mouseY, (ITooltip)this.searchFieldNames);
    }

    @Override
    protected void func_73864_a(int xCoord, int yCoord, int btn) {
        this.searchFieldInputs.mouseClicked(xCoord, yCoord, btn);
        this.searchFieldOutputs.mouseClicked(xCoord, yCoord, btn);
        this.searchFieldNames.mouseClicked(xCoord, yCoord, btn);
        if (this.masterList.mouseClicked(xCoord - this.field_147003_i - 10, yCoord - this.field_147009_r - 52, btn)) {
            return;
        }
        super.func_73864_a(xCoord, yCoord, btn);
    }

    @Override
    protected void func_146284_a(GuiButton btn) {
        if (btn == this.guiButtonAssemblersOnly) {
            this.onlyMolecularAssemblers = !this.onlyMolecularAssemblers;
            this.masterList.markDirty();
        } else if (btn == this.guiButtonHideFull) {
            AEConfig.instance.showOnlyInterfacesWithFreeSlotsInInterfaceTerminal = !AEConfig.instance.showOnlyInterfacesWithFreeSlotsInInterfaceTerminal;
            this.masterList.markDirty();
        } else if (btn == this.guiButtonBrokenRecipes) {
            this.onlyBrokenRecipes = !this.onlyBrokenRecipes;
            this.masterList.markDirty();
        } else if (btn instanceof GuiImgButton) {
            GuiImgButton iBtn = (GuiImgButton)btn;
            if (iBtn.getSetting() != Settings.ACTIONS) {
                Enum cv = iBtn.getCurrentValue();
                boolean backwards = Mouse.isButtonDown((int)1);
                Enum next = Platform.rotateEnum((Enum)cv, (boolean)backwards, (EnumSet)iBtn.getSetting().getPossibleValues());
                if (btn == this.terminalStyleBox) {
                    AEConfig.instance.settings.putSetting(iBtn.getSetting(), next);
                    super.scheduleGuiResize();
                } else if (btn == this.searchStringSave) {
                    AEConfig.instance.preserveSearchBar = next == YesNo.YES;
                }
                iBtn.set(next);
            }
        } else {
            super.func_146284_a(btn);
        }
    }

    @Override
    public void func_146281_b() {
        super.func_146281_b();
        searchFieldInputsText = this.searchFieldInputs.getText();
        searchFieldOutputsText = this.searchFieldOutputs.getText();
        searchFieldNamesText = this.searchFieldNames.getText();
    }

    public void setSearchString() {
        boolean setString;
        boolean bl = setString = AEConfig.instance.preserveSearchBar || this.isSubGui();
        if (this.searchFieldInputs.getText().isEmpty() && setString) {
            this.searchFieldInputs.setText(searchFieldInputsText);
        }
        if (this.searchFieldOutputs.getText().isEmpty() && setString) {
            this.searchFieldOutputs.setText(searchFieldOutputsText);
        }
        if (this.searchFieldNames.getText().isEmpty() && setString) {
            this.searchFieldNames.setText(searchFieldNamesText);
        }
    }

    public void drawBG(int offsetX, int offsetY, int mouseX, int mouseY) {
        this.bindTexture(BACKGROUND);
        this.func_73729_b(offsetX, offsetY, 0, 0, this.field_146999_f, 52);
        Tessellator.field_78398_a.func_78382_b();
        this.addTexturedRectToTesselator(offsetX, offsetY + 52, offsetX + this.field_146999_f, offsetY + 52 + this.viewHeight + 1, 0.0f, 0.0f, 0.25390625f, (float)this.field_146999_f / 256.0f, 0.6171875f);
        Tessellator.field_78398_a.func_78381_a();
        this.func_73729_b(offsetX, offsetY + 52 + this.viewHeight, 0, 158, this.field_146999_f, 98);
        if (this.online) {
            GL11.glPushAttrib((int)1048575);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glPushMatrix();
            GL11.glTranslatef((float)(offsetX + 10), (float)(offsetY + 52), (float)0.0f);
            this.tooltipStack = null;
            this.masterList.hoveredEntry = null;
            this.drawViewport(mouseX - offsetX - 10, mouseY - offsetY - 52 - 1);
            GL11.glPopMatrix();
            GL11.glPopAttrib();
        }
        this.searchFieldInputs.drawTextBox();
        this.searchFieldOutputs.drawTextBox();
        this.searchFieldNames.drawTextBox();
    }

    private void drawViewport(int relMouseX, int relMouseY) {
        int scroll = this.getScrollBar().getCurrentScroll();
        int viewY = -scroll;
        int entryIdx = 0;
        List<InterfaceWirelessSection> visibleSections = this.masterList.getVisibleSections();
        float guiScaleX = (float)this.field_146297_k.field_71443_c / (float)this.field_146294_l;
        float guiScaleY = (float)this.field_146297_k.field_71440_d / (float)this.field_146295_m;
        GL11.glScissor((int)((int)((float)(this.field_147003_i + 10) * guiScaleX)), (int)((int)((float)(this.field_146295_m - (this.field_147009_r + 52 + this.viewHeight)) * guiScaleY)), (int)((int)(174.0f * guiScaleX)), (int)((int)((float)this.viewHeight * guiScaleY)));
        GL11.glEnable((int)3089);
        while (viewY < this.viewHeight && entryIdx < visibleSections.size()) {
            InterfaceWirelessSection section = visibleSections.get(entryIdx);
            int sectionHeight = section.getHeight();
            if (viewY + sectionHeight < 0) {
                ++entryIdx;
                viewY += sectionHeight;
                section.visible = false;
                continue;
            }
            section.visible = true;
            int advanceY = this.drawSection(section, viewY, relMouseX, relMouseY);
            viewY += advanceY;
            ++entryIdx;
        }
    }

    private int drawSection(InterfaceWirelessSection section, int viewY, int relMouseX, int relMouseY) {
        int renderY = 0;
        int sectionBottom = viewY + section.getHeight() - 1;
        int fontColor = GuiColors.InterfaceTerminalInventory.getColor();
        this.bindTexture(BACKGROUND);
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)310.0f);
        int title = sectionBottom > 0 && sectionBottom < 12 ? sectionBottom : (viewY < 0 ? 0 : 0);
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-310.0f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Iterator<InterfaceWirelessEntry> visible = section.getVisible();
        while (visible.hasNext()) {
            InterfaceWirelessEntry entry = visible.next();
            if (viewY + renderY + entry.rows * 18 + 1 > 0 && viewY + renderY < this.viewHeight) {
                renderY += this.drawEntry(entry, viewY + 12 + renderY, title, relMouseX, relMouseY);
                continue;
            }
            entry.dispY = -9999;
            entry.optionsButton.field_146129_i = -1;
            renderY += entry.rows * 18 + 1;
        }
        this.bindTexture(BACKGROUND);
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)310.0f);
        if (sectionBottom > 0 && sectionBottom < 12) {
            this.func_73729_b(0, 0, 10, 64 - sectionBottom, 174, sectionBottom);
            this.field_146289_q.func_78276_b(section.name, 2, sectionBottom - 12 + 2, fontColor);
        } else if (viewY < 0) {
            GL11.glDisable((int)2929);
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)100.0f);
            this.func_73729_b(0, 0, 10, 52, 174, 12);
            this.field_146289_q.func_78276_b(section.name, 2, 2, fontColor);
            GL11.glEnable((int)2929);
        } else {
            this.func_73729_b(0, viewY, 10, 52, 174, 12);
            this.field_146289_q.func_78276_b(section.name, 2, viewY + 2, fontColor);
        }
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-310.0f);
        return 12 + renderY;
    }

    private int drawEntry(InterfaceWirelessEntry entry, int viewY, int titleBottom, int relMouseX, int relMouseY) {
        int rowYBot;
        int rowYTop;
        this.bindTexture(BACKGROUND);
        Tessellator.field_78398_a.func_78382_b();
        int relY = 0;
        int slotLeftMargin = 174 - entry.rowSize * 18;
        entry.dispY = viewY;
        for (int row = 0; row < entry.rows; ++row) {
            rowYTop = row * 18;
            rowYBot = rowYTop + 18;
            relY += 18;
            if (viewY + rowYBot <= titleBottom) continue;
            for (int col = 0; col < entry.rowSize; ++col) {
                this.addTexturedRectToTesselator(col * 18 + slotLeftMargin, viewY + rowYTop, 18 * col + 18 + slotLeftMargin, viewY + rowYBot, 0.0f, 0.08203125f, 0.67578125f, 0.15234375f, 0.74609375f);
            }
        }
        Tessellator.field_78398_a.func_78381_a();
        if (viewY + entry.optionsButton.field_146121_g > 0 && viewY < this.viewHeight) {
            entry.optionsButton.field_146129_i = viewY + 5;
            entry.renameButton.field_146129_i = viewY + 5;
            GuiFCImgButton toRender = GuiInterfaceWireless.func_146272_n() ? entry.renameButton : entry.optionsButton;
            toRender.func_146112_a(this.field_146297_k, relMouseX, relMouseY);
            if (toRender.getMouseIn() && relMouseY >= Math.max(12, entry.optionsButton.field_146129_i)) {
                GL11.glTranslatef((float)0.0f, (float)0.0f, (float)410.0f);
                GL11.glDisable((int)3089);
                this.drawHoveringText(Arrays.asList(toRender.getMessage()), relMouseX, relMouseY);
                GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-410.0f);
                GL11.glEnable((int)3089);
            }
        } else {
            entry.optionsButton.field_146129_i = -1;
            entry.renameButton.field_146129_i = -1;
        }
        for (int row = 0; row < entry.rows; ++row) {
            rowYTop = row * 18;
            rowYBot = rowYTop + 18;
            if (viewY + rowYBot <= titleBottom) continue;
            AppEngInternalInventory inv = entry.getInventory();
            for (int col = 0; col < entry.rowSize; ++col) {
                boolean tooltip;
                int colLeft = col * 18 + slotLeftMargin + 1;
                int colRight = colLeft + 18 + 1;
                int slotIdx = row * entry.rowSize + col;
                ItemStack stack = inv.func_70301_a(slotIdx);
                boolean bl = tooltip = relMouseX > colLeft - 1 && relMouseX < colRight - 1 && relMouseY >= Math.max(viewY + rowYTop, 12) && relMouseY < Math.min(viewY + rowYBot, this.viewHeight);
                if (stack != null) {
                    ItemEncodedPattern iep = (ItemEncodedPattern)stack.func_77973_b();
                    ItemStack toRender = iep.getOutput(stack);
                    GL11.glPushMatrix();
                    GL11.glTranslatef((float)colLeft, (float)(viewY + rowYTop + 1), (float)100.0f);
                    GL11.glEnable((int)32826);
                    RenderHelper.func_74520_c();
                    GuiInterfaceWireless.translatedRenderItem.field_77023_b = 50.0f;
                    translatedRenderItem.func_82406_b(this.field_146289_q, this.field_146297_k.func_110434_K(), toRender, 0, 0);
                    GL11.glTranslatef((float)0.0f, (float)0.0f, (float)200.0f);
                    aeRenderItem.setAeStack((IAEItemStack)AEItemStack.create((ItemStack)toRender));
                    aeRenderItem.func_77021_b(this.field_146289_q, this.field_146297_k.func_110434_K(), toRender, 0, 0);
                    GuiInterfaceWireless.aeRenderItem.field_77023_b = 0.0f;
                    RenderHelper.func_74518_a();
                    if (!tooltip) {
                        if (entry.slotIsBroken(slotIdx)) {
                            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-199.5f);
                            GuiInterfaceWireless.func_73734_a((int)0, (int)0, (int)16, (int)16, (int)GuiColors.ItemSlotOverlayInvalid.getColor());
                        } else if (entry.filteredRecipes[slotIdx]) {
                            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)200.0f);
                            GuiInterfaceWireless.func_73734_a((int)0, (int)0, (int)16, (int)16, (int)GuiColors.ItemSlotOverlayUnpowered.getColor());
                        }
                    } else {
                        this.tooltipStack = stack;
                    }
                    GL11.glPopMatrix();
                } else if (entry.filteredRecipes[slotIdx]) {
                    GL11.glPushMatrix();
                    GL11.glTranslatef((float)colLeft, (float)(viewY + rowYTop + 1), (float)200.0f);
                    GuiInterfaceWireless.func_73734_a((int)0, (int)0, (int)16, (int)16, (int)GuiColors.ItemSlotOverlayUnpowered.getColor());
                    GL11.glPopMatrix();
                }
                if (tooltip) {
                    GL11.glDisable((int)2896);
                    GL11.glTranslatef((float)0.0f, (float)0.0f, (float)310.0f);
                    GuiInterfaceWireless.func_73734_a((int)colLeft, (int)(viewY + 1 + rowYTop), (int)(-2 + colRight), (int)(viewY - 1 + rowYBot), (int)0x77FFFFFF);
                    GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-310.0f);
                    this.masterList.hoveredEntry = entry;
                    entry.hoveredSlotIdx = slotIdx;
                }
                GL11.glDisable((int)2896);
            }
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        return relY + 1;
    }

    public List<String> handleItemTooltip(ItemStack stack, int mouseX, int mouseY, List<String> currentToolTip) {
        return currentToolTip;
    }

    public ItemStack getHoveredStack() {
        return this.tooltipStack;
    }

    public void drawHoveringText(List textLines, int x, int y, FontRenderer font) {
        if (!textLines.isEmpty()) {
            GL11.glDisable((int)32826);
            RenderHelper.func_74518_a();
            int maxStrWidth = 0;
            for (String s : textLines) {
                int width = font.func_78256_a(s);
                if (width <= maxStrWidth) continue;
                maxStrWidth = width;
            }
            int curX = x + 12;
            int curY = y - 12;
            int totalHeight = 8;
            if (textLines.size() > 1) {
                totalHeight += 2 + (textLines.size() - 1) * 10;
            }
            if (curX + maxStrWidth > this.field_146294_l) {
                curX -= 28 + maxStrWidth;
            }
            if (curY + totalHeight + 6 > this.field_146295_m) {
                curY = this.field_146295_m - totalHeight - 6;
            }
            int borderColor = -267386864;
            this.func_73733_a(curX - 3, curY - 4, curX + maxStrWidth + 3, curY - 3, borderColor, borderColor);
            this.func_73733_a(curX - 3, curY + totalHeight + 3, curX + maxStrWidth + 3, curY + totalHeight + 4, borderColor, borderColor);
            this.func_73733_a(curX - 3, curY - 3, curX + maxStrWidth + 3, curY + totalHeight + 3, borderColor, borderColor);
            this.func_73733_a(curX - 4, curY - 3, curX - 3, curY + totalHeight + 3, borderColor, borderColor);
            this.func_73733_a(curX + maxStrWidth + 3, curY - 3, curX + maxStrWidth + 4, curY + totalHeight + 3, borderColor, borderColor);
            int color1 = 0x505000FF;
            int color2 = (color1 & 0xFEFEFE) >> 1 | color1 & 0xFF000000;
            this.func_73733_a(curX - 3, curY - 3 + 1, curX - 3 + 1, curY + totalHeight + 3 - 1, color1, color2);
            this.func_73733_a(curX + maxStrWidth + 2, curY - 3 + 1, curX + maxStrWidth + 3, curY + totalHeight + 3 - 1, color1, color2);
            this.func_73733_a(curX - 3, curY - 3, curX + maxStrWidth + 3, curY - 3 + 1, color1, color1);
            this.func_73733_a(curX - 3, curY + totalHeight + 2, curX + maxStrWidth + 3, curY + totalHeight + 3, color2, color2);
            for (int i = 0; i < textLines.size(); ++i) {
                String line = (String)textLines.get(i);
                font.func_78261_a(line, curX, curY, -1);
                if (i == 0) {
                    curY += 2;
                }
                curY += 10;
            }
            RenderHelper.func_74520_c();
            GL11.glEnable((int)32826);
        }
    }

    protected void func_73869_a(char character, int key) {
        if (!this.func_146983_a(key)) {
            if (character == ' ' ? this.searchFieldInputs.getText().isEmpty() && this.searchFieldInputs.isFocused() || this.searchFieldOutputs.getText().isEmpty() && this.searchFieldOutputs.isFocused() || this.searchFieldNames.getText().isEmpty() && this.searchFieldNames.isFocused() : character == '\t' && this.handleTab()) {
                return;
            }
            if (this.searchFieldInputs.textboxKeyTyped(character, key) || this.searchFieldOutputs.textboxKeyTyped(character, key) || this.searchFieldNames.textboxKeyTyped(character, key)) {
                return;
            }
            super.func_73869_a(character, key);
        }
    }

    protected boolean mouseWheelEvent(int mouseX, int mouseY, int wheel) {
        boolean isMouseInViewport = this.isMouseInViewport(mouseX, mouseY);
        GuiScrollbar scrollbar = this.getScrollBar();
        if (isMouseInViewport && GuiInterfaceWireless.func_146271_m()) {
            if (wheel < 0) {
                scrollbar.setCurrentScroll(this.masterList.getHeight());
            } else {
                this.getScrollBar().setCurrentScroll(0);
            }
            return true;
        }
        if (isMouseInViewport && GuiInterfaceWireless.func_146272_n()) {
            return this.masterList.scrollNextSection(wheel > 0);
        }
        return super.mouseWheelEvent(mouseX, mouseY, wheel);
    }

    private boolean isMouseInViewport(int mouseX, int mouseY) {
        return mouseX > this.field_147003_i + 10 && mouseX < this.field_147003_i + 10 + 174 && mouseY > this.field_147009_r + 52 && mouseY < this.field_147009_r + 52 + this.viewHeight;
    }

    private boolean handleTab() {
        if (this.searchFieldInputs.isFocused()) {
            this.searchFieldInputs.setFocused(false);
            if (GuiInterfaceWireless.func_146272_n()) {
                this.searchFieldNames.setFocused(true);
            } else {
                this.searchFieldOutputs.setFocused(true);
            }
            return true;
        }
        if (this.searchFieldOutputs.isFocused()) {
            this.searchFieldOutputs.setFocused(false);
            if (GuiInterfaceWireless.func_146272_n()) {
                this.searchFieldInputs.setFocused(true);
            } else {
                this.searchFieldNames.setFocused(true);
            }
            return true;
        }
        if (this.searchFieldNames.isFocused()) {
            this.searchFieldNames.setFocused(false);
            if (GuiInterfaceWireless.func_146272_n()) {
                this.searchFieldOutputs.setFocused(true);
            } else {
                this.searchFieldInputs.setFocused(true);
            }
            return true;
        }
        return false;
    }

    public void postUpdate(List<PacketInterfaceTerminalUpdate.PacketEntry> updates, int statusFlags) {
        if ((statusFlags & 1) == 1) {
            this.masterList.list.clear();
        }
        this.online = (statusFlags & 2) != 2;
        for (PacketInterfaceTerminalUpdate.PacketEntry cmd : updates) {
            this.parsePacketCmd(cmd);
        }
        this.masterList.markDirty();
    }

    private void parsePacketCmd(PacketInterfaceTerminalUpdate.PacketEntry cmd) {
        long id = cmd.entryId;
        if (cmd instanceof PacketInterfaceTerminalUpdate.PacketAdd) {
            PacketInterfaceTerminalUpdate.PacketAdd addCmd = (PacketInterfaceTerminalUpdate.PacketAdd)cmd;
            InterfaceWirelessEntry entry = new InterfaceWirelessEntry(id, addCmd.name, addCmd.rows, addCmd.rowSize, addCmd.online, addCmd.p2pOutput).setLocation(addCmd.x, addCmd.y, addCmd.z, addCmd.dim, addCmd.side).setIcons(addCmd.selfRep, addCmd.dispRep).setItems(addCmd.items);
            this.masterList.addEntry(entry);
        } else if (cmd instanceof PacketInterfaceTerminalUpdate.PacketRemove) {
            this.masterList.removeEntry(id);
        } else if (cmd instanceof PacketInterfaceTerminalUpdate.PacketOverwrite) {
            PacketInterfaceTerminalUpdate.PacketOverwrite owCmd = (PacketInterfaceTerminalUpdate.PacketOverwrite)cmd;
            InterfaceWirelessEntry entry = (InterfaceWirelessEntry)this.masterList.list.get(id);
            if (entry == null) {
                return;
            }
            if (owCmd.onlineValid) {
                entry.online = owCmd.online;
            }
            if (owCmd.itemsValid) {
                if (owCmd.allItemUpdate) {
                    entry.fullItemUpdate(owCmd.items, owCmd.validIndices.length);
                } else {
                    entry.partialItemUpdate(owCmd.items, owCmd.validIndices);
                }
            }
            this.masterList.isDirty = true;
        } else if (cmd instanceof PacketInterfaceTerminalUpdate.PacketRename) {
            PacketInterfaceTerminalUpdate.PacketRename renameCmd = (PacketInterfaceTerminalUpdate.PacketRename)cmd;
            InterfaceWirelessEntry entry = (InterfaceWirelessEntry)this.masterList.list.get(id);
            if (entry != null) {
                entry.dispName = StatCollector.func_94522_b((String)renameCmd.newName) ? StatCollector.func_74838_a((String)renameCmd.newName) : StatCollector.func_150826_b((String)renameCmd.newName);
            }
            this.masterList.isDirty = true;
        }
    }

    private boolean itemStackMatchesSearchTerm(ItemStack itemStack, String searchTerm, boolean in) {
        if (itemStack == null) {
            return false;
        }
        NBTTagCompound encodedValue = itemStack.func_77978_p();
        if (encodedValue == null) {
            return false;
        }
        NBTTagList tags = encodedValue.func_150295_c(in ? "in" : "out", 10);
        boolean containsInvalidDisplayName = GuiText.UnknownItem.getLocal().toLowerCase().contains(searchTerm);
        for (int i = 0; i < tags.func_74745_c(); ++i) {
            String displayName;
            NBTTagCompound tag = tags.func_150305_b(i);
            ItemStack parsedItemStack = ItemStack.func_77949_a((NBTTagCompound)tag);
            if (!(parsedItemStack != null ? (displayName = Platform.getItemDisplayName((Object)AEApi.instance().storage().createItemStack(parsedItemStack)).toLowerCase()).contains(searchTerm) : containsInvalidDisplayName && !tag.func_82582_d())) continue;
            return true;
        }
        return false;
    }

    private boolean recipeIsBroken(ItemStack itemStack) {
        if (itemStack == null) {
            return false;
        }
        NBTTagCompound encodedValue = itemStack.func_77978_p();
        if (encodedValue == null) {
            return true;
        }
        World w = CommonHelper.proxy.getWorld();
        if (w == null) {
            return false;
        }
        try {
            new PatternHelper(itemStack, w);
            return false;
        }
        catch (Throwable t) {
            return true;
        }
    }

    private int getMaxViewHeight() {
        return AEConfig.instance.getConfigManager().getSetting(Settings.TERMINAL_STYLE) == TerminalStyle.SMALL ? AEConfig.instance.InterfaceTerminalSmallSize * 18 : Integer.MAX_VALUE;
    }

    public boolean isOverTextField(int mousex, int mousey) {
        return this.searchFieldInputs.isMouseIn(mousex, mousey) || this.searchFieldOutputs.isMouseIn(mousex, mousey) || this.searchFieldNames.isMouseIn(mousex, mousey);
    }

    public void setTextFieldValue(String displayName, int mousex, int mousey, ItemStack stack) {
        if (this.searchFieldInputs.isMouseIn(mousex, mousey)) {
            this.searchFieldInputs.setText(displayName);
        } else if (this.searchFieldOutputs.isMouseIn(mousex, mousey)) {
            this.searchFieldOutputs.setText(displayName);
        } else if (this.searchFieldNames.isMouseIn(mousex, mousey)) {
            this.searchFieldNames.setText(displayName);
        }
    }

    private class InterfaceWirelessList {
        private final Map<Long, InterfaceWirelessEntry> list = new HashMap<Long, InterfaceWirelessEntry>();
        private final Map<String, InterfaceWirelessSection> sections = new TreeMap<String, InterfaceWirelessSection>();
        private final List<InterfaceWirelessSection> visibleSections = new ArrayList<InterfaceWirelessSection>();
        private boolean isDirty = true;
        private int height;
        private InterfaceWirelessEntry hoveredEntry;

        InterfaceWirelessList() {
        }

        private void update() {
            this.height = 0;
            this.visibleSections.clear();
            for (InterfaceWirelessSection section : this.sections.values()) {
                String query = GuiInterfaceWireless.this.searchFieldNames.getText();
                if (!query.isEmpty() && !section.name.toLowerCase().contains(query.toLowerCase())) continue;
                section.isDirty = true;
                if (!section.getVisible().hasNext()) continue;
                this.height += section.getHeight();
                this.visibleSections.add(section);
            }
            this.isDirty = false;
        }

        public void markDirty() {
            this.isDirty = true;
            GuiInterfaceWireless.this.setScrollBar();
        }

        public int getHeight() {
            if (this.isDirty) {
                this.update();
            }
            return this.height;
        }

        private boolean scrollNextSection(boolean up) {
            GuiScrollbar scrollbar = GuiInterfaceWireless.this.getScrollBar();
            int viewY = scrollbar.getCurrentScroll();
            List<InterfaceWirelessSection> sections = this.getVisibleSections();
            boolean result = false;
            if (up) {
                int y = GuiInterfaceWireless.this.masterList.getHeight();
                int i = sections.size() - 1;
                while (y > 0 && i >= 0) {
                    if ((y -= sections.get(--i).getHeight()) >= viewY) continue;
                    result = true;
                    scrollbar.setCurrentScroll(y);
                    break;
                }
            } else {
                int y = 0;
                for (InterfaceWirelessSection section : sections) {
                    if (y > viewY) {
                        result = true;
                        scrollbar.setCurrentScroll(y);
                        break;
                    }
                    y += section.getHeight();
                }
            }
            return result;
        }

        public void addEntry(InterfaceWirelessEntry entry) {
            InterfaceWirelessSection section = this.sections.get(entry.dispName);
            if (section == null) {
                section = new InterfaceWirelessSection(entry.dispName);
                this.sections.put(entry.dispName, section);
            }
            section.addEntry(entry);
            this.list.put(entry.id, entry);
            this.isDirty = true;
        }

        public void removeEntry(long id) {
            InterfaceWirelessEntry entry = this.list.remove(id);
            if (entry != null) {
                entry.section.removeEntry(entry);
            }
        }

        public List<InterfaceWirelessSection> getVisibleSections() {
            if (this.isDirty) {
                this.update();
            }
            return this.visibleSections;
        }

        public boolean mouseClicked(int relMouseX, int relMouseY, int btn) {
            if (relMouseX < 0 || relMouseX >= 174 || relMouseY < 0 || relMouseY >= GuiInterfaceWireless.this.viewHeight) {
                return false;
            }
            for (InterfaceWirelessSection section : this.getVisibleSections()) {
                if (!section.mouseClicked(relMouseX, relMouseY, btn)) continue;
                return true;
            }
            return false;
        }
    }

    private class InterfaceWirelessSection {
        public static final int TITLE_HEIGHT = 12;
        String name;
        List<InterfaceWirelessEntry> entries = new ArrayList<InterfaceWirelessEntry>();
        Set<InterfaceWirelessEntry> visibleEntries = new TreeSet<InterfaceWirelessEntry>(Comparator.comparing(e -> {
            if (e.dispRep != null) {
                return e.dispRep.func_82833_r() + e.id;
            }
            return String.valueOf(e.id);
        }));
        int height;
        private boolean isDirty = true;
        boolean visible = false;

        InterfaceWirelessSection(String name) {
            this.name = name;
        }

        public int getHeight() {
            if (this.isDirty) {
                this.update();
            }
            return this.height;
        }

        private void update() {
            this.refreshVisible();
            if (this.visibleEntries.isEmpty()) {
                this.height = 0;
            } else {
                this.height = 12;
                for (InterfaceWirelessEntry entry : this.visibleEntries) {
                    this.height += entry.guiHeight;
                }
            }
            this.isDirty = false;
        }

        public void refreshVisible() {
            this.visibleEntries.clear();
            String input = GuiInterfaceWireless.this.searchFieldInputs.getText().toLowerCase();
            String output = GuiInterfaceWireless.this.searchFieldOutputs.getText().toLowerCase();
            for (InterfaceWirelessEntry entry : this.entries) {
                if (!entry.online || entry.p2pOutput) continue;
                Optional moleAss = AEApi.instance().definitions().blocks().molecularAssembler().maybeStack(1);
                entry.dispY = -9999;
                if (GuiInterfaceWireless.this.onlyMolecularAssemblers && (!moleAss.isPresent() || !Platform.isSameItem((ItemStack)((ItemStack)moleAss.get()), (ItemStack)entry.dispRep)) || AEConfig.instance.showOnlyInterfacesWithFreeSlotsInInterfaceTerminal && entry.numItems == entry.rows * entry.rowSize || GuiInterfaceWireless.this.onlyBrokenRecipes && !entry.hasBrokenSlot()) continue;
                if (!input.isEmpty() || !output.isEmpty()) {
                    AppEngInternalInventory inv = entry.inv;
                    boolean shouldAdd = false;
                    for (int i = 0; i < inv.func_70302_i_(); ++i) {
                        ItemStack stack = inv.func_70301_a(i);
                        if (GuiInterfaceWireless.this.itemStackMatchesSearchTerm(stack, input, true) && GuiInterfaceWireless.this.itemStackMatchesSearchTerm(stack, output, false)) {
                            shouldAdd = true;
                            entry.filteredRecipes[i] = false;
                            continue;
                        }
                        entry.filteredRecipes[i] = true;
                    }
                    if (!shouldAdd) {
                        continue;
                    }
                } else {
                    Arrays.fill(entry.filteredRecipes, false);
                }
                this.visibleEntries.add(entry);
            }
        }

        public void addEntry(InterfaceWirelessEntry entry) {
            this.entries.add(entry);
            entry.section = this;
            this.isDirty = true;
        }

        public void removeEntry(InterfaceWirelessEntry entry) {
            this.entries.remove(entry);
            entry.section = null;
            this.isDirty = true;
        }

        public Iterator<InterfaceWirelessEntry> getVisible() {
            if (this.isDirty) {
                this.update();
            }
            return this.visibleEntries.iterator();
        }

        public boolean mouseClicked(int relMouseX, int relMouseY, int btn) {
            Iterator<InterfaceWirelessEntry> it = this.getVisible();
            boolean ret = false;
            while (it.hasNext() && !ret) {
                ret = it.next().mouseClicked(relMouseX, relMouseY, btn);
            }
            return ret;
        }
    }

    private class InterfaceWirelessEntry {
        String dispName;
        AppEngInternalInventory inv;
        GuiFCImgButton optionsButton;
        GuiFCImgButton renameButton;
        ItemStack selfRep;
        ItemStack dispRep;
        InterfaceWirelessSection section;
        long id;
        int x;
        int y;
        int z;
        int dim;
        int side;
        int rows;
        int rowSize;
        int guiHeight;
        int dispY = -9999;
        boolean online;
        boolean p2pOutput;
        private Boolean[] brokenRecipes;
        int numItems = 0;
        boolean[] filteredRecipes;
        private int hoveredSlotIdx = -1;

        InterfaceWirelessEntry(long id, String name, int rows, int rowSize, boolean online, boolean p2pOutput) {
            String fallback;
            this.id = id;
            this.dispName = StatCollector.func_94522_b((String)name) ? StatCollector.func_74838_a((String)name) : (StatCollector.func_94522_b((String)(fallback = name + ".name")) ? StatCollector.func_74838_a((String)fallback) : StatCollector.func_150826_b((String)name));
            this.inv = new AppEngInternalInventory(null, rows * rowSize, 1);
            this.rows = rows;
            this.rowSize = rowSize;
            this.online = online;
            this.p2pOutput = p2pOutput;
            this.optionsButton = new GuiFCImgButton(2, 0, "HIGHLIGHT", "YES");
            this.optionsButton.setHalfSize(true);
            this.renameButton = new GuiFCImgButton(2, 0, "EDIT", "YES");
            this.renameButton.setHalfSize(true);
            this.guiHeight = 18 * rows + 1;
            this.brokenRecipes = new Boolean[rows * rowSize];
            this.filteredRecipes = new boolean[rows * rowSize];
        }

        InterfaceWirelessEntry setLocation(int x, int y, int z, int dim, int side) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.dim = dim;
            this.side = side;
            return this;
        }

        InterfaceWirelessEntry setIcons(ItemStack selfRep, ItemStack dispRep) {
            this.selfRep = selfRep;
            this.dispRep = dispRep;
            return this;
        }

        public void fullItemUpdate(NBTTagList items, int newSize) {
            this.inv = new AppEngInternalInventory(null, newSize);
            this.rows = newSize / this.rowSize;
            this.brokenRecipes = new Boolean[newSize];
            this.numItems = 0;
            for (int i = 0; i < this.inv.func_70302_i_(); ++i) {
                this.setItemInSlot(ItemStack.func_77949_a((NBTTagCompound)items.func_150305_b(i)), i);
            }
            this.guiHeight = 18 * this.rows + 4;
        }

        InterfaceWirelessEntry setItems(NBTTagList items) {
            assert (items.func_74745_c() == this.inv.func_70302_i_());
            for (int i = 0; i < items.func_74745_c(); ++i) {
                this.setItemInSlot(ItemStack.func_77949_a((NBTTagCompound)items.func_150305_b(i)), i);
            }
            return this;
        }

        public void partialItemUpdate(NBTTagList items, int[] validIndices) {
            for (int i = 0; i < validIndices.length; ++i) {
                this.setItemInSlot(ItemStack.func_77949_a((NBTTagCompound)items.func_150305_b(i)), validIndices[i]);
            }
        }

        private void setItemInSlot(ItemStack stack, int idx) {
            int oldHasItem = this.inv.func_70301_a(idx) != null ? 1 : 0;
            int newHasItem = stack != null ? 1 : 0;
            this.inv.func_70299_a(idx, stack);
            this.numItems += newHasItem - oldHasItem;
            assert (this.numItems >= 0);
        }

        public boolean hasBrokenSlot() {
            int idx;
            boolean existsUnknown = false;
            for (idx = 0; idx < this.brokenRecipes.length; ++idx) {
                if (this.brokenRecipes[idx] == null) {
                    existsUnknown = true;
                    continue;
                }
                if (!this.brokenRecipes[idx].booleanValue()) continue;
                return true;
            }
            if (existsUnknown) {
                for (idx = 0; idx < this.brokenRecipes.length; ++idx) {
                    if (!this.slotIsBroken(idx)) continue;
                    return true;
                }
            }
            return false;
        }

        public boolean slotIsBroken(int idx) {
            if (this.brokenRecipes[idx] == null) {
                this.brokenRecipes[idx] = GuiInterfaceWireless.this.recipeIsBroken(this.inv.func_70301_a(idx));
            }
            return this.brokenRecipes[idx];
        }

        public AppEngInternalInventory getInventory() {
            return this.inv;
        }

        public boolean mouseClicked(int mouseX, int mouseY, int btn) {
            if (!this.section.visible || btn < 0 || btn > 2) {
                return false;
            }
            if (mouseX >= this.optionsButton.field_146128_h && mouseX < 2 + this.optionsButton.field_146120_f && mouseY > Math.max(this.optionsButton.field_146129_i, 12) && mouseY <= Math.min(this.optionsButton.field_146129_i + this.optionsButton.field_146121_g, GuiInterfaceWireless.this.viewHeight)) {
                this.optionsButton.func_146113_a(GuiInterfaceWireless.this.field_146297_k.func_147118_V());
                DimensionalCoord blockPos = new DimensionalCoord(this.x, this.y, this.z, this.dim);
                if (GuiScreen.func_146272_n()) {
                    FluidCraft.proxy.netHandler.sendToServer(new CPacketRenamer(blockPos.x, blockPos.y, blockPos.z, blockPos.getDimension(), ForgeDirection.getOrientation((int)this.side)));
                } else {
                    BlockPosHighlighter.highlightBlocks((EntityPlayer)GuiInterfaceWireless.this.field_146297_k.field_71439_g, Collections.singletonList(blockPos), (String)PlayerMessages.InterfaceHighlighted.getName(), (String)PlayerMessages.InterfaceInOtherDim.getName());
                    GuiInterfaceWireless.this.field_146297_k.field_71439_g.func_71053_j();
                }
                return true;
            }
            int offsetY = mouseY - this.dispY;
            int offsetX = mouseX - (174 - this.rowSize * 18) - 1;
            if (offsetX >= 0 && offsetX < this.rowSize * 18 && mouseY > Math.max(this.dispY, 12) && offsetY < Math.min(GuiInterfaceWireless.this.viewHeight - this.dispY, this.guiHeight)) {
                int col = offsetX / 18;
                int row = offsetY / 18;
                int slotIdx = row * this.rowSize + col;
                PacketInventoryAction packet = Keyboard.isKeyDown((int)57) ? new PacketInventoryAction(InventoryAction.MOVE_REGION, 0, this.id) : (GuiScreen.func_146272_n() && (btn == 0 || btn == 1) ? new PacketInventoryAction(InventoryAction.SHIFT_CLICK, slotIdx, this.id) : (btn == 0 || btn == 1 ? new PacketInventoryAction(InventoryAction.PICKUP_OR_SET_DOWN, slotIdx, this.id) : new PacketInventoryAction(InventoryAction.CREATIVE_DUPLICATE, slotIdx, this.id)));
                NetworkHandler.instance.sendToServer((AppEngPacket)packet);
                return true;
            }
            return false;
        }
    }
}

