/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.asm;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;

public class OreDictionaryVisitor
extends ClassVisitor {
    private static final Logger logger = LogManager.getLogger((String)"OreDictionaryVisitor");

    public OreDictionaryVisitor(int api, ClassVisitor cv) {
        super(api, cv);
    }

    public void visitEnd() {
        logger.debug("Adding emptyEntryCreationLock");
        this.cv.visitField(26, "emptyEntryCreationLock", "Ljava/lang/Object;", null, null);
        super.visitEnd();
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if (name.equals("getOreID") && desc.equals("(Ljava/lang/String;)I")) {
            logger.debug("Patching getOreID");
            return new GetOreIDVisitor(this.api, super.visitMethod(access, name, desc, signature, exceptions));
        }
        if (name.equals("<clinit>")) {
            logger.debug("Patching clinit");
            return new ClassInitializerVisitor(this.api, super.visitMethod(access, name, desc, signature, exceptions));
        }
        return super.visitMethod(access, name, desc, signature, exceptions);
    }

    private static class GetOreIDVisitor
    extends MethodVisitor {
        Label jumpEnd;
        Label catchStart = new Label();
        Label exitStart = new Label();

        public GetOreIDVisitor(int api, MethodVisitor mv) {
            super(api, mv);
        }

        public void visitJumpInsn(int opcode, Label label) {
            super.visitJumpInsn(opcode, label);
            logger.trace("Adding getOreID MONITERENTER");
            this.jumpEnd = label;
            this.mv.visitFieldInsn(178, "net/minecraftforge/oredict/OreDictionary", "emptyEntryCreationLock", "Ljava/lang/Object;");
            this.mv.visitInsn(194);
            this.mv.visitLabel(this.catchStart);
            this.mv.visitFieldInsn(178, "net/minecraftforge/oredict/OreDictionary", "nameToId", "Ljava/util/Map;");
            this.mv.visitVarInsn(25, 0);
            this.mv.visitMethodInsn(185, "java/util/Map", "get", "(Ljava/lang/Object;)Ljava/lang/Object;", true);
            this.mv.visitTypeInsn(192, "java/lang/Integer");
            this.mv.visitVarInsn(58, 1);
            this.mv.visitVarInsn(25, 1);
            this.mv.visitJumpInsn(199, this.exitStart);
        }

        public void visitLabel(Label label) {
            if (label.equals(this.jumpEnd)) {
                logger.trace("Adding getOreID MONITEREXIT");
                this.mv.visitLabel(this.exitStart);
                this.mv.visitFieldInsn(178, "net/minecraftforge/oredict/OreDictionary", "emptyEntryCreationLock", "Ljava/lang/Object;");
                this.mv.visitInsn(195);
                this.mv.visitJumpInsn(167, this.jumpEnd);
                Label catchBegin = new Label();
                this.mv.visitLabel(catchBegin);
                this.mv.visitFieldInsn(178, "net/minecraftforge/oredict/OreDictionary", "emptyEntryCreationLock", "Ljava/lang/Object;");
                this.mv.visitInsn(195);
                this.mv.visitInsn(191);
                this.mv.visitTryCatchBlock(this.catchStart, catchBegin, catchBegin, null);
            }
            super.visitLabel(label);
        }

        public void visitEnd() {
            super.visitEnd();
        }
    }

    private static class ClassInitializerVisitor
    extends MethodVisitor {
        public ClassInitializerVisitor(int api, MethodVisitor mv) {
            super(api, mv);
        }

        public void visitCode() {
            super.visitCode();
            logger.trace("Adding emptyEntryCreationLock initializer");
            this.mv.visitTypeInsn(187, "java/lang/Object");
            this.mv.visitInsn(89);
            this.mv.visitMethodInsn(183, "java/lang/Object", "<init>", "()V", false);
            this.mv.visitFieldInsn(179, "net/minecraftforge/oredict/OreDictionary", "emptyEntryCreationLock", "Ljava/lang/Object;");
        }

        public void visitEnd() {
            super.visitEnd();
        }
    }
}

