/*
 * Decompiled with CFR 0.152.
 */
package codechicken.core.asm;

import codechicken.core.asm.CodeChickenCoreModContainer;
import codechicken.lib.asm.ASMBlock;
import codechicken.lib.asm.ASMInit;
import codechicken.lib.asm.ASMReader;
import codechicken.lib.asm.InsnComparator;
import codechicken.lib.asm.ModularASMTransformer;
import codechicken.lib.asm.ObfMapping;
import codechicken.lib.config.ConfigTag;
import java.util.Map;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodNode;

public class TweakTransformer
implements IClassTransformer,
Opcodes {
    private static ModularASMTransformer transformer;
    private static Map<String, ASMBlock> blocks;
    public static ConfigTag tweaks;

    public static void load() {
        CodeChickenCoreModContainer.loadConfig();
        tweaks = CodeChickenCoreModContainer.config.getTag("tweaks").setComment("Various tweaks that can be applied to game mechanics.").useBraces();
        tweaks.removeTag("persistantLava");
        if (tweaks.getTag("environmentallyFriendlyCreepers").setComment("If set to true, creepers will not destroy landscape. (A version of mobGriefing setting just for creepers)").getBooleanValue(false)) {
            transformer.add(new ModularASMTransformer.MethodReplacer(new ObfMapping("net/minecraft/entity/monster/EntityCreeper", "func_146077_cc", "()V"), blocks.get("d_environmentallyFriendlyCreepers"), blocks.get("environmentallyFriendlyCreepers")));
        }
        if (!tweaks.getTag("softLeafReplace").setComment("If set to false, leaves will only replace air when growing").getBooleanValue(false)) {
            transformer.add(new ModularASMTransformer.MethodWriter(1, new ObfMapping("net/minecraft/block/Block", "canBeReplacedByLeaves", "(Lnet/minecraft/world/IBlockAccess;III)Z"), blocks.get("softLeafReplace")));
        }
        if (tweaks.getTag("doFireTickOut").setComment("If set to true and doFireTick is disabled in the game rules, fire will still dissipate if it's not over a fire source").getBooleanValue(true)) {
            transformer.add(new ModularASMTransformer.MethodTransformer(new ObfMapping("net/minecraft/block/BlockFire", "func_149674_a", "(Lnet/minecraft/world/World;IIILjava/util/Random;)V")){

                @Override
                public void transform(MethodNode mv) {
                    ASMBlock needle = (ASMBlock)blocks.get("n_doFireTick");
                    ASMBlock inject = (ASMBlock)blocks.get("doFireTick");
                    ASMBlock key = needle.applyLabels(InsnComparator.findOnce(mv.instructions, needle.list));
                    LabelNode jlabel = key.get("LRET");
                    mv.instructions.insertBefore((AbstractInsnNode)jlabel, (AbstractInsnNode)new JumpInsnNode(167, inject.get("LSKIP")));
                    mv.instructions.insert((AbstractInsnNode)jlabel, inject.list.list);
                }
            });
        }
        if (tweaks.getTag("finiteWater").setComment("If set to true two adjacent water source blocks will not generate a third.").getBooleanValue(false)) {
            transformer.add(new ModularASMTransformer.MethodTransformer(new ObfMapping("net/minecraft/block/BlockDynamicLiquid", "func_149674_a", "(Lnet/minecraft/world/World;IIILjava/util/Random;)V")){

                @Override
                public void transform(MethodNode mv) {
                    ASMBlock needle = (ASMBlock)blocks.get("finiteWater");
                    ASMBlock key = needle.applyLabels(InsnComparator.findOnce(mv.instructions, needle.list));
                    mv.instructions.insertBefore(key.list.getFirst(), (AbstractInsnNode)new JumpInsnNode(167, key.get("LEND")));
                }
            });
        }
    }

    public byte[] transform(String name, String tname, byte[] bytes) {
        return transformer.transform(name, bytes);
    }

    static {
        ASMInit.init();
        transformer = new ModularASMTransformer();
        blocks = ASMReader.loadResource("/assets/codechickencore/asm/tweaks.asm");
    }
}

