/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.modules;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import logisticspipes.interfaces.IBufferItems;
import logisticspipes.interfaces.IModuleInventoryReceive;
import logisticspipes.interfaces.routing.IAdditionalTargetInformation;
import logisticspipes.modules.ModuleCrafter;
import logisticspipes.network.PacketHandler;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.network.packets.module.ModuleInventory;
import logisticspipes.pipes.PipeItemsCraftingLogisticsMk3;
import logisticspipes.proxy.MainProxy;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.routing.order.IOrderInfoProvider;
import logisticspipes.utils.AdjacentTile;
import logisticspipes.utils.CacheHolder;
import logisticspipes.utils.ISimpleInventoryEventHandler;
import logisticspipes.utils.InventoryHelper;
import logisticspipes.utils.SinkReply;
import logisticspipes.utils.item.ItemIdentifier;
import logisticspipes.utils.item.ItemIdentifierInventory;
import logisticspipes.utils.item.ItemIdentifierStack;
import logisticspipes.utils.tuples.Triplet;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;

public class ModuleCrafterMK3
extends ModuleCrafter
implements IBufferItems,
ISimpleInventoryEventHandler,
IModuleInventoryReceive {
    public ItemIdentifierInventory inv = new ItemIdentifierInventory(16, "Buffer", 127);
    public List<ItemIdentifierStack> bufferList = new LinkedList<ItemIdentifierStack>();

    public ModuleCrafterMK3() {
        this.inv.addListener(this);
    }

    public ModuleCrafterMK3(PipeItemsCraftingLogisticsMk3 parent) {
        super(parent);
        this.inv.addListener(this);
    }

    @Override
    public void onAllowedRemoval() {
        this.inv.dropContents(this.getWorld(), this.getX(), this.getY(), this.getZ());
    }

    @Override
    public SinkReply sinksItem(ItemIdentifier item, int bestPriority, int bestCustomPriority, boolean allowDefault, boolean includeInTransit) {
        if (bestPriority > this._sinkReply.fixedPriority.ordinal() || bestPriority == this._sinkReply.fixedPriority.ordinal() && bestCustomPriority >= this._sinkReply.customPriority) {
            return null;
        }
        return new SinkReply(this._sinkReply, this.spaceFor(item, includeInTransit, true), this.isForBuffer(item, includeInTransit) ? SinkReply.BufferMode.BUFFERED : (this.areAllOrderesToBuffer() ? SinkReply.BufferMode.DESTINATION_BUFFERED : SinkReply.BufferMode.NONE));
    }

    protected int spaceFor(ItemIdentifier item, boolean includeInTransit, boolean addBufferSpace) {
        Triplet<String, ItemIdentifier, Boolean> key = new Triplet<String, ItemIdentifier, Boolean>("spaceForMK3", item, addBufferSpace);
        int invSpace = super.spaceFor(item, includeInTransit);
        Object cache = this._service.getCacheHolder().getCacheFor(CacheHolder.CacheTypes.Inventory, key);
        if (cache != null) {
            return invSpace + (Integer)cache;
        }
        int modify = 0;
        if (addBufferSpace) {
            for (int i = 0; i < this.inv.func_70302_i_(); ++i) {
                if (this.inv.getIDStackInSlot(i) == null) {
                    modify += this.inv.func_70297_j_();
                    continue;
                }
                if (!this.inv.getIDStackInSlot(i).getItem().equals(item)) continue;
                modify += this.inv.func_70297_j_() - this.inv.getIDStackInSlot(i).getStackSize();
            }
        } else {
            Map<ItemIdentifier, Integer> items = this.inv.getItemsAndCount();
            if (items.containsKey(item)) {
                modify -= items.get(item).intValue();
            }
        }
        this._service.getCacheHolder().setCache(CacheHolder.CacheTypes.Inventory, key, modify);
        return invSpace + modify;
    }

    private boolean isForBuffer(ItemIdentifier item, boolean includeInTransit) {
        return this.spaceFor(item, includeInTransit, false) <= 0;
    }

    @Override
    protected int neededEnergy() {
        return 20;
    }

    @Override
    protected int itemsToExtract() {
        return 128;
    }

    @Override
    protected int stacksToExtract() {
        return 8;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon getIconTexture(IIconRegister register) {
        return register.func_94245_a("logisticspipes:itemModule/ModuleCrafterMK3");
    }

    @Override
    public void tick() {
        super.tick();
        if (this.inv.isEmpty()) {
            return;
        }
        if (!this._service.isNthTick(6)) {
            return;
        }
        List<AdjacentTile> crafters = this.locateCrafters();
        boolean change = false;
        for (AdjacentTile tile : crafters) {
            for (int i = this.inv.func_70302_i_() - 1; i >= 0; --i) {
                ItemIdentifierStack slot = this.inv.getIDStackInSlot(i);
                if (slot == null) continue;
                ForgeDirection insertion = tile.orientation.getOpposite();
                if (this.getUpgradeManager().hasSneakyUpgrade()) {
                    insertion = this.getUpgradeManager().getSneakyOrientation();
                }
                ItemIdentifierStack toadd = slot.clone();
                toadd.setStackSize(Math.min(toadd.getStackSize(), toadd.getItem().getMaxStackSize()));
                if (this._service.getItemOrderManager().hasOrders(IOrderInfoProvider.ResourceType.CRAFTING)) {
                    toadd.setStackSize(Math.min(toadd.getStackSize(), ((IInventory)tile.tile).func_70297_j_()));
                    ItemStack added = InventoryHelper.getTransactorFor(tile.tile, tile.orientation.getOpposite()).add(toadd.makeNormalStack(), insertion, true);
                    slot.setStackSize(slot.getStackSize() - added.field_77994_a);
                    if (added.field_77994_a != 0) {
                        change = true;
                    }
                } else {
                    this._service.queueRoutedItem(SimpleServiceLocator.routedItemHelper.createNewTravelItem(toadd), tile.orientation.getOpposite());
                    slot.setStackSize(slot.getStackSize() - toadd.getStackSize());
                    change = true;
                }
                if (slot.getStackSize() <= 0) {
                    this.inv.clearInventorySlotContents(i);
                    continue;
                }
                this.inv.setInventorySlotContents(i, slot);
            }
        }
        if (change) {
            this.inv.func_70296_d();
            this._service.getCacheHolder().trigger(CacheHolder.CacheTypes.Inventory);
        }
    }

    @Override
    public void InventoryChanged(IInventory inventory) {
        if (MainProxy.isServer(this._world.getWorld())) {
            MainProxy.sendToPlayerList((ModernPacket)PacketHandler.getPacket(ModuleInventory.class).setIdentList(ItemIdentifierStack.getListFromInventory(this.inv, true)).setModulePos(this), this.localModeWatchers);
        }
    }

    @Override
    public void handleInvContent(Collection<ItemIdentifierStack> list) {
        this.bufferList.clear();
        this.bufferList.addAll(list);
    }

    @Override
    public void startWatching(EntityPlayer player) {
        MainProxy.sendPacketToPlayer(PacketHandler.getPacket(ModuleInventory.class).setIdentList(ItemIdentifierStack.getListFromInventory(this.inv, true)).setModulePos(this), player);
        super.startWatching(player);
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        this.inv.writeToNBT(nbttagcompound, "buffer");
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.inv.readFromNBT(nbttagcompound, "buffer");
    }

    @Override
    public int addToBuffer(ItemIdentifierStack stack, IAdditionalTargetInformation info) {
        return this.inv.addCompressed(stack.makeNormalStack(), true);
    }
}

