/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.eventbus;

import com.gtnewhorizon.gtnhlib.eventbus.EventBusUtil;
import com.gtnewhorizon.gtnhlib.eventbus.MethodInfo;
import com.gtnewhorizon.gtnhlib.eventbus.Phase;
import com.gtnewhorizon.gtnhlib.eventbus.StaticASMEventHandler;
import com.gtnewhorizon.gtnhlib.mixins.early.fml.EventBusAccessor;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.EventBus;
import cpw.mods.fml.common.eventhandler.IEventListener;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.lang.invoke.CallSite;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BooleanSupplier;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.OreGenEvent;
import org.apache.commons.lang3.reflect.ConstructorUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class AutoEventBus {
    private static final Logger LOGGER = LogManager.getLogger((String)"GTNHLib EventBus");
    private static final DummyEvent INVALID_EVENT = new DummyEvent();
    private static final Object2ObjectMap<String, Event> eventCache = new Object2ObjectOpenHashMap<String, Event>();
    private static final Object2BooleanMap<String> optionalMods = new Object2BooleanOpenHashMap<String>();
    private static final MethodHandles.Lookup LOOKUP = MethodHandles.lookup();
    private static final MethodType CONDITION_TYPE = MethodType.methodType(Boolean.TYPE);

    /*
     * WARNING - void declaration
     */
    public static void executePhase(Phase phase) {
        if (phase.hasExecuted) {
            return;
        }
        phase.hasExecuted = true;
        Object2ObjectMap<ModContainer, ObjectSet<String>> subscribers = phase.getModClassesForPhase();
        if (subscribers.isEmpty()) {
            return;
        }
        for (Object2ObjectMap.Entry entry : subscribers.object2ObjectEntrySet()) {
            for (String className : (ObjectSet)entry.getValue()) {
                try {
                    Class<?> clazz = Class.forName(className, false, Loader.instance().getModClassLoader());
                    String conditionToCheck = (String)EventBusUtil.getConditionsToCheck().get(className);
                    if (conditionToCheck != null && !AutoEventBus.isConditionMet(clazz, conditionToCheck)) {
                        if (!EventBusUtil.DEBUG_EVENT_BUS.booleanValue()) continue;
                        LOGGER.info("Skipping registration for {}, condition not met", new Object[]{clazz.getSimpleName()});
                        continue;
                    }
                    ObjectSet methods = (ObjectSet)EventBusUtil.getMethodsToSubscribe().get(className);
                    if (methods == null || methods.isEmpty()) continue;
                    AutoEventBus.register((ModContainer)entry.getKey(), clazz, methods);
                }
                catch (ClassNotFoundException e) {
                    if (!EventBusUtil.DEBUG_EVENT_BUS.booleanValue()) continue;
                    LOGGER.error("Failed to load class {}", new Object[]{className, e});
                }
            }
        }
        if (phase == Phase.INIT) {
            ObjectList<String> invalidMethods = EventBusUtil.getInvalidMethods();
            if (invalidMethods.size() == 1) {
                throw new IllegalArgumentException((String)invalidMethods.get(0));
            }
            if (invalidMethods.size() > 1) {
                void var3_5;
                boolean bl = false;
                while (var3_5 < invalidMethods.size() - 1) {
                    LOGGER.error((String)invalidMethods.get((int)var3_5));
                    ++var3_5;
                }
                throw new IllegalArgumentException("Encountered" + (int)var3_5 + "invalid methods. " + (String)invalidMethods.get((int)var3_5));
            }
        }
    }

    private static void register(ModContainer classOwner, Class<?> target, ObjectSet<MethodInfo> methods) {
        for (MethodInfo method : methods) {
            try {
                Event event;
                if (method.getOptionalMod() != null && !optionalMods.computeIfAbsent(method.getOptionalMod(), Loader::isModLoaded) || ((Object)((Object)INVALID_EVENT)).equals(event = AutoEventBus.getCachedEvent(EventBusUtil.getParameterClassName(method.desc)))) continue;
                StaticASMEventHandler listener = new StaticASMEventHandler(method);
                for (EventBusType bus : EventBusType.VALUES) {
                    if (!bus.canRegister(event.getClass())) continue;
                    event.getListenerList().register(bus.busID, listener.getPriority(), (IEventListener)listener);
                    bus.listenerOwners.putIfAbsent(target, classOwner);
                    bus.listeners.computeIfAbsent(target, k -> new ArrayList()).add(listener);
                    if (!EventBusUtil.DEBUG_EVENT_BUS.booleanValue()) continue;
                    LOGGER.info("Registered event handler for {} on {}", new Object[]{event.getClass().getSimpleName(), bus});
                }
            }
            catch (Exception e) {
                if (!EventBusUtil.DEBUG_EVENT_BUS.booleanValue()) continue;
                LOGGER.error("Failed to register event handler for {}", new Object[]{method.desc, e});
            }
        }
    }

    @Nonnull
    private static Event getCachedEvent(String eventClass) {
        return eventCache.computeIfAbsent(eventClass, e -> {
            try {
                Class<?> clazz = Class.forName(eventClass, false, Loader.instance().getModClassLoader());
                return (Event)ConstructorUtils.invokeConstructor(clazz, (Object[])new Object[0]);
            }
            catch (Exception | ExceptionInInitializerError | NoClassDefFoundError ex) {
                if (EventBusUtil.DEBUG_EVENT_BUS.booleanValue()) {
                    LOGGER.error("Failed to create event instance for {}", new Object[]{eventClass, ex});
                }
                return INVALID_EVENT;
            }
        });
    }

    private static boolean isConditionMet(@NotNull Class<?> clazz, @Nullable String condition) {
        if (condition == null) {
            return true;
        }
        try {
            MethodHandle handle = MethodHandles.publicLookup().findStatic(clazz, condition.substring(0, condition.indexOf("(")), CONDITION_TYPE);
            CallSite call = LambdaMetafactory.metafactory(LOOKUP, "getAsBoolean", MethodType.methodType(BooleanSupplier.class), CONDITION_TYPE, handle, CONDITION_TYPE);
            return ((BooleanSupplier)call.getTarget().invokeWithArguments(new Object[0])).getAsBoolean();
        }
        catch (Throwable e) {
            LOGGER.error("Failed to invoke condition {} for class {}", new Object[]{condition, clazz, e});
            return false;
        }
    }

    private static boolean isFMLEvent(Class<?> event) {
        return event.getName().startsWith("cpw.mods.fml");
    }

    private static boolean isTerrainEvent(Class<?> event) {
        return event.getName().startsWith("net.minecraftforge.event.terraingen") && !AutoEventBus.isOreGenEvent(event);
    }

    private static boolean isOreGenEvent(Class<?> event) {
        return OreGenEvent.class.isAssignableFrom(event);
    }

    private static boolean isForgeEvent(Class<?> event) {
        return !AutoEventBus.isFMLEvent(event) && !AutoEventBus.isTerrainEvent(event) && !AutoEventBus.isOreGenEvent(event);
    }

    private AutoEventBus() {
    }

    private static class DummyEvent
    extends Event {
        private DummyEvent() {
        }
    }

    private static enum EventBusType {
        FORGE(MinecraftForge.EVENT_BUS, x$0 -> AutoEventBus.access$400(x$0)),
        OREGEN(MinecraftForge.ORE_GEN_BUS, x$0 -> AutoEventBus.access$300(x$0)),
        TERRAIN_GEN(MinecraftForge.TERRAIN_GEN_BUS, x$0 -> AutoEventBus.access$200(x$0)),
        FML(FMLCommonHandler.instance().bus(), x$0 -> AutoEventBus.access$100(x$0));

        private static final EventBusType[] VALUES;
        private final ConcurrentHashMap<Object, ArrayList<IEventListener>> listeners;
        private final Map<Object, ModContainer> listenerOwners;
        private final Predicate<Class<?>> canRegister;
        private final int busID;

        private EventBusType(EventBus instance, Predicate<Class<?>> canRegister) {
            this.canRegister = canRegister;
            EventBusAccessor accessor = (EventBusAccessor)instance;
            this.listeners = accessor.getListeners();
            this.listenerOwners = accessor.getListenerOwners();
            this.busID = accessor.getBusID();
        }

        private boolean canRegister(Class<?> clazz) {
            return this.canRegister.test(clazz);
        }

        static {
            VALUES = EventBusType.values();
        }
    }
}

