/*
 * Decompiled with CFR 0.152.
 */
package tb.common.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.BlockGrass;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.init.Blocks;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import tb.init.TBBlocks;

public class BlockAureliaPlant
extends Block {
    public static IIcon[] icons = new IIcon[2];

    public BlockAureliaPlant() {
        super(Material.field_151585_k);
        this.func_149675_a(true);
        this.func_149676_a(0.25f, 0.0f, 0.25f, 0.75f, 0.85f, 0.75f);
        this.func_149715_a(0.5f);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister reg) {
        BlockAureliaPlant.icons[0] = reg.func_94245_a(this.field_149768_d + "closed");
        BlockAureliaPlant.icons[1] = reg.func_94245_a(this.field_149768_d + "open");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        return icons[meta];
    }

    protected boolean canPlaceBlockOn(Block b) {
        return b != null && (b == Blocks.field_150349_c || b == Blocks.field_150346_d || b instanceof BlockGrass || b instanceof BlockDirt);
    }

    public void func_149674_a(World w, int x, int y, int z, Random rnd) {
        this.checkForMoonlight(w, x, y, z);
        if (w.func_72805_g(x, y, z) == 1) {
            int rndX = x + rnd.nextInt(5) - rnd.nextInt(5);
            int rndZ = z + rnd.nextInt(5) - rnd.nextInt(5);
            ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[2 + w.field_73012_v.nextInt(4)];
            int newY = this.findSutableY(w, rndX, y, rndZ);
            if (this.canPlaceBlockOn(w.func_147439_a(rndX, newY - 1, rndZ)) && w.func_147437_c(rndX, newY, rndZ)) {
                w.func_147465_d(rndX, newY, rndZ, TBBlocks.aureliaPetal, 0, 3);
            }
        }
    }

    public int findSutableGround(World w, int x, int y, int z) {
        while (w.func_147437_c(x, y, z) && y > 0 && !w.isSideSolid(x, y, z, ForgeDirection.UP)) {
            --y;
        }
        return y;
    }

    public int findSutableY(World w, int x, int y, int z) {
        int bY = y++;
        while (!this.canPlaceBlockOn(w.func_147439_a(x, y, z)) && y > bY - 2) {
            --y;
        }
        return y + 1;
    }

    public int func_149738_a(World w) {
        return 10;
    }

    public void func_149695_a(World w, int x, int y, int z, Block updated) {
        if (!BlockAureliaPlant.canGrowOn(w, x, y - 1, z)) {
            w.func_147468_f(x, y, z);
        } else {
            this.checkForMoonlight(w, x, y, z);
        }
    }

    public int func_149692_a(int meta) {
        return 0;
    }

    public AxisAlignedBB func_149668_a(World p_149668_1_, int p_149668_2_, int p_149668_3_, int p_149668_4_) {
        return null;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149645_b() {
        return 1;
    }

    public void checkForMoonlight(World w, int x, int y, int z) {
        boolean isOpen;
        boolean underSky = w.func_72937_j(x, y + 1, z);
        boolean night = !w.func_72935_r();
        boolean isFullMoon = w.field_73011_w.func_76559_b(w.func_72820_D()) == 0;
        boolean bl = isOpen = w.func_72805_g(x, y, z) == 1;
        if (underSky && night && isFullMoon) {
            if (!isOpen) {
                w.func_72921_c(x, y, z, 1, 3);
                w.func_147458_c(x - 1, y - 1, z - 1, x + 1, y + 1, z + 1);
            }
        } else if (isOpen) {
            w.func_72921_c(x, y, z, 0, 3);
            w.func_147458_c(x - 1, y - 1, z - 1, x + 1, y + 1, z + 1);
        }
    }

    public static boolean canGrowOn(World w, int x, int y, int z) {
        return !w.func_147437_c(x, y, z) && (w.func_147439_a(x, y, z).isReplaceableOreGen(w, x, y, z, (Block)Blocks.field_150349_c) || w.func_147439_a(x, y, z).isReplaceableOreGen(w, x, y, z, Blocks.field_150346_d));
    }
}

