/*
 * Decompiled with CFR 0.152.
 */
package codechicken.wirelessredstone.core;

import codechicken.core.CommonUtils;
import codechicken.lib.config.ConfigTag;
import codechicken.lib.vec.BlockCoord;
import codechicken.lib.vec.Vector3;
import codechicken.wirelessredstone.core.ITileJammer;
import codechicken.wirelessredstone.core.ITileWireless;
import codechicken.wirelessredstone.core.RedstoneEther;
import codechicken.wirelessredstone.core.RedstoneEtherServer;
import codechicken.wirelessredstone.core.WRCoreSPH;
import codechicken.wirelessredstone.core.WirelessRedstoneCore;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class WirelessBolt {
    ArrayList<Segment> segments = new ArrayList();
    Vector3 start;
    Vector3 end;
    BlockCoord target;
    HashMap<Integer, Integer> splitparents = new HashMap();
    public double length;
    public int numsegments0;
    private int numsplits;
    private boolean finalized;
    private boolean canhittarget = true;
    private Random rand;
    public long seed;
    public int particleAge;
    public int particleMaxAge;
    public boolean isDead;
    private AxisAlignedBB boundingBox;
    public World world;
    private Entity wrapper;
    private RedstoneEther ether;
    public static ArrayList<WirelessBolt> serverboltlist = new ArrayList();
    public static ArrayList<WirelessBolt> clientboltlist = new ArrayList();
    public static final float speed = 3.0f;
    public static final int fadetime = 20;
    public static int playerdamage;
    public static int entitydamage;

    public WirelessBolt(World world, Vector3 jammervec, Vector3 targetvec, long seed) {
        this.world = world;
        this.seed = seed;
        this.rand = new Random(seed);
        this.ether = RedstoneEther.get(world.field_72995_K);
        this.start = jammervec;
        this.end = targetvec;
        this.numsegments0 = 1;
        this.length = this.end.copy().subtract(this.start).mag();
        this.particleMaxAge = 20 + this.rand.nextInt(20) - 10;
        this.particleAge = -((int)(this.length * 3.0));
        this.boundingBox = AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0);
        this.boundingBox.func_72328_c(AxisAlignedBB.func_72330_a((double)Math.min(this.start.x, this.end.x), (double)Math.min(this.start.y, this.end.y), (double)Math.min(this.start.z, this.end.z), (double)Math.max(this.start.x, this.end.x), (double)Math.max(this.start.y, this.end.y), (double)Math.max(this.start.z, this.end.z)).func_72314_b(this.length / 2.0, this.length / 2.0, this.length / 2.0));
        this.segments.add(new Segment(this.start, this.end));
    }

    public static Vector3 getFocalPoint(ITileWireless tile) {
        return Vector3.fromTileEntityCenter((TileEntity)((TileEntity)tile)).add(tile.getFocalPoint());
    }

    public static Vector3 getFocalPoint(ITileJammer tile) {
        return Vector3.fromTileEntityCenter((TileEntity)((TileEntity)tile)).add(tile.getFocalPoint());
    }

    public WirelessBolt(World world, Vector3 jammer, ITileWireless target, long seed) {
        this(world, jammer, WirelessBolt.getFocalPoint(target), seed);
        this.target = new BlockCoord((TileEntity)target);
    }

    public void setWrapper(Entity entity) {
        this.wrapper = entity;
    }

    public void fractal(int splits, double amount, double splitchance, double splitlength, double splitangle) {
        if (this.finalized) {
            return;
        }
        ArrayList<Segment> oldsegments = this.segments;
        this.segments = new ArrayList();
        Segment prev = null;
        for (Segment segment : oldsegments) {
            int i;
            prev = segment.prev;
            Vector3 subsegment = segment.diff.copy().multiply((double)(1.0f / (float)splits));
            BoltPoint[] newpoints = new BoltPoint[splits + 1];
            Vector3 startpoint = segment.startpoint.point;
            newpoints[0] = segment.startpoint;
            newpoints[splits] = segment.endpoint;
            for (i = 1; i < splits; ++i) {
                Vector3 randoff = segment.diff.copy().perpendicular().normalize().rotate((double)(this.rand.nextFloat() * 360.0f), segment.diff);
                randoff.multiply((double)(this.rand.nextFloat() - 0.5f) * amount * 2.0);
                Vector3 basepoint = startpoint.copy().add(subsegment.copy().multiply((double)i));
                newpoints[i] = new BoltPoint(basepoint, randoff);
            }
            for (i = 0; i < splits; ++i) {
                Segment next = new Segment(newpoints[i], newpoints[i + 1], segment.light, segment.segmentno * splits + i, segment.splitno);
                next.prev = prev;
                if (prev != null) {
                    prev.next = next;
                }
                if (i != 0 && (double)this.rand.nextFloat() < splitchance) {
                    Vector3 splitrot = next.diff.copy().xCrossProduct().rotate((double)(this.rand.nextFloat() * 360.0f), next.diff);
                    Vector3 diff = next.diff.copy().rotate((double)(this.rand.nextFloat() * 0.66f + 0.33f) * splitangle, splitrot).multiply(splitlength);
                    ++this.numsplits;
                    this.splitparents.put(this.numsplits, next.splitno);
                    Segment split = new Segment(newpoints[i], new BoltPoint(newpoints[i + 1].basepoint, newpoints[i + 1].offsetvec.copy().add(diff)), segment.light / 2.0f, next.segmentno, this.numsplits);
                    split.prev = prev;
                    this.segments.add(split);
                }
                prev = next;
                this.segments.add(next);
            }
            if (segment.next == null) continue;
            segment.next.prev = prev;
        }
        this.numsegments0 *= splits;
    }

    public void defaultFractal() {
        this.fractal(2, this.length / 1.5, 0.7f, 0.7f, 45.0);
        this.fractal(2, this.length / 4.0, 0.5, 0.8f, 50.0);
        this.fractal(2, this.length / 15.0, 0.5, 0.9f, 55.0);
        this.fractal(2, this.length / 30.0, 0.5, 1.0, 60.0);
        this.fractal(2, this.length / 60.0, 0.0, 0.0, 0.0);
        this.fractal(2, this.length / 100.0, 0.0, 0.0, 0.0);
        this.fractal(2, this.length / 400.0, 0.0, 0.0, 0.0);
    }

    private float rayTraceResistance(Vector3 start, Vector3 end, float prevresistance) {
        MovingObjectPosition mop = this.world.func_72933_a(start.toVec3D(), end.toVec3D());
        if (mop == null) {
            return prevresistance;
        }
        if (mop.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
            Block block = this.world.func_147439_a(mop.field_72311_b, mop.field_72312_c, mop.field_72309_d);
            if (block.isAir((IBlockAccess)this.world, mop.field_72311_b, mop.field_72312_c, mop.field_72309_d)) {
                return prevresistance;
            }
            return prevresistance + block.func_149638_a(this.wrapper) + 0.3f;
        }
        return prevresistance;
    }

    private void vecBBDamageSegment(Vector3 start, Vector3 end, ArrayList<Entity> entitylist) {
        Vec3 start3D = start.toVec3D();
        Vec3 end3D = end.toVec3D();
        for (Entity entity : entitylist) {
            if (!(entity instanceof EntityLivingBase) || !entity.field_70121_D.func_72318_a(start3D) && !entity.field_70121_D.func_72318_a(end3D)) continue;
            if (entity instanceof EntityPlayer) {
                entity.func_70097_a(WirelessRedstoneCore.damagebolt, (float)playerdamage);
            } else {
                entity.func_70097_a(WirelessRedstoneCore.damagebolt, (float)entitydamage);
            }
            this.ether.jamEntity((EntityLivingBase)entity, true);
        }
    }

    private void bbTestEntityDamage() {
        if (this.world.field_72995_K) {
            return;
        }
        int newestsegment = (int)((float)(this.particleAge + (int)(this.length * 3.0)) / (float)((int)(this.length * 3.0)) * (float)this.numsegments0);
        List nearentities = this.world.func_72839_b(this.wrapper, this.boundingBox);
        if (nearentities.size() == 0) {
            return;
        }
        for (Segment segment : this.segments) {
            if (segment.segmentno > newestsegment) continue;
            this.vecBBDamageSegment(segment.startpoint.point, segment.endpoint.point, (ArrayList)nearentities);
        }
    }

    private void calculateCollisionAndDiffs() {
        HashMap<Integer, Integer> lastactivesegment = new HashMap<Integer, Integer>();
        Collections.sort(this.segments, new SegmentSorter());
        int lastsplitcalc = 0;
        int lastactiveseg = 0;
        float splitresistance = 0.0f;
        for (Segment segment : this.segments) {
            if (segment.splitno > lastsplitcalc) {
                lastactivesegment.put(lastsplitcalc, lastactiveseg);
                lastsplitcalc = segment.splitno;
                lastactiveseg = (Integer)lastactivesegment.get(this.splitparents.get(segment.splitno));
                float f = splitresistance = lastactiveseg < segment.segmentno ? 50.0f : 0.0f;
            }
            if (splitresistance >= 40.0f * segment.light) continue;
            splitresistance = this.rayTraceResistance(segment.startpoint.point, segment.endpoint.point, splitresistance);
            lastactiveseg = segment.segmentno;
        }
        lastactivesegment.put(lastsplitcalc, lastactiveseg);
        lastsplitcalc = 0;
        lastactiveseg = (Integer)lastactivesegment.get(0);
        Iterator<Segment> iterator = this.segments.iterator();
        while (iterator.hasNext()) {
            Segment segment;
            segment = iterator.next();
            if (lastsplitcalc != segment.splitno) {
                lastsplitcalc = segment.splitno;
                lastactiveseg = (Integer)lastactivesegment.get(segment.splitno);
            }
            if (segment.segmentno > lastactiveseg) {
                iterator.remove();
            }
            segment.calcEndDiffs();
        }
        if ((Integer)lastactivesegment.get(0) + 1 < this.numsegments0) {
            this.canhittarget = false;
        }
    }

    public void finalizeBolt() {
        if (this.finalized) {
            return;
        }
        this.finalized = true;
        this.calculateCollisionAndDiffs();
        Collections.sort(this.segments, new SegmentLightSorter());
        if (this.world.field_72995_K) {
            clientboltlist.add(this);
        } else {
            serverboltlist.add(this);
            WRCoreSPH.sendWirelessBolt(this);
        }
    }

    private void jamTile() {
        if (this.world.field_72995_K || this.target == null) {
            return;
        }
        RedstoneEtherServer ether = (RedstoneEtherServer)this.ether;
        if (this.canhittarget) {
            TileEntity tile = RedstoneEther.getTile(this.world, this.target);
            if (tile == null || !(tile instanceof ITileWireless)) {
                ether.unjamTile(this.world, this.target.x, this.target.y, this.target.z);
                return;
            }
            ITileWireless wirelesstile = (ITileWireless)tile;
            int freq = wirelesstile.getFreq();
            if (freq == 0) {
                ether.unjamTile(this.world, this.target.x, this.target.y, this.target.z);
                return;
            }
            ether.jamNode(this.world, this.target, CommonUtils.getDimension((World)this.world), freq);
            wirelesstile.jamTile();
        } else {
            ether.unjamTile(this.world, this.target.x, this.target.y, this.target.z);
        }
    }

    public void onUpdate() {
        ++this.particleAge;
        this.bbTestEntityDamage();
        if (this.particleAge == 0) {
            this.jamTile();
        }
        if (this.particleAge >= this.particleMaxAge) {
            this.isDead = true;
        }
    }

    public static void init(ConfigTag rpconfig) {
        ConfigTag boltconfig = rpconfig.getTag("boltEffect").useBraces();
        ConfigTag damageconfig = boltconfig.getTag("damage").setComment("Damages are in half hearts:If an entity gets knocked into another bolt it may suffer multiple hits");
        entitydamage = damageconfig.getTag("entity").setComment("").getIntValue(5);
        playerdamage = damageconfig.getTag("player").setComment("").getIntValue(3);
    }

    public static void update(List<WirelessBolt> boltlist) {
        Iterator<WirelessBolt> iterator = boltlist.iterator();
        while (iterator.hasNext()) {
            WirelessBolt bolt = iterator.next();
            bolt.onUpdate();
            if (!bolt.isDead) continue;
            iterator.remove();
        }
    }

    public class Segment {
        public BoltPoint startpoint;
        public BoltPoint endpoint;
        public Vector3 diff;
        public Segment prev;
        public Segment next;
        public Vector3 nextdiff;
        public Vector3 prevdiff;
        public float sinprev;
        public float sinnext;
        public float light;
        public int segmentno;
        public int splitno;

        public Segment(BoltPoint start, BoltPoint end, float light, int segmentnumber, int splitnumber) {
            this.startpoint = start;
            this.endpoint = end;
            this.light = light;
            this.segmentno = segmentnumber;
            this.splitno = splitnumber;
            this.calcDiff();
        }

        public Segment(Vector3 start, Vector3 end) {
            this(this$0.new BoltPoint(start, new Vector3(0.0, 0.0, 0.0)), this$0.new BoltPoint(end, new Vector3(0.0, 0.0, 0.0)), 1.0f, 0, 0);
        }

        public void calcDiff() {
            this.diff = this.endpoint.point.copy().subtract(this.startpoint.point);
        }

        public void calcEndDiffs() {
            Vector3 thisdiffnorm;
            if (this.prev != null) {
                Vector3 prevdiffnorm = this.prev.diff.copy().normalize();
                thisdiffnorm = this.diff.copy().normalize();
                this.prevdiff = thisdiffnorm.copy().add(prevdiffnorm).normalize();
                this.sinprev = (float)Math.sin(thisdiffnorm.angle(prevdiffnorm.negate()) / 2.0);
            } else {
                this.prevdiff = this.diff.copy().normalize();
                this.sinprev = 1.0f;
            }
            if (this.next != null) {
                Vector3 nextdiffnorm = this.next.diff.copy().normalize();
                thisdiffnorm = this.diff.copy().normalize();
                this.nextdiff = thisdiffnorm.add(nextdiffnorm).normalize();
                this.sinnext = (float)Math.sin(thisdiffnorm.angle(nextdiffnorm.negate()) / 2.0);
            } else {
                this.nextdiff = this.diff.copy().normalize();
                this.sinnext = 1.0f;
            }
        }

        public String toString() {
            return this.startpoint.point.toString() + " " + this.endpoint.point.toString();
        }
    }

    public class SegmentLightSorter
    implements Comparator<Segment> {
        @Override
        public int compare(Segment o1, Segment o2) {
            return o1.light != o2.light ? (o1.light < o2.light ? -1 : 1) : 0;
        }
    }

    public class SegmentSorter
    implements Comparator<Segment> {
        @Override
        public int compare(Segment o1, Segment o2) {
            if (o1.splitno != o2.splitno) {
                return o1.splitno < o2.splitno ? -1 : 1;
            }
            if (o1.segmentno != o2.segmentno) {
                return o1.segmentno < o2.segmentno ? -1 : 1;
            }
            return 0;
        }
    }

    public class BoltPoint {
        Vector3 point;
        Vector3 basepoint;
        Vector3 offsetvec;

        public BoltPoint(Vector3 basepoint, Vector3 offsetvec) {
            this.point = basepoint.copy().add(offsetvec);
            this.basepoint = basepoint;
            this.offsetvec = offsetvec;
        }
    }
}

