/*
 * Decompiled with CFR 0.152.
 */
package shukaro.warptheory.handlers.warpevents;

import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import shukaro.warptheory.handlers.IMultiWarpEvent;
import shukaro.warptheory.util.BlockCoord;
import shukaro.warptheory.util.RandomBlockHelper;
import thaumcraft.common.entities.monster.EntityFireBat;

public class WarpFireBats
extends IMultiWarpEvent {
    public WarpFireBats(int minWarp) {
        super("firebats", minWarp, 2, world -> 5 + world.field_73012_v.nextInt(10));
    }

    @Override
    public int triggerEvent(int eventLevel, int eventAmount, World world, EntityPlayer player) {
        int successful = 0;
        for (int i = 0; i < 6; ++i) {
            BlockCoord target = RandomBlockHelper.randomAirBlock(world, player, 16);
            if (target == null) continue;
            EntityFireBat bat = new EntityFireBat(world);
            bat.func_70642_aH();
            RandomBlockHelper.setLocation(world, (Entity)bat, target);
            if (eventLevel > 0) {
                switch (world.field_73012_v.nextInt(3)) {
                    case 2: {
                        bat.setIsDevil(true);
                        break;
                    }
                    case 1: {
                        bat.setIsExplosive(true);
                        break;
                    }
                }
            }
            if (world.func_72838_d((Entity)bat) && ++successful >= eventAmount) break;
        }
        return successful;
    }
}

