/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.client.renderer.common;

import com.jaquadro.minecraft.storagedrawers.block.BlockFramingTable;
import com.jaquadro.minecraft.storagedrawers.util.RenderHelper;
import net.minecraft.block.Block;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;

public class CommonFramingRenderer {
    private static double unit = 0.0625;
    private static double unit2 = unit * 2.0;
    private static double unit4 = unit * 4.0;
    private static double unit14 = unit * 14.0;
    private static double[][] baseBoundsLeftY = new double[][]{{unit, 1.0 - unit2, unit, 1.0, 1.0, 1.0 - unit}};
    private static double[][] trimBoundsLeftY = new double[][]{{0.0, 1.0 - unit2, unit, unit, 1.0, 1.0 - unit}, {0.0, 1.0 - unit2, 0.0, unit, 1.0, unit}, {0.0, 1.0 - unit2, 1.0 - unit, unit, 1.0, 1.0}, {unit, 1.0 - unit2, 0.0, 1.0, 1.0, unit}, {unit, 1.0 - unit2, 1.0 - unit, 1.0, 1.0, 1.0}};
    private static double[][] trimBoundsLeftZ = new double[][]{{0.0, 1.0 - unit2, 0.0, unit, 1.0, 1.0}, {unit, 1.0 - unit2, 0.0, 1.0, 1.0, 1.0}};
    private static double[][] trimBoundsLeftX = new double[][]{{0.0, 1.0 - unit2, 0.0, 1.0, 1.0, unit}, {0.0, 1.0 - unit2, unit, 1.0, 1.0, 1.0 - unit}, {0.0, 1.0 - unit2, 1.0 - unit, 1.0, 1.0, 1.0}};
    private static double[][] baseBoundsRightY = new double[][]{{0.0, 1.0 - unit2, unit, 1.0 - unit, 1.0, 1.0 - unit}};
    private static double[][] trimBoundsRightY = new double[][]{{1.0 - unit, 1.0 - unit2, unit, 1.0, 1.0, 1.0 - unit}, {1.0 - unit, 1.0 - unit2, 0.0, 1.0, 1.0, unit}, {1.0 - unit, 1.0 - unit2, 1.0 - unit, 1.0, 1.0, 1.0}, {0.0, 1.0 - unit2, 0.0, 1.0 - unit, 1.0, unit}, {0.0, 1.0 - unit2, 1.0 - unit, 1.0 - unit, 1.0, 1.0}};
    private static double[][] trimBoundsRightZ = new double[][]{{1.0 - unit, 1.0 - unit2, 0.0, 1.0, 1.0, 1.0}, {0.0, 1.0 - unit2, 0.0, 1.0 - unit, 1.0, 1.0}};
    private static double[][] trimBoundsRightX = new double[][]{{0.0, 1.0 - unit2, 0.0, 1.0, 1.0, unit}, {0.0, 1.0 - unit2, unit, 1.0, 1.0, 1.0 - unit}, {0.0, 1.0 - unit2, 1.0 - unit, 1.0, 1.0, 1.0}};

    public void renderLeft(IBlockAccess blockAccess, int x, int y, int z, BlockFramingTable block) {
        this.renderTableBox(blockAccess, x, y, z, block, baseBoundsLeftY, trimBoundsLeftY, trimBoundsLeftZ, trimBoundsLeftX, true);
        this.renderStructure(blockAccess, x, y, z, block, true);
    }

    public void renderRight(IBlockAccess blockAccess, int x, int y, int z, BlockFramingTable block) {
        this.renderTableBox(blockAccess, x, y, z, block, baseBoundsRightY, trimBoundsRightY, trimBoundsRightZ, trimBoundsRightX, false);
        this.renderStructure(blockAccess, x, y, z, block, false);
    }

    public void renderOverlayLeft(IBlockAccess blockAccess, int x, int y, int z, BlockFramingTable block) {
        this.renderOverlay(blockAccess, x, y, z, block, baseBoundsLeftY, true);
    }

    public void renderOverlayRight(IBlockAccess blockAccess, int x, int y, int z, BlockFramingTable block) {
        this.renderOverlay(blockAccess, x, y, z, block, baseBoundsRightY, false);
    }

    public void renderOverlay(IBlockAccess blockAccess, int x, int y, int z, BlockFramingTable block, double[][] baseBoundsY, boolean left) {
        IIcon iconOverlay = block.getIconOverlay(left);
        RenderHelper renderer = RenderHelper.instances.get();
        for (double[] bound : baseBoundsY) {
            renderer.setRenderBounds(bound);
            renderer.renderFace(1, blockAccess, (Block)block, x, y, z, iconOverlay);
        }
    }

    private void renderStructure(IBlockAccess blockAccess, int x, int y, int z, BlockFramingTable block, boolean left) {
        IIcon iconSurface = block.getIconBase();
        this.renderFoot(blockAccess, x, y, z, block, iconSurface, left);
        this.renderLegs(blockAccess, x, y, z, block, iconSurface, left);
        this.renderBraces(blockAccess, x, y, z, block, iconSurface, left);
    }

    private void renderTableBox(IBlockAccess blockAccess, int x, int y, int z, BlockFramingTable block, double[][] baseBoundsY, double[][] trimBoundsY, double[][] trimBoundsZ, double[][] trimBoundsX, boolean left) {
        RenderHelper renderer = RenderHelper.instances.get();
        IIcon iconSurface = block.getIconBase();
        IIcon iconTrim = block.getIconTrim();
        int xSide = left ? 4 : 5;
        for (double[] bound : baseBoundsY) {
            renderer.setRenderBounds(bound);
            renderer.renderFace(1, blockAccess, (Block)block, x, y, z, iconSurface);
            renderer.renderFace(0, blockAccess, (Block)block, x, y, z, iconSurface);
        }
        for (double[] bound : trimBoundsY) {
            renderer.setRenderBounds(bound);
            renderer.renderFace(1, blockAccess, (Block)block, x, y, z, iconTrim);
            renderer.renderFace(0, blockAccess, (Block)block, x, y, z, iconTrim);
        }
        for (double[] bound : trimBoundsZ) {
            renderer.setRenderBounds(bound);
            renderer.renderFace(2, blockAccess, (Block)block, x, y, z, iconTrim);
            renderer.renderFace(3, blockAccess, (Block)block, x, y, z, iconTrim);
        }
        for (double[] bound : trimBoundsX) {
            renderer.setRenderBounds(bound);
            renderer.renderFace(xSide, blockAccess, (Block)block, x, y, z, iconTrim);
        }
    }

    private void renderFoot(IBlockAccess blockAccess, int x, int y, int z, BlockFramingTable block, IIcon icon, boolean left) {
        int i;
        RenderHelper renderer = RenderHelper.instances.get();
        float oldColor = renderer.state.colorMultYPos;
        renderer.state.colorMultYPos = 0.9f;
        for (int i2 = 0; i2 < 2; ++i2) {
            renderer.state.setUVRotation(i2, (renderer.state.rotateTransform + 1) % 4);
        }
        double xStart = left ? unit2 : 1.0 - unit2 - unit2;
        renderer.setRenderBounds(xStart, 0.0, 0.0, xStart + unit2, unit2, 1.0);
        for (i = 0; i < 6; ++i) {
            renderer.renderFace(i, blockAccess, (Block)block, x, y, z, icon);
        }
        for (i = 0; i < 2; ++i) {
            renderer.state.clearUVRotation(i);
        }
        renderer.state.colorMultYPos = oldColor;
    }

    private void renderLegs(IBlockAccess blockAccess, int x, int y, int z, BlockFramingTable block, IIcon icon, boolean left) {
        int i;
        RenderHelper renderer = RenderHelper.instances.get();
        for (int i2 = 2; i2 < 6; ++i2) {
            renderer.state.setUVRotation(i2, 1);
        }
        double xStart = left ? unit2 : 1.0 - unit2 - unit2;
        renderer.setRenderBounds(xStart, unit2, unit2, xStart + unit2, 1.0 - unit2, unit2 + unit2);
        for (i = 2; i < 6; ++i) {
            renderer.renderFace(i, blockAccess, (Block)block, x, y, z, icon);
        }
        renderer.setRenderBounds(xStart, unit2, 1.0 - unit2 - unit2, xStart + unit2, 1.0 - unit2, 1.0 - unit2);
        for (i = 2; i < 6; ++i) {
            renderer.renderFace(i, blockAccess, (Block)block, x, y, z, icon);
        }
        for (i = 2; i < 6; ++i) {
            renderer.state.clearUVRotation(i);
        }
    }

    private void renderBraces(IBlockAccess blockAccess, int x, int y, int z, BlockFramingTable block, IIcon icon, boolean left) {
        int i;
        RenderHelper renderer = RenderHelper.instances.get();
        float oldColor = renderer.state.colorMultYPos;
        renderer.state.colorMultYPos = 0.85f;
        for (int i2 = 0; i2 < 2; ++i2) {
            renderer.state.setUVRotation(i2, renderer.state.rotateTransform);
        }
        double xStart = left ? unit2 + unit2 : 0.0;
        double xStop = left ? 1.0 : 1.0 - unit2 - unit2;
        renderer.setRenderBounds(xStart, unit4, unit2, xStop, unit4 + unit2, unit2 + unit2);
        for (i = 0; i < 4; ++i) {
            renderer.renderFace(i, blockAccess, (Block)block, x, y, z, icon);
        }
        renderer.setRenderBounds(xStart, unit4, 1.0 - unit2 - unit2, xStop, unit4 + unit2, 1.0 - unit2);
        for (i = 0; i < 4; ++i) {
            renderer.renderFace(i, blockAccess, (Block)block, x, y, z, icon);
        }
        for (i = 0; i < 2; ++i) {
            renderer.state.clearUVRotation(i);
        }
        renderer.state.colorMultYPos = oldColor;
    }
}

