/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.core.render.sky;

import cpw.mods.fml.client.FMLClientHandler;
import galaxyspace.core.config.GSConfigCore;
import galaxyspace.core.mca.common.math.FastMath;
import galaxyspace.core.render.GSResources;
import gregtech.api.objects.XSTR;
import java.util.Calendar;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import net.minecraftforge.client.IRenderHandler;
import org.lwjgl.opengl.GL11;

public class SkyProviderBase
extends IRenderHandler
implements GSResources {
    protected int starList;
    protected int glSkyList;
    protected int glSkyList2;
    protected float skyColorRed;
    protected float skyColorGreen;
    protected float skyColorBlue;
    protected float[] sunRGBA = new float[]{1.0f, 0.7607843f, 0.7058824f, 0.3f};
    protected double sunRadius = 10.5;
    protected double innerFlareRadius = 20.0;
    protected double outerFlareRadius = 40.0;

    public SkyProviderBase() {
        int z;
        int x;
        this.setup();
        this.starList = GLAllocation.func_74526_a((int)3);
        this.glSkyList = this.starList + 1;
        this.glSkyList2 = this.starList + 2;
        GL11.glPushMatrix();
        GL11.glNewList((int)this.starList, (int)4864);
        this.renderStars();
        GL11.glEndList();
        GL11.glPopMatrix();
        Tessellator tessellator = Tessellator.field_78398_a;
        GL11.glNewList((int)this.glSkyList, (int)4864);
        for (x = -384; x <= 384; x += 64) {
            for (z = -384; z <= 384; z += 64) {
                tessellator.func_78382_b();
                tessellator.func_78377_a((double)x, 16.0, (double)z);
                tessellator.func_78377_a((double)(x + 64), 16.0, (double)z);
                tessellator.func_78377_a((double)(x + 64), 16.0, (double)(z + 64));
                tessellator.func_78377_a((double)x, 16.0, (double)(z + 64));
                tessellator.func_78381_a();
            }
        }
        GL11.glEndList();
        GL11.glNewList((int)this.glSkyList2, (int)4864);
        tessellator.func_78382_b();
        for (x = -384; x <= 384; x += 64) {
            for (z = -384; z <= 384; z += 64) {
                tessellator.func_78377_a((double)(x + 64), -16.0, (double)z);
                tessellator.func_78377_a((double)x, -16.0, (double)z);
                tessellator.func_78377_a((double)x, -16.0, (double)(z + 64));
                tessellator.func_78377_a((double)(x + 64), -16.0, (double)(z + 64));
            }
        }
        tessellator.func_78381_a();
        GL11.glEndList();
    }

    protected void setup() {
    }

    private void renderStars() {
        XSTR rand = new XSTR(10842L);
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        for (int starIndex = 0; starIndex < (ConfigManagerCore.moreStars ? 35000 : 6000); ++starIndex) {
            double randX = rand.nextFloat() * 2.0f - 1.0f;
            double randY = rand.nextFloat() * 2.0f - 1.0f;
            double randZ = rand.nextFloat() * 2.0f - 1.0f;
            double randFloat = 0.15f + rand.nextFloat() * 0.1f;
            double dist = randX * randX + randY * randY + randZ * randZ;
            if (!(dist < 1.0) || !(dist > 0.01)) continue;
            dist = FastMath.invSqrtD(dist);
            double x = (randX *= dist) * (ConfigManagerCore.moreStars ? rand.nextDouble() * 150.0 + 130.0 : 100.0);
            double y = (randY *= dist) * (ConfigManagerCore.moreStars ? rand.nextDouble() * 150.0 + 130.0 : 100.0);
            double z = (randZ *= dist) * (ConfigManagerCore.moreStars ? rand.nextDouble() * 150.0 + 130.0 : 100.0);
            double alpha = Math.atan2(randX, randZ);
            double what2 = Math.sin(alpha);
            double what3 = Math.cos(alpha);
            double beta = Math.atan2(Math.sqrt(randX * randX + randZ * randZ), randY);
            double what5 = Math.sin(beta);
            double what6 = Math.cos(beta);
            double randAngle = rand.nextDouble() * Math.PI * 2.0;
            double what7 = Math.sin(randAngle);
            double what8 = Math.cos(randAngle);
            for (int i = 0; i < 4; ++i) {
                double alternating1 = (double)((i & 2) - 1) * randFloat;
                double alternating2 = (double)((i + 1 & 2) - 1) * randFloat;
                double what11 = alternating1 * what8 - alternating2 * what7;
                double what12 = alternating2 * what8 + alternating1 * what7;
                double what13 = -what11 * what6;
                double dY = what11 * what5;
                double dX = what13 * what2 - what12 * what3;
                double dZ = what12 * what2 + what13 * what3;
                tessellator.func_78377_a(x + dX, y + dY, z + dZ);
            }
        }
        tessellator.func_78381_a();
    }

    public void render(float partialTicks, WorldClient world, Minecraft mc) {
        this.renderDefault(partialTicks, world, mc);
    }

    protected void renderDefault(float partialTicks, WorldClient world, Minecraft mc) {
        GL11.glDisable((int)3553);
        this.queryAndApplySkyColor(partialTicks, world, mc);
        GL11.glDepthMask((boolean)false);
        this.renderSkyList();
        GL11.glDisable((int)3008);
        GL11.glEnable((int)3042);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        RenderHelper.func_74518_a();
        this.renderStarList(partialTicks, world);
        this.renderSun(partialTicks, world, mc);
        this.renderGalaxies();
        GL11.glDisable((int)3042);
        this.renderCelestialBodies(partialTicks, world, mc);
        GL11.glEnable((int)3008);
        GL11.glEnable((int)2912);
        GL11.glDisable((int)3553);
        this.renderSkyList2(partialTicks, world, mc);
        GL11.glEnable((int)3553);
        GL11.glDepthMask((boolean)true);
    }

    protected void renderDefaultWithoutSkyList2(float partialTicks, WorldClient world, Minecraft mc) {
        GL11.glDisable((int)3553);
        this.queryAndApplySkyColor(partialTicks, world, mc);
        GL11.glDepthMask((boolean)false);
        this.renderSkyList();
        GL11.glDisable((int)3008);
        GL11.glEnable((int)3042);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        RenderHelper.func_74518_a();
        this.renderStarList(partialTicks, world);
        this.renderSun(partialTicks, world, mc);
        this.renderGalaxies();
        GL11.glDisable((int)3042);
        this.renderCelestialBodies(partialTicks, world, mc);
        GL11.glEnable((int)3008);
        GL11.glEnable((int)2912);
        GL11.glEnable((int)3553);
        GL11.glDepthMask((boolean)true);
    }

    protected void renderCelestialBodies(float partialTicks, WorldClient world, Minecraft mc) {
    }

    protected void drawTexture(ResourceLocation texture, double radius) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(texture);
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a(-radius, -100.0, radius, 0.0, 1.0);
        tessellator.func_78374_a(radius, -100.0, radius, 1.0, 1.0);
        tessellator.func_78374_a(radius, -100.0, -radius, 1.0, 0.0);
        tessellator.func_78374_a(-radius, -100.0, -radius, 0.0, 0.0);
        tessellator.func_78381_a();
    }

    protected void queryAndApplySkyColor(float partialTicks, WorldClient world, Minecraft mc) {
        Vec3 skyColor = world.func_72833_a((Entity)mc.field_71451_h, partialTicks);
        this.skyColorRed = (float)skyColor.field_72450_a;
        this.skyColorGreen = (float)skyColor.field_72448_b;
        this.skyColorBlue = (float)skyColor.field_72449_c;
        if (mc.field_71474_y.field_74337_g) {
            float skyColorRedAnaglyph = this.skyColorRed * 0.3f + this.skyColorGreen * 0.59f + this.skyColorBlue * 0.11f;
            float skyColorGreenAnaglyph = this.skyColorRed * 0.3f + this.skyColorGreen * 0.7f;
            float skyColorBlueAnaglyph = this.skyColorRed * 0.3f + this.skyColorBlue * 0.7f;
            this.skyColorRed = skyColorRedAnaglyph;
            this.skyColorGreen = skyColorGreenAnaglyph;
            this.skyColorBlue = skyColorBlueAnaglyph;
        }
        GL11.glColor3f((float)this.skyColorRed, (float)this.skyColorGreen, (float)this.skyColorBlue);
    }

    protected void renderSkyList() {
        GL11.glEnable((int)2912);
        GL11.glColor3f((float)this.skyColorRed, (float)this.skyColorGreen, (float)this.skyColorBlue);
        GL11.glCallList((int)this.glSkyList);
        GL11.glDisable((int)2912);
    }

    protected void renderStarList(float partialTicks, WorldClient world) {
        float starBrightness = world.func_72880_h(partialTicks);
        if (starBrightness > 0.0f) {
            GL11.glPushMatrix();
            GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)(world.func_72826_c(partialTicks) * 360.0f), (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)-19.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glColor4f((float)starBrightness, (float)starBrightness, (float)starBrightness, (float)starBrightness);
            GL11.glCallList((int)this.starList);
            GL11.glPopMatrix();
        }
    }

    protected void renderStarListFullBrighness(float partialTicks, WorldClient world) {
        GL11.glPushMatrix();
        GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(world.func_72826_c(partialTicks) * 360.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)-19.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glColor4f((float)GSConfigCore.spaceStationStarBrightness, (float)GSConfigCore.spaceStationStarBrightness, (float)GSConfigCore.spaceStationStarBrightness, (float)GSConfigCore.spaceStationStarBrightness);
        GL11.glCallList((int)this.starList);
        GL11.glPopMatrix();
    }

    protected void renderSun(float partialTicks, WorldClient world, Minecraft mc) {
        float sunColorBlueAnaglyph;
        float sunColorGreenAnaglyph;
        float sunColorRedAnaglyph;
        GL11.glDisable((int)3553);
        GL11.glShadeModel((int)7425);
        GL11.glPushMatrix();
        GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(world.func_72826_c(partialTicks) * 360.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        float starBrightness = 1.0f - world.func_72880_h(partialTicks);
        if (mc.field_71474_y.field_74337_g) {
            sunColorRedAnaglyph = this.sunRGBA[0] * 0.3f + this.sunRGBA[1] * 0.59f + this.sunRGBA[2] * 0.11f;
            sunColorGreenAnaglyph = this.sunRGBA[0] * 0.3f + this.sunRGBA[1] * 0.7f;
            sunColorBlueAnaglyph = this.sunRGBA[0] * 0.3f + this.sunRGBA[2] * 0.7f;
        } else {
            sunColorRedAnaglyph = this.sunRGBA[0];
            sunColorGreenAnaglyph = this.sunRGBA[1];
            sunColorBlueAnaglyph = this.sunRGBA[2];
        }
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78371_b(6);
        tessellator.func_78369_a(sunColorRedAnaglyph * starBrightness, sunColorGreenAnaglyph * starBrightness, sunColorBlueAnaglyph * starBrightness, this.sunRGBA[3] * 2.0f / starBrightness);
        tessellator.func_78377_a(0.0, 100.0, 0.0);
        tessellator.func_78369_a(this.sunRGBA[0] * starBrightness, this.sunRGBA[1] * starBrightness, this.sunRGBA[2] * starBrightness, 0.0f);
        tessellator.func_78377_a(-this.innerFlareRadius, 100.0, -this.innerFlareRadius);
        tessellator.func_78377_a(0.0, 100.0, -this.innerFlareRadius * 1.5);
        tessellator.func_78377_a(this.innerFlareRadius, 100.0, -this.innerFlareRadius);
        tessellator.func_78377_a(this.innerFlareRadius * 1.5, 100.0, 0.0);
        tessellator.func_78377_a(this.innerFlareRadius, 100.0, this.innerFlareRadius);
        tessellator.func_78377_a(0.0, 100.0, this.innerFlareRadius * 1.5);
        tessellator.func_78377_a(-this.innerFlareRadius, 100.0, this.innerFlareRadius);
        tessellator.func_78377_a(-this.innerFlareRadius * 1.5, 100.0, 0.0);
        tessellator.func_78377_a(-this.innerFlareRadius, 100.0, -this.innerFlareRadius);
        tessellator.func_78381_a();
        tessellator.func_78371_b(6);
        tessellator.func_78369_a(sunColorRedAnaglyph * starBrightness, sunColorGreenAnaglyph * starBrightness, sunColorBlueAnaglyph * starBrightness, this.sunRGBA[3] * starBrightness);
        tessellator.func_78377_a(0.0, 100.0, 0.0);
        tessellator.func_78369_a(this.sunRGBA[0] * starBrightness, this.sunRGBA[1] * starBrightness, this.sunRGBA[2] * starBrightness, 0.0f);
        tessellator.func_78377_a(-this.outerFlareRadius, 100.0, -this.outerFlareRadius);
        tessellator.func_78377_a(0.0, 100.0, -this.outerFlareRadius * 1.5);
        tessellator.func_78377_a(this.outerFlareRadius, 100.0, -this.outerFlareRadius);
        tessellator.func_78377_a(this.outerFlareRadius * 1.5, 100.0, 0.0);
        tessellator.func_78377_a(this.outerFlareRadius, 100.0, this.outerFlareRadius);
        tessellator.func_78377_a(0.0, 100.0, this.outerFlareRadius * 1.5);
        tessellator.func_78377_a(-this.outerFlareRadius, 100.0, this.outerFlareRadius);
        tessellator.func_78377_a(-this.outerFlareRadius * 1.5, 100.0, 0.0);
        tessellator.func_78377_a(-this.outerFlareRadius, 100.0, -this.outerFlareRadius);
        tessellator.func_78381_a();
        GL11.glPopMatrix();
        GL11.glShadeModel((int)7424);
        GL11.glEnable((int)3553);
        OpenGlHelper.func_148821_a((int)770, (int)1, (int)1, (int)0);
        GL11.glPushMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(world.func_72826_c(partialTicks) * 360.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(this.getSunTexture());
        tessellator.func_78382_b();
        tessellator.func_78374_a(-this.sunRadius, 100.0, -this.sunRadius, 0.0, 0.0);
        tessellator.func_78374_a(this.sunRadius, 100.0, -this.sunRadius, 1.0, 0.0);
        tessellator.func_78374_a(this.sunRadius, 100.0, this.sunRadius, 1.0, 1.0);
        tessellator.func_78374_a(-this.sunRadius, 100.0, this.sunRadius, 0.0, 1.0);
        tessellator.func_78381_a();
        GL11.glPopMatrix();
    }

    protected ResourceLocation getSunTexture() {
        Calendar calendar = Calendar.getInstance();
        if (calendar.get(2) + 1 == 10 && calendar.get(5) >= 30 && calendar.get(5) <= 31 || calendar.get(2) + 1 == 11 && calendar.get(5) <= 1) {
            return pumpkinsunTexture;
        }
        return sunTexture;
    }

    protected void renderGalaxies() {
        GL11.glPushMatrix();
        GL11.glScalef((float)0.6f, (float)0.6f, (float)0.6f);
        GL11.glRotatef((float)-105.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        this.drawTexture(lmcTexture, 15.0);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glScalef((float)0.6f, (float)0.6f, (float)0.6f);
        GL11.glRotatef((float)-45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)-105.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        this.drawTexture(smcTexture, 5.0);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glScalef((float)0.6f, (float)0.6f, (float)0.6f);
        GL11.glRotatef((float)145.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)-135.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        this.drawTexture(andromedaTexture, 4.0);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glScalef((float)0.6f, (float)0.6f, (float)0.6f);
        GL11.glRotatef((float)65.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)-135.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        this.drawTexture(barnardaloopTexture, 40.0);
        GL11.glPopMatrix();
    }

    protected void renderSkyList2(float partialTicks, WorldClient world, Minecraft mc) {
        GL11.glColor3f((float)0.0f, (float)0.0f, (float)0.0f);
        double distOverHorizon = mc.field_71439_g.func_70666_h((float)partialTicks).field_72448_b - world.func_72919_O();
        if (distOverHorizon < 0.0) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)0.0f, (float)12.0f, (float)0.0f);
            GL11.glCallList((int)this.glSkyList2);
            GL11.glPopMatrix();
            float y = -((float)(distOverHorizon + 65.0));
            Tessellator tessellator = Tessellator.field_78398_a;
            tessellator.func_78382_b();
            tessellator.func_78384_a(0, 255);
            tessellator.func_78377_a(-1.0, (double)y, 1.0);
            tessellator.func_78377_a(1.0, (double)y, 1.0);
            tessellator.func_78377_a(1.0, -1.0, 1.0);
            tessellator.func_78377_a(-1.0, -1.0, 1.0);
            tessellator.func_78377_a(-1.0, -1.0, -1.0);
            tessellator.func_78377_a(1.0, -1.0, -1.0);
            tessellator.func_78377_a(1.0, (double)y, -1.0);
            tessellator.func_78377_a(-1.0, (double)y, -1.0);
            tessellator.func_78377_a(1.0, -1.0, -1.0);
            tessellator.func_78377_a(1.0, -1.0, 1.0);
            tessellator.func_78377_a(1.0, (double)y, 1.0);
            tessellator.func_78377_a(1.0, (double)y, -1.0);
            tessellator.func_78377_a(-1.0, (double)y, -1.0);
            tessellator.func_78377_a(-1.0, (double)y, 1.0);
            tessellator.func_78377_a(-1.0, -1.0, 1.0);
            tessellator.func_78377_a(-1.0, -1.0, -1.0);
            tessellator.func_78377_a(-1.0, -1.0, -1.0);
            tessellator.func_78377_a(-1.0, -1.0, 1.0);
            tessellator.func_78377_a(1.0, -1.0, 1.0);
            tessellator.func_78377_a(1.0, -1.0, -1.0);
            tessellator.func_78381_a();
        }
        if (world.field_73011_w.func_76561_g()) {
            GL11.glColor3f((float)(this.skyColorRed * 0.2f + 0.04f), (float)(this.skyColorGreen * 0.2f + 0.04f), (float)(this.skyColorBlue * 0.6f + 0.1f));
        } else {
            GL11.glColor3f((float)this.skyColorRed, (float)this.skyColorGreen, (float)this.skyColorBlue);
        }
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.0f, (float)(16.0f - (float)distOverHorizon), (float)0.0f);
        GL11.glCallList((int)this.glSkyList2);
        GL11.glPopMatrix();
    }
}

