/*
 * Decompiled with CFR 0.152.
 */
package serverutils.command.tp;

import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import serverutils.ServerUtilities;
import serverutils.data.ServerUtilitiesPlayerData;
import serverutils.data.TeleportLog;
import serverutils.data.TeleportType;
import serverutils.lib.command.CmdBase;
import serverutils.lib.command.CommandUtils;
import serverutils.lib.data.ForgePlayer;
import serverutils.lib.data.Universe;
import serverutils.lib.math.BlockDimPos;
import serverutils.lib.util.permission.PermissionAPI;
import serverutils.task.Task;

public class CmdBack
extends CmdBase {
    public CmdBack() {
        super("back", CmdBase.Level.ALL);
    }

    public void func_71515_b(ICommandSender sender, String[] args) throws CommandException {
        final EntityPlayerMP player = CmdBack.func_71521_c((ICommandSender)sender);
        ForgePlayer p = CommandUtils.getForgePlayer((ICommandSender)player);
        final ServerUtilitiesPlayerData data = ServerUtilitiesPlayerData.get(p);
        TeleportLog lastTeleportLog = data.getLastTeleportLog();
        if (lastTeleportLog == null) {
            throw ServerUtilities.error(sender, "serverutilities.lang.warps.no_dp", new Object[0]);
        }
        BlockDimPos noPosFound = new BlockDimPos(0, 0, 0, 0);
        if (lastTeleportLog.getBlockDimPos().equalsPos(noPosFound)) {
            throw ServerUtilities.error(sender, "serverutilities.lang.warps.no_pos_found", new Object[0]);
        }
        data.checkTeleportCooldown(sender, ServerUtilitiesPlayerData.Timer.BACK);
        Task task = new Task(){

            @Override
            public void execute(Universe universe) {
                if (!PermissionAPI.hasPermission((EntityPlayer)player, "serverutilities.back.infinite")) {
                    for (TeleportType t : TeleportType.values()) {
                        data.clearLastTeleport(t);
                    }
                }
            }
        };
        ServerUtilitiesPlayerData.Timer.BACK.teleport(player, playerMP -> lastTeleportLog.teleporter(), task);
    }
}

