/*
 * Decompiled with CFR 0.152.
 */
package serverutils.command;

import java.util.Collections;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.util.EnumChatFormatting;
import serverutils.ServerUtilities;
import serverutils.ServerUtilitiesConfig;
import serverutils.data.ServerUtilitiesPlayerData;
import serverutils.lib.command.CmdBase;
import serverutils.lib.command.CommandUtils;
import serverutils.lib.data.ForgePlayer;
import serverutils.lib.util.StringUtils;
import serverutils.net.MessageUpdateTabName;

public class CmdNick
extends CmdBase {
    public CmdNick() {
        super("nick", CmdBase.Level.ALL);
    }

    public void func_71515_b(ICommandSender sender, String[] args) throws CommandException {
        ForgePlayer player = CommandUtils.getForgePlayer(sender);
        if (!player.hasPermission("serverutilities.chat.nickname.set")) {
            throw new CommandException("commands.generic.permission", new Object[0]);
        }
        ServerUtilitiesPlayerData data = ServerUtilitiesPlayerData.get(player);
        data.setNickname(StringUtils.joinSpaceUntilEnd(0, args));
        if (data.getNickname().isEmpty()) {
            player.getPlayer().func_145747_a(ServerUtilities.lang((ICommandSender)player.getPlayer(), "serverutilities.lang.nickname_reset", new Object[0]));
        } else {
            String name = StringUtils.addFormatting(data.getNickname());
            if (!player.hasPermission("serverutilities.chat.nickname.colors")) {
                name = StringUtils.unformatted(name);
            } else if (name.indexOf(167) != -1) {
                name = name + EnumChatFormatting.RESET;
            }
            player.getPlayer().func_145747_a(ServerUtilities.lang((ICommandSender)player.getPlayer(), "serverutilities.lang.nickname_changed", name));
        }
        if (ServerUtilitiesConfig.chat.replace_tab_names) {
            new MessageUpdateTabName(Collections.singleton(player)).sendToAll();
        }
    }
}

