/*
 * Decompiled with CFR 0.152.
 */
package serverutils;

import com.gtnewhorizon.gtnhlib.config.Config;
import cpw.mods.fml.common.registry.GameData;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.IChatComponent;
import serverutils.ServerUtilities;
import serverutils.data.ClaimedChunks;
import serverutils.lib.config.EnumTristate;
import serverutils.lib.io.DataReader;
import serverutils.lib.item.ItemStackSerializer;
import serverutils.lib.math.Ticks;
import serverutils.lib.util.JsonUtils;
import serverutils.lib.util.ServerUtils;

@Config(modid="serverutilities", category="", configSubDirectory="../serverutilities/")
@Config.RequiresWorldRestart
public class ServerUtilitiesConfig {
    public static final AutoShutdown auto_shutdown = new AutoShutdown();
    public static final AFK afk = new AFK();
    public static final Chat chat = new Chat();
    public static final Commands commands = new Commands();
    public static final Login login = new Login();
    public static final RanksConfig ranks = new RanksConfig();
    public static final WorldConfig world = new WorldConfig();
    public static final Debugging debugging = new Debugging();
    public static final Backups backups = new Backups();
    public static final General general = new General();
    public static final Teams teams = new Teams();
    public static final Tasks tasks = new Tasks();

    public static class AutoShutdown {
        @Config.Comment(value={"Enables auto-shutdown."})
        @Config.DefaultBoolean(value=false)
        public boolean enabled;
        @Config.Comment(value={"Enables auto-shutdown in singleplayer worlds."})
        @Config.DefaultBoolean(value=false)
        public boolean enabled_singleplayer;
        @Config.Comment(value={"Server will automatically shut down after X hours.\nTime Format: HH:MM. If the system time matches a value, server will shut down.\nIt will look for closest value available that is not equal to current time."})
        @Config.DefaultStringList(value={"04:00", "16:00"})
        public String[] times;
    }

    public static class AFK {
        @Config.Comment(value={"Enables afk timer."})
        @Config.DefaultBoolean(value=true)
        public boolean enabled;
        @Config.Comment(value={"Enables afk timer in singleplayer."})
        @Config.DefaultBoolean(value=true)
        public boolean enabled_singleplayer;
        @Config.Comment(value={"After how much time it will display notification to all players."})
        @Config.DefaultString(value="5m")
        public String notification_timer;
        @Config.Ignore
        private long notificationTimer = -1L;

        public boolean isEnabled(MinecraftServer server) {
            return this.enabled && (this.enabled_singleplayer || !server.func_71264_H());
        }

        public long getNotificationTimer() {
            if (this.notificationTimer < 0L) {
                this.notificationTimer = Ticks.get(this.notification_timer).millis();
            }
            return this.notificationTimer;
        }
    }

    public static class Chat {
        @Config.Comment(value={"Adds ~ to player names that have changed nickname to prevent trolling."})
        @Config.DefaultBoolean(value=false)
        public boolean add_nickname_tilde;
        @Config.Comment(value={"Replaces player names in the TAB screen with the names used in chat."})
        @Config.DefaultBoolean(value=true)
        public boolean replace_tab_names;
    }

    public static class Commands {
        @Config.DefaultBoolean(value=true)
        public boolean warp;
        @Config.DefaultBoolean(value=true)
        public boolean home;
        @Config.DefaultBoolean(value=true)
        public boolean back;
        @Config.DefaultBoolean(value=true)
        public boolean spawn;
        @Config.DefaultBoolean(value=true)
        public boolean inv;
        @Config.DefaultBoolean(value=true)
        public boolean tpl;
        @Config.DefaultBoolean(value=true)
        public boolean trash_can;
        @Config.DefaultBoolean(value=true)
        public boolean chunks;
        @Config.DefaultBoolean(value=true)
        public boolean kickme;
        @Config.DefaultBoolean(value=true)
        public boolean ranks;
        @Config.DefaultBoolean(value=true)
        public boolean heal;
        @Config.DefaultBoolean(value=true)
        public boolean killall;
        @Config.DefaultBoolean(value=true)
        public boolean nbtedit;
        @Config.DefaultBoolean(value=true)
        public boolean fly;
        @Config.DefaultBoolean(value=true)
        public boolean leaderboard;
        @Config.DefaultBoolean(value=true)
        public boolean tpa;
        @Config.DefaultBoolean(value=true)
        public boolean nick;
        @Config.DefaultBoolean(value=true)
        public boolean mute;
        @Config.DefaultBoolean(value=true)
        public boolean rtp;
        @Config.DefaultBoolean(value=true)
        public boolean god;
        @Config.DefaultBoolean(value=true)
        public boolean rec;
        @Config.DefaultBoolean(value=true)
        public boolean reload;
        @Config.DefaultBoolean(value=true)
        public boolean backup;
        @Config.DefaultBoolean(value=true)
        public boolean dump_chunkloaders;
        @Config.DefaultBoolean(value=true)
        public boolean dump_permissions;
        @Config.DefaultBoolean(value=true)
        public boolean dump_stats;
    }

    public static class Login {
        @Config.Comment(value={"Enables message of the day."})
        @Config.DefaultBoolean(value=false)
        public boolean enable_motd;
        @Config.Comment(value={"Enables starting items."})
        @Config.DefaultBoolean(value=false)
        public boolean enable_starting_items;
        @Config.Comment(value={"Message of the day. This will be displayed when player joins the server."})
        @Config.DefaultStringList(value={"\"Hello player!\""})
        public String[] motd;
        @Config.Comment(value={"Items to give player when they first join the server.\nFormat: '{id:\"ID\",Count:X,Damage:X,tag:{}}', Use /print_item to get NBT of item in your hand."})
        @Config.DefaultStringList(value={"{id:\"minecraft:stone_sword\",Count:1,Damage:1,tag:{display:{Name:\"Epic Stone Sword\"}}}"})
        public String[] starting_items;
        @Config.Ignore
        private List<IChatComponent> motdComponents = null;
        @Config.Ignore
        private List<ItemStack> startingItems = null;

        public List<IChatComponent> getMOTD() {
            if (this.motdComponents == null) {
                this.motdComponents = new ArrayList<IChatComponent>();
                if (this.enable_motd) {
                    for (String s : this.motd) {
                        IChatComponent t = JsonUtils.deserializeTextComponent(DataReader.get(s).safeJson());
                        if (t == null) continue;
                        this.motdComponents.add(t);
                    }
                }
            }
            return this.motdComponents;
        }

        public List<ItemStack> getStartingItems() {
            if (this.startingItems == null) {
                this.startingItems = new ArrayList<ItemStack>();
                if (this.enable_starting_items) {
                    for (String s : this.starting_items) {
                        try {
                            ItemStack stack = ItemStackSerializer.parseItem(s);
                            if (stack == null) continue;
                            this.startingItems.add(stack);
                        }
                        catch (Exception ex) {
                            ServerUtilities.LOGGER.warn("Failed to parse starting item: {}", new Object[]{s, ex});
                        }
                    }
                }
            }
            return this.startingItems;
        }
    }

    public static class RanksConfig {
        @Config.Comment(value={"Enables Ranks."})
        @Config.DefaultBoolean(value=true)
        public boolean enabled;
        @Config.Comment(value={"Adds chat colors/rank-specific syntax."})
        @Config.DefaultBoolean(value=true)
        public boolean override_chat;
        @Config.Comment(value={"Add permissions for commands and allow them to be controlled by ranks."})
        @Config.DefaultBoolean(value=true)
        public boolean command_permissions;
    }

    public static class WorldConfig {
        public final WorldLogging logging = new WorldLogging();
        @Config.Comment(value={"Enables chunk claiming."})
        @Config.DefaultBoolean(value=true)
        public boolean chunk_claiming;
        @Config.Comment(value={"Enables chunk loading. If chunk_claiming is set to false, changing this won't do anything."})
        @Config.DefaultBoolean(value=true)
        public boolean chunk_loading;
        @Config.Comment(value={"If set to true, explosions and hostile mobs in spawn area will be disabled, players won't be able to attack each other in spawn area."})
        @Config.DefaultBoolean(value=false)
        public boolean safe_spawn;
        @Config.Comment(value={"Enable spawn area in singleplayer."})
        @Config.DefaultBoolean(value=false)
        public boolean spawn_area_in_sp;
        @Config.Comment(value={"Dimensions where chunk claiming isn't allowed."})
        @Config.DefaultIntList(value={})
        public int[] blocked_claiming_dimensions;
        @Config.Comment(value={"Allowed values:\nDEFAULT = Players can choose their own PVP status.\nTRUE = PVP on for everyone.\nFALSE = PVP disabled for everyone."})
        @Config.DefaultEnum(value="DEFAULT")
        public EnumTristate enable_pvp;
        @Config.Comment(value={"Allowed values:\nDEFAULT = Teams can decide their explosion setting\nTRUE = Explosions on for everyone.\nFALSE = Explosions disabled for everyone."})
        @Config.DefaultEnum(value="DEFAULT")
        public EnumTristate enable_explosions;
        @Config.Comment(value={"Spawn radius. You must set spawn-protection in server.properties file to 0!"})
        @Config.DefaultInt(value=0)
        public int spawn_radius;
        @Config.Comment(value={"Spawn dimension. Overworld by default."})
        @Config.DefaultInt(value=0)
        public int spawn_dimension;
        @Config.Comment(value={"Unloads erroring chunks if dimension isn't loaded or some other problem occurs."})
        @Config.DefaultBoolean(value=false)
        public boolean unload_erroring_chunks;
        @Config.Comment(value={"Min /rtp distance"})
        @Config.DefaultDouble(value=1000.0)
        public double rtp_min_distance;
        @Config.Comment(value={"Max /rtp distance"})
        @Config.DefaultDouble(value=100000.0)
        public double rtp_max_distance;
        @Config.Comment(value={"Max tries /rtp does before failure."})
        @Config.DefaultInt(value=200)
        public int rtp_max_tries;
        @Config.Comment(value={"List of items that will have right-click function disabled on both sides.\nYou can use '/inv disable_right_click' command to do with from in-game.\nSyntax: modid:item:metadata. Set metadata to * to ignore it."})
        @Config.DefaultStringList(value={""})
        public String[] disabled_right_click_items;
        @Config.Comment(value={"Locked time in ticks in spawn dimension.\n-1 - Disabled\n0 - Morning\n6000 - Noon\n12000 - Evening\n18000 - Midnight"})
        @Config.RangeInt(min=-1, max=23999)
        @Config.DefaultInt(value=-1)
        public int forced_spawn_dimension_time;
        @Config.Comment(value={"Locked weather type in spawn dimension.\n-1 - Disabled\n0 - Clear\n1 - Raining\n2 - Thunderstorm"})
        @Config.RangeInt(min=-1, max=2)
        @Config.DefaultInt(value=-1)
        public int forced_spawn_dimension_weather;
        @Config.Comment(value={"Disables player damage when they are stuck in walls."})
        @Config.DefaultBoolean(value=false)
        public boolean disable_player_suffocation_damage;
        @Config.Comment(value={"Show play time in corner."})
        @Config.DefaultBoolean(value=false)
        public boolean show_playtime;
        @Config.Ignore
        private List<DisabledItem> disabledItems = null;

        public boolean blockDimension(int dimension) {
            if (!ClaimedChunks.isActive()) {
                return true;
            }
            for (int i : this.blocked_claiming_dimensions) {
                if (i != dimension) continue;
                return true;
            }
            return false;
        }

        public boolean isItemRightClickDisabled(ItemStack stack) {
            if (this.disabledItems == null) {
                this.disabledItems = new ArrayList<DisabledItem>();
                for (String s : this.disabled_right_click_items) {
                    String[] s1 = s.split("@", 2);
                    Item item = (Item)GameData.getItemRegistry().func_82594_a(s1[0]);
                    if (item == null) continue;
                    DisabledItem di = new DisabledItem();
                    di.item = item;
                    di.metadata = s1.length == 1 || s1[1].startsWith("*") ? Short.MAX_VALUE : Integer.parseInt(s1[1].trim());
                    this.disabledItems.add(di);
                }
            }
            if (this.disabledItems.isEmpty()) {
                return false;
            }
            Item item = stack.func_77973_b();
            int meta = stack.func_77960_j();
            for (DisabledItem disabledItem : this.disabledItems) {
                if (disabledItem.item != item || disabledItem.metadata != Short.MAX_VALUE && disabledItem.metadata != meta) continue;
                return true;
            }
            return false;
        }

        public static class WorldLogging {
            @Config.Comment(value={"Enables world logging."})
            @Config.DefaultBoolean(value=false)
            public boolean enabled;
            @Config.Comment(value={"Includes creative players in world logging."})
            @Config.DefaultBoolean(value=false)
            public boolean include_creative_players;
            @Config.Comment(value={"Includes fake players in world logging."})
            @Config.DefaultBoolean(value=false)
            public boolean include_fake_players;
            @Config.Comment(value={"Logs block placement."})
            @Config.DefaultBoolean(value=true)
            public boolean block_placed;
            @Config.Comment(value={"Logs block breaking."})
            @Config.DefaultBoolean(value=true)
            public boolean block_broken;
            @Config.Comment(value={"Logs item clicking in air."})
            @Config.DefaultBoolean(value=true)
            public boolean item_clicked_in_air;
            @Config.Comment(value={"Logs player attacks on other players/entites."})
            @Config.DefaultBoolean(value=true)
            public boolean entity_attacked;
            @Config.Comment(value={"Exclude mobs from entity attack logging."})
            @Config.DefaultBoolean(value=true)
            public boolean exclude_mob_entity;
            @Config.Comment(value={"Enables chat logging."})
            @Config.DefaultBoolean(value=false)
            public boolean chat_enable;

            public boolean log(EntityPlayerMP player) {
                return !(!this.enabled || !this.include_creative_players && player.field_71075_bZ.field_75098_d || !this.include_fake_players && ServerUtils.isFake(player));
            }
        }

        private static class DisabledItem {
            private Item item;
            private int metadata;

            private DisabledItem() {
            }
        }
    }

    public static class Debugging {
        @Config.Comment(value={"Enables special debug commands."})
        @Config.DefaultBoolean(value=false)
        public boolean special_commands;
        @Config.Comment(value={"Print more info."})
        @Config.DefaultBoolean(value=false)
        public boolean print_more_info;
        @Config.Comment(value={"Print more errors."})
        @Config.DefaultBoolean(value=false)
        public boolean print_more_errors;
        @Config.Comment(value={"Log incoming and outgoing network messages."})
        @Config.DefaultBoolean(value=false)
        public boolean log_network;
        @Config.Comment(value={"Log player teleporting."})
        @Config.DefaultBoolean(value=false)
        public boolean log_teleport;
        @Config.Comment(value={"Log config editing."})
        @Config.DefaultBoolean(value=false)
        public boolean log_config_editing;
        @Config.Comment(value={"See dev-only sidebar buttons. They probably don't do anything."})
        @Config.DefaultBoolean(value=false)
        public boolean dev_sidebar_buttons;
        @Config.Comment(value={"See GUI widget bounds when you hold B."})
        @Config.DefaultBoolean(value=false)
        public boolean gui_widget_bounds;
        @Config.Comment(value={"Log all events that extend EventBase."})
        @Config.DefaultBoolean(value=false)
        public boolean log_events;
        @Config.Comment(value={"Print a message in console every time a chunk is forced or unforced. Recommended to be off, because spam."})
        @Config.DefaultBoolean(value=false)
        public boolean log_chunkloading;
    }

    public static class Backups {
        @Config.Comment(value={"Enables backups."})
        @Config.DefaultBoolean(value=true)
        public boolean enable_backups;
        @Config.Comment(value={"Time between backups in hours. \n1.0 - backups every hour 6.0 - backups every 6 hours 0.5 - backups every 30 minutes."})
        @Config.DefaultDouble(value=0.5)
        public double backup_timer;
        @Config.Comment(value={"Number of backup files to keep before deleting old ones."})
        @Config.DefaultInt(value=12)
        public int backups_to_keep;
        @Config.Comment(value={"How much the backup file will be compressed. 1 - best speed 9 - smallest file size."})
        @Config.DefaultInt(value=1)
        public int compression_level;
        @Config.Comment(value={"Path to backups folder."})
        @Config.DefaultString(value="./backups/")
        public String backup_folder_path;
        @Config.Comment(value={"Run backup in a separated thread (recommended)"})
        @Config.DefaultBoolean(value=true)
        public boolean use_separate_thread;
        @Config.Comment(value={"Prints (current size | total size) when backup is done"})
        @Config.DefaultBoolean(value=true)
        public boolean display_file_size;
        @Config.Comment(value={"Backups won't run if no players are online."})
        @Config.DefaultBoolean(value=true)
        public boolean need_online_players;
        @Config.Comment(value={"Silence backup notifications."})
        @Config.DefaultBoolean(value=false)
        public boolean silent_backup;
        @Config.Comment(value={"Max size of backup folder in GB. If total folder size exceeds this value it will delete old backups until the size is under.\n0 = Disabled and backups_to_keep will be used instead."})
        @Config.DefaultInt(value=0)
        public int max_folder_size;
        @Config.Comment(value={"Delete backups that have a custom name set through /backup start <name>"})
        @Config.DefaultBoolean(value=true)
        public boolean delete_custom_name_backups;
        @Config.Comment(value={"Only include claimed chunks in backup.\nBackups will be much faster and smaller, but any unclaimed chunk will be unrecoverable."})
        @Config.DefaultBoolean(value=false)
        public boolean only_backup_claimed_chunks;
    }

    public static class General {
        @Config.Comment(value={"Merges player profiles, in case player logged in without internet connection/in offline mode server. If set to DEFAULT, it will only merge on singleplayer worlds."})
        @Config.DefaultEnum(value="TRUE")
        public EnumTristate merge_offline_mode_players;
    }

    public static class Teams {
        @Config.Comment(value={"Disable teams entirely"})
        @Config.DefaultBoolean(value=false)
        public boolean disable_teams;
        @Config.Comment(value={"Automatically creates a team for player on multiplayer, based on their username and with a random color."})
        @Config.DefaultBoolean(value=false)
        public boolean autocreate_mp;
        @Config.Comment(value={"Automatically creates (or joins) a team on singleplayer/LAN with ID 'singleplayer'."})
        @Config.DefaultBoolean(value=true)
        public boolean autocreate_sp;
        @Config.Comment(value={"Disable no team notification entirely."})
        @Config.DefaultBoolean(value=false)
        public boolean hide_team_notification;
        @Config.Comment(value={"Don't allow other players to break blocks in claimed chunks"})
        @Config.DefaultBoolean(value=true)
        public boolean grief_protection;
        @Config.Comment(value={"Don't allow other players to interact with blocks in claimed chunks"})
        @Config.DefaultBoolean(value=true)
        public boolean interaction_protection;
        @Config.Comment(value={"Forces player chat messages to be prefixed with their team name. Example: [Team] <Player> Message"})
        @Config.DefaultBoolean(value=false)
        public boolean force_team_prefix;
    }

    public static class Tasks {
        public final Cleanup cleanup = new Cleanup();

        public static class Cleanup {
            @Config.Comment(value={"Enables periodic removal of entities"})
            @Config.DefaultBoolean(value=false)
            public boolean enabled;
            @Config.Comment(value={"How often the cleanup should run in hours"})
            @Config.DefaultDouble(value=2.0)
            public double interval;
            @Config.Comment(value={"Include hostile mobs in cleanup"})
            @Config.DefaultBoolean(value=true)
            public boolean hostiles;
            @Config.Comment(value={"Include passive mobs in cleanup"})
            @Config.DefaultBoolean(value=false)
            public boolean passives;
            @Config.Comment(value={"Include items on the ground in cleanup"})
            @Config.DefaultBoolean(value=true)
            public boolean items;
            @Config.Comment(value={"Include experience orbs in cleanup"})
            @Config.DefaultBoolean(value=true)
            public boolean experience;
            @Config.Comment(value={"Silence cleanup warning that are sent prior to starting"})
            @Config.DefaultBoolean(value=false)
            public boolean silent;
        }
    }
}

