/*
 * Decompiled with CFR 0.152.
 */
package org.lwjglx.opengl;

import java.awt.Canvas;
import java.awt.event.KeyEvent;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Objects;
import java.util.Optional;
import me.eigenraven.lwjgl3ify.Lwjgl3ify;
import me.eigenraven.lwjgl3ify.api.InputEvents;
import me.eigenraven.lwjgl3ify.core.Config;
import me.eigenraven.lwjgl3ify.core.Lwjgl3ifyCoremod;
import net.minecraft.client.Minecraft;
import org.lwjgl.PointerBuffer;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWCharCallback;
import org.lwjgl.glfw.GLFWCharCallbackI;
import org.lwjgl.glfw.GLFWCursorPosCallback;
import org.lwjgl.glfw.GLFWCursorPosCallbackI;
import org.lwjgl.glfw.GLFWFramebufferSizeCallback;
import org.lwjgl.glfw.GLFWFramebufferSizeCallbackI;
import org.lwjgl.glfw.GLFWImage;
import org.lwjgl.glfw.GLFWKeyCallback;
import org.lwjgl.glfw.GLFWKeyCallbackI;
import org.lwjgl.glfw.GLFWMouseButtonCallback;
import org.lwjgl.glfw.GLFWMouseButtonCallbackI;
import org.lwjgl.glfw.GLFWScrollCallback;
import org.lwjgl.glfw.GLFWScrollCallbackI;
import org.lwjgl.glfw.GLFWVidMode;
import org.lwjgl.glfw.GLFWWindowFocusCallback;
import org.lwjgl.glfw.GLFWWindowFocusCallbackI;
import org.lwjgl.glfw.GLFWWindowIconifyCallback;
import org.lwjgl.glfw.GLFWWindowIconifyCallbackI;
import org.lwjgl.glfw.GLFWWindowPosCallback;
import org.lwjgl.glfw.GLFWWindowPosCallbackI;
import org.lwjgl.glfw.GLFWWindowRefreshCallback;
import org.lwjgl.glfw.GLFWWindowRefreshCallbackI;
import org.lwjgl.glfw.GLFWWindowSizeCallback;
import org.lwjgl.glfw.GLFWWindowSizeCallbackI;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL11;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.Platform;
import org.lwjgl.system.Struct;
import org.lwjglx.BufferUtils;
import org.lwjglx.Sys;
import org.lwjglx.input.KeyCodes;
import org.lwjglx.input.Keyboard;
import org.lwjglx.input.Mouse;
import org.lwjglx.opengl.ContextAttribs;
import org.lwjglx.opengl.DisplayImplementation;
import org.lwjglx.opengl.DisplayMode;
import org.lwjglx.opengl.Drawable;
import org.lwjglx.opengl.DrawableGL;
import org.lwjglx.opengl.PixelFormat;
import org.lwjglx.opengl.Sync;
import org.lwjglx.util.Rectangle;

public class Display {
    private static String windowTitle = "Game";
    private static boolean displayCreated = false;
    private static boolean displayFocused = false;
    private static boolean displayVisible = true;
    private static boolean displayDirty = false;
    private static boolean displayResizable = false;
    private static boolean startFullscreen = false;
    private static boolean borderlessInsteadOfFullscreen = true;
    private static DisplayMode mode = new DisplayMode(854, 480);
    private static DisplayMode desktopDisplayMode = new DisplayMode(854, 480);
    private static int latestEventKey = 0;
    private static int displayX = 0;
    private static int displayY = 0;
    private static boolean displayResized = false;
    private static int displayWidth = 0;
    private static int displayHeight = 0;
    private static int displayFramebufferWidth = 0;
    private static int displayFramebufferHeight = 0;
    private static boolean latestResized = false;
    private static int latestWidth = 0;
    private static int latestHeight = 0;
    private static boolean cancelNextChar = false;
    private static Keyboard.KeyEvent ingredientKeyEvent;
    private static ByteBuffer[] savedIcons;
    private static boolean lastAltIsRightAlt;
    private static HashMap<Integer, String> glfwKeycodeNames;
    private static int[] savedX;
    private static int[] savedY;
    private static int[] savedW;
    private static int[] savedH;
    protected static DrawableGL drawable;

    public static void create(PixelFormat pixelFormat, Drawable sharedDrawable) {
        Display.create(pixelFormat, null, sharedDrawable.getGlfwWindowId());
    }

    public static void create() {
        Display.create(null, (ContextAttribs)null);
    }

    public static void create(PixelFormat pixelFormat) {
        Display.create(pixelFormat, (ContextAttribs)null);
    }

    public static void create(PixelFormat pixelFormat, ContextAttribs attribs) {
        Display.create(pixelFormat, attribs, 0L);
    }

    public static void create(PixelFormat pixelFormat, ContextAttribs attribs, long sharedWindow) {
        if (displayCreated) {
            return;
        }
        long monitor = GLFW.glfwGetPrimaryMonitor();
        GLFWVidMode vidmode = GLFW.glfwGetVideoMode((long)monitor);
        int monitorWidth = vidmode.width();
        int monitorHeight = vidmode.height();
        int monitorBitPerPixel = vidmode.redBits() + vidmode.greenBits() + vidmode.blueBits();
        int monitorRefreshRate = vidmode.refreshRate();
        desktopDisplayMode = new DisplayMode(monitorWidth, monitorHeight, monitorBitPerPixel, monitorRefreshRate);
        int ctxMajor = attribs != null ? attribs.getMajorVersion() : 2;
        int ctxMinor = attribs != null ? attribs.getMinorVersion() : 1;
        boolean ctxForwardCompat = attribs != null && attribs.isForwardCompatible();
        boolean ctxSrgb = pixelFormat != null ? pixelFormat.isSRGB() : Config.OPENGL_SRGB_CONTEXT;
        GLFW.glfwDefaultWindowHints();
        GLFW.glfwWindowHint((int)131076, (int)1);
        GLFW.glfwWindowHint((int)131075, (int)1);
        GLFW.glfwWindowHint((int)139266, (int)ctxMajor);
        GLFW.glfwWindowHint((int)139267, (int)ctxMinor);
        GLFW.glfwWindowHint((int)139270, (int)(ctxForwardCompat ? 1 : 0));
        if (attribs != null) {
            if (attribs.isProfileCore()) {
                GLFW.glfwWindowHint((int)139272, (int)204801);
            } else if (attribs.isProfileCompatibility()) {
                GLFW.glfwWindowHint((int)139272, (int)204802);
            }
        }
        GLFW.glfwWindowHint((int)131080, (int)(Config.WINDOW_START_MAXIMIZED ? 1 : 0));
        GLFW.glfwWindowHint((int)131073, (int)(Config.WINDOW_START_FOCUSED ? 1 : 0));
        displayFocused = Config.WINDOW_START_FOCUSED;
        GLFW.glfwWindowHint((int)131074, (int)(Config.WINDOW_START_ICONIFIED ? 1 : 0));
        displayVisible = !Config.WINDOW_START_ICONIFIED;
        GLFW.glfwWindowHint((int)131077, (int)(Config.WINDOW_DECORATED ? 1 : 0));
        GLFW.glfwWindowHint((int)135182, (int)(ctxSrgb ? 1 : 0));
        GLFW.glfwWindowHint((int)135184, (int)(Config.OPENGL_DOUBLEBUFFER ? 1 : 0));
        GLFW.glfwWindowHint((int)139274, (int)(Config.OPENGL_CONTEXT_NO_ERROR ? 1 : 0));
        GLFW.glfwWindowHint((int)139271, (int)(Config.OPENGL_DEBUG_CONTEXT || Config.DEBUG_REGISTER_OPENGL_LOGGER ? 1 : 0));
        GLFW.glfwWindowHint((int)139271, (int)(Config.OPENGL_DEBUG_CONTEXT || Config.DEBUG_REGISTER_OPENGL_LOGGER ? 1 : 0));
        GLFW.glfwWindowHintString((int)147457, (CharSequence)Config.X11_CLASS_NAME);
        GLFW.glfwWindowHintString((int)143362, (CharSequence)Config.COCOA_FRAME_NAME);
        if (Config.WINDOW_CENTERED) {
            GLFW.glfwWindowHint((int)131086, (int)((monitorWidth - mode.getWidth()) / 2));
            GLFW.glfwWindowHint((int)131087, (int)((monitorHeight - mode.getHeight()) / 2));
        }
        if ((Window.handle = GLFW.glfwCreateWindow((int)mode.getWidth(), (int)mode.getHeight(), (CharSequence)windowTitle, (long)0L, (long)sharedWindow)) == 0L) {
            throw new IllegalStateException("Failed to create Display window");
        }
        Window.keyCallback = new GLFWKeyCallback(){

            public void invoke(long window, int key, int scancode, int action, int mods) {
                InputEvents.KeyAction keyAction;
                if (Config.DEBUG_PRINT_KEY_EVENTS) {
                    Lwjgl3ify.LOG.info("[DEBUG-KEY] key window:{} key:{} ({}) scancode:{} action:{} mods:{} charname:{} naive-char:{}", new Object[]{window, key, glfwKeycodeNames.getOrDefault(key, "unknown"), scancode, action == 1 ? "PRESS" : (action == 0 ? "RELEASE" : "REPEAT"), mods, KeyEvent.getKeyText(KeyCodes.lwjglToAwt(KeyCodes.glfwToLwjgl(key))), Character.valueOf(key >= 32 && key < 127 ? (char)key : (char)'?')});
                }
                switch (action) {
                    case 1: {
                        keyAction = InputEvents.KeyAction.PRESSED;
                        break;
                    }
                    case 0: {
                        keyAction = InputEvents.KeyAction.RELEASED;
                        break;
                    }
                    case 2: {
                        keyAction = InputEvents.KeyAction.REPEATED;
                        break;
                    }
                    default: {
                        keyAction = InputEvents.KeyAction.PRESSED;
                    }
                }
                InputEvents.KeyAction enumAction = keyAction;
                InputEvents.injectKeyEvent(new InputEvents.KeyEvent(KeyCodes.glfwToLwjgl(key), key, scancode, enumAction, (mods & 2) != 0, (mods & 1) != 0, (mods & 4) != 0, (mods & 8) != 0));
                cancelNextChar = false;
                if (action == 1) {
                    if (key == 342) {
                        lastAltIsRightAlt = false;
                    } else if (key == 346) {
                        lastAltIsRightAlt = true;
                    }
                }
                if (key > 32 && key <= 96) {
                    boolean ctrlGraphicalMode;
                    boolean isAlt = (4 & mods) != 0;
                    boolean isAltGr = lastAltIsRightAlt;
                    if (isAlt) {
                        ctrlGraphicalMode = isAltGr ? !Config.INPUT_ALTGR_ESCAPE_CODES : Config.INPUT_CTRL_ALT_TEXT;
                        if (ctrlGraphicalMode) {
                            Keyboard.addGlfwKeyEvent(window, key, scancode, action, mods, (char)(key & 0x1F));
                        }
                    } else {
                        ctrlGraphicalMode = false;
                    }
                    if ((8 & mods) != 0) {
                        Keyboard.addGlfwKeyEvent(window, key, scancode, action, mods, (char)key);
                        if (Platform.get() != Platform.MACOSX) {
                            cancelNextChar = true;
                        }
                    } else if ((2 & mods) != 0 && !ctrlGraphicalMode) {
                        if (Config.DEBUG_PRINT_KEY_EVENTS) {
                            Lwjgl3ify.LOG.info("[DEBUG-KEY] Handling key as escape code, skipping next char input. isAlt:{} isAltGr:{}", new Object[]{isAlt, isAltGr});
                        }
                        Keyboard.addGlfwKeyEvent(window, key, scancode, action, mods, (char)(key & 0x1F));
                        cancelNextChar = true;
                    } else if (action > 0) {
                        ingredientKeyEvent = new Keyboard.KeyEvent(KeyCodes.glfwToLwjgl(key), '\u0000', action > 1 ? Keyboard.KeyState.REPEAT : Keyboard.KeyState.PRESS, Sys.getNanoTime());
                    } else {
                        if (ingredientKeyEvent != null && ingredientKeyEvent.key == KeyCodes.glfwToLwjgl(key)) {
                            ingredientKeyEvent.queueOutOfOrderRelease = true;
                        }
                        Keyboard.addGlfwKeyEvent(window, key, scancode, action, mods, '\u0000');
                    }
                } else {
                    char c;
                    switch (key) {
                        case 257: {
                            c = '\r';
                            break;
                        }
                        case 256: {
                            c = '\u001b';
                            break;
                        }
                        case 258: {
                            c = '\t';
                            break;
                        }
                        case 259: {
                            c = '\b';
                            break;
                        }
                        default: {
                            c = '\u0000';
                        }
                    }
                    char mappedChar = c;
                    Keyboard.addGlfwKeyEvent(window, key, scancode, action, mods, mappedChar);
                }
            }
        };
        Window.charCallback = new GLFWCharCallback(){

            public void invoke(long window, int codepoint) {
                if (Config.DEBUG_PRINT_KEY_EVENTS) {
                    Lwjgl3ify.LOG.info("[DEBUG-KEY] char window:{} codepoint:{} char:{}", new Object[]{window, codepoint, Character.valueOf((char)codepoint)});
                }
                InputEvents.injectTextEvent(new InputEvents.TextEvent(String.valueOf((char)codepoint)));
                if (cancelNextChar) {
                    cancelNextChar = false;
                } else if (ingredientKeyEvent != null) {
                    ingredientKeyEvent.aChar = (char)codepoint;
                    Keyboard.addRawKeyEvent(ingredientKeyEvent);
                    if (ingredientKeyEvent.queueOutOfOrderRelease) {
                        ingredientKeyEvent = ingredientKeyEvent.copy();
                        ingredientKeyEvent.state = Keyboard.KeyState.RELEASE;
                        Keyboard.addRawKeyEvent(ingredientKeyEvent);
                    }
                    ingredientKeyEvent = null;
                } else {
                    Keyboard.addCharEvent(0, (char)codepoint);
                }
            }
        };
        Window.cursorPosCallback = new GLFWCursorPosCallback(){

            public void invoke(long window, double xpos, double ypos) {
                if (Config.DEBUG_PRINT_MOUSE_EVENTS) {
                    Lwjgl3ify.LOG.info("[DEBUG-MOUSE] cursorPos window:{} xpos:{} ypos:{}", new Object[]{window, xpos, ypos});
                }
                Mouse.addMoveEvent(xpos, ypos);
            }
        };
        Window.mouseButtonCallback = new GLFWMouseButtonCallback(){

            public void invoke(long window, int button, int action, int mods) {
                if (Config.DEBUG_PRINT_MOUSE_EVENTS) {
                    Lwjgl3ify.LOG.info("[DEBUG-MOUSE] button window:{} button:{} action:{} mods:{}", new Object[]{window, button, action, mods});
                }
                Mouse.addButtonEvent(button, action == 1);
            }
        };
        Window.scrollCallback = new GLFWScrollCallback(){

            public void invoke(long window, double xoffset, double yoffset) {
                if (Config.DEBUG_PRINT_MOUSE_EVENTS) {
                    Lwjgl3ify.LOG.info("[DEBUG-MOUSE] wheel window:{} xoffset:{} yoffset:{}", new Object[]{window, xoffset, yoffset});
                }
                Mouse.addWheelEvent(yoffset == 0.0 ? (Config.INPUT_INVERT_X_WHEEL ? -xoffset : xoffset) : yoffset);
            }
        };
        Window.windowFocusCallback = new GLFWWindowFocusCallback(){

            public void invoke(long window, boolean focused) {
                if (Config.DEBUG_PRINT_MOUSE_EVENTS) {
                    Lwjgl3ify.LOG.info("[DEBUG-MOUSE] focus window:{} focus:{}", new Object[]{window, focused});
                }
                displayFocused = focused;
            }
        };
        Window.windowIconifyCallback = new GLFWWindowIconifyCallback(){

            public void invoke(long window, boolean iconified) {
                if (Config.DEBUG_PRINT_MOUSE_EVENTS) {
                    Lwjgl3ify.LOG.info("[DEBUG-MOUSE] focus window:{} iconified:{}", new Object[]{window, iconified});
                }
                displayVisible = !iconified;
            }
        };
        Window.windowSizeCallback = new GLFWWindowSizeCallback(){

            public void invoke(long window, int width, int height) {
                if (Config.DEBUG_PRINT_MOUSE_EVENTS) {
                    Lwjgl3ify.LOG.info("[DEBUG-MOUSE] window-resize window:{} w:{} h:{}", new Object[]{window, width, height});
                }
                latestResized = true;
                latestWidth = width;
                latestHeight = height;
            }
        };
        Window.windowPosCallback = new GLFWWindowPosCallback(){

            public void invoke(long window, int xpos, int ypos) {
                displayX = xpos;
                displayY = ypos;
            }
        };
        Window.windowRefreshCallback = new GLFWWindowRefreshCallback(){

            public void invoke(long window) {
                displayDirty = true;
            }
        };
        Window.framebufferSizeCallback = new GLFWFramebufferSizeCallback(){

            public void invoke(long window, int width, int height) {
                if (Config.DEBUG_PRINT_MOUSE_EVENTS) {
                    Lwjgl3ify.LOG.info("[DEBUG-MOUSE] framebuffer-resize window:{} w:{} h:{}", new Object[]{window, width, height});
                }
                displayFramebufferWidth = width;
                displayFramebufferHeight = height;
            }
        };
        Window.setCallbacks();
        displayWidth = mode.getWidth();
        displayHeight = mode.getHeight();
        try (MemoryStack stack = MemoryStack.stackPush();){
            IntBuffer fbw = stack.mallocInt(1);
            IntBuffer fbh = stack.mallocInt(1);
            GLFW.glfwGetFramebufferSize((long)Window.handle, (IntBuffer)fbw, (IntBuffer)fbh);
            displayFramebufferWidth = fbw.get(0);
            displayFramebufferHeight = fbh.get(0);
        }
        displayX = (monitorWidth - mode.getWidth()) / 2;
        displayY = (monitorHeight - mode.getHeight()) / 2;
        GLFW.glfwMakeContextCurrent((long)Window.handle);
        drawable = new DrawableGL();
        GL.createCapabilities();
        if (savedIcons != null) {
            Display.setIcon(savedIcons);
            savedIcons = null;
        }
        GLFW.glfwSwapInterval((int)1);
        displayCreated = true;
        Display.lwjgl3ify$updateRawMouseMode(Config.INPUT_RAW_MOUSE);
        if (startFullscreen) {
            Display.setFullscreen(true);
        }
        int[] x = new int[1];
        int[] y = new int[1];
        GLFW.glfwGetWindowSize((long)Window.handle, (int[])x, (int[])y);
        Window.windowSizeCallback.invoke(Window.handle, x[0], y[0]);
        GLFW.glfwGetFramebufferSize((long)Window.handle, (int[])x, (int[])y);
        Window.framebufferSizeCallback.invoke(Window.handle, x[0], y[0]);
    }

    public static void lwjgl3ify$updateRawMouseMode(boolean mode) {
        boolean supported = GLFW.glfwRawMouseMotionSupported();
        if (Display.isCreated()) {
            if (supported) {
                GLFW.glfwSetInputMode((long)Window.handle, (int)208901, (int)(mode ? 1 : 0));
                Lwjgl3ifyCoremod.LOGGER.info("Updated raw mouse input mode to " + mode);
            } else if (mode) {
                Lwjgl3ifyCoremod.LOGGER.warn("Raw mouse input not supported on your system.");
            }
        }
    }

    public static boolean isCreated() {
        return displayCreated;
    }

    public static boolean isActive() {
        return displayFocused;
    }

    public static boolean isVisible() {
        return displayVisible;
    }

    public static void setLocation(int new_x, int new_y) {
        System.out.println("TODO: Implement Display.setLocation(int, int)");
    }

    public static void setVSyncEnabled(boolean sync) {
        GLFW.glfwSwapInterval((int)(sync ? 1 : 0));
    }

    public static long getWindow() {
        return Window.handle;
    }

    public static void update() {
        Display.update(true);
    }

    public static void update(boolean processMessages) {
        Display.swapBuffers();
        displayDirty = false;
        if (processMessages) {
            Display.processMessages();
        }
    }

    public static void processMessages() {
        GLFW.glfwPollEvents();
        Keyboard.poll();
        Mouse.poll();
        if (latestResized) {
            latestResized = false;
            displayResized = true;
            displayWidth = latestWidth;
            displayHeight = latestHeight;
        } else {
            displayResized = false;
        }
    }

    public static void swapBuffers() {
        GLFW.glfwSwapBuffers((long)Window.handle);
    }

    public static void destroy() {
        Window.releaseCallbacks();
        GLFW.glfwDestroyWindow((long)Window.handle);
        displayCreated = false;
    }

    public static void setDisplayMode(DisplayMode dm) {
        mode = dm;
    }

    public static DisplayMode getDisplayMode() {
        return mode;
    }

    public static DisplayMode[] getAvailableDisplayModes() {
        IntBuffer count = BufferUtils.createIntBuffer(1);
        GLFWVidMode.Buffer modes = GLFW.glfwGetVideoModes((long)GLFW.glfwGetPrimaryMonitor());
        DisplayMode[] displayModes = new DisplayMode[count.get(0)];
        for (int i = 0; i < count.get(0); ++i) {
            modes.position(i * GLFWVidMode.SIZEOF);
            int w = modes.width();
            int h = modes.height();
            int b = modes.redBits() + modes.greenBits() + modes.blueBits();
            int r = modes.refreshRate();
            displayModes[i] = new DisplayMode(w, h, b, r);
        }
        return displayModes;
    }

    public static DisplayMode getDesktopDisplayMode() {
        return desktopDisplayMode;
    }

    public static boolean wasResized() {
        return displayResized;
    }

    public static int getX() {
        return displayX;
    }

    public static int getY() {
        return displayY;
    }

    public static int getWidth() {
        return displayFramebufferWidth;
    }

    public static int getHeight() {
        return displayFramebufferHeight;
    }

    public static void setTitle(String title) {
        windowTitle = title;
        if (Display.isCreated()) {
            GLFW.glfwSetWindowTitle((long)Display.getWindow(), (CharSequence)title);
        }
    }

    public static boolean isCloseRequested() {
        boolean saved = GLFW.glfwWindowShouldClose((long)Window.handle);
        GLFW.glfwSetWindowShouldClose((long)Window.handle, (boolean)false);
        return saved;
    }

    public static boolean isDirty() {
        return displayDirty;
    }

    public static void setInitialBackground(float red, float green, float blue) {
    }

    public static int setIcon(ByteBuffer[] icons) {
        if (Display.getWindow() == 0L) {
            savedIcons = icons;
            return 0;
        }
        GLFWImage.Buffer glfwImages = GLFWImage.calloc((int)icons.length);
        try (MemoryStack stack = MemoryStack.stackPush();){
            ByteBuffer[] nativeBuffers = new ByteBuffer[icons.length];
            for (int icon = 0; icon < icons.length; ++icon) {
                nativeBuffers[icon] = stack.malloc(icons[icon].capacity());
                nativeBuffers[icon].put(icons[icon]);
                nativeBuffers[icon].flip();
                int dimension = (int)Math.sqrt((double)nativeBuffers[icon].limit() / 4.0);
                if (dimension * dimension * 4 != nativeBuffers[icon].limit()) {
                    throw new IllegalStateException();
                }
                glfwImages.put(icon, (Struct)GLFWImage.create().set(dimension, dimension, nativeBuffers[icon]));
            }
            GLFW.glfwSetWindowIcon((long)Display.getWindow(), (GLFWImage.Buffer)glfwImages);
        }
        glfwImages.free();
        return 0;
    }

    public static void setResizable(boolean resizable) {
        displayResizable = resizable;
    }

    public static boolean isResizable() {
        return displayResizable;
    }

    public static void setDisplayModeAndFullscreen(DisplayMode mode) {
        System.out.println("TODO: Implement Display.setDisplayModeAndFullscreen(DisplayMode)");
    }

    public static PositionedGLFWVidMode getTargetFullscreenMonitor() {
        int x = savedX[0] + savedW[0] / 2;
        int y = savedY[0] + savedH[0] / 2;
        PointerBuffer monitors = GLFW.glfwGetMonitors();
        assert (monitors != null);
        ArrayList<PositionedGLFWVidMode> monitorInfos = new ArrayList<PositionedGLFWVidMode>(monitors.limit());
        for (int i = 0; i < monitors.limit(); ++i) {
            long monitor = monitors.get(i);
            PositionedGLFWVidMode monitorInfo = Display.getPositionedMonitorInfo(monitor);
            monitorInfos.add(monitorInfo);
            if (!monitorInfo.bounds.contains(x, y)) continue;
            return monitorInfo;
        }
        Rectangle windowBounds = new Rectangle(savedX[0], savedY[0], savedW[0], savedH[0]);
        Optional<PositionedGLFWVidMode> targetMonitor = monitorInfos.stream().filter(o -> !((PositionedGLFWVidMode)o).bounds.intersection(windowBounds, null).isEmpty()).max(Comparator.comparingInt(o -> ((PositionedGLFWVidMode)o).bounds.intersection(windowBounds, null).getArea()));
        return targetMonitor.orElse(Display.getPositionedMonitorInfo(GLFW.glfwGetPrimaryMonitor()));
    }

    private static PositionedGLFWVidMode getPositionedMonitorInfo(long monitorId) {
        int y;
        int x;
        try (MemoryStack stack = MemoryStack.stackPush();){
            IntBuffer posX = stack.mallocInt(1);
            IntBuffer posY = stack.mallocInt(1);
            GLFW.glfwGetMonitorPos((long)monitorId, (IntBuffer)posX, (IntBuffer)posY);
            x = posX.get(0);
            y = posY.get(0);
        }
        GLFWVidMode vidmode = GLFW.glfwGetVideoMode((long)monitorId);
        assert (vidmode != null);
        return new PositionedGLFWVidMode(x, y, new Rectangle(x, y, vidmode.width(), vidmode.height()), monitorId, vidmode);
    }

    public static void setFullscreen(boolean fullscreen) {
        long window = Display.getWindow();
        if (window == 0L) {
            startFullscreen = fullscreen;
            return;
        }
        boolean currentState = Display.isFullscreen();
        if (currentState == fullscreen) {
            return;
        }
        GLFW.glfwSetWindowSizeLimits((long)window, (int)0, (int)0, (int)-1, (int)-1);
        if (fullscreen) {
            GLFW.glfwGetWindowPos((long)window, (int[])savedX, (int[])savedY);
            GLFW.glfwGetWindowSize((long)window, (int[])savedW, (int[])savedH);
            PositionedGLFWVidMode monitorInfo = Display.getTargetFullscreenMonitor();
            GLFWVidMode vidMode = monitorInfo.vidMode;
            GLFW.glfwSetWindowMonitor((long)window, (long)monitorInfo.monitorId, (int)0, (int)0, (int)vidMode.width(), (int)vidMode.height(), (int)vidMode.refreshRate());
            Minecraft.func_71410_x().func_71370_a(vidMode.width(), vidMode.height());
        } else {
            GLFW.glfwSetWindowSize((long)window, (int)savedW[0], (int)savedH[0]);
            GLFW.glfwSetWindowMonitor((long)window, (long)0L, (int)savedX[0], (int)savedY[0], (int)savedW[0], (int)savedH[0], (int)0);
        }
    }

    public static void toggleBorderless() {
        Display.setBorderless(!Display.isBorderless());
    }

    public static void setBorderless(boolean toBorderless) {
        long window = Display.getWindow();
        if (window == 0L) {
            return;
        }
        if (toBorderless) {
            GLFW.glfwGetWindowPos((long)window, (int[])savedX, (int[])savedY);
            GLFW.glfwGetWindowSize((long)window, (int[])savedW, (int[])savedH);
            PositionedGLFWVidMode monitorInfo = Display.getTargetFullscreenMonitor();
            GLFWVidMode vidMode = monitorInfo.vidMode;
            int height = vidMode.height();
            if (Config.WINDOW_BORDERLESS_WINDOWS_COMPATIBILITY && System.getProperty("os.name").toLowerCase().contains("win")) {
                ++height;
            }
            GLFW.glfwSetWindowSizeLimits((long)window, (int)0, (int)0, (int)vidMode.width(), (int)height);
            GLFW.glfwSetWindowSize((long)window, (int)vidMode.width(), (int)height);
            GLFW.glfwSetWindowMonitor((long)window, (long)0L, (int)monitorInfo.x, (int)monitorInfo.y, (int)vidMode.width(), (int)height, (int)vidMode.refreshRate());
        } else {
            GLFW.glfwSetWindowSizeLimits((long)window, (int)0, (int)0, (int)-1, (int)-1);
            GLFW.glfwSetWindowSize((long)window, (int)savedW[0], (int)savedH[0]);
            GLFW.glfwSetWindowMonitor((long)window, (long)0L, (int)savedX[0], (int)savedY[0], (int)savedW[0], (int)savedH[0], (int)0);
        }
    }

    public static boolean isBorderless() {
        long window = Display.getWindow();
        long windowMonitor = GLFW.glfwGetWindowMonitor((long)Display.getWindow());
        if (Display.getWindow() != 0L && windowMonitor == 0L) {
            try (MemoryStack stack = MemoryStack.stackPush();){
                IntBuffer windowX = stack.mallocInt(1);
                IntBuffer windowY = stack.mallocInt(1);
                IntBuffer windowWidth = stack.mallocInt(1);
                IntBuffer windowHeight = stack.mallocInt(1);
                GLFW.glfwGetWindowPos((long)window, (IntBuffer)windowX, (IntBuffer)windowY);
                GLFW.glfwGetWindowSize((long)window, (IntBuffer)windowWidth, (IntBuffer)windowHeight);
                PositionedGLFWVidMode monitorInfo = Display.getTargetFullscreenMonitor();
                GLFWVidMode vidMode = monitorInfo.vidMode();
                boolean bl = windowX.get(0) == monitorInfo.x() && windowY.get(0) == monitorInfo.y() && windowWidth.get(0) == vidMode.width() && windowHeight.get(0) >= vidMode.height();
                return bl;
            }
        }
        return false;
    }

    public static boolean isFullscreen() {
        if (Display.getWindow() != 0L) {
            return GLFW.glfwGetWindowMonitor((long)Display.getWindow()) != 0L;
        }
        return false;
    }

    public static void setParent(Canvas parent) {
    }

    public static void releaseContext() {
        GLFW.glfwMakeContextCurrent((long)0L);
    }

    public static boolean isCurrent() {
        return true;
    }

    public static void makeCurrent() {
        GLFW.glfwMakeContextCurrent((long)Window.handle);
    }

    public static String getAdapter() {
        if (Display.isCreated()) {
            return GL11.glGetString((int)7936);
        }
        return "Unknown";
    }

    public static String getVersion() {
        if (Display.isCreated()) {
            return GL11.glGetString((int)7938);
        }
        return "Unknown";
    }

    public static String getTitle() {
        return windowTitle;
    }

    public static Canvas getParent() {
        return null;
    }

    public static float getPixelScaleFactor() {
        if (!Display.isCreated()) {
            return 1.0f;
        }
        int[] windowWidth = new int[1];
        int[] windowHeight = new int[1];
        int[] framebufferWidth = new int[1];
        int[] framebufferHeight = new int[1];
        GLFW.glfwGetWindowSize((long)Display.getWindow(), (int[])windowWidth, (int[])windowHeight);
        GLFW.glfwGetFramebufferSize((long)Display.getWindow(), (int[])framebufferWidth, (int[])framebufferHeight);
        float xScale = (float)framebufferWidth[0] / (float)windowWidth[0];
        float yScale = (float)framebufferHeight[0] / (float)windowHeight[0];
        return Math.max(xScale, yScale);
    }

    public static void setSwapInterval(int value) {
        GLFW.glfwSwapInterval((int)value);
    }

    public static void setDisplayConfiguration(float gamma, float brightness, float contrast) {
    }

    public static void sync(int fps) {
        Sync.sync(fps);
    }

    public static Drawable getDrawable() {
        return drawable;
    }

    static DisplayImplementation getImplementation() {
        return null;
    }

    static {
        lastAltIsRightAlt = false;
        glfwKeycodeNames = new HashMap();
        Sys.initialize();
        long monitor = GLFW.glfwGetPrimaryMonitor();
        GLFWVidMode vidmode = GLFW.glfwGetVideoMode((long)monitor);
        int monitorWidth = vidmode.width();
        int monitorHeight = vidmode.height();
        int monitorBitPerPixel = vidmode.redBits() + vidmode.greenBits() + vidmode.blueBits();
        int monitorRefreshRate = vidmode.refreshRate();
        desktopDisplayMode = new DisplayMode(monitorWidth, monitorHeight, monitorBitPerPixel, monitorRefreshRate);
        try {
            Class<GLFW> glfwClass = GLFW.class;
            for (Field f : glfwClass.getFields()) {
                if (!f.getName().startsWith("GLFW_KEY_") || f.getType() != Integer.TYPE || !Modifier.isStatic(f.getModifiers())) continue;
                int value = f.getInt(null);
                glfwKeycodeNames.put(value, f.getName());
            }
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            // empty catch block
        }
        savedX = new int[1];
        savedY = new int[1];
        savedW = new int[1];
        savedH = new int[1];
        drawable = null;
    }

    private static class Window {
        static long handle;
        static GLFWKeyCallback keyCallback;
        static GLFWCharCallback charCallback;
        static GLFWCursorPosCallback cursorPosCallback;
        static GLFWMouseButtonCallback mouseButtonCallback;
        static GLFWScrollCallback scrollCallback;
        static GLFWWindowFocusCallback windowFocusCallback;
        static GLFWWindowIconifyCallback windowIconifyCallback;
        static GLFWWindowSizeCallback windowSizeCallback;
        static GLFWWindowPosCallback windowPosCallback;
        static GLFWWindowRefreshCallback windowRefreshCallback;
        static GLFWFramebufferSizeCallback framebufferSizeCallback;

        private Window() {
        }

        public static void setCallbacks() {
            GLFW.glfwSetKeyCallback((long)handle, (GLFWKeyCallbackI)keyCallback);
            GLFW.glfwSetCharCallback((long)handle, (GLFWCharCallbackI)charCallback);
            GLFW.glfwSetCursorPosCallback((long)handle, (GLFWCursorPosCallbackI)cursorPosCallback);
            GLFW.glfwSetMouseButtonCallback((long)handle, (GLFWMouseButtonCallbackI)mouseButtonCallback);
            GLFW.glfwSetScrollCallback((long)handle, (GLFWScrollCallbackI)scrollCallback);
            GLFW.glfwSetWindowFocusCallback((long)handle, (GLFWWindowFocusCallbackI)windowFocusCallback);
            GLFW.glfwSetWindowIconifyCallback((long)handle, (GLFWWindowIconifyCallbackI)windowIconifyCallback);
            GLFW.glfwSetWindowSizeCallback((long)handle, (GLFWWindowSizeCallbackI)windowSizeCallback);
            GLFW.glfwSetWindowPosCallback((long)handle, (GLFWWindowPosCallbackI)windowPosCallback);
            GLFW.glfwSetWindowRefreshCallback((long)handle, (GLFWWindowRefreshCallbackI)windowRefreshCallback);
            GLFW.glfwSetFramebufferSizeCallback((long)handle, (GLFWFramebufferSizeCallbackI)framebufferSizeCallback);
        }

        public static void releaseCallbacks() {
            keyCallback.free();
            charCallback.free();
            cursorPosCallback.free();
            mouseButtonCallback.free();
            scrollCallback.free();
            windowFocusCallback.free();
            windowIconifyCallback.free();
            windowSizeCallback.free();
            windowPosCallback.free();
            windowRefreshCallback.free();
            framebufferSizeCallback.free();
        }
    }

    public static final class PositionedGLFWVidMode {
        private final int x;
        private final int y;
        private final Rectangle bounds;
        private final long monitorId;
        private final GLFWVidMode vidMode;

        public PositionedGLFWVidMode(int x, int y, Rectangle bounds, long monitorId, GLFWVidMode vidMode) {
            this.x = x;
            this.y = y;
            this.bounds = bounds;
            this.monitorId = monitorId;
            this.vidMode = vidMode;
        }

        public String toString() {
            return "PositionedGLFWVidMode[" + "x=" + this.x + "," + "y=" + this.y + "," + "bounds=" + this.bounds + "," + "monitorId=" + this.monitorId + "," + "vidMode=" + this.vidMode + "]";
        }

        public int hashCode() {
            int result = 0;
            result = 31 * result + this.x;
            result = 31 * result + this.y;
            result = 31 * result + (this.bounds != null ? this.bounds.hashCode() : 0);
            result = 31 * result + (int)(this.monitorId ^ this.monitorId >>> 32);
            result = 31 * result + (this.vidMode != null ? this.vidMode.hashCode() : 0);
            return result;
        }

        public final boolean equals(Object arg0) {
            if (this == arg0) {
                return true;
            }
            if (arg0 == null) {
                return false;
            }
            if (arg0.getClass() != this.getClass()) {
                return false;
            }
            if (((PositionedGLFWVidMode)arg0).x != this.x) {
                return false;
            }
            if (((PositionedGLFWVidMode)arg0).y != this.y) {
                return false;
            }
            if (!Objects.equals(((PositionedGLFWVidMode)arg0).bounds, this.bounds)) {
                return false;
            }
            if (((PositionedGLFWVidMode)arg0).monitorId != this.monitorId) {
                return false;
            }
            return Objects.equals(((PositionedGLFWVidMode)arg0).vidMode, this.vidMode);
            {
            }
        }

        public int x() {
            return this.x;
        }

        public int y() {
            return this.y;
        }

        public Rectangle bounds() {
            return this.bounds;
        }

        public long monitorId() {
            return this.monitorId;
        }

        public GLFWVidMode vidMode() {
            return this.vidMode;
        }
    }
}

