/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.scrollpane;

import com.github.weisj.darklaf.graphics.DefaultInterpolator;
import com.github.weisj.darklaf.graphics.LegacyAnimator;
import com.github.weisj.darklaf.ui.scrollpane.DarkScrollBarUI;
import com.github.weisj.darklaf.ui.scrollpane.ScrollBarConstants;
import com.github.weisj.darklaf.ui.scrollpane.ScrollBarUtil;
import com.github.weisj.darklaf.util.PropertyUtil;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class DarkScrollBarListener<T extends DarkScrollBarUI>
extends MouseAdapter
implements AdjustmentListener,
ScrollBarConstants {
    private static final float MAX_TRACK_ALPHA = 0.3f;
    private static final float MAX_THUMB_ALPHA = 0.7f;
    protected static final int FADE_RESOLUTION = 10;
    protected static final int TRACK_FADE_OUT_DURATION = 400;
    protected static final int TRACK_FADE_OUT_DELAY = 100;
    protected static final int TRACK_FADE_IN_DURATION = 200;
    protected static final int TRACK_FADE_IN_DELAY = 0;
    protected static final int THUMB_FADE_OUT_DURATION = 400;
    protected static final int THUMB_FADE_OUT_DELAY = 100;
    protected static final int THUMB_FADE_IN_DURATION = 200;
    protected static final int THUMB_FADE_IN_DELAY = 0;
    protected final JScrollBar scrollbar;
    protected final T ui;
    private final LegacyAnimator trackFadeoutAnimator;
    private final LegacyAnimator trackFadeinAnimator;
    private final LegacyAnimator thumbFadeoutAnimator;
    private final LegacyAnimator thumbFadeinAnimator;
    protected boolean mouseOverThumb = false;
    protected boolean mouseOverTrack = false;
    protected float trackState;
    protected float thumbState;
    protected float trackAlpha;
    protected float thumbAlpha;

    public DarkScrollBarListener(JScrollBar scrollbar, T ui) {
        this.scrollbar = scrollbar;
        this.ui = ui;
        boolean animationsEnabled = UIManager.getBoolean("ScrollBar.animated");
        this.trackFadeoutAnimator = this.createTrackFadeoutAnimator();
        this.trackFadeinAnimator = this.createTrackFadeinAnimator();
        this.thumbFadeoutAnimator = this.createThumbFadeoutAnimator();
        this.thumbFadeinAnimator = this.createThumbFadeinAnimator();
        if (this.trackFadeoutAnimator != null) {
            this.trackFadeoutAnimator.setEnabled(animationsEnabled);
        }
        if (this.trackFadeinAnimator != null) {
            this.trackFadeinAnimator.setEnabled(animationsEnabled);
        }
        if (this.thumbFadeoutAnimator != null) {
            this.thumbFadeoutAnimator.setEnabled(animationsEnabled);
        }
        if (this.thumbFadeinAnimator != null) {
            this.thumbFadeinAnimator.setEnabled(animationsEnabled);
        }
    }

    public void uninstall() {
        this.dispose(this.trackFadeoutAnimator);
        this.dispose(this.thumbFadeoutAnimator);
        this.dispose(this.trackFadeinAnimator);
        this.dispose(this.trackFadeoutAnimator);
    }

    private void dispose(LegacyAnimator animator) {
        if (animator != null) {
            animator.dispose();
        }
    }

    public float getTrackAlpha() {
        return this.trackAlpha;
    }

    public float getTrackState() {
        return this.trackState;
    }

    public float getThumbState() {
        return this.thumbState;
    }

    public float getThumbAlpha() {
        return this.thumbAlpha;
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        if (this.scrollbar.getParent() instanceof JScrollPane && !((JScrollPane)this.scrollbar.getParent()).isWheelScrollingEnabled()) {
            return;
        }
        if (this.scrollbar.getOrientation() == 1 && !e.isShiftDown() || this.scrollbar.getOrientation() == 0 && e.isShiftDown()) {
            this.scrollbar.setValueIsAdjusting(true);
            JScrollPane sp = PropertyUtil.getObject(this.scrollbar, "JScrollBar.scrollPaneParent", JScrollPane.class);
            if (this.scrollbar.getParent() instanceof JScrollPane) {
                ScrollBarUtil.doScroll(this.scrollbar, ((JScrollPane)this.scrollbar.getParent()).getViewport(), e, this.scrollbar.getParent().getComponentOrientation().isLeftToRight());
            } else if (sp != null) {
                ScrollBarUtil.doScroll(this.scrollbar, sp.getViewport(), e, this.scrollbar.getParent().getComponentOrientation().isLeftToRight());
            } else {
                ScrollBarUtil.doScroll(this.scrollbar, null, e, this.scrollbar.getComponentOrientation().isLeftToRight());
            }
            this.scrollbar.setValueIsAdjusting(false);
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (e == null) {
            return;
        }
        boolean overThumb = this.isOverThumb(e.getPoint());
        if (overThumb != this.mouseOverThumb) {
            this.mouseOverThumb = overThumb;
            if (!this.scrollbar.getValueIsAdjusting()) {
                this.resetThumbAnimator();
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (!((DarkScrollBarUI)this.ui).getTrackBounds().contains(e.getPoint())) {
            this.mouseOverTrack = false;
            this.resetTrackAnimator();
        }
        if (!((DarkScrollBarUI)this.ui).getThumbBounds().contains(e.getPoint())) {
            this.mouseOverThumb = false;
            this.resetThumbAnimator();
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (((DarkScrollBarUI)this.ui).getThumbBounds().isEmpty()) {
            return;
        }
        this.mouseOverTrack = true;
        if (!this.scrollbar.getValueIsAdjusting()) {
            this.resetTrackAnimator();
        }
        this.mouseMoved(e);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (((DarkScrollBarUI)this.ui).getThumbBounds().isEmpty()) {
            return;
        }
        this.mouseOverTrack = false;
        if (!this.scrollbar.getValueIsAdjusting()) {
            this.resetTrackAnimator();
        }
        this.mouseMoved(e);
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent e) {
        if (!e.getValueIsAdjusting()) {
            return;
        }
        JScrollBar scrollBar = (JScrollBar)e.getAdjustable();
        boolean animateTrack = this.animateTrackOnScroll(scrollBar);
        boolean animateThumb = this.animateThumbOnScroll(scrollBar);
        if (animateTrack || animateThumb) {
            int extent = scrollBar.getModel().getExtent();
            int value = scrollBar.getValue() + extent;
            if (value == extent || value == scrollBar.getMaximum()) {
                return;
            }
            Point p = MouseInfo.getPointerInfo().getLocation();
            SwingUtilities.convertPointFromScreen(p, this.scrollbar);
            if (animateTrack && !scrollBar.contains(p)) {
                this.runOnScrollTrackAnimation();
            }
            if (animateThumb && !((DarkScrollBarUI)this.ui).getThumbBounds().contains(p)) {
                this.runOnScrollThumbAnimation();
            }
        }
    }

    protected void runOnScrollTrackAnimation() {
        if (!this.trackFadeinAnimator.isRunning()) {
            this.mouseOverTrack = true;
            this.resetTrackAnimator();
        }
    }

    protected void runOnScrollThumbAnimation() {
        if (!this.thumbFadeinAnimator.isRunning()) {
            this.mouseOverThumb = true;
            this.resetThumbAnimator();
        }
    }

    protected boolean isOverThumb(Point p) {
        Rectangle bounds = ((DarkScrollBarUI)this.ui).getThumbBounds();
        return bounds != null && bounds.contains(p);
    }

    protected void resetThumbAnimator() {
        if (this.thumbFadeinAnimator == null || this.thumbFadeoutAnimator == null) {
            return;
        }
        this.resetAnimators(this.thumbFadeinAnimator, this.thumbFadeoutAnimator, this.mouseOverThumb, this.thumbAlpha, 0.7f);
    }

    protected void resetTrackAnimator() {
        if (this.trackFadeinAnimator == null || this.trackFadeoutAnimator == null) {
            return;
        }
        this.resetAnimators(this.trackFadeinAnimator, this.trackFadeoutAnimator, this.mouseOverTrack, this.trackAlpha, 0.3f);
    }

    protected void resetAnimators(LegacyAnimator fadeInAnimator, LegacyAnimator fadeOutAnimator, boolean overAnimatedComponent, float currentAlpha, float maxAlpha) {
        boolean fadeInRunning = fadeInAnimator.isRunning();
        boolean fadeOutRunning = fadeInAnimator.isRunning();
        fadeInAnimator.reset();
        fadeOutAnimator.reset();
        if (this.scrollbar != null && (this.scrollbar.getValueIsAdjusting() || overAnimatedComponent)) {
            fadeOutAnimator.suspend();
            int startFrame = (int)(currentAlpha / maxAlpha * (float)fadeInAnimator.getTotalFrames());
            fadeInAnimator.resume(startFrame, fadeOutRunning, this.scrollbar);
        } else {
            fadeInAnimator.suspend();
            int startFrame = 0;
            if (currentAlpha < maxAlpha) {
                startFrame = (int)((1.0 - (double)(currentAlpha / maxAlpha)) * (double)fadeOutAnimator.getTotalFrames());
            }
            fadeOutAnimator.resume(startFrame, fadeInRunning, this.scrollbar);
        }
    }

    protected boolean animateTrackOnScroll(JScrollBar scrollbar) {
        return false;
    }

    protected boolean animateThumbOnScroll(JScrollBar scrollbar) {
        return PropertyUtil.getBooleanProperty(scrollbar, "JScrollBar.highlightOnScroll");
    }

    protected int getFadeResolution() {
        return 10;
    }

    protected int getTrackFadeOutDuration() {
        return 400;
    }

    protected int getTrackFadeOutDelay() {
        return 100;
    }

    protected int getTrackFadeInDuration() {
        return 200;
    }

    protected int getTrackFadeInDelay() {
        return 0;
    }

    protected int getThumbFadeOutDuration() {
        return 400;
    }

    protected int getThumbFadeOutDelay() {
        return 100;
    }

    protected int getThumbFadeInDuration() {
        return 200;
    }

    protected int getThumbFadeInDelay() {
        return 0;
    }

    protected LegacyAnimator createTrackFadeoutAnimator() {
        return new TrackFadeOutAnimator();
    }

    protected LegacyAnimator createThumbFadeoutAnimator() {
        return new ThumbFadeOutAnimator();
    }

    protected LegacyAnimator createTrackFadeinAnimator() {
        return new TrackFadeInAnimator();
    }

    protected LegacyAnimator createThumbFadeinAnimator() {
        return new ThumbFadeInAnimator();
    }

    protected class TrackFadeOutAnimator
    extends SBAnimator {
        public TrackFadeOutAnimator() {
            super(DarkScrollBarListener.this.getTrackFadeOutDuration(), DarkScrollBarListener.this.getFadeResolution(), DarkScrollBarListener.this.getTrackFadeOutDelay(), DarkScrollBarListener.this.scrollbar, 0.0f, 0.3f, false);
        }

        @Override
        protected void updateValue(float state, float value) {
            DarkScrollBarListener.this.trackAlpha = value;
            DarkScrollBarListener.this.trackState = state;
        }
    }

    protected class ThumbFadeOutAnimator
    extends SBAnimator {
        public ThumbFadeOutAnimator() {
            super(DarkScrollBarListener.this.getThumbFadeOutDuration(), DarkScrollBarListener.this.getFadeResolution(), DarkScrollBarListener.this.getThumbFadeOutDelay(), DarkScrollBarListener.this.scrollbar, 0.0f, 0.7f, false);
        }

        @Override
        protected void updateValue(float state, float value) {
            DarkScrollBarListener.this.thumbAlpha = value;
            DarkScrollBarListener.this.thumbState = state;
        }
    }

    protected class TrackFadeInAnimator
    extends SBAnimator {
        public TrackFadeInAnimator() {
            super(DarkScrollBarListener.this.getTrackFadeInDuration(), DarkScrollBarListener.this.getFadeResolution(), DarkScrollBarListener.this.getTrackFadeInDelay(), DarkScrollBarListener.this.scrollbar, 0.0f, 0.3f, true);
        }

        @Override
        protected void updateValue(float state, float value) {
            DarkScrollBarListener.this.trackAlpha = value;
            DarkScrollBarListener.this.trackState = state;
        }
    }

    protected class ThumbFadeInAnimator
    extends SBAnimator {
        public ThumbFadeInAnimator() {
            super(DarkScrollBarListener.this.getThumbFadeInDuration(), DarkScrollBarListener.this.getFadeResolution(), DarkScrollBarListener.this.getThumbFadeInDelay(), DarkScrollBarListener.this.scrollbar, 0.0f, 0.7f, true);
        }

        @Override
        protected void updateValue(float state, float value) {
            DarkScrollBarListener.this.thumbAlpha = value;
            DarkScrollBarListener.this.thumbState = state;
        }

        @Override
        protected void paintCycleEnd() {
            super.paintCycleEnd();
            if (DarkScrollBarListener.this.scrollbar == null) {
                return;
            }
            Point p = MouseInfo.getPointerInfo().getLocation();
            SwingUtilities.convertPointFromScreen(p, DarkScrollBarListener.this.scrollbar);
            if (!((DarkScrollBarUI)DarkScrollBarListener.this.ui).getThumbBounds().contains(p) && !DarkScrollBarListener.this.scrollbar.getValueIsAdjusting()) {
                DarkScrollBarListener.this.mouseOverThumb = false;
                DarkScrollBarListener.this.resetThumbAnimator();
            }
        }
    }

    protected static abstract class SBAnimator
    extends LegacyAnimator {
        private final JComponent component;
        private final float minValue;
        private final float maxValue;
        private final boolean fadeIn;

        public SBAnimator(int duration, int resolution, int delay, JComponent component, float minValue, float maxValue, boolean fadeIn) {
            super(duration / resolution, duration, delay, false, fadeIn ? DefaultInterpolator.EASE_OUT_CUBIC : DefaultInterpolator.EASE_IN_CUBIC);
            this.component = component;
            this.minValue = minValue;
            this.maxValue = maxValue;
            this.fadeIn = fadeIn;
        }

        protected abstract void updateValue(float var1, float var2);

        @Override
        public void paintNow(float fraction) {
            float fr = this.fadeIn ? fraction : 1.0f - fraction;
            this.updateValue(fr, this.minValue + this.maxValue * fr);
            this.repaint();
        }

        @Override
        protected void paintCycleEnd() {
            this.updateValue(this.fadeIn ? 1.0f : 0.0f, this.fadeIn ? this.maxValue : this.minValue);
            this.repaint();
        }

        private void repaint() {
            if (this.component != null) {
                ((JComponent)this.component.getParent()).paintImmediately(this.component.getBounds());
                this.component.getParent().repaint();
            }
        }
    }
}

