/*
 * Decompiled with CFR 0.152.
 */
package gttweaker.mods.gregtech.machines;

import gregtech.api.enums.GTValues;
import gregtech.api.interfaces.IRecipeMap;
import gregtech.api.recipe.RecipeMaps;
import gttweaker.mods.AddMultipleRecipeAction;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.annotations.ModOnly;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import minetweaker.api.liquid.ILiquidStack;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.gregtech.Assembler")
@ModOnly(value={"gregtech"})
public class Assembler {
    @ZenMethod
    public static void addRecipe(IItemStack output, IIngredient input1, IIngredient input2, ILiquidStack fluidInput, int durationTicks, int euPerTick) {
        Assembler.addRecipe(output, new IIngredient[]{input1, input2}, fluidInput, durationTicks, euPerTick);
    }

    @ZenMethod
    public static void addRecipe(IItemStack output, IIngredient input1, IIngredient input2, int durationTicks, int euPerTick) {
        MineTweakerAPI.apply((IUndoableAction)new AddMultipleRecipeAction("Adding assembler recipe for " + output, new Object[]{input1, input2, output, durationTicks, euPerTick}){

            @Override
            protected void applySingleRecipe(AddMultipleRecipeAction.ArgIterator i) {
                ItemStack input1 = i.nextItem();
                ItemStack input2 = i.nextItem();
                ItemStack output = i.nextItem();
                int duration = i.nextInt();
                int eut = i.nextInt();
                GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{input1, input2}).itemOutputs(new ItemStack[]{output}).duration(duration).eut(eut).addTo((IRecipeMap)RecipeMaps.assemblerRecipes);
            }
        });
    }

    @ZenMethod
    public static void addRecipe(IItemStack output, IIngredient[] inputs, ILiquidStack fluidInput, int durationTicks, int euPerTick) {
        MineTweakerAPI.apply((IUndoableAction)new AddMultipleRecipeAction("Adding assembler recipe for " + output, new Object[]{inputs, fluidInput, output, durationTicks, euPerTick}){

            @Override
            protected void applySingleRecipe(AddMultipleRecipeAction.ArgIterator i) {
                ItemStack[] inputs = i.nextItemArr();
                FluidStack fluidInput = i.nextFluid();
                ItemStack output = i.nextItem();
                int duration = i.nextInt();
                int eut = i.nextInt();
                GTValues.RA.stdBuilder().itemInputs(inputs).itemOutputs(new ItemStack[]{output}).fluidInputs(new FluidStack[]{fluidInput}).duration(duration).eut(eut).addTo((IRecipeMap)RecipeMaps.assemblerRecipes);
            }
        });
    }
}

