/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.rfbplugins.compat.transformers;

import com.gtnewhorizons.retrofuturabootstrap.api.ClassNodeHandle;
import com.gtnewhorizons.retrofuturabootstrap.api.ExtensibleClassLoader;
import com.gtnewhorizons.retrofuturabootstrap.api.FastClassAccessor;
import com.gtnewhorizons.retrofuturabootstrap.api.RfbClassTransformer;
import com.gtnewhorizons.rfbplugins.compat.ModernJavaCompatibilityPlugin;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.intellij.lang.annotations.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Handle;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InvokeDynamicInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class InterfaceMethodRefFixer
implements RfbClassTransformer {
    public static final Attributes.Name MANIFEST_SAFE_ATTRIBUTE = new Attributes.Name("Has-Safe-InterfaceMethodRefs");

    @Override
    @Pattern(value="[a-z0-9-]+")
    @NotNull
    public String id() {
        return "interface-method-ref-fixer";
    }

    @Override
    public boolean shouldTransformClass(@NotNull ExtensibleClassLoader classLoader, @NotNull RfbClassTransformer.Context context, @Nullable Manifest manifest, @NotNull String className, @NotNull ClassNodeHandle classNode) {
        if (!classNode.isPresent()) {
            return false;
        }
        if (classNode.getOriginalMetadata() == null) {
            return false;
        }
        if (manifest != null && "true".equals(manifest.getMainAttributes().getValue(MANIFEST_SAFE_ATTRIBUTE))) {
            return false;
        }
        return classNode.getOriginalMetadata().majorVersion < 53;
    }

    @Override
    public void transformClass(@NotNull ExtensibleClassLoader classLoader, @NotNull RfbClassTransformer.Context context, @Nullable Manifest manifest, @NotNull String className, @NotNull ClassNodeHandle classNode) {
        ClassNode node = classNode.getNode();
        if (node == null) {
            return;
        }
        boolean iAmAnInterface = (node.access & 0x200) != 0;
        String internalClassName = node.name;
        if (node.methods == null) {
            return;
        }
        for (MethodNode method : node.methods) {
            if (method.instructions == null) continue;
            for (AbstractInsnNode insn : method.instructions) {
                this.validateInstruction(classLoader, internalClassName, iAmAnInterface, insn);
            }
        }
    }

    private void validateInstruction(ExtensibleClassLoader classLoader, String internalClassName, boolean iAmAnInterface, AbstractInsnNode rawInsn) {
        if (rawInsn.getType() == 6) {
            InvokeDynamicInsnNode insn = (InvokeDynamicInsnNode)rawInsn;
            insn.bsm = this.fixHandle(classLoader, internalClassName, iAmAnInterface, insn.bsm);
            if (insn.bsmArgs != null) {
                for (int i = 0; i < insn.bsmArgs.length; ++i) {
                    Object arg = insn.bsmArgs[i];
                    if (!(arg instanceof Handle)) continue;
                    insn.bsmArgs[i] = this.fixHandle(classLoader, internalClassName, iAmAnInterface, (Handle)arg);
                }
            }
        }
    }

    private Handle fixHandle(ExtensibleClassLoader classLoader, String internalClassName, boolean iAmAnInterface, Handle handle) {
        if (!handle.isInterface()) {
            String regularName;
            FastClassAccessor javaClass;
            boolean fixSelfReference = handle.getOwner().equals(internalClassName) && iAmAnInterface;
            boolean fixJavaReference = false;
            if (!fixSelfReference && (javaClass = classLoader.findClassMetadata(regularName = handle.getOwner().replace('/', '.'))) != null && javaClass.isInterface()) {
                fixJavaReference = true;
            }
            if (fixSelfReference || fixJavaReference) {
                ModernJavaCompatibilityPlugin.log.debug("Fixed a broken InterfaceMethodRef {} -> {}#{} ({})", new Object[]{internalClassName, handle.getOwner(), handle.getName(), handle.getDesc()});
                return new Handle(handle.getTag(), handle.getOwner(), handle.getName(), handle.getDesc(), true);
            }
        }
        return handle;
    }
}

