/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.widgets;

import com.cleanroommc.modularui.api.drawable.IKey;
import com.cleanroommc.modularui.drawable.text.TextRenderer;
import com.cleanroommc.modularui.screen.viewport.ModularGuiContext;
import com.cleanroommc.modularui.theme.WidgetTheme;
import com.cleanroommc.modularui.utils.Alignment;
import com.cleanroommc.modularui.widgets.TextWidget;

public class ScrollingTextWidget
extends TextWidget {
    private static final int pauseTime = 60;
    private TextRenderer.Line line = new TextRenderer.Line("", 0.0f);
    private long time = 0L;
    private int scroll = 0;
    private boolean hovering = false;
    private int pauseTimer = 0;

    public ScrollingTextWidget(IKey key) {
        super(key);
        this.tooltipBuilder(tooltip -> {
            tooltip.showUpTimer(10);
            if (this.line.getWidth() > (float)this.getArea().width) {
                tooltip.addLine(key);
            }
        });
    }

    @Override
    public void onMouseStartHover() {
        this.hovering = true;
    }

    @Override
    public void onMouseEndHover() {
        this.hovering = false;
        this.scroll = 0;
        this.time = 0L;
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (this.pauseTimer > 0) {
            if (++this.pauseTimer == 60) {
                this.pauseTimer = this.scroll == 0 ? 0 : 1;
                this.scroll = 0;
            }
            return;
        }
        if (this.hovering && ++this.time % 2L == 0L && ++this.scroll == this.line.upperWidth() - this.getArea().width - 1) {
            this.pauseTimer = 1;
        }
    }

    @Override
    public void draw(ModularGuiContext context, WidgetTheme widgetTheme) {
        this.checkString();
        TextRenderer renderer = TextRenderer.SHARED;
        renderer.setColor(this.getColor());
        renderer.setAlignment(this.getAlignment(), this.getArea().w() + 1, this.getArea().h());
        renderer.setShadow(this.isShadow());
        renderer.setPos(this.getArea().getPadding().left, this.getArea().getPadding().top);
        renderer.setScale(this.getScale());
        renderer.setSimulate(false);
        if (this.hovering) {
            renderer.drawScrolling(this.line, this.scroll, this.getArea(), context);
        } else {
            renderer.drawCut(this.line);
        }
    }

    private void checkString() {
        String s = this.getKey().get();
        if (!s.equals(this.line.getText())) {
            TextRenderer.SHARED.setScale(this.getScale());
            this.line = TextRenderer.SHARED.line(s);
            this.scroll = 0;
            this.markTooltipDirty();
        }
    }

    @Override
    public ScrollingTextWidget alignment(Alignment alignment) {
        return (ScrollingTextWidget)super.alignment(alignment);
    }

    @Override
    public ScrollingTextWidget color(int color) {
        return (ScrollingTextWidget)super.color(color);
    }

    @Override
    public ScrollingTextWidget scale(float scale) {
        return (ScrollingTextWidget)super.scale(scale);
    }

    @Override
    public ScrollingTextWidget shadow(boolean shadow) {
        return (ScrollingTextWidget)super.shadow(shadow);
    }

    @Override
    public ScrollingTextWidget widgetTheme(String widgetTheme) {
        return (ScrollingTextWidget)super.widgetTheme(widgetTheme);
    }
}

