/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.configuration.structures;

import biomesoplenty.api.content.BOPCBiomes;
import biomesoplenty.common.world.BOPBiomeManager;
import cpw.mods.fml.common.FMLLog;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeManager;
import net.minecraftforge.common.config.Configuration;
import org.apache.logging.log4j.Level;

public class BOPConfigurationVillages {
    public static Configuration config;
    public static int villageDistance;
    public static ArrayList<Integer> enabledBiomes;

    public static void addDefaultVillageBiomes() {
        BOPConfigurationVillages.addVillageBiome(BOPCBiomes.arctic);
        BOPConfigurationVillages.addVillageBiome(BOPCBiomes.brushland);
        BOPConfigurationVillages.addVillageBiome(BOPCBiomes.chaparral);
        BOPConfigurationVillages.addVillageBiome(BOPCBiomes.deadForest);
        BOPConfigurationVillages.addVillageBiome(BOPCBiomes.frostForest);
        BOPConfigurationVillages.addVillageBiome(BOPCBiomes.grassland);
        BOPConfigurationVillages.addVillageBiome(BOPCBiomes.grove);
        BOPConfigurationVillages.addVillageBiome(BOPCBiomes.heathland);
        BOPConfigurationVillages.addVillageBiome(BOPCBiomes.meadow);
        BOPConfigurationVillages.addVillageBiome(BOPCBiomes.outback);
        BOPConfigurationVillages.addVillageBiome(BOPCBiomes.prairie);
        BOPConfigurationVillages.addVillageBiome(BOPCBiomes.shrubland);
        BOPConfigurationVillages.addVillageBiome(BOPCBiomes.steppe);
        BOPConfigurationVillages.addVillageBiome(BOPCBiomes.tundra);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(File configFile) {
        BOPConfigurationVillages.addDefaultVillageBiomes();
        config = new Configuration(configFile);
        try {
            config.load();
            villageDistance = config.get("Biomes O' Plenty World Type Settings", "Distance between villages", 32, "In Vanilla it is set to 32").getInt();
            if (villageDistance < 8) {
                villageDistance = 8;
            }
            for (List<BiomeManager.BiomeEntry> biomeList : BOPBiomeManager.overworldBiomes) {
                for (BiomeManager.BiomeEntry entry : biomeList) {
                    BiomeGenBase biome = entry.biome;
                    if (!config.get("Allow Villages", biome.field_76791_y, enabledBiomes.contains(biome.field_76756_M)).getBoolean(enabledBiomes.contains(biome.field_76756_M))) continue;
                    BiomeManager.addVillageBiome((BiomeGenBase)biome, (boolean)true);
                }
            }
        }
        catch (Exception e) {
            FMLLog.log((Level)Level.ERROR, (String)"Biomes O Plenty has had a problem loading its configuration", (Object[])new Object[]{e});
        }
        finally {
            if (config.hasChanged()) {
                config.save();
            }
        }
    }

    public static void addVillageBiome(BiomeGenBase biome) {
        if (biome != null) {
            enabledBiomes.add(biome.field_76756_M);
        }
    }

    static {
        enabledBiomes = new ArrayList();
    }
}

