/*
 * Decompiled with CFR 0.152.
 */
package shedar.mods.ic2.nuclearcontrol.renderers.model;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.Facing;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import org.lwjgl.opengl.GL11;
import shedar.mods.ic2.nuclearcontrol.panel.Screen;
import shedar.mods.ic2.nuclearcontrol.tileentities.TileEntityAdvancedInfoPanel;

@SideOnly(value=Side.CLIENT)
public class ModelInfoPanel {
    private static final String TEXTURE_FILE = "nuclearcontrol:infoPanel/panelAdvancedSide";
    private static final IIcon advSideTex = Minecraft.func_71410_x().func_147117_R().func_94245_a("nuclearcontrol:infoPanel/panelAdvancedSide");
    private static final double Uma = advSideTex.func_94212_f();
    private static final double Umi = advSideTex.func_94209_e();
    private static final double Vma = advSideTex.func_94210_h();
    private static final double Vmi = advSideTex.func_94206_g();
    private double[] coordinates = new double[24];
    private static final byte[][] pointMap = new byte[][]{{0, 3, 2, 1}, {4, 5, 6, 7}, {0, 4, 7, 3}, {6, 5, 1, 2}, {5, 4, 0, 1}, {2, 3, 7, 6}};
    private static final byte[][] normalMap = new byte[][]{{0, -1, 0}, {0, 1, 0}, {0, 0, -1}, {0, 0, 1}, {-1, 0, 0}, {1, 0, 0}};

    private void assignWithRotation(int rotation, int offset, int sign, int tl, int tr, int br, int bl, double dtl, double dtr, double dbr, double dbl) {
        switch (rotation) {
            case 0: {
                int n = tl * 3 + offset;
                this.coordinates[n] = this.coordinates[n] + (double)sign * dtl;
                int n2 = tr * 3 + offset;
                this.coordinates[n2] = this.coordinates[n2] + (double)sign * dtr;
                int n3 = br * 3 + offset;
                this.coordinates[n3] = this.coordinates[n3] + (double)sign * dbr;
                int n4 = bl * 3 + offset;
                this.coordinates[n4] = this.coordinates[n4] + (double)sign * dbl;
                break;
            }
            case 1: {
                int n = tl * 3 + offset;
                this.coordinates[n] = this.coordinates[n] + (double)sign * dbl;
                int n5 = tr * 3 + offset;
                this.coordinates[n5] = this.coordinates[n5] + (double)sign * dtl;
                int n6 = br * 3 + offset;
                this.coordinates[n6] = this.coordinates[n6] + (double)sign * dtr;
                int n7 = bl * 3 + offset;
                this.coordinates[n7] = this.coordinates[n7] + (double)sign * dbr;
                break;
            }
            case 2: {
                int n = tl * 3 + offset;
                this.coordinates[n] = this.coordinates[n] + (double)sign * dtr;
                int n8 = tr * 3 + offset;
                this.coordinates[n8] = this.coordinates[n8] + (double)sign * dbr;
                int n9 = br * 3 + offset;
                this.coordinates[n9] = this.coordinates[n9] + (double)sign * dbl;
                int n10 = bl * 3 + offset;
                this.coordinates[n10] = this.coordinates[n10] + (double)sign * dtl;
                break;
            }
            case 3: {
                int n = tl * 3 + offset;
                this.coordinates[n] = this.coordinates[n] + (double)sign * dbr;
                int n11 = tr * 3 + offset;
                this.coordinates[n11] = this.coordinates[n11] + (double)sign * dbl;
                int n12 = br * 3 + offset;
                this.coordinates[n12] = this.coordinates[n12] + (double)sign * dtl;
                int n13 = bl * 3 + offset;
                this.coordinates[n13] = this.coordinates[n13] + (double)sign * dtr;
                break;
            }
        }
    }

    public double[] getDeltas(TileEntityAdvancedInfoPanel panel, Screen screen) {
        double thickness;
        boolean isTopBottom = panel.rotateVert != 0;
        boolean isLeftRight = panel.rotateHor != 0;
        double dTopLeft = 0.0;
        double dTopRight = 0.0;
        double dBottomLeft = 0.0;
        double dBottomRight = 0.0;
        int height = screen.getHeight(panel);
        int width = screen.getWidth(panel);
        double maxDelta = 0.0;
        if (isTopBottom) {
            if (panel.rotateVert > 0) {
                dBottomRight = dBottomLeft = (double)height * Math.tan(Math.PI * (double)panel.rotateVert / 180.0);
                maxDelta = dBottomLeft;
            } else {
                maxDelta = dTopRight = (dTopLeft = (double)height * Math.tan(Math.PI * (double)(-panel.rotateVert) / 180.0));
            }
        }
        if (isLeftRight) {
            if (panel.rotateHor > 0) {
                maxDelta = dTopRight = (dBottomRight = (double)width * Math.tan(Math.PI * (double)panel.rotateHor / 180.0));
            } else {
                dTopLeft = dBottomLeft = (double)width * Math.tan(Math.PI * (double)(-panel.rotateHor) / 180.0);
                maxDelta = dBottomLeft;
            }
        }
        if (isTopBottom && isLeftRight) {
            maxDelta = dTopLeft == 0.0 ? (dBottomRight = dBottomLeft + dTopRight) : (dTopRight == 0.0 ? (dBottomLeft = dTopLeft + dBottomRight) : (dBottomLeft == 0.0 ? (dTopRight = dTopLeft + dBottomRight) : (dTopLeft = dBottomLeft + dTopRight)));
        }
        if (maxDelta > (thickness = (double)panel.thickness / 16.0)) {
            double scale = thickness / maxDelta;
            dTopLeft = scale * dTopLeft;
            dTopRight = scale * dTopRight;
            dBottomLeft = scale * dBottomLeft;
            dBottomRight = scale * dBottomRight;
        }
        double[] res = new double[]{dTopLeft, dTopRight, dBottomLeft, dBottomRight};
        return res;
    }

    private void addSlopes(TileEntityAdvancedInfoPanel panel, Screen screen, double[] deltas) {
        double dTopLeft = deltas[0];
        double dTopRight = deltas[1];
        double dBottomLeft = deltas[2];
        double dBottomRight = deltas[3];
        short facing = panel.facing;
        int rotation = panel.getRotation();
        switch (facing) {
            case 0: {
                this.assignWithRotation(rotation, 1, -1, 4, 7, 6, 5, dTopLeft, dTopRight, dBottomRight, dBottomLeft);
                break;
            }
            case 1: {
                this.assignWithRotation(rotation, 1, 1, 3, 0, 1, 2, dTopLeft, dTopRight, dBottomRight, dBottomLeft);
                break;
            }
            case 2: {
                this.assignWithRotation(rotation, 2, -1, 5, 6, 2, 1, dTopLeft, dTopRight, dBottomRight, dBottomLeft);
                break;
            }
            case 3: {
                this.assignWithRotation(rotation, 2, 1, 7, 4, 0, 3, dTopLeft, dTopRight, dBottomRight, dBottomLeft);
                break;
            }
            case 4: {
                this.assignWithRotation(rotation, 0, -1, 6, 7, 3, 2, dTopLeft, dTopRight, dBottomRight, dBottomLeft);
                break;
            }
            case 5: {
                this.assignWithRotation(rotation, 0, 1, 4, 5, 1, 0, dTopLeft, dTopRight, dBottomRight, dBottomLeft);
            }
        }
    }

    private void initCoordinates(Block block, Screen screen) {
        double blockMinX = block.func_149704_x();
        double blockMinY = block.func_149665_z();
        double blockMinZ = block.func_149706_B();
        double blockMaxX = block.func_149753_y();
        double blockMaxY = block.func_149669_A();
        double blockMaxZ = block.func_149693_C();
        this.coordinates[0] = (double)screen.minX + blockMinX;
        this.coordinates[1] = (double)screen.minY + blockMinY;
        this.coordinates[2] = (double)screen.minZ + blockMinZ;
        this.coordinates[3] = (double)screen.minX + blockMinX;
        this.coordinates[4] = (double)screen.minY + blockMinY;
        this.coordinates[5] = (double)screen.maxZ + blockMaxZ;
        this.coordinates[6] = (double)screen.maxX + blockMaxX;
        this.coordinates[7] = (double)screen.minY + blockMinY;
        this.coordinates[8] = (double)screen.maxZ + blockMaxZ;
        this.coordinates[9] = (double)screen.maxX + blockMaxX;
        this.coordinates[10] = (double)screen.minY + blockMinY;
        this.coordinates[11] = (double)screen.minZ + blockMinZ;
        this.coordinates[12] = (double)screen.minX + blockMinX;
        this.coordinates[13] = (double)screen.maxY + blockMaxY;
        this.coordinates[14] = (double)screen.minZ + blockMinZ;
        this.coordinates[15] = (double)screen.minX + blockMinX;
        this.coordinates[16] = (double)screen.maxY + blockMaxY;
        this.coordinates[17] = (double)screen.maxZ + blockMaxZ;
        this.coordinates[18] = (double)screen.maxX + blockMaxX;
        this.coordinates[19] = (double)screen.maxY + blockMaxY;
        this.coordinates[20] = (double)screen.maxZ + blockMaxZ;
        this.coordinates[21] = (double)screen.maxX + blockMaxX;
        this.coordinates[22] = (double)screen.maxY + blockMaxY;
        this.coordinates[23] = (double)screen.minZ + blockMinZ;
    }

    private void addPoint(int point, double u, double v) {
        Tessellator.field_78398_a.func_78374_a(this.coordinates[point * 3], this.coordinates[point * 3 + 1], this.coordinates[point * 3 + 2], u, v);
    }

    private void addPoints(byte[] points, byte[] n, double u1, double u2, double v1, double v2) {
        Tessellator.field_78398_a.func_78375_b((float)n[0], (float)n[1], (float)n[2]);
        this.addPoint(points[0], u1, v1);
        this.addPoint(points[1], u1, v2);
        this.addPoint(points[2], u2, v2);
        this.addPoint(points[3], u2, v1);
    }

    private double[] normalize(double[] vec) {
        double len = Math.sqrt(vec[0] * vec[0] + vec[1] * vec[1] + vec[2] * vec[2]);
        return new double[]{vec[0] / len, vec[1] / len, vec[2] / len};
    }

    private double[] scale(double[] vec, double scale) {
        return new double[]{vec[0] * scale, vec[1] * scale, vec[2] * scale};
    }

    private double[] vectorBetweenPoints(double[] vec1, double[] vec2) {
        return new double[]{vec1[0] - vec2[0], vec1[1] - vec2[1], vec1[2] - vec2[2]};
    }

    private void drawScreenWithBorder(byte[] points, byte[] n, double u1, double u2, double v1, double v2, double border, int facing) {
        Tessellator.field_78398_a.func_78375_b((float)n[0], (float)n[1], (float)n[2]);
        double[][] UVMap = new double[][]{{u1, v1}, {u1, v2}, {u2, v2}, {u2, v1}};
        byte[] edges = new byte[]{points[3], points[0], points[1], points[2], points[3], points[0]};
        for (int i = 1; i < 5; ++i) {
            double[] edge1 = this.scale(this.normalize(this.vectorBetweenPoints(new double[]{this.coordinates[edges[i] * 3], this.coordinates[edges[i] * 3 + 1], this.coordinates[edges[i] * 3 + 2]}, new double[]{this.coordinates[edges[i + 1] * 3], this.coordinates[edges[i + 1] * 3 + 1], this.coordinates[edges[i + 1] * 3 + 2]})), border);
            double[] edge2 = this.scale(this.normalize(this.vectorBetweenPoints(new double[]{this.coordinates[edges[i] * 3], this.coordinates[edges[i] * 3 + 1], this.coordinates[edges[i] * 3 + 2]}, new double[]{this.coordinates[edges[i - 1] * 3], this.coordinates[edges[i - 1] * 3 + 1], this.coordinates[edges[i - 1] * 3 + 2]})), border);
            Tessellator.field_78398_a.func_78374_a(this.coordinates[edges[i] * 3] - edge1[0] - edge2[0] + 0.001 * (double)Facing.field_71586_b[facing], this.coordinates[edges[i] * 3 + 1] - edge1[1] - edge2[1] + 0.001 * (double)Facing.field_71587_c[facing], this.coordinates[edges[i] * 3 + 2] - edge1[2] - edge2[2] + 0.001 * (double)Facing.field_71585_d[facing], UVMap[i - 1][0], UVMap[i - 1][1]);
        }
    }

    private void drawFacing(int facing, int rotation, Screen screen, TileEntityAdvancedInfoPanel panel, Block block, Tessellator tess) {
        IIcon texture = block.func_149673_e((IBlockAccess)panel.func_145831_w(), panel.field_145851_c, panel.field_145848_d, panel.field_145849_e, 0);
        double u1 = texture.func_94209_e();
        double u2 = texture.func_94212_f();
        double v1 = texture.func_94206_g();
        double v2 = texture.func_94210_h();
        this.addPoints(pointMap[facing], normalMap[facing], u1, u2, v1, v2);
        texture = block.func_149673_e((IBlockAccess)panel.func_145831_w(), panel.field_145851_c, panel.field_145848_d, panel.field_145849_e, facing);
        u1 = texture.func_94209_e();
        u2 = texture.func_94212_f();
        v1 = texture.func_94206_g();
        v2 = texture.func_94210_h();
        this.drawScreenWithBorder(pointMap[facing], normalMap[facing], u1, u2, v1, v2, 0.05, facing);
    }

    public void renderScreen(Block block, TileEntityAdvancedInfoPanel panel, double x, double y, double z, RenderBlocks renderer) {
        Screen screen = panel.getScreen();
        if (screen == null) {
            return;
        }
        this.initCoordinates(block, screen);
        double[] deltas = this.getDeltas(panel, screen);
        this.addSlopes(panel, screen, deltas);
        short facing = panel.getFacing();
        Tessellator tess = Tessellator.field_78398_a;
        tess.func_78380_c(block.func_149677_c((IBlockAccess)panel.func_145831_w(), panel.field_145851_c, panel.field_145848_d, panel.field_145849_e));
        tess.func_78386_a(0.5f, 0.5f, 0.5f);
        if (panel.getTransparencyMode() == 0) {
            this.drawFacing(facing, panel.getRotation(), screen, panel, block, tess);
        }
        if (panel.getTransparencyMode() == 0) {
            Tessellator.field_78398_a.func_78380_c(block.func_149677_c((IBlockAccess)panel.func_145831_w(), panel.field_145851_c, panel.field_145848_d, panel.field_145849_e));
            Tessellator.field_78398_a.func_78386_a(0.5f, 0.5f, 0.5f);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (facing != 0) {
                Tessellator.field_78398_a.func_78375_b(0.0f, -1.0f, 0.0f);
                this.addPoint(0, Umi, Vmi);
                this.addPoint(3, Uma, Vmi);
                this.addPoint(2, Uma, Vma);
                this.addPoint(1, Umi, Vma);
            }
            if (facing != 1) {
                Tessellator.field_78398_a.func_78375_b(0.0f, 1.0f, 0.0f);
                this.addPoint(4, Umi, Vmi);
                this.addPoint(5, Uma, Vmi);
                this.addPoint(6, Uma, Vma);
                this.addPoint(7, Umi, Vma);
            }
            if (facing != 2) {
                Tessellator.field_78398_a.func_78375_b(0.0f, 0.0f, -1.0f);
                this.addPoint(0, Umi, Vmi);
                this.addPoint(4, Uma, Vmi);
                this.addPoint(7, Uma, Vma);
                this.addPoint(3, Umi, Vma);
            }
            if (facing != 3) {
                Tessellator.field_78398_a.func_78375_b(0.0f, 0.0f, 1.0f);
                this.addPoint(6, Umi, Vmi);
                this.addPoint(5, Uma, Vmi);
                this.addPoint(1, Uma, Vma);
                this.addPoint(2, Umi, Vma);
            }
            if (facing != 4) {
                Tessellator.field_78398_a.func_78375_b(-1.0f, 0.0f, 0.0f);
                this.addPoint(5, Umi, Vmi);
                this.addPoint(4, Uma, Vmi);
                this.addPoint(0, Uma, Vma);
                this.addPoint(1, Umi, Vma);
            }
            if (facing != 5) {
                Tessellator.field_78398_a.func_78375_b(1.0f, 0.0f, 0.0f);
                this.addPoint(2, Umi, Vmi);
                this.addPoint(3, Uma, Vmi);
                this.addPoint(7, Uma, Vma);
                this.addPoint(6, Umi, Vma);
            }
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Tessellator.field_78398_a.func_78386_a(0.5f, 0.5f, 0.5f);
    }
}

