/*
 * Decompiled with CFR 0.152.
 */
package shedar.mods.ic2.nuclearcontrol.items;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import java.util.Vector;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;
import shedar.mods.ic2.nuclearcontrol.api.CardState;
import shedar.mods.ic2.nuclearcontrol.api.ICardWrapper;
import shedar.mods.ic2.nuclearcontrol.api.PanelSetting;
import shedar.mods.ic2.nuclearcontrol.api.PanelString;
import shedar.mods.ic2.nuclearcontrol.crossmod.EnergyStorageData;
import shedar.mods.ic2.nuclearcontrol.items.ItemCardBase;
import shedar.mods.ic2.nuclearcontrol.panel.CardWrapperImpl;
import shedar.mods.ic2.nuclearcontrol.utils.EnergyStorageHelper;
import shedar.mods.ic2.nuclearcontrol.utils.LangHelper;
import shedar.mods.ic2.nuclearcontrol.utils.StringUtils;

public class ItemCardEnergyArrayLocation
extends ItemCardBase {
    public static final int DISPLAY_ENERGY = 1;
    public static final int DISPLAY_FREE = 2;
    public static final int DISPLAY_STORAGE = 4;
    public static final int DISPLAY_EACH = 8;
    public static final int DISPLAY_TOTAL = 16;
    public static final int DISPLAY_PERCENTAGE = 32;
    private static final int STATUS_NOT_FOUND = Integer.MIN_VALUE;
    private static final int STATUS_OUT_OF_RANGE = -2147483647;
    public static final UUID CARD_TYPE = new UUID(0L, 3L);

    public ItemCardEnergyArrayLocation() {
        super("cardEnergyArray");
    }

    private int[] getCoordinates(ICardWrapper card, int cardNumber) {
        int cardCount = card.getInt("cardCount");
        if (cardNumber >= cardCount) {
            return null;
        }
        int[] coordinates = new int[]{card.getInt(String.format("_%dx", cardNumber)), card.getInt(String.format("_%dy", cardNumber)), card.getInt(String.format("_%dz", cardNumber))};
        return coordinates;
    }

    public static int getCardCount(ICardWrapper card) {
        return card.getInt("cardCount");
    }

    public static void initArray(CardWrapperImpl card, Vector<ItemStack> cards) {
        int cardCount = ItemCardEnergyArrayLocation.getCardCount(card);
        for (ItemStack subCard : cards) {
            CardWrapperImpl wrapper = new CardWrapperImpl(subCard, -1);
            ChunkCoordinates target = wrapper.getTarget();
            if (target == null) continue;
            card.setInt(String.format("_%dx", cardCount), target.field_71574_a);
            card.setInt(String.format("_%dy", cardCount), target.field_71572_b);
            card.setInt(String.format("_%dz", cardCount), target.field_71573_c);
            card.setInt(String.format("_%dtargetType", cardCount), wrapper.getInt("targetType"));
            ++cardCount;
        }
        card.setInt("cardCount", cardCount);
    }

    @Override
    public CardState update(TileEntity panel, ICardWrapper card, int range) {
        int cardCount = ItemCardEnergyArrayLocation.getCardCount(card);
        double totalEnergy = 0.0;
        if (cardCount == 0) {
            return CardState.INVALID_CARD;
        }
        boolean foundAny = false;
        boolean outOfRange = false;
        for (int i = 0; i < cardCount; ++i) {
            int[] coordinates = this.getCoordinates(card, i);
            int dx = coordinates[0] - panel.field_145851_c;
            int dy = coordinates[1] - panel.field_145848_d;
            int dz = coordinates[2] - panel.field_145849_e;
            if (Math.abs(dx) <= range && Math.abs(dy) <= range && Math.abs(dz) <= range) {
                EnergyStorageData storage = EnergyStorageHelper.getStorageAt(panel.func_145831_w(), coordinates[0], coordinates[1], coordinates[2], card.getInt(String.format("_%dtargetType", i)));
                if (storage != null) {
                    totalEnergy += storage.stored;
                    card.setInt(String.format("_%denergy", i), (int)storage.stored);
                    card.setInt(String.format("_%dmaxStorage", i), (int)storage.capacity);
                    foundAny = true;
                    continue;
                }
                card.setInt(String.format("_%denergy", i), Integer.MIN_VALUE);
                continue;
            }
            card.setInt(String.format("_%denergy", i), -2147483647);
            outOfRange = true;
        }
        card.setDouble("energyL", totalEnergy);
        if (!foundAny) {
            if (outOfRange) {
                return CardState.OUT_OF_RANGE;
            }
            return CardState.NO_TARGET;
        }
        return CardState.OK;
    }

    @Override
    public CardState update(World world, ICardWrapper card, int range) {
        return CardState.CUSTOM_ERROR;
    }

    @Override
    public UUID getCardType() {
        return CARD_TYPE;
    }

    @Override
    public List<PanelString> getStringData(int displaySettings, ICardWrapper card, boolean showLabels) {
        PanelString line;
        LinkedList<PanelString> result = new LinkedList<PanelString>();
        double totalEnergy = 0.0;
        double totalStorage = 0.0;
        boolean showEach = (displaySettings & 8) > 0;
        boolean showSummary = (displaySettings & 0x10) > 0;
        boolean showEnergy = (displaySettings & 1) > 0;
        boolean showFree = (displaySettings & 2) > 0;
        boolean showStorage = (displaySettings & 4) > 0;
        boolean showPercentage = (displaySettings & 0x20) > 0;
        int cardCount = ItemCardEnergyArrayLocation.getCardCount(card);
        for (int i = 0; i < cardCount; ++i) {
            boolean isNotFound;
            int energy = card.getInt(String.format("_%denergy", i));
            int storage = card.getInt(String.format("_%dmaxStorage", i));
            boolean isOutOfRange = energy == -2147483647;
            boolean bl = isNotFound = energy == Integer.MIN_VALUE;
            if (showSummary && !isOutOfRange && !isNotFound) {
                totalEnergy += (double)energy;
                totalStorage += (double)storage;
            }
            if (!showEach) continue;
            if (isOutOfRange) {
                line = new PanelString();
                line.textLeft = StringUtils.getFormattedKey("msg.nc.InfoPanelOutOfRangeN", i + 1);
                result.add(line);
                continue;
            }
            if (isNotFound) {
                line = new PanelString();
                line.textLeft = StringUtils.getFormattedKey("msg.nc.InfoPanelNotFoundN", i + 1);
                result.add(line);
                continue;
            }
            if (showEnergy) {
                line = new PanelString();
                line.textLeft = showLabels ? StringUtils.getFormattedKey("msg.nc.InfoPanelEnergyN", i + 1, StringUtils.getFormatted("", energy, false)) : StringUtils.getFormatted("", energy, false);
                result.add(line);
            }
            if (showFree) {
                line = new PanelString();
                line.textLeft = showLabels ? StringUtils.getFormattedKey("msg.nc.InfoPanelEnergyFreeN", i + 1, StringUtils.getFormatted("", storage - energy, false)) : StringUtils.getFormatted("", storage - energy, false);
                result.add(line);
            }
            if (showStorage) {
                line = new PanelString();
                line.textLeft = showLabels ? StringUtils.getFormattedKey("msg.nc.InfoPanelEnergyStorageN", i + 1, StringUtils.getFormatted("", storage, false)) : StringUtils.getFormatted("", storage, false);
                result.add(line);
            }
            if (!showPercentage) continue;
            line = new PanelString();
            line.textLeft = showLabels ? StringUtils.getFormattedKey("msg.nc.InfoPanelEnergyPercentageN", i + 1, StringUtils.getFormatted("", storage == 0 ? 100.0 : (double)((int)((double)energy / (double)storage * 100.0)), false)) : StringUtils.getFormatted("", storage == 0 ? 100.0 : (double)((int)((double)energy / (double)storage * 100.0)), false);
            result.add(line);
        }
        if (showSummary) {
            if (showEnergy) {
                line = new PanelString();
                line.textLeft = StringUtils.getFormatted("msg.nc.InfoPanelEnergy", totalEnergy, showLabels);
                result.add(line);
            }
            if (showFree) {
                line = new PanelString();
                line.textLeft = StringUtils.getFormatted("msg.nc.InfoPanelEnergyFree", totalStorage - totalEnergy, showLabels);
                result.add(line);
            }
            if (showStorage) {
                line = new PanelString();
                line.textLeft = StringUtils.getFormatted("msg.nc.InfoPanelEnergyStorage", totalStorage, showLabels);
                result.add(line);
            }
            if (showPercentage) {
                line = new PanelString();
                line.textLeft = StringUtils.getFormatted("msg.nc.InfoPanelEnergyPercentage", totalStorage == 0.0 ? 100.0 : totalEnergy / totalStorage * 100.0, showLabels);
                result.add(line);
            }
        }
        return result;
    }

    @Override
    public List<PanelSetting> getSettingsList() {
        ArrayList<PanelSetting> result = new ArrayList<PanelSetting>(6);
        result.add(new PanelSetting(LangHelper.translate("1"), 1, CARD_TYPE));
        result.add(new PanelSetting(LangHelper.translate("2"), 4, CARD_TYPE));
        result.add(new PanelSetting(LangHelper.translate("3"), 2, CARD_TYPE));
        result.add(new PanelSetting(LangHelper.translate("4"), 32, CARD_TYPE));
        result.add(new PanelSetting(LangHelper.translate("5"), 8, CARD_TYPE));
        result.add(new PanelSetting(LangHelper.translate("6"), 16, CARD_TYPE));
        return result;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, EntityPlayer player, List info, boolean advanced) {
        CardWrapperImpl card = new CardWrapperImpl(itemStack, -1);
        int cardCount = ItemCardEnergyArrayLocation.getCardCount(card);
        if (cardCount > 0) {
            String title = card.getTitle();
            if (title != null && !title.isEmpty()) {
                info.add(title);
            }
            String hint = String.format(LangHelper.translate("msg.nc.EnergyCardQuantity"), cardCount);
            info.add(hint);
        }
    }
}

